/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThemeAliasRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateThemeAliasRequest.Builder, CreateThemeAliasRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateThemeAliasRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeId").getter(getter(CreateThemeAliasRequest::themeId)).setter(setter(Builder::themeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ThemeId").build()).build();

    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasName").getter(getter(CreateThemeAliasRequest::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AliasName").build()).build();

    private static final SdkField<Long> THEME_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ThemeVersionNumber").getter(getter(CreateThemeAliasRequest::themeVersionNumber))
            .setter(setter(Builder::themeVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            THEME_ID_FIELD, ALIAS_NAME_FIELD, THEME_VERSION_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String themeId;

    private final String aliasName;

    private final Long themeVersionNumber;

    private CreateThemeAliasRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.themeId = builder.themeId;
        this.aliasName = builder.aliasName;
        this.themeVersionNumber = builder.themeVersionNumber;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the theme for the new theme alias.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the theme for the new theme alias.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An ID for the theme alias.
     * </p>
     * 
     * @return An ID for the theme alias.
     */
    public final String themeId() {
        return themeId;
    }

    /**
     * <p>
     * The name that you want to give to the theme alias that you are creating. The alias name can't begin with a
     * <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon Quick Sight.
     * </p>
     * 
     * @return The name that you want to give to the theme alias that you are creating. The alias name can't begin with
     *         a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon Quick Sight.
     */
    public final String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * The version number of the theme.
     * </p>
     * 
     * @return The version number of the theme.
     */
    public final Long themeVersionNumber() {
        return themeVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(themeId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(themeVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeAliasRequest)) {
            return false;
        }
        CreateThemeAliasRequest other = (CreateThemeAliasRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(themeId(), other.themeId())
                && Objects.equals(aliasName(), other.aliasName())
                && Objects.equals(themeVersionNumber(), other.themeVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThemeAliasRequest").add("AwsAccountId", awsAccountId()).add("ThemeId", themeId())
                .add("AliasName", aliasName()).add("ThemeVersionNumber", themeVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "ThemeId":
            return Optional.ofNullable(clazz.cast(themeId()));
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "ThemeVersionNumber":
            return Optional.ofNullable(clazz.cast(themeVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ThemeId", THEME_ID_FIELD);
        map.put("AliasName", ALIAS_NAME_FIELD);
        map.put("ThemeVersionNumber", THEME_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateThemeAliasRequest, T> g) {
        return obj -> g.apply((CreateThemeAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateThemeAliasRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the theme for the new theme alias.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the theme for the new theme alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An ID for the theme alias.
         * </p>
         * 
         * @param themeId
         *        An ID for the theme alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeId(String themeId);

        /**
         * <p>
         * The name that you want to give to the theme alias that you are creating. The alias name can't begin with a
         * <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon Quick Sight.
         * </p>
         * 
         * @param aliasName
         *        The name that you want to give to the theme alias that you are creating. The alias name can't begin
         *        with a <code>$</code>. Alias names that start with <code>$</code> are reserved by Amazon Quick Sight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * The version number of the theme.
         * </p>
         * 
         * @param themeVersionNumber
         *        The version number of the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeVersionNumber(Long themeVersionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String themeId;

        private String aliasName;

        private Long themeVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThemeAliasRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            themeId(model.themeId);
            aliasName(model.aliasName);
            themeVersionNumber(model.themeVersionNumber);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getThemeId() {
            return themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final String getAliasName() {
            return aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final Long getThemeVersionNumber() {
            return themeVersionNumber;
        }

        public final void setThemeVersionNumber(Long themeVersionNumber) {
            this.themeVersionNumber = themeVersionNumber;
        }

        @Override
        public final Builder themeVersionNumber(Long themeVersionNumber) {
            this.themeVersionNumber = themeVersionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateThemeAliasRequest build() {
            return new CreateThemeAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
