/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The option that determines the data label type.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLabelType implements SdkPojo, Serializable, ToCopyableBuilder<DataLabelType.Builder, DataLabelType> {
    private static final SdkField<FieldLabelType> FIELD_LABEL_TYPE_FIELD = SdkField
            .<FieldLabelType> builder(MarshallingType.SDK_POJO).memberName("FieldLabelType")
            .getter(getter(DataLabelType::fieldLabelType)).setter(setter(Builder::fieldLabelType))
            .constructor(FieldLabelType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLabelType").build()).build();

    private static final SdkField<DataPathLabelType> DATA_PATH_LABEL_TYPE_FIELD = SdkField
            .<DataPathLabelType> builder(MarshallingType.SDK_POJO).memberName("DataPathLabelType")
            .getter(getter(DataLabelType::dataPathLabelType)).setter(setter(Builder::dataPathLabelType))
            .constructor(DataPathLabelType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPathLabelType").build()).build();

    private static final SdkField<RangeEndsLabelType> RANGE_ENDS_LABEL_TYPE_FIELD = SdkField
            .<RangeEndsLabelType> builder(MarshallingType.SDK_POJO).memberName("RangeEndsLabelType")
            .getter(getter(DataLabelType::rangeEndsLabelType)).setter(setter(Builder::rangeEndsLabelType))
            .constructor(RangeEndsLabelType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeEndsLabelType").build())
            .build();

    private static final SdkField<MinimumLabelType> MINIMUM_LABEL_TYPE_FIELD = SdkField
            .<MinimumLabelType> builder(MarshallingType.SDK_POJO).memberName("MinimumLabelType")
            .getter(getter(DataLabelType::minimumLabelType)).setter(setter(Builder::minimumLabelType))
            .constructor(MinimumLabelType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLabelType").build()).build();

    private static final SdkField<MaximumLabelType> MAXIMUM_LABEL_TYPE_FIELD = SdkField
            .<MaximumLabelType> builder(MarshallingType.SDK_POJO).memberName("MaximumLabelType")
            .getter(getter(DataLabelType::maximumLabelType)).setter(setter(Builder::maximumLabelType))
            .constructor(MaximumLabelType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumLabelType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_LABEL_TYPE_FIELD,
            DATA_PATH_LABEL_TYPE_FIELD, RANGE_ENDS_LABEL_TYPE_FIELD, MINIMUM_LABEL_TYPE_FIELD, MAXIMUM_LABEL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldLabelType fieldLabelType;

    private final DataPathLabelType dataPathLabelType;

    private final RangeEndsLabelType rangeEndsLabelType;

    private final MinimumLabelType minimumLabelType;

    private final MaximumLabelType maximumLabelType;

    private DataLabelType(BuilderImpl builder) {
        this.fieldLabelType = builder.fieldLabelType;
        this.dataPathLabelType = builder.dataPathLabelType;
        this.rangeEndsLabelType = builder.rangeEndsLabelType;
        this.minimumLabelType = builder.minimumLabelType;
        this.maximumLabelType = builder.maximumLabelType;
    }

    /**
     * <p>
     * Determines the label configuration for the entire field.
     * </p>
     * 
     * @return Determines the label configuration for the entire field.
     */
    public final FieldLabelType fieldLabelType() {
        return fieldLabelType;
    }

    /**
     * <p>
     * The option that specifies individual data values for labels.
     * </p>
     * 
     * @return The option that specifies individual data values for labels.
     */
    public final DataPathLabelType dataPathLabelType() {
        return dataPathLabelType;
    }

    /**
     * <p>
     * Determines the label configuration for range end value in a visual.
     * </p>
     * 
     * @return Determines the label configuration for range end value in a visual.
     */
    public final RangeEndsLabelType rangeEndsLabelType() {
        return rangeEndsLabelType;
    }

    /**
     * <p>
     * Determines the label configuration for the minimum value in a visual.
     * </p>
     * 
     * @return Determines the label configuration for the minimum value in a visual.
     */
    public final MinimumLabelType minimumLabelType() {
        return minimumLabelType;
    }

    /**
     * <p>
     * Determines the label configuration for the maximum value in a visual.
     * </p>
     * 
     * @return Determines the label configuration for the maximum value in a visual.
     */
    public final MaximumLabelType maximumLabelType() {
        return maximumLabelType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldLabelType());
        hashCode = 31 * hashCode + Objects.hashCode(dataPathLabelType());
        hashCode = 31 * hashCode + Objects.hashCode(rangeEndsLabelType());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLabelType());
        hashCode = 31 * hashCode + Objects.hashCode(maximumLabelType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLabelType)) {
            return false;
        }
        DataLabelType other = (DataLabelType) obj;
        return Objects.equals(fieldLabelType(), other.fieldLabelType())
                && Objects.equals(dataPathLabelType(), other.dataPathLabelType())
                && Objects.equals(rangeEndsLabelType(), other.rangeEndsLabelType())
                && Objects.equals(minimumLabelType(), other.minimumLabelType())
                && Objects.equals(maximumLabelType(), other.maximumLabelType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLabelType").add("FieldLabelType", fieldLabelType())
                .add("DataPathLabelType", dataPathLabelType()).add("RangeEndsLabelType", rangeEndsLabelType())
                .add("MinimumLabelType", minimumLabelType()).add("MaximumLabelType", maximumLabelType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldLabelType":
            return Optional.ofNullable(clazz.cast(fieldLabelType()));
        case "DataPathLabelType":
            return Optional.ofNullable(clazz.cast(dataPathLabelType()));
        case "RangeEndsLabelType":
            return Optional.ofNullable(clazz.cast(rangeEndsLabelType()));
        case "MinimumLabelType":
            return Optional.ofNullable(clazz.cast(minimumLabelType()));
        case "MaximumLabelType":
            return Optional.ofNullable(clazz.cast(maximumLabelType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldLabelType", FIELD_LABEL_TYPE_FIELD);
        map.put("DataPathLabelType", DATA_PATH_LABEL_TYPE_FIELD);
        map.put("RangeEndsLabelType", RANGE_ENDS_LABEL_TYPE_FIELD);
        map.put("MinimumLabelType", MINIMUM_LABEL_TYPE_FIELD);
        map.put("MaximumLabelType", MAXIMUM_LABEL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLabelType, T> g) {
        return obj -> g.apply((DataLabelType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLabelType> {
        /**
         * <p>
         * Determines the label configuration for the entire field.
         * </p>
         * 
         * @param fieldLabelType
         *        Determines the label configuration for the entire field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLabelType(FieldLabelType fieldLabelType);

        /**
         * <p>
         * Determines the label configuration for the entire field.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldLabelType.Builder} avoiding the need
         * to create one manually via {@link FieldLabelType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldLabelType.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldLabelType(FieldLabelType)}.
         * 
         * @param fieldLabelType
         *        a consumer that will call methods on {@link FieldLabelType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLabelType(FieldLabelType)
         */
        default Builder fieldLabelType(Consumer<FieldLabelType.Builder> fieldLabelType) {
            return fieldLabelType(FieldLabelType.builder().applyMutation(fieldLabelType).build());
        }

        /**
         * <p>
         * The option that specifies individual data values for labels.
         * </p>
         * 
         * @param dataPathLabelType
         *        The option that specifies individual data values for labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPathLabelType(DataPathLabelType dataPathLabelType);

        /**
         * <p>
         * The option that specifies individual data values for labels.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPathLabelType.Builder} avoiding the
         * need to create one manually via {@link DataPathLabelType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPathLabelType.Builder#build()} is called immediately and its
         * result is passed to {@link #dataPathLabelType(DataPathLabelType)}.
         * 
         * @param dataPathLabelType
         *        a consumer that will call methods on {@link DataPathLabelType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPathLabelType(DataPathLabelType)
         */
        default Builder dataPathLabelType(Consumer<DataPathLabelType.Builder> dataPathLabelType) {
            return dataPathLabelType(DataPathLabelType.builder().applyMutation(dataPathLabelType).build());
        }

        /**
         * <p>
         * Determines the label configuration for range end value in a visual.
         * </p>
         * 
         * @param rangeEndsLabelType
         *        Determines the label configuration for range end value in a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeEndsLabelType(RangeEndsLabelType rangeEndsLabelType);

        /**
         * <p>
         * Determines the label configuration for range end value in a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link RangeEndsLabelType.Builder} avoiding the
         * need to create one manually via {@link RangeEndsLabelType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RangeEndsLabelType.Builder#build()} is called immediately and its
         * result is passed to {@link #rangeEndsLabelType(RangeEndsLabelType)}.
         * 
         * @param rangeEndsLabelType
         *        a consumer that will call methods on {@link RangeEndsLabelType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeEndsLabelType(RangeEndsLabelType)
         */
        default Builder rangeEndsLabelType(Consumer<RangeEndsLabelType.Builder> rangeEndsLabelType) {
            return rangeEndsLabelType(RangeEndsLabelType.builder().applyMutation(rangeEndsLabelType).build());
        }

        /**
         * <p>
         * Determines the label configuration for the minimum value in a visual.
         * </p>
         * 
         * @param minimumLabelType
         *        Determines the label configuration for the minimum value in a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLabelType(MinimumLabelType minimumLabelType);

        /**
         * <p>
         * Determines the label configuration for the minimum value in a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link MinimumLabelType.Builder} avoiding the
         * need to create one manually via {@link MinimumLabelType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MinimumLabelType.Builder#build()} is called immediately and its
         * result is passed to {@link #minimumLabelType(MinimumLabelType)}.
         * 
         * @param minimumLabelType
         *        a consumer that will call methods on {@link MinimumLabelType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumLabelType(MinimumLabelType)
         */
        default Builder minimumLabelType(Consumer<MinimumLabelType.Builder> minimumLabelType) {
            return minimumLabelType(MinimumLabelType.builder().applyMutation(minimumLabelType).build());
        }

        /**
         * <p>
         * Determines the label configuration for the maximum value in a visual.
         * </p>
         * 
         * @param maximumLabelType
         *        Determines the label configuration for the maximum value in a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumLabelType(MaximumLabelType maximumLabelType);

        /**
         * <p>
         * Determines the label configuration for the maximum value in a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaximumLabelType.Builder} avoiding the
         * need to create one manually via {@link MaximumLabelType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaximumLabelType.Builder#build()} is called immediately and its
         * result is passed to {@link #maximumLabelType(MaximumLabelType)}.
         * 
         * @param maximumLabelType
         *        a consumer that will call methods on {@link MaximumLabelType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maximumLabelType(MaximumLabelType)
         */
        default Builder maximumLabelType(Consumer<MaximumLabelType.Builder> maximumLabelType) {
            return maximumLabelType(MaximumLabelType.builder().applyMutation(maximumLabelType).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FieldLabelType fieldLabelType;

        private DataPathLabelType dataPathLabelType;

        private RangeEndsLabelType rangeEndsLabelType;

        private MinimumLabelType minimumLabelType;

        private MaximumLabelType maximumLabelType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLabelType model) {
            fieldLabelType(model.fieldLabelType);
            dataPathLabelType(model.dataPathLabelType);
            rangeEndsLabelType(model.rangeEndsLabelType);
            minimumLabelType(model.minimumLabelType);
            maximumLabelType(model.maximumLabelType);
        }

        public final FieldLabelType.Builder getFieldLabelType() {
            return fieldLabelType != null ? fieldLabelType.toBuilder() : null;
        }

        public final void setFieldLabelType(FieldLabelType.BuilderImpl fieldLabelType) {
            this.fieldLabelType = fieldLabelType != null ? fieldLabelType.build() : null;
        }

        @Override
        public final Builder fieldLabelType(FieldLabelType fieldLabelType) {
            this.fieldLabelType = fieldLabelType;
            return this;
        }

        public final DataPathLabelType.Builder getDataPathLabelType() {
            return dataPathLabelType != null ? dataPathLabelType.toBuilder() : null;
        }

        public final void setDataPathLabelType(DataPathLabelType.BuilderImpl dataPathLabelType) {
            this.dataPathLabelType = dataPathLabelType != null ? dataPathLabelType.build() : null;
        }

        @Override
        public final Builder dataPathLabelType(DataPathLabelType dataPathLabelType) {
            this.dataPathLabelType = dataPathLabelType;
            return this;
        }

        public final RangeEndsLabelType.Builder getRangeEndsLabelType() {
            return rangeEndsLabelType != null ? rangeEndsLabelType.toBuilder() : null;
        }

        public final void setRangeEndsLabelType(RangeEndsLabelType.BuilderImpl rangeEndsLabelType) {
            this.rangeEndsLabelType = rangeEndsLabelType != null ? rangeEndsLabelType.build() : null;
        }

        @Override
        public final Builder rangeEndsLabelType(RangeEndsLabelType rangeEndsLabelType) {
            this.rangeEndsLabelType = rangeEndsLabelType;
            return this;
        }

        public final MinimumLabelType.Builder getMinimumLabelType() {
            return minimumLabelType != null ? minimumLabelType.toBuilder() : null;
        }

        public final void setMinimumLabelType(MinimumLabelType.BuilderImpl minimumLabelType) {
            this.minimumLabelType = minimumLabelType != null ? minimumLabelType.build() : null;
        }

        @Override
        public final Builder minimumLabelType(MinimumLabelType minimumLabelType) {
            this.minimumLabelType = minimumLabelType;
            return this;
        }

        public final MaximumLabelType.Builder getMaximumLabelType() {
            return maximumLabelType != null ? maximumLabelType.toBuilder() : null;
        }

        public final void setMaximumLabelType(MaximumLabelType.BuilderImpl maximumLabelType) {
            this.maximumLabelType = maximumLabelType != null ? maximumLabelType.build() : null;
        }

        @Override
        public final Builder maximumLabelType(MaximumLabelType maximumLabelType) {
            this.maximumLabelType = maximumLabelType;
            return this;
        }

        @Override
        public DataLabelType build() {
            return new DataLabelType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
