/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregation function that concatenates values from multiple rows into a single string with a specified separator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPrepListAggregationFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPrepListAggregationFunction.Builder, DataPrepListAggregationFunction> {
    private static final SdkField<String> INPUT_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputColumnName").getter(getter(DataPrepListAggregationFunction::inputColumnName))
            .setter(setter(Builder::inputColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumnName").build()).build();

    private static final SdkField<String> SEPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Separator").getter(getter(DataPrepListAggregationFunction::separator))
            .setter(setter(Builder::separator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Separator").build()).build();

    private static final SdkField<Boolean> DISTINCT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Distinct").getter(getter(DataPrepListAggregationFunction::distinct)).setter(setter(Builder::distinct))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distinct").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_COLUMN_NAME_FIELD,
            SEPARATOR_FIELD, DISTINCT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputColumnName;

    private final String separator;

    private final Boolean distinct;

    private DataPrepListAggregationFunction(BuilderImpl builder) {
        this.inputColumnName = builder.inputColumnName;
        this.separator = builder.separator;
        this.distinct = builder.distinct;
    }

    /**
     * <p>
     * The name of the column containing values to be concatenated.
     * </p>
     * 
     * @return The name of the column containing values to be concatenated.
     */
    public final String inputColumnName() {
        return inputColumnName;
    }

    /**
     * <p>
     * The string used to separate values in the concatenated result.
     * </p>
     * 
     * @return The string used to separate values in the concatenated result.
     */
    public final String separator() {
        return separator;
    }

    /**
     * <p>
     * Whether to include only distinct values in the concatenated result, removing duplicates.
     * </p>
     * 
     * @return Whether to include only distinct values in the concatenated result, removing duplicates.
     */
    public final Boolean distinct() {
        return distinct;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(separator());
        hashCode = 31 * hashCode + Objects.hashCode(distinct());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPrepListAggregationFunction)) {
            return false;
        }
        DataPrepListAggregationFunction other = (DataPrepListAggregationFunction) obj;
        return Objects.equals(inputColumnName(), other.inputColumnName()) && Objects.equals(separator(), other.separator())
                && Objects.equals(distinct(), other.distinct());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPrepListAggregationFunction").add("InputColumnName", inputColumnName())
                .add("Separator", separator()).add("Distinct", distinct()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputColumnName":
            return Optional.ofNullable(clazz.cast(inputColumnName()));
        case "Separator":
            return Optional.ofNullable(clazz.cast(separator()));
        case "Distinct":
            return Optional.ofNullable(clazz.cast(distinct()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InputColumnName", INPUT_COLUMN_NAME_FIELD);
        map.put("Separator", SEPARATOR_FIELD);
        map.put("Distinct", DISTINCT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPrepListAggregationFunction, T> g) {
        return obj -> g.apply((DataPrepListAggregationFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPrepListAggregationFunction> {
        /**
         * <p>
         * The name of the column containing values to be concatenated.
         * </p>
         * 
         * @param inputColumnName
         *        The name of the column containing values to be concatenated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumnName(String inputColumnName);

        /**
         * <p>
         * The string used to separate values in the concatenated result.
         * </p>
         * 
         * @param separator
         *        The string used to separate values in the concatenated result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder separator(String separator);

        /**
         * <p>
         * Whether to include only distinct values in the concatenated result, removing duplicates.
         * </p>
         * 
         * @param distinct
         *        Whether to include only distinct values in the concatenated result, removing duplicates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinct(Boolean distinct);
    }

    static final class BuilderImpl implements Builder {
        private String inputColumnName;

        private String separator;

        private Boolean distinct;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPrepListAggregationFunction model) {
            inputColumnName(model.inputColumnName);
            separator(model.separator);
            distinct(model.distinct);
        }

        public final String getInputColumnName() {
            return inputColumnName;
        }

        public final void setInputColumnName(String inputColumnName) {
            this.inputColumnName = inputColumnName;
        }

        @Override
        public final Builder inputColumnName(String inputColumnName) {
            this.inputColumnName = inputColumnName;
            return this;
        }

        public final String getSeparator() {
            return separator;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        @Override
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public final Boolean getDistinct() {
            return distinct;
        }

        public final void setDistinct(Boolean distinct) {
            this.distinct = distinct;
        }

        @Override
        public final Builder distinct(Boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        @Override
        public DataPrepListAggregationFunction build() {
            return new DataPrepListAggregationFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
