/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A simple aggregation function that performs standard statistical operations on a column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPrepSimpleAggregationFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPrepSimpleAggregationFunction.Builder, DataPrepSimpleAggregationFunction> {
    private static final SdkField<String> INPUT_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputColumnName").getter(getter(DataPrepSimpleAggregationFunction::inputColumnName))
            .setter(setter(Builder::inputColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumnName").build()).build();

    private static final SdkField<String> FUNCTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionType").getter(getter(DataPrepSimpleAggregationFunction::functionTypeAsString))
            .setter(setter(Builder::functionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_COLUMN_NAME_FIELD,
            FUNCTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputColumnName;

    private final String functionType;

    private DataPrepSimpleAggregationFunction(BuilderImpl builder) {
        this.inputColumnName = builder.inputColumnName;
        this.functionType = builder.functionType;
    }

    /**
     * <p>
     * The name of the column on which to perform the aggregation function.
     * </p>
     * 
     * @return The name of the column on which to perform the aggregation function.
     */
    public final String inputColumnName() {
        return inputColumnName;
    }

    /**
     * <p>
     * The type of aggregation function to perform, such as <code>COUNT</code>, <code>SUM</code>, <code>AVERAGE</code>,
     * <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
     * <code>STANDARD_DEVIATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #functionType} will
     * return {@link DataPrepSimpleAggregationFunctionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #functionTypeAsString}.
     * </p>
     * 
     * @return The type of aggregation function to perform, such as <code>COUNT</code>, <code>SUM</code>,
     *         <code>AVERAGE</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
     *         <code>STANDARD_DEVIATION</code>.
     * @see DataPrepSimpleAggregationFunctionType
     */
    public final DataPrepSimpleAggregationFunctionType functionType() {
        return DataPrepSimpleAggregationFunctionType.fromValue(functionType);
    }

    /**
     * <p>
     * The type of aggregation function to perform, such as <code>COUNT</code>, <code>SUM</code>, <code>AVERAGE</code>,
     * <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
     * <code>STANDARD_DEVIATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #functionType} will
     * return {@link DataPrepSimpleAggregationFunctionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #functionTypeAsString}.
     * </p>
     * 
     * @return The type of aggregation function to perform, such as <code>COUNT</code>, <code>SUM</code>,
     *         <code>AVERAGE</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
     *         <code>STANDARD_DEVIATION</code>.
     * @see DataPrepSimpleAggregationFunctionType
     */
    public final String functionTypeAsString() {
        return functionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(functionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPrepSimpleAggregationFunction)) {
            return false;
        }
        DataPrepSimpleAggregationFunction other = (DataPrepSimpleAggregationFunction) obj;
        return Objects.equals(inputColumnName(), other.inputColumnName())
                && Objects.equals(functionTypeAsString(), other.functionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPrepSimpleAggregationFunction").add("InputColumnName", inputColumnName())
                .add("FunctionType", functionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputColumnName":
            return Optional.ofNullable(clazz.cast(inputColumnName()));
        case "FunctionType":
            return Optional.ofNullable(clazz.cast(functionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InputColumnName", INPUT_COLUMN_NAME_FIELD);
        map.put("FunctionType", FUNCTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPrepSimpleAggregationFunction, T> g) {
        return obj -> g.apply((DataPrepSimpleAggregationFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPrepSimpleAggregationFunction> {
        /**
         * <p>
         * The name of the column on which to perform the aggregation function.
         * </p>
         * 
         * @param inputColumnName
         *        The name of the column on which to perform the aggregation function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumnName(String inputColumnName);

        /**
         * <p>
         * The type of aggregation function to perform, such as <code>COUNT</code>, <code>SUM</code>,
         * <code>AVERAGE</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
         * <code>STANDARD_DEVIATION</code>.
         * </p>
         * 
         * @param functionType
         *        The type of aggregation function to perform, such as <code>COUNT</code>, <code>SUM</code>,
         *        <code>AVERAGE</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>,
         *        or <code>STANDARD_DEVIATION</code>.
         * @see DataPrepSimpleAggregationFunctionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataPrepSimpleAggregationFunctionType
         */
        Builder functionType(String functionType);

        /**
         * <p>
         * The type of aggregation function to perform, such as <code>COUNT</code>, <code>SUM</code>,
         * <code>AVERAGE</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
         * <code>STANDARD_DEVIATION</code>.
         * </p>
         * 
         * @param functionType
         *        The type of aggregation function to perform, such as <code>COUNT</code>, <code>SUM</code>,
         *        <code>AVERAGE</code>, <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>,
         *        or <code>STANDARD_DEVIATION</code>.
         * @see DataPrepSimpleAggregationFunctionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataPrepSimpleAggregationFunctionType
         */
        Builder functionType(DataPrepSimpleAggregationFunctionType functionType);
    }

    static final class BuilderImpl implements Builder {
        private String inputColumnName;

        private String functionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPrepSimpleAggregationFunction model) {
            inputColumnName(model.inputColumnName);
            functionType(model.functionType);
        }

        public final String getInputColumnName() {
            return inputColumnName;
        }

        public final void setInputColumnName(String inputColumnName) {
            this.inputColumnName = inputColumnName;
        }

        @Override
        public final Builder inputColumnName(String inputColumnName) {
            this.inputColumnName = inputColumnName;
            return this;
        }

        public final String getFunctionType() {
            return functionType;
        }

        public final void setFunctionType(String functionType) {
            this.functionType = functionType;
        }

        @Override
        public final Builder functionType(String functionType) {
            this.functionType = functionType;
            return this;
        }

        @Override
        public final Builder functionType(DataPrepSimpleAggregationFunctionType functionType) {
            this.functionType(functionType == null ? null : functionType.toString());
            return this;
        }

        @Override
        public DataPrepSimpleAggregationFunction build() {
            return new DataPrepSimpleAggregationFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
