/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Maps a source column identifier to a target column identifier during transform operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetColumnIdMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetColumnIdMapping.Builder, DataSetColumnIdMapping> {
    private static final SdkField<String> SOURCE_COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceColumnId").getter(getter(DataSetColumnIdMapping::sourceColumnId))
            .setter(setter(Builder::sourceColumnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceColumnId").build()).build();

    private static final SdkField<String> TARGET_COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetColumnId").getter(getter(DataSetColumnIdMapping::targetColumnId))
            .setter(setter(Builder::targetColumnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetColumnId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COLUMN_ID_FIELD,
            TARGET_COLUMN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceColumnId;

    private final String targetColumnId;

    private DataSetColumnIdMapping(BuilderImpl builder) {
        this.sourceColumnId = builder.sourceColumnId;
        this.targetColumnId = builder.targetColumnId;
    }

    /**
     * <p>
     * Source column ID.
     * </p>
     * 
     * @return Source column ID.
     */
    public final String sourceColumnId() {
        return sourceColumnId;
    }

    /**
     * <p>
     * Target column ID.
     * </p>
     * 
     * @return Target column ID.
     */
    public final String targetColumnId() {
        return targetColumnId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceColumnId());
        hashCode = 31 * hashCode + Objects.hashCode(targetColumnId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetColumnIdMapping)) {
            return false;
        }
        DataSetColumnIdMapping other = (DataSetColumnIdMapping) obj;
        return Objects.equals(sourceColumnId(), other.sourceColumnId())
                && Objects.equals(targetColumnId(), other.targetColumnId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetColumnIdMapping").add("SourceColumnId", sourceColumnId())
                .add("TargetColumnId", targetColumnId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceColumnId":
            return Optional.ofNullable(clazz.cast(sourceColumnId()));
        case "TargetColumnId":
            return Optional.ofNullable(clazz.cast(targetColumnId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceColumnId", SOURCE_COLUMN_ID_FIELD);
        map.put("TargetColumnId", TARGET_COLUMN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetColumnIdMapping, T> g) {
        return obj -> g.apply((DataSetColumnIdMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetColumnIdMapping> {
        /**
         * <p>
         * Source column ID.
         * </p>
         * 
         * @param sourceColumnId
         *        Source column ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceColumnId(String sourceColumnId);

        /**
         * <p>
         * Target column ID.
         * </p>
         * 
         * @param targetColumnId
         *        Target column ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetColumnId(String targetColumnId);
    }

    static final class BuilderImpl implements Builder {
        private String sourceColumnId;

        private String targetColumnId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetColumnIdMapping model) {
            sourceColumnId(model.sourceColumnId);
            targetColumnId(model.targetColumnId);
        }

        public final String getSourceColumnId() {
            return sourceColumnId;
        }

        public final void setSourceColumnId(String sourceColumnId) {
            this.sourceColumnId = sourceColumnId;
        }

        @Override
        public final Builder sourceColumnId(String sourceColumnId) {
            this.sourceColumnId = sourceColumnId;
            return this;
        }

        public final String getTargetColumnId() {
            return targetColumnId;
        }

        public final void setTargetColumnId(String targetColumnId) {
            this.targetColumnId = targetColumnId;
        }

        @Override
        public final Builder targetColumnId(String targetColumnId) {
            this.targetColumnId = targetColumnId;
            return this;
        }

        @Override
        public DataSetColumnIdMapping build() {
            return new DataSetColumnIdMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
