/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter condition for numeric columns, supporting both comparison and range-based filtering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetNumericFilterCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetNumericFilterCondition.Builder, DataSetNumericFilterCondition> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(DataSetNumericFilterCondition::columnName))
            .setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<DataSetNumericComparisonFilterCondition> COMPARISON_FILTER_CONDITION_FIELD = SdkField
            .<DataSetNumericComparisonFilterCondition> builder(MarshallingType.SDK_POJO).memberName("ComparisonFilterCondition")
            .getter(getter(DataSetNumericFilterCondition::comparisonFilterCondition))
            .setter(setter(Builder::comparisonFilterCondition)).constructor(DataSetNumericComparisonFilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonFilterCondition").build())
            .build();

    private static final SdkField<DataSetNumericRangeFilterCondition> RANGE_FILTER_CONDITION_FIELD = SdkField
            .<DataSetNumericRangeFilterCondition> builder(MarshallingType.SDK_POJO).memberName("RangeFilterCondition")
            .getter(getter(DataSetNumericFilterCondition::rangeFilterCondition)).setter(setter(Builder::rangeFilterCondition))
            .constructor(DataSetNumericRangeFilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeFilterCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COMPARISON_FILTER_CONDITION_FIELD, RANGE_FILTER_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final DataSetNumericComparisonFilterCondition comparisonFilterCondition;

    private final DataSetNumericRangeFilterCondition rangeFilterCondition;

    private DataSetNumericFilterCondition(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.comparisonFilterCondition = builder.comparisonFilterCondition;
        this.rangeFilterCondition = builder.rangeFilterCondition;
    }

    /**
     * <p>
     * The name of the numeric column to filter.
     * </p>
     * 
     * @return The name of the numeric column to filter.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * A comparison-based filter condition for the numeric column.
     * </p>
     * 
     * @return A comparison-based filter condition for the numeric column.
     */
    public final DataSetNumericComparisonFilterCondition comparisonFilterCondition() {
        return comparisonFilterCondition;
    }

    /**
     * <p>
     * A range-based filter condition for the numeric column, filtering values between minimum and maximum numbers.
     * </p>
     * 
     * @return A range-based filter condition for the numeric column, filtering values between minimum and maximum
     *         numbers.
     */
    public final DataSetNumericRangeFilterCondition rangeFilterCondition() {
        return rangeFilterCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonFilterCondition());
        hashCode = 31 * hashCode + Objects.hashCode(rangeFilterCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetNumericFilterCondition)) {
            return false;
        }
        DataSetNumericFilterCondition other = (DataSetNumericFilterCondition) obj;
        return Objects.equals(columnName(), other.columnName())
                && Objects.equals(comparisonFilterCondition(), other.comparisonFilterCondition())
                && Objects.equals(rangeFilterCondition(), other.rangeFilterCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetNumericFilterCondition").add("ColumnName", columnName())
                .add("ComparisonFilterCondition", comparisonFilterCondition())
                .add("RangeFilterCondition", rangeFilterCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "ComparisonFilterCondition":
            return Optional.ofNullable(clazz.cast(comparisonFilterCondition()));
        case "RangeFilterCondition":
            return Optional.ofNullable(clazz.cast(rangeFilterCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("ComparisonFilterCondition", COMPARISON_FILTER_CONDITION_FIELD);
        map.put("RangeFilterCondition", RANGE_FILTER_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetNumericFilterCondition, T> g) {
        return obj -> g.apply((DataSetNumericFilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetNumericFilterCondition> {
        /**
         * <p>
         * The name of the numeric column to filter.
         * </p>
         * 
         * @param columnName
         *        The name of the numeric column to filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * A comparison-based filter condition for the numeric column.
         * </p>
         * 
         * @param comparisonFilterCondition
         *        A comparison-based filter condition for the numeric column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonFilterCondition(DataSetNumericComparisonFilterCondition comparisonFilterCondition);

        /**
         * <p>
         * A comparison-based filter condition for the numeric column.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataSetNumericComparisonFilterCondition.Builder} avoiding the need to create one manually via
         * {@link DataSetNumericComparisonFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetNumericComparisonFilterCondition.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #comparisonFilterCondition(DataSetNumericComparisonFilterCondition)}.
         * 
         * @param comparisonFilterCondition
         *        a consumer that will call methods on {@link DataSetNumericComparisonFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparisonFilterCondition(DataSetNumericComparisonFilterCondition)
         */
        default Builder comparisonFilterCondition(
                Consumer<DataSetNumericComparisonFilterCondition.Builder> comparisonFilterCondition) {
            return comparisonFilterCondition(DataSetNumericComparisonFilterCondition.builder()
                    .applyMutation(comparisonFilterCondition).build());
        }

        /**
         * <p>
         * A range-based filter condition for the numeric column, filtering values between minimum and maximum numbers.
         * </p>
         * 
         * @param rangeFilterCondition
         *        A range-based filter condition for the numeric column, filtering values between minimum and maximum
         *        numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeFilterCondition(DataSetNumericRangeFilterCondition rangeFilterCondition);

        /**
         * <p>
         * A range-based filter condition for the numeric column, filtering values between minimum and maximum numbers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataSetNumericRangeFilterCondition.Builder} avoiding the need to create one manually via
         * {@link DataSetNumericRangeFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetNumericRangeFilterCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #rangeFilterCondition(DataSetNumericRangeFilterCondition)}.
         * 
         * @param rangeFilterCondition
         *        a consumer that will call methods on {@link DataSetNumericRangeFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeFilterCondition(DataSetNumericRangeFilterCondition)
         */
        default Builder rangeFilterCondition(Consumer<DataSetNumericRangeFilterCondition.Builder> rangeFilterCondition) {
            return rangeFilterCondition(DataSetNumericRangeFilterCondition.builder().applyMutation(rangeFilterCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private DataSetNumericComparisonFilterCondition comparisonFilterCondition;

        private DataSetNumericRangeFilterCondition rangeFilterCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetNumericFilterCondition model) {
            columnName(model.columnName);
            comparisonFilterCondition(model.comparisonFilterCondition);
            rangeFilterCondition(model.rangeFilterCondition);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final DataSetNumericComparisonFilterCondition.Builder getComparisonFilterCondition() {
            return comparisonFilterCondition != null ? comparisonFilterCondition.toBuilder() : null;
        }

        public final void setComparisonFilterCondition(
                DataSetNumericComparisonFilterCondition.BuilderImpl comparisonFilterCondition) {
            this.comparisonFilterCondition = comparisonFilterCondition != null ? comparisonFilterCondition.build() : null;
        }

        @Override
        public final Builder comparisonFilterCondition(DataSetNumericComparisonFilterCondition comparisonFilterCondition) {
            this.comparisonFilterCondition = comparisonFilterCondition;
            return this;
        }

        public final DataSetNumericRangeFilterCondition.Builder getRangeFilterCondition() {
            return rangeFilterCondition != null ? rangeFilterCondition.toBuilder() : null;
        }

        public final void setRangeFilterCondition(DataSetNumericRangeFilterCondition.BuilderImpl rangeFilterCondition) {
            this.rangeFilterCondition = rangeFilterCondition != null ? rangeFilterCondition.build() : null;
        }

        @Override
        public final Builder rangeFilterCondition(DataSetNumericRangeFilterCondition rangeFilterCondition) {
            this.rangeFilterCondition = rangeFilterCondition;
            return this;
        }

        @Override
        public DataSetNumericFilterCondition build() {
            return new DataSetNumericFilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
