/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a numeric value used in filter conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetNumericFilterValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetNumericFilterValue.Builder, DataSetNumericFilterValue> {
    private static final SdkField<Double> STATIC_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StaticValue").getter(getter(DataSetNumericFilterValue::staticValue))
            .setter(setter(Builder::staticValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double staticValue;

    private DataSetNumericFilterValue(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
    }

    /**
     * <p>
     * A static numeric value used for filtering.
     * </p>
     * 
     * @return A static numeric value used for filtering.
     */
    public final Double staticValue() {
        return staticValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetNumericFilterValue)) {
            return false;
        }
        DataSetNumericFilterValue other = (DataSetNumericFilterValue) obj;
        return Objects.equals(staticValue(), other.staticValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetNumericFilterValue")
                .add("StaticValue", staticValue() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticValue":
            return Optional.ofNullable(clazz.cast(staticValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StaticValue", STATIC_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetNumericFilterValue, T> g) {
        return obj -> g.apply((DataSetNumericFilterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetNumericFilterValue> {
        /**
         * <p>
         * A static numeric value used for filtering.
         * </p>
         * 
         * @param staticValue
         *        A static numeric value used for filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValue(Double staticValue);
    }

    static final class BuilderImpl implements Builder {
        private Double staticValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetNumericFilterValue model) {
            staticValue(model.staticValue);
        }

        public final Double getStaticValue() {
            return staticValue;
        }

        public final void setStaticValue(Double staticValue) {
            this.staticValue = staticValue;
        }

        @Override
        public final Builder staticValue(Double staticValue) {
            this.staticValue = staticValue;
            return this;
        }

        @Override
        public DataSetNumericFilterValue build() {
            return new DataSetNumericFilterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
