/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter condition that filters numeric values within a specified range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetNumericRangeFilterCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetNumericRangeFilterCondition.Builder, DataSetNumericRangeFilterCondition> {
    private static final SdkField<DataSetNumericFilterValue> RANGE_MINIMUM_FIELD = SdkField
            .<DataSetNumericFilterValue> builder(MarshallingType.SDK_POJO).memberName("RangeMinimum")
            .getter(getter(DataSetNumericRangeFilterCondition::rangeMinimum)).setter(setter(Builder::rangeMinimum))
            .constructor(DataSetNumericFilterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMinimum").build()).build();

    private static final SdkField<DataSetNumericFilterValue> RANGE_MAXIMUM_FIELD = SdkField
            .<DataSetNumericFilterValue> builder(MarshallingType.SDK_POJO).memberName("RangeMaximum")
            .getter(getter(DataSetNumericRangeFilterCondition::rangeMaximum)).setter(setter(Builder::rangeMaximum))
            .constructor(DataSetNumericFilterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMaximum").build()).build();

    private static final SdkField<Boolean> INCLUDE_MINIMUM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeMinimum").getter(getter(DataSetNumericRangeFilterCondition::includeMinimum))
            .setter(setter(Builder::includeMinimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMinimum").build()).build();

    private static final SdkField<Boolean> INCLUDE_MAXIMUM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeMaximum").getter(getter(DataSetNumericRangeFilterCondition::includeMaximum))
            .setter(setter(Builder::includeMaximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMaximum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANGE_MINIMUM_FIELD,
            RANGE_MAXIMUM_FIELD, INCLUDE_MINIMUM_FIELD, INCLUDE_MAXIMUM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataSetNumericFilterValue rangeMinimum;

    private final DataSetNumericFilterValue rangeMaximum;

    private final Boolean includeMinimum;

    private final Boolean includeMaximum;

    private DataSetNumericRangeFilterCondition(BuilderImpl builder) {
        this.rangeMinimum = builder.rangeMinimum;
        this.rangeMaximum = builder.rangeMaximum;
        this.includeMinimum = builder.includeMinimum;
        this.includeMaximum = builder.includeMaximum;
    }

    /**
     * <p>
     * The minimum numeric value for the range filter.
     * </p>
     * 
     * @return The minimum numeric value for the range filter.
     */
    public final DataSetNumericFilterValue rangeMinimum() {
        return rangeMinimum;
    }

    /**
     * <p>
     * The maximum numeric value for the range filter.
     * </p>
     * 
     * @return The maximum numeric value for the range filter.
     */
    public final DataSetNumericFilterValue rangeMaximum() {
        return rangeMaximum;
    }

    /**
     * <p>
     * Whether to include the minimum value in the filter range.
     * </p>
     * 
     * @return Whether to include the minimum value in the filter range.
     */
    public final Boolean includeMinimum() {
        return includeMinimum;
    }

    /**
     * <p>
     * Whether to include the maximum value in the filter range.
     * </p>
     * 
     * @return Whether to include the maximum value in the filter range.
     */
    public final Boolean includeMaximum() {
        return includeMaximum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rangeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(rangeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(includeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(includeMaximum());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetNumericRangeFilterCondition)) {
            return false;
        }
        DataSetNumericRangeFilterCondition other = (DataSetNumericRangeFilterCondition) obj;
        return Objects.equals(rangeMinimum(), other.rangeMinimum()) && Objects.equals(rangeMaximum(), other.rangeMaximum())
                && Objects.equals(includeMinimum(), other.includeMinimum())
                && Objects.equals(includeMaximum(), other.includeMaximum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetNumericRangeFilterCondition").add("RangeMinimum", rangeMinimum())
                .add("RangeMaximum", rangeMaximum()).add("IncludeMinimum", includeMinimum())
                .add("IncludeMaximum", includeMaximum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RangeMinimum":
            return Optional.ofNullable(clazz.cast(rangeMinimum()));
        case "RangeMaximum":
            return Optional.ofNullable(clazz.cast(rangeMaximum()));
        case "IncludeMinimum":
            return Optional.ofNullable(clazz.cast(includeMinimum()));
        case "IncludeMaximum":
            return Optional.ofNullable(clazz.cast(includeMaximum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RangeMinimum", RANGE_MINIMUM_FIELD);
        map.put("RangeMaximum", RANGE_MAXIMUM_FIELD);
        map.put("IncludeMinimum", INCLUDE_MINIMUM_FIELD);
        map.put("IncludeMaximum", INCLUDE_MAXIMUM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetNumericRangeFilterCondition, T> g) {
        return obj -> g.apply((DataSetNumericRangeFilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetNumericRangeFilterCondition> {
        /**
         * <p>
         * The minimum numeric value for the range filter.
         * </p>
         * 
         * @param rangeMinimum
         *        The minimum numeric value for the range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeMinimum(DataSetNumericFilterValue rangeMinimum);

        /**
         * <p>
         * The minimum numeric value for the range filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetNumericFilterValue.Builder}
         * avoiding the need to create one manually via {@link DataSetNumericFilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetNumericFilterValue.Builder#build()} is called immediately
         * and its result is passed to {@link #rangeMinimum(DataSetNumericFilterValue)}.
         * 
         * @param rangeMinimum
         *        a consumer that will call methods on {@link DataSetNumericFilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeMinimum(DataSetNumericFilterValue)
         */
        default Builder rangeMinimum(Consumer<DataSetNumericFilterValue.Builder> rangeMinimum) {
            return rangeMinimum(DataSetNumericFilterValue.builder().applyMutation(rangeMinimum).build());
        }

        /**
         * <p>
         * The maximum numeric value for the range filter.
         * </p>
         * 
         * @param rangeMaximum
         *        The maximum numeric value for the range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeMaximum(DataSetNumericFilterValue rangeMaximum);

        /**
         * <p>
         * The maximum numeric value for the range filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetNumericFilterValue.Builder}
         * avoiding the need to create one manually via {@link DataSetNumericFilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetNumericFilterValue.Builder#build()} is called immediately
         * and its result is passed to {@link #rangeMaximum(DataSetNumericFilterValue)}.
         * 
         * @param rangeMaximum
         *        a consumer that will call methods on {@link DataSetNumericFilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeMaximum(DataSetNumericFilterValue)
         */
        default Builder rangeMaximum(Consumer<DataSetNumericFilterValue.Builder> rangeMaximum) {
            return rangeMaximum(DataSetNumericFilterValue.builder().applyMutation(rangeMaximum).build());
        }

        /**
         * <p>
         * Whether to include the minimum value in the filter range.
         * </p>
         * 
         * @param includeMinimum
         *        Whether to include the minimum value in the filter range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMinimum(Boolean includeMinimum);

        /**
         * <p>
         * Whether to include the maximum value in the filter range.
         * </p>
         * 
         * @param includeMaximum
         *        Whether to include the maximum value in the filter range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMaximum(Boolean includeMaximum);
    }

    static final class BuilderImpl implements Builder {
        private DataSetNumericFilterValue rangeMinimum;

        private DataSetNumericFilterValue rangeMaximum;

        private Boolean includeMinimum;

        private Boolean includeMaximum;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetNumericRangeFilterCondition model) {
            rangeMinimum(model.rangeMinimum);
            rangeMaximum(model.rangeMaximum);
            includeMinimum(model.includeMinimum);
            includeMaximum(model.includeMaximum);
        }

        public final DataSetNumericFilterValue.Builder getRangeMinimum() {
            return rangeMinimum != null ? rangeMinimum.toBuilder() : null;
        }

        public final void setRangeMinimum(DataSetNumericFilterValue.BuilderImpl rangeMinimum) {
            this.rangeMinimum = rangeMinimum != null ? rangeMinimum.build() : null;
        }

        @Override
        public final Builder rangeMinimum(DataSetNumericFilterValue rangeMinimum) {
            this.rangeMinimum = rangeMinimum;
            return this;
        }

        public final DataSetNumericFilterValue.Builder getRangeMaximum() {
            return rangeMaximum != null ? rangeMaximum.toBuilder() : null;
        }

        public final void setRangeMaximum(DataSetNumericFilterValue.BuilderImpl rangeMaximum) {
            this.rangeMaximum = rangeMaximum != null ? rangeMaximum.build() : null;
        }

        @Override
        public final Builder rangeMaximum(DataSetNumericFilterValue rangeMaximum) {
            this.rangeMaximum = rangeMaximum;
            return this;
        }

        public final Boolean getIncludeMinimum() {
            return includeMinimum;
        }

        public final void setIncludeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
        }

        @Override
        public final Builder includeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
            return this;
        }

        public final Boolean getIncludeMaximum() {
            return includeMaximum;
        }

        public final void setIncludeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
        }

        @Override
        public final Builder includeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
            return this;
        }

        @Override
        public DataSetNumericRangeFilterCondition build() {
            return new DataSetNumericRangeFilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
