/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter condition for string columns, supporting both comparison and list-based filtering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetStringFilterCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetStringFilterCondition.Builder, DataSetStringFilterCondition> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(DataSetStringFilterCondition::columnName))
            .setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<DataSetStringComparisonFilterCondition> COMPARISON_FILTER_CONDITION_FIELD = SdkField
            .<DataSetStringComparisonFilterCondition> builder(MarshallingType.SDK_POJO).memberName("ComparisonFilterCondition")
            .getter(getter(DataSetStringFilterCondition::comparisonFilterCondition))
            .setter(setter(Builder::comparisonFilterCondition)).constructor(DataSetStringComparisonFilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonFilterCondition").build())
            .build();

    private static final SdkField<DataSetStringListFilterCondition> LIST_FILTER_CONDITION_FIELD = SdkField
            .<DataSetStringListFilterCondition> builder(MarshallingType.SDK_POJO).memberName("ListFilterCondition")
            .getter(getter(DataSetStringFilterCondition::listFilterCondition)).setter(setter(Builder::listFilterCondition))
            .constructor(DataSetStringListFilterCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListFilterCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COMPARISON_FILTER_CONDITION_FIELD, LIST_FILTER_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final DataSetStringComparisonFilterCondition comparisonFilterCondition;

    private final DataSetStringListFilterCondition listFilterCondition;

    private DataSetStringFilterCondition(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.comparisonFilterCondition = builder.comparisonFilterCondition;
        this.listFilterCondition = builder.listFilterCondition;
    }

    /**
     * <p>
     * The name of the string column to filter.
     * </p>
     * 
     * @return The name of the string column to filter.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * A comparison-based filter condition for the string column.
     * </p>
     * 
     * @return A comparison-based filter condition for the string column.
     */
    public final DataSetStringComparisonFilterCondition comparisonFilterCondition() {
        return comparisonFilterCondition;
    }

    /**
     * <p>
     * A list-based filter condition that includes or excludes values from a specified list.
     * </p>
     * 
     * @return A list-based filter condition that includes or excludes values from a specified list.
     */
    public final DataSetStringListFilterCondition listFilterCondition() {
        return listFilterCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonFilterCondition());
        hashCode = 31 * hashCode + Objects.hashCode(listFilterCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetStringFilterCondition)) {
            return false;
        }
        DataSetStringFilterCondition other = (DataSetStringFilterCondition) obj;
        return Objects.equals(columnName(), other.columnName())
                && Objects.equals(comparisonFilterCondition(), other.comparisonFilterCondition())
                && Objects.equals(listFilterCondition(), other.listFilterCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetStringFilterCondition").add("ColumnName", columnName())
                .add("ComparisonFilterCondition", comparisonFilterCondition()).add("ListFilterCondition", listFilterCondition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "ComparisonFilterCondition":
            return Optional.ofNullable(clazz.cast(comparisonFilterCondition()));
        case "ListFilterCondition":
            return Optional.ofNullable(clazz.cast(listFilterCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("ComparisonFilterCondition", COMPARISON_FILTER_CONDITION_FIELD);
        map.put("ListFilterCondition", LIST_FILTER_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetStringFilterCondition, T> g) {
        return obj -> g.apply((DataSetStringFilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetStringFilterCondition> {
        /**
         * <p>
         * The name of the string column to filter.
         * </p>
         * 
         * @param columnName
         *        The name of the string column to filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * A comparison-based filter condition for the string column.
         * </p>
         * 
         * @param comparisonFilterCondition
         *        A comparison-based filter condition for the string column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonFilterCondition(DataSetStringComparisonFilterCondition comparisonFilterCondition);

        /**
         * <p>
         * A comparison-based filter condition for the string column.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataSetStringComparisonFilterCondition.Builder} avoiding the need to create one manually via
         * {@link DataSetStringComparisonFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetStringComparisonFilterCondition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #comparisonFilterCondition(DataSetStringComparisonFilterCondition)}.
         * 
         * @param comparisonFilterCondition
         *        a consumer that will call methods on {@link DataSetStringComparisonFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparisonFilterCondition(DataSetStringComparisonFilterCondition)
         */
        default Builder comparisonFilterCondition(
                Consumer<DataSetStringComparisonFilterCondition.Builder> comparisonFilterCondition) {
            return comparisonFilterCondition(DataSetStringComparisonFilterCondition.builder()
                    .applyMutation(comparisonFilterCondition).build());
        }

        /**
         * <p>
         * A list-based filter condition that includes or excludes values from a specified list.
         * </p>
         * 
         * @param listFilterCondition
         *        A list-based filter condition that includes or excludes values from a specified list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listFilterCondition(DataSetStringListFilterCondition listFilterCondition);

        /**
         * <p>
         * A list-based filter condition that includes or excludes values from a specified list.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetStringListFilterCondition.Builder}
         * avoiding the need to create one manually via {@link DataSetStringListFilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetStringListFilterCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #listFilterCondition(DataSetStringListFilterCondition)}.
         * 
         * @param listFilterCondition
         *        a consumer that will call methods on {@link DataSetStringListFilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listFilterCondition(DataSetStringListFilterCondition)
         */
        default Builder listFilterCondition(Consumer<DataSetStringListFilterCondition.Builder> listFilterCondition) {
            return listFilterCondition(DataSetStringListFilterCondition.builder().applyMutation(listFilterCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private DataSetStringComparisonFilterCondition comparisonFilterCondition;

        private DataSetStringListFilterCondition listFilterCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetStringFilterCondition model) {
            columnName(model.columnName);
            comparisonFilterCondition(model.comparisonFilterCondition);
            listFilterCondition(model.listFilterCondition);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final DataSetStringComparisonFilterCondition.Builder getComparisonFilterCondition() {
            return comparisonFilterCondition != null ? comparisonFilterCondition.toBuilder() : null;
        }

        public final void setComparisonFilterCondition(
                DataSetStringComparisonFilterCondition.BuilderImpl comparisonFilterCondition) {
            this.comparisonFilterCondition = comparisonFilterCondition != null ? comparisonFilterCondition.build() : null;
        }

        @Override
        public final Builder comparisonFilterCondition(DataSetStringComparisonFilterCondition comparisonFilterCondition) {
            this.comparisonFilterCondition = comparisonFilterCondition;
            return this;
        }

        public final DataSetStringListFilterCondition.Builder getListFilterCondition() {
            return listFilterCondition != null ? listFilterCondition.toBuilder() : null;
        }

        public final void setListFilterCondition(DataSetStringListFilterCondition.BuilderImpl listFilterCondition) {
            this.listFilterCondition = listFilterCondition != null ? listFilterCondition.build() : null;
        }

        @Override
        public final Builder listFilterCondition(DataSetStringListFilterCondition listFilterCondition) {
            this.listFilterCondition = listFilterCondition;
            return this;
        }

        @Override
        public DataSetStringFilterCondition build() {
            return new DataSetStringFilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
