/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter condition that includes or excludes string values from a specified list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetStringListFilterCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetStringListFilterCondition.Builder, DataSetStringListFilterCondition> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(DataSetStringListFilterCondition::operatorAsString))
            .setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<DataSetStringListFilterValue> VALUES_FIELD = SdkField
            .<DataSetStringListFilterValue> builder(MarshallingType.SDK_POJO).memberName("Values")
            .getter(getter(DataSetStringListFilterCondition::values)).setter(setter(Builder::values))
            .constructor(DataSetStringListFilterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operator;

    private final DataSetStringListFilterValue values;

    private DataSetStringListFilterCondition(BuilderImpl builder) {
        this.operator = builder.operator;
        this.values = builder.values;
    }

    /**
     * <p>
     * The list operator to use, either <code>INCLUDE</code> to match values in the list or <code>EXCLUDE</code> to
     * filter out values in the list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link DataSetStringListFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The list operator to use, either <code>INCLUDE</code> to match values in the list or <code>EXCLUDE</code>
     *         to filter out values in the list.
     * @see DataSetStringListFilterOperator
     */
    public final DataSetStringListFilterOperator operator() {
        return DataSetStringListFilterOperator.fromValue(operator);
    }

    /**
     * <p>
     * The list operator to use, either <code>INCLUDE</code> to match values in the list or <code>EXCLUDE</code> to
     * filter out values in the list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link DataSetStringListFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The list operator to use, either <code>INCLUDE</code> to match values in the list or <code>EXCLUDE</code>
     *         to filter out values in the list.
     * @see DataSetStringListFilterOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The list of string values to include or exclude in the filter.
     * </p>
     * 
     * @return The list of string values to include or exclude in the filter.
     */
    public final DataSetStringListFilterValue values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetStringListFilterCondition)) {
            return false;
        }
        DataSetStringListFilterCondition other = (DataSetStringListFilterCondition) obj;
        return Objects.equals(operatorAsString(), other.operatorAsString()) && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetStringListFilterCondition").add("Operator", operatorAsString()).add("Values", values())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operator", OPERATOR_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetStringListFilterCondition, T> g) {
        return obj -> g.apply((DataSetStringListFilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetStringListFilterCondition> {
        /**
         * <p>
         * The list operator to use, either <code>INCLUDE</code> to match values in the list or <code>EXCLUDE</code> to
         * filter out values in the list.
         * </p>
         * 
         * @param operator
         *        The list operator to use, either <code>INCLUDE</code> to match values in the list or
         *        <code>EXCLUDE</code> to filter out values in the list.
         * @see DataSetStringListFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetStringListFilterOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The list operator to use, either <code>INCLUDE</code> to match values in the list or <code>EXCLUDE</code> to
         * filter out values in the list.
         * </p>
         * 
         * @param operator
         *        The list operator to use, either <code>INCLUDE</code> to match values in the list or
         *        <code>EXCLUDE</code> to filter out values in the list.
         * @see DataSetStringListFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetStringListFilterOperator
         */
        Builder operator(DataSetStringListFilterOperator operator);

        /**
         * <p>
         * The list of string values to include or exclude in the filter.
         * </p>
         * 
         * @param values
         *        The list of string values to include or exclude in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(DataSetStringListFilterValue values);

        /**
         * <p>
         * The list of string values to include or exclude in the filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetStringListFilterValue.Builder}
         * avoiding the need to create one manually via {@link DataSetStringListFilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetStringListFilterValue.Builder#build()} is called
         * immediately and its result is passed to {@link #values(DataSetStringListFilterValue)}.
         * 
         * @param values
         *        a consumer that will call methods on {@link DataSetStringListFilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(DataSetStringListFilterValue)
         */
        default Builder values(Consumer<DataSetStringListFilterValue.Builder> values) {
            return values(DataSetStringListFilterValue.builder().applyMutation(values).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String operator;

        private DataSetStringListFilterValue values;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetStringListFilterCondition model) {
            operator(model.operator);
            values(model.values);
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(DataSetStringListFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final DataSetStringListFilterValue.Builder getValues() {
            return values != null ? values.toBuilder() : null;
        }

        public final void setValues(DataSetStringListFilterValue.BuilderImpl values) {
            this.values = values != null ? values.build() : null;
        }

        @Override
        public final Builder values(DataSetStringListFilterValue values) {
            this.values = values;
            return this;
        }

        @Override
        public DataSetStringListFilterCondition build() {
            return new DataSetStringListFilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
