/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The basic information of the flow exluding its definition specifying the steps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowSummary implements SdkPojo, Serializable, ToCopyableBuilder<FlowSummary.Builder, FlowSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(FlowSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FlowId")
            .getter(getter(FlowSummary::flowId)).setter(setter(Builder::flowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FlowSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(FlowSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(FlowSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(FlowSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(FlowSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedBy").getter(getter(FlowSummary::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()).build();

    private static final SdkField<String> PUBLISH_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishState").getter(getter(FlowSummary::publishStateAsString)).setter(setter(Builder::publishState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishState").build()).build();

    private static final SdkField<Integer> RUN_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RunCount").getter(getter(FlowSummary::runCount)).setter(setter(Builder::runCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunCount").build()).build();

    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UserCount").getter(getter(FlowSummary::userCount)).setter(setter(Builder::userCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCount").build()).build();

    private static final SdkField<String> LAST_PUBLISHED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastPublishedBy").getter(getter(FlowSummary::lastPublishedBy)).setter(setter(Builder::lastPublishedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPublishedBy").build()).build();

    private static final SdkField<Instant> LAST_PUBLISHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastPublishedAt").getter(getter(FlowSummary::lastPublishedAt)).setter(setter(Builder::lastPublishedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPublishedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FLOW_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, CREATED_TIME_FIELD, CREATED_BY_FIELD, LAST_UPDATED_TIME_FIELD, LAST_UPDATED_BY_FIELD,
            PUBLISH_STATE_FIELD, RUN_COUNT_FIELD, USER_COUNT_FIELD, LAST_PUBLISHED_BY_FIELD, LAST_PUBLISHED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String flowId;

    private final String name;

    private final String description;

    private final Instant createdTime;

    private final String createdBy;

    private final Instant lastUpdatedTime;

    private final String lastUpdatedBy;

    private final String publishState;

    private final Integer runCount;

    private final Integer userCount;

    private final String lastPublishedBy;

    private final Instant lastPublishedAt;

    private FlowSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.flowId = builder.flowId;
        this.name = builder.name;
        this.description = builder.description;
        this.createdTime = builder.createdTime;
        this.createdBy = builder.createdBy;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.publishState = builder.publishState;
        this.runCount = builder.runCount;
        this.userCount = builder.userCount;
        this.lastPublishedBy = builder.lastPublishedBy;
        this.lastPublishedAt = builder.lastPublishedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowId() {
        return flowId;
    }

    /**
     * <p>
     * The display name of the flow.
     * </p>
     * 
     * @return The display name of the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the flow.
     * </p>
     * 
     * @return The description of the flow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time this flow was created.
     * </p>
     * 
     * @return The time this flow was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The identifier of the principal who created the flow.
     * </p>
     * 
     * @return The identifier of the principal who created the flow.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The last time this flow was modified.
     * </p>
     * 
     * @return The last time this flow was modified.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The identifier of the last principal who updated the flow.
     * </p>
     * 
     * @return The identifier of the last principal who updated the flow.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p>
     * The publish state for the flow. The valid values are <code>DRAFT</code>, <code>PUBLISHED</code>, or
     * <code>PENDING_APPROVAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publishState} will
     * return {@link FlowPublishState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #publishStateAsString}.
     * </p>
     * 
     * @return The publish state for the flow. The valid values are <code>DRAFT</code>, <code>PUBLISHED</code>, or
     *         <code>PENDING_APPROVAL</code>.
     * @see FlowPublishState
     */
    public final FlowPublishState publishState() {
        return FlowPublishState.fromValue(publishState);
    }

    /**
     * <p>
     * The publish state for the flow. The valid values are <code>DRAFT</code>, <code>PUBLISHED</code>, or
     * <code>PENDING_APPROVAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publishState} will
     * return {@link FlowPublishState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #publishStateAsString}.
     * </p>
     * 
     * @return The publish state for the flow. The valid values are <code>DRAFT</code>, <code>PUBLISHED</code>, or
     *         <code>PENDING_APPROVAL</code>.
     * @see FlowPublishState
     */
    public final String publishStateAsString() {
        return publishState;
    }

    /**
     * <p>
     * The number of runs done for the flow.
     * </p>
     * 
     * @return The number of runs done for the flow.
     */
    public final Integer runCount() {
        return runCount;
    }

    /**
     * <p>
     * The number of users who have used the flow.
     * </p>
     * 
     * @return The number of users who have used the flow.
     */
    public final Integer userCount() {
        return userCount;
    }

    /**
     * <p>
     * The identifier of the last principal who published the flow.
     * </p>
     * 
     * @return The identifier of the last principal who published the flow.
     */
    public final String lastPublishedBy() {
        return lastPublishedBy;
    }

    /**
     * <p>
     * The last time this flow was published.
     * </p>
     * 
     * @return The last time this flow was published.
     */
    public final Instant lastPublishedAt() {
        return lastPublishedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(flowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(publishStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runCount());
        hashCode = 31 * hashCode + Objects.hashCode(userCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastPublishedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastPublishedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowSummary)) {
            return false;
        }
        FlowSummary other = (FlowSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(flowId(), other.flowId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy())
                && Objects.equals(publishStateAsString(), other.publishStateAsString())
                && Objects.equals(runCount(), other.runCount()) && Objects.equals(userCount(), other.userCount())
                && Objects.equals(lastPublishedBy(), other.lastPublishedBy())
                && Objects.equals(lastPublishedAt(), other.lastPublishedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowSummary").add("Arn", arn()).add("FlowId", flowId()).add("Name", name())
                .add("Description", description()).add("CreatedTime", createdTime()).add("CreatedBy", createdBy())
                .add("LastUpdatedTime", lastUpdatedTime()).add("LastUpdatedBy", lastUpdatedBy())
                .add("PublishState", publishStateAsString()).add("RunCount", runCount()).add("UserCount", userCount())
                .add("LastPublishedBy", lastPublishedBy()).add("LastPublishedAt", lastPublishedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "FlowId":
            return Optional.ofNullable(clazz.cast(flowId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "LastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "PublishState":
            return Optional.ofNullable(clazz.cast(publishStateAsString()));
        case "RunCount":
            return Optional.ofNullable(clazz.cast(runCount()));
        case "UserCount":
            return Optional.ofNullable(clazz.cast(userCount()));
        case "LastPublishedBy":
            return Optional.ofNullable(clazz.cast(lastPublishedBy()));
        case "LastPublishedAt":
            return Optional.ofNullable(clazz.cast(lastPublishedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("FlowId", FLOW_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("PublishState", PUBLISH_STATE_FIELD);
        map.put("RunCount", RUN_COUNT_FIELD);
        map.put("UserCount", USER_COUNT_FIELD);
        map.put("LastPublishedBy", LAST_PUBLISHED_BY_FIELD);
        map.put("LastPublishedAt", LAST_PUBLISHED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowSummary, T> g) {
        return obj -> g.apply((FlowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowId
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowId(String flowId);

        /**
         * <p>
         * The display name of the flow.
         * </p>
         * 
         * @param name
         *        The display name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the flow.
         * </p>
         * 
         * @param description
         *        The description of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time this flow was created.
         * </p>
         * 
         * @param createdTime
         *        The time this flow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The identifier of the principal who created the flow.
         * </p>
         * 
         * @param createdBy
         *        The identifier of the principal who created the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The last time this flow was modified.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time this flow was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The identifier of the last principal who updated the flow.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The identifier of the last principal who updated the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The publish state for the flow. The valid values are <code>DRAFT</code>, <code>PUBLISHED</code>, or
         * <code>PENDING_APPROVAL</code>.
         * </p>
         * 
         * @param publishState
         *        The publish state for the flow. The valid values are <code>DRAFT</code>, <code>PUBLISHED</code>, or
         *        <code>PENDING_APPROVAL</code>.
         * @see FlowPublishState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowPublishState
         */
        Builder publishState(String publishState);

        /**
         * <p>
         * The publish state for the flow. The valid values are <code>DRAFT</code>, <code>PUBLISHED</code>, or
         * <code>PENDING_APPROVAL</code>.
         * </p>
         * 
         * @param publishState
         *        The publish state for the flow. The valid values are <code>DRAFT</code>, <code>PUBLISHED</code>, or
         *        <code>PENDING_APPROVAL</code>.
         * @see FlowPublishState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowPublishState
         */
        Builder publishState(FlowPublishState publishState);

        /**
         * <p>
         * The number of runs done for the flow.
         * </p>
         * 
         * @param runCount
         *        The number of runs done for the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runCount(Integer runCount);

        /**
         * <p>
         * The number of users who have used the flow.
         * </p>
         * 
         * @param userCount
         *        The number of users who have used the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCount(Integer userCount);

        /**
         * <p>
         * The identifier of the last principal who published the flow.
         * </p>
         * 
         * @param lastPublishedBy
         *        The identifier of the last principal who published the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastPublishedBy(String lastPublishedBy);

        /**
         * <p>
         * The last time this flow was published.
         * </p>
         * 
         * @param lastPublishedAt
         *        The last time this flow was published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastPublishedAt(Instant lastPublishedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String flowId;

        private String name;

        private String description;

        private Instant createdTime;

        private String createdBy;

        private Instant lastUpdatedTime;

        private String lastUpdatedBy;

        private String publishState;

        private Integer runCount;

        private Integer userCount;

        private String lastPublishedBy;

        private Instant lastPublishedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowSummary model) {
            arn(model.arn);
            flowId(model.flowId);
            name(model.name);
            description(model.description);
            createdTime(model.createdTime);
            createdBy(model.createdBy);
            lastUpdatedTime(model.lastUpdatedTime);
            lastUpdatedBy(model.lastUpdatedBy);
            publishState(model.publishState);
            runCount(model.runCount);
            userCount(model.userCount);
            lastPublishedBy(model.lastPublishedBy);
            lastPublishedAt(model.lastPublishedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFlowId() {
            return flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getPublishState() {
            return publishState;
        }

        public final void setPublishState(String publishState) {
            this.publishState = publishState;
        }

        @Override
        public final Builder publishState(String publishState) {
            this.publishState = publishState;
            return this;
        }

        @Override
        public final Builder publishState(FlowPublishState publishState) {
            this.publishState(publishState == null ? null : publishState.toString());
            return this;
        }

        public final Integer getRunCount() {
            return runCount;
        }

        public final void setRunCount(Integer runCount) {
            this.runCount = runCount;
        }

        @Override
        public final Builder runCount(Integer runCount) {
            this.runCount = runCount;
            return this;
        }

        public final Integer getUserCount() {
            return userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final String getLastPublishedBy() {
            return lastPublishedBy;
        }

        public final void setLastPublishedBy(String lastPublishedBy) {
            this.lastPublishedBy = lastPublishedBy;
        }

        @Override
        public final Builder lastPublishedBy(String lastPublishedBy) {
            this.lastPublishedBy = lastPublishedBy;
            return this;
        }

        public final Instant getLastPublishedAt() {
            return lastPublishedAt;
        }

        public final void setLastPublishedAt(Instant lastPublishedAt) {
            this.lastPublishedAt = lastPublishedAt;
        }

        @Override
        public final Builder lastPublishedAt(Instant lastPublishedAt) {
            this.lastPublishedAt = lastPublishedAt;
            return this;
        }

        @Override
        public FlowSummary build() {
            return new FlowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
