/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that imports data from a source table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTableOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportTableOperation.Builder, ImportTableOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(ImportTableOperation::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<ImportTableOperationSource> SOURCE_FIELD = SdkField
            .<ImportTableOperationSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(ImportTableOperation::source)).setter(setter(Builder::source))
            .constructor(ImportTableOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final ImportTableOperationSource source;

    private ImportTableOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
    }

    /**
     * <p>
     * Alias for this operation.
     * </p>
     * 
     * @return Alias for this operation.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The source configuration that specifies which source table to import and any column mappings.
     * </p>
     * 
     * @return The source configuration that specifies which source table to import and any column mappings.
     */
    public final ImportTableOperationSource source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTableOperation)) {
            return false;
        }
        ImportTableOperation other = (ImportTableOperation) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTableOperation").add("Alias", alias()).add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportTableOperation, T> g) {
        return obj -> g.apply((ImportTableOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTableOperation> {
        /**
         * <p>
         * Alias for this operation.
         * </p>
         * 
         * @param alias
         *        Alias for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The source configuration that specifies which source table to import and any column mappings.
         * </p>
         * 
         * @param source
         *        The source configuration that specifies which source table to import and any column mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ImportTableOperationSource source);

        /**
         * <p>
         * The source configuration that specifies which source table to import and any column mappings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportTableOperationSource.Builder}
         * avoiding the need to create one manually via {@link ImportTableOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportTableOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(ImportTableOperationSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ImportTableOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ImportTableOperationSource)
         */
        default Builder source(Consumer<ImportTableOperationSource.Builder> source) {
            return source(ImportTableOperationSource.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private ImportTableOperationSource source;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTableOperation model) {
            alias(model.alias);
            source(model.source);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final ImportTableOperationSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ImportTableOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ImportTableOperationSource source) {
            this.source = source;
            return this;
        }

        @Override
        public ImportTableOperation build() {
            return new ImportTableOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
