/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties that control how columns are handled for a join operand, including column name overrides.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinOperandProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<JoinOperandProperties.Builder, JoinOperandProperties> {
    private static final SdkField<List<OutputColumnNameOverride>> OUTPUT_COLUMN_NAME_OVERRIDES_FIELD = SdkField
            .<List<OutputColumnNameOverride>> builder(MarshallingType.LIST)
            .memberName("OutputColumnNameOverrides")
            .getter(getter(JoinOperandProperties::outputColumnNameOverrides))
            .setter(setter(Builder::outputColumnNameOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputColumnNameOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputColumnNameOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputColumnNameOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OUTPUT_COLUMN_NAME_OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<OutputColumnNameOverride> outputColumnNameOverrides;

    private JoinOperandProperties(BuilderImpl builder) {
        this.outputColumnNameOverrides = builder.outputColumnNameOverrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputColumnNameOverrides property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOutputColumnNameOverrides() {
        return outputColumnNameOverrides != null && !(outputColumnNameOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of column name overrides to apply to the join operand's output columns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputColumnNameOverrides} method.
     * </p>
     * 
     * @return A list of column name overrides to apply to the join operand's output columns.
     */
    public final List<OutputColumnNameOverride> outputColumnNameOverrides() {
        return outputColumnNameOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputColumnNameOverrides() ? outputColumnNameOverrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinOperandProperties)) {
            return false;
        }
        JoinOperandProperties other = (JoinOperandProperties) obj;
        return hasOutputColumnNameOverrides() == other.hasOutputColumnNameOverrides()
                && Objects.equals(outputColumnNameOverrides(), other.outputColumnNameOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JoinOperandProperties")
                .add("OutputColumnNameOverrides", hasOutputColumnNameOverrides() ? outputColumnNameOverrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputColumnNameOverrides":
            return Optional.ofNullable(clazz.cast(outputColumnNameOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutputColumnNameOverrides", OUTPUT_COLUMN_NAME_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JoinOperandProperties, T> g) {
        return obj -> g.apply((JoinOperandProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JoinOperandProperties> {
        /**
         * <p>
         * A list of column name overrides to apply to the join operand's output columns.
         * </p>
         * 
         * @param outputColumnNameOverrides
         *        A list of column name overrides to apply to the join operand's output columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputColumnNameOverrides(Collection<OutputColumnNameOverride> outputColumnNameOverrides);

        /**
         * <p>
         * A list of column name overrides to apply to the join operand's output columns.
         * </p>
         * 
         * @param outputColumnNameOverrides
         *        A list of column name overrides to apply to the join operand's output columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputColumnNameOverrides(OutputColumnNameOverride... outputColumnNameOverrides);

        /**
         * <p>
         * A list of column name overrides to apply to the join operand's output columns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.OutputColumnNameOverride.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.OutputColumnNameOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.OutputColumnNameOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #outputColumnNameOverrides(List<OutputColumnNameOverride>)}.
         * 
         * @param outputColumnNameOverrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.OutputColumnNameOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputColumnNameOverrides(java.util.Collection<OutputColumnNameOverride>)
         */
        Builder outputColumnNameOverrides(Consumer<OutputColumnNameOverride.Builder>... outputColumnNameOverrides);
    }

    static final class BuilderImpl implements Builder {
        private List<OutputColumnNameOverride> outputColumnNameOverrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JoinOperandProperties model) {
            outputColumnNameOverrides(model.outputColumnNameOverrides);
        }

        public final List<OutputColumnNameOverride.Builder> getOutputColumnNameOverrides() {
            List<OutputColumnNameOverride.Builder> result = OutputColumnNameOverrideListCopier
                    .copyToBuilder(this.outputColumnNameOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputColumnNameOverrides(Collection<OutputColumnNameOverride.BuilderImpl> outputColumnNameOverrides) {
            this.outputColumnNameOverrides = OutputColumnNameOverrideListCopier.copyFromBuilder(outputColumnNameOverrides);
        }

        @Override
        public final Builder outputColumnNameOverrides(Collection<OutputColumnNameOverride> outputColumnNameOverrides) {
            this.outputColumnNameOverrides = OutputColumnNameOverrideListCopier.copy(outputColumnNameOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputColumnNameOverrides(OutputColumnNameOverride... outputColumnNameOverrides) {
            outputColumnNameOverrides(Arrays.asList(outputColumnNameOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputColumnNameOverrides(Consumer<OutputColumnNameOverride.Builder>... outputColumnNameOverrides) {
            outputColumnNameOverrides(Stream.of(outputColumnNameOverrides)
                    .map(c -> OutputColumnNameOverride.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public JoinOperandProperties build() {
            return new JoinOperandProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
