/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * References a parent dataset that serves as a data source, including its columns and metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParentDataSet implements SdkPojo, Serializable, ToCopyableBuilder<ParentDataSet.Builder, ParentDataSet> {
    private static final SdkField<String> DATA_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetArn").getter(getter(ParentDataSet::dataSetArn)).setter(setter(Builder::dataSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArn").build()).build();

    private static final SdkField<List<InputColumn>> INPUT_COLUMNS_FIELD = SdkField
            .<List<InputColumn>> builder(MarshallingType.LIST)
            .memberName("InputColumns")
            .getter(getter(ParentDataSet::inputColumns))
            .setter(setter(Builder::inputColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ARN_FIELD,
            INPUT_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSetArn;

    private final List<InputColumn> inputColumns;

    private ParentDataSet(BuilderImpl builder) {
        this.dataSetArn = builder.dataSetArn;
        this.inputColumns = builder.inputColumns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the parent dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the parent dataset.
     */
    public final String dataSetArn() {
        return dataSetArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputColumns() {
        return inputColumns != null && !(inputColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of input columns available from the parent dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputColumns} method.
     * </p>
     * 
     * @return The list of input columns available from the parent dataset.
     */
    public final List<InputColumn> inputColumns() {
        return inputColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputColumns() ? inputColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentDataSet)) {
            return false;
        }
        ParentDataSet other = (ParentDataSet) obj;
        return Objects.equals(dataSetArn(), other.dataSetArn()) && hasInputColumns() == other.hasInputColumns()
                && Objects.equals(inputColumns(), other.inputColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParentDataSet").add("DataSetArn", dataSetArn())
                .add("InputColumns", hasInputColumns() ? inputColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetArn":
            return Optional.ofNullable(clazz.cast(dataSetArn()));
        case "InputColumns":
            return Optional.ofNullable(clazz.cast(inputColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSetArn", DATA_SET_ARN_FIELD);
        map.put("InputColumns", INPUT_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParentDataSet, T> g) {
        return obj -> g.apply((ParentDataSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParentDataSet> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the parent dataset.
         * </p>
         * 
         * @param dataSetArn
         *        The Amazon Resource Name (ARN) of the parent dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetArn(String dataSetArn);

        /**
         * <p>
         * The list of input columns available from the parent dataset.
         * </p>
         * 
         * @param inputColumns
         *        The list of input columns available from the parent dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumns(Collection<InputColumn> inputColumns);

        /**
         * <p>
         * The list of input columns available from the parent dataset.
         * </p>
         * 
         * @param inputColumns
         *        The list of input columns available from the parent dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumns(InputColumn... inputColumns);

        /**
         * <p>
         * The list of input columns available from the parent dataset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.InputColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder#build()} is called immediately
         * and its result is passed to {@link #inputColumns(List<InputColumn>)}.
         * 
         * @param inputColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputColumns(java.util.Collection<InputColumn>)
         */
        Builder inputColumns(Consumer<InputColumn.Builder>... inputColumns);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetArn;

        private List<InputColumn> inputColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParentDataSet model) {
            dataSetArn(model.dataSetArn);
            inputColumns(model.inputColumns);
        }

        public final String getDataSetArn() {
            return dataSetArn;
        }

        public final void setDataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
        }

        @Override
        public final Builder dataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
            return this;
        }

        public final List<InputColumn.Builder> getInputColumns() {
            List<InputColumn.Builder> result = InputColumnListCopier.copyToBuilder(this.inputColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputColumns(Collection<InputColumn.BuilderImpl> inputColumns) {
            this.inputColumns = InputColumnListCopier.copyFromBuilder(inputColumns);
        }

        @Override
        public final Builder inputColumns(Collection<InputColumn> inputColumns) {
            this.inputColumns = InputColumnListCopier.copy(inputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(InputColumn... inputColumns) {
            inputColumns(Arrays.asList(inputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(Consumer<InputColumn.Builder>... inputColumns) {
            inputColumns(Stream.of(inputColumns).map(c -> InputColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ParentDataSet build() {
            return new ParentDataSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
