/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Read-only metadata for OAuth2 authorization code grant authentication configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadAuthorizationCodeGrantMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ReadAuthorizationCodeGrantMetadata.Builder, ReadAuthorizationCodeGrantMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseEndpoint").getter(getter(ReadAuthorizationCodeGrantMetadata::baseEndpoint))
            .setter(setter(Builder::baseEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()).build();

    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedirectUrl").getter(getter(ReadAuthorizationCodeGrantMetadata::redirectUrl))
            .setter(setter(Builder::redirectUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectUrl").build()).build();

    private static final SdkField<ReadAuthorizationCodeGrantCredentialsDetails> READ_AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD = SdkField
            .<ReadAuthorizationCodeGrantCredentialsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ReadAuthorizationCodeGrantCredentialsDetails")
            .getter(getter(ReadAuthorizationCodeGrantMetadata::readAuthorizationCodeGrantCredentialsDetails))
            .setter(setter(Builder::readAuthorizationCodeGrantCredentialsDetails))
            .constructor(ReadAuthorizationCodeGrantCredentialsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReadAuthorizationCodeGrantCredentialsDetails").build()).build();

    private static final SdkField<String> AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationCodeGrantCredentialsSource")
            .getter(getter(ReadAuthorizationCodeGrantMetadata::authorizationCodeGrantCredentialsSourceAsString))
            .setter(setter(Builder::authorizationCodeGrantCredentialsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AuthorizationCodeGrantCredentialsSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD,
            REDIRECT_URL_FIELD, READ_AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD,
            AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String baseEndpoint;

    private final String redirectUrl;

    private final ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails;

    private final String authorizationCodeGrantCredentialsSource;

    private ReadAuthorizationCodeGrantMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.redirectUrl = builder.redirectUrl;
        this.readAuthorizationCodeGrantCredentialsDetails = builder.readAuthorizationCodeGrantCredentialsDetails;
        this.authorizationCodeGrantCredentialsSource = builder.authorizationCodeGrantCredentialsSource;
    }

    /**
     * <p>
     * The base endpoint URL for the OAuth2 authorization code grant flow.
     * </p>
     * 
     * @return The base endpoint URL for the OAuth2 authorization code grant flow.
     */
    public final String baseEndpoint() {
        return baseEndpoint;
    }

    /**
     * <p>
     * The redirect URL where the authorization server will send the user after authorization.
     * </p>
     * 
     * @return The redirect URL where the authorization server will send the user after authorization.
     */
    public final String redirectUrl() {
        return redirectUrl;
    }

    /**
     * <p>
     * The read-only credentials details for the authorization code grant flow.
     * </p>
     * 
     * @return The read-only credentials details for the authorization code grant flow.
     */
    public final ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails() {
        return readAuthorizationCodeGrantCredentialsDetails;
    }

    /**
     * <p>
     * The source of credentials for the authorization code grant flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationCodeGrantCredentialsSource} will return
     * {@link AuthorizationCodeGrantCredentialsSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationCodeGrantCredentialsSourceAsString}.
     * </p>
     * 
     * @return The source of credentials for the authorization code grant flow.
     * @see AuthorizationCodeGrantCredentialsSource
     */
    public final AuthorizationCodeGrantCredentialsSource authorizationCodeGrantCredentialsSource() {
        return AuthorizationCodeGrantCredentialsSource.fromValue(authorizationCodeGrantCredentialsSource);
    }

    /**
     * <p>
     * The source of credentials for the authorization code grant flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationCodeGrantCredentialsSource} will return
     * {@link AuthorizationCodeGrantCredentialsSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationCodeGrantCredentialsSourceAsString}.
     * </p>
     * 
     * @return The source of credentials for the authorization code grant flow.
     * @see AuthorizationCodeGrantCredentialsSource
     */
    public final String authorizationCodeGrantCredentialsSourceAsString() {
        return authorizationCodeGrantCredentialsSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(redirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(readAuthorizationCodeGrantCredentialsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationCodeGrantCredentialsSourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadAuthorizationCodeGrantMetadata)) {
            return false;
        }
        ReadAuthorizationCodeGrantMetadata other = (ReadAuthorizationCodeGrantMetadata) obj;
        return Objects.equals(baseEndpoint(), other.baseEndpoint())
                && Objects.equals(redirectUrl(), other.redirectUrl())
                && Objects.equals(readAuthorizationCodeGrantCredentialsDetails(),
                        other.readAuthorizationCodeGrantCredentialsDetails())
                && Objects.equals(authorizationCodeGrantCredentialsSourceAsString(),
                        other.authorizationCodeGrantCredentialsSourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadAuthorizationCodeGrantMetadata").add("BaseEndpoint", baseEndpoint())
                .add("RedirectUrl", redirectUrl())
                .add("ReadAuthorizationCodeGrantCredentialsDetails", readAuthorizationCodeGrantCredentialsDetails())
                .add("AuthorizationCodeGrantCredentialsSource", authorizationCodeGrantCredentialsSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseEndpoint":
            return Optional.ofNullable(clazz.cast(baseEndpoint()));
        case "RedirectUrl":
            return Optional.ofNullable(clazz.cast(redirectUrl()));
        case "ReadAuthorizationCodeGrantCredentialsDetails":
            return Optional.ofNullable(clazz.cast(readAuthorizationCodeGrantCredentialsDetails()));
        case "AuthorizationCodeGrantCredentialsSource":
            return Optional.ofNullable(clazz.cast(authorizationCodeGrantCredentialsSourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("RedirectUrl", REDIRECT_URL_FIELD);
        map.put("ReadAuthorizationCodeGrantCredentialsDetails", READ_AUTHORIZATION_CODE_GRANT_CREDENTIALS_DETAILS_FIELD);
        map.put("AuthorizationCodeGrantCredentialsSource", AUTHORIZATION_CODE_GRANT_CREDENTIALS_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadAuthorizationCodeGrantMetadata, T> g) {
        return obj -> g.apply((ReadAuthorizationCodeGrantMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadAuthorizationCodeGrantMetadata> {
        /**
         * <p>
         * The base endpoint URL for the OAuth2 authorization code grant flow.
         * </p>
         * 
         * @param baseEndpoint
         *        The base endpoint URL for the OAuth2 authorization code grant flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpoint(String baseEndpoint);

        /**
         * <p>
         * The redirect URL where the authorization server will send the user after authorization.
         * </p>
         * 
         * @param redirectUrl
         *        The redirect URL where the authorization server will send the user after authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectUrl(String redirectUrl);

        /**
         * <p>
         * The read-only credentials details for the authorization code grant flow.
         * </p>
         * 
         * @param readAuthorizationCodeGrantCredentialsDetails
         *        The read-only credentials details for the authorization code grant flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readAuthorizationCodeGrantCredentialsDetails(
                ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails);

        /**
         * <p>
         * The read-only credentials details for the authorization code grant flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReadAuthorizationCodeGrantCredentialsDetails.Builder} avoiding the need to create one manually via
         * {@link ReadAuthorizationCodeGrantCredentialsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadAuthorizationCodeGrantCredentialsDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #readAuthorizationCodeGrantCredentialsDetails(ReadAuthorizationCodeGrantCredentialsDetails)}.
         * 
         * @param readAuthorizationCodeGrantCredentialsDetails
         *        a consumer that will call methods on {@link ReadAuthorizationCodeGrantCredentialsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readAuthorizationCodeGrantCredentialsDetails(ReadAuthorizationCodeGrantCredentialsDetails)
         */
        default Builder readAuthorizationCodeGrantCredentialsDetails(
                Consumer<ReadAuthorizationCodeGrantCredentialsDetails.Builder> readAuthorizationCodeGrantCredentialsDetails) {
            return readAuthorizationCodeGrantCredentialsDetails(ReadAuthorizationCodeGrantCredentialsDetails.builder()
                    .applyMutation(readAuthorizationCodeGrantCredentialsDetails).build());
        }

        /**
         * <p>
         * The source of credentials for the authorization code grant flow.
         * </p>
         * 
         * @param authorizationCodeGrantCredentialsSource
         *        The source of credentials for the authorization code grant flow.
         * @see AuthorizationCodeGrantCredentialsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationCodeGrantCredentialsSource
         */
        Builder authorizationCodeGrantCredentialsSource(String authorizationCodeGrantCredentialsSource);

        /**
         * <p>
         * The source of credentials for the authorization code grant flow.
         * </p>
         * 
         * @param authorizationCodeGrantCredentialsSource
         *        The source of credentials for the authorization code grant flow.
         * @see AuthorizationCodeGrantCredentialsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationCodeGrantCredentialsSource
         */
        Builder authorizationCodeGrantCredentialsSource(
                AuthorizationCodeGrantCredentialsSource authorizationCodeGrantCredentialsSource);
    }

    static final class BuilderImpl implements Builder {
        private String baseEndpoint;

        private String redirectUrl;

        private ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails;

        private String authorizationCodeGrantCredentialsSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadAuthorizationCodeGrantMetadata model) {
            baseEndpoint(model.baseEndpoint);
            redirectUrl(model.redirectUrl);
            readAuthorizationCodeGrantCredentialsDetails(model.readAuthorizationCodeGrantCredentialsDetails);
            authorizationCodeGrantCredentialsSource(model.authorizationCodeGrantCredentialsSource);
        }

        public final String getBaseEndpoint() {
            return baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final String getRedirectUrl() {
            return redirectUrl;
        }

        public final void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        @Override
        public final Builder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public final ReadAuthorizationCodeGrantCredentialsDetails.Builder getReadAuthorizationCodeGrantCredentialsDetails() {
            return readAuthorizationCodeGrantCredentialsDetails != null ? readAuthorizationCodeGrantCredentialsDetails
                    .toBuilder() : null;
        }

        public final void setReadAuthorizationCodeGrantCredentialsDetails(
                ReadAuthorizationCodeGrantCredentialsDetails.BuilderImpl readAuthorizationCodeGrantCredentialsDetails) {
            this.readAuthorizationCodeGrantCredentialsDetails = readAuthorizationCodeGrantCredentialsDetails != null ? readAuthorizationCodeGrantCredentialsDetails
                    .build() : null;
        }

        @Override
        public final Builder readAuthorizationCodeGrantCredentialsDetails(
                ReadAuthorizationCodeGrantCredentialsDetails readAuthorizationCodeGrantCredentialsDetails) {
            this.readAuthorizationCodeGrantCredentialsDetails = readAuthorizationCodeGrantCredentialsDetails;
            return this;
        }

        public final String getAuthorizationCodeGrantCredentialsSource() {
            return authorizationCodeGrantCredentialsSource;
        }

        public final void setAuthorizationCodeGrantCredentialsSource(String authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource = authorizationCodeGrantCredentialsSource;
        }

        @Override
        public final Builder authorizationCodeGrantCredentialsSource(String authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource = authorizationCodeGrantCredentialsSource;
            return this;
        }

        @Override
        public final Builder authorizationCodeGrantCredentialsSource(
                AuthorizationCodeGrantCredentialsSource authorizationCodeGrantCredentialsSource) {
            this.authorizationCodeGrantCredentialsSource(authorizationCodeGrantCredentialsSource == null ? null
                    : authorizationCodeGrantCredentialsSource.toString());
            return this;
        }

        @Override
        public ReadAuthorizationCodeGrantMetadata build() {
            return new ReadAuthorizationCodeGrantMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
