/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the semantic model that defines how prepared data is structured for analysis and reporting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SemanticModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SemanticModelConfiguration.Builder, SemanticModelConfiguration> {
    private static final SdkField<Map<String, SemanticTable>> TABLE_MAP_FIELD = SdkField
            .<Map<String, SemanticTable>> builder(MarshallingType.MAP)
            .memberName("TableMap")
            .getter(getter(SemanticModelConfiguration::tableMap))
            .setter(setter(Builder::tableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SemanticTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(SemanticTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, SemanticTable> tableMap;

    private SemanticModelConfiguration(BuilderImpl builder) {
        this.tableMap = builder.tableMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the TableMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTableMap() {
        return tableMap != null && !(tableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of semantic tables that define the analytical structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTableMap} method.
     * </p>
     * 
     * @return A map of semantic tables that define the analytical structure.
     */
    public final Map<String, SemanticTable> tableMap() {
        return tableMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTableMap() ? tableMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticModelConfiguration)) {
            return false;
        }
        SemanticModelConfiguration other = (SemanticModelConfiguration) obj;
        return hasTableMap() == other.hasTableMap() && Objects.equals(tableMap(), other.tableMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SemanticModelConfiguration").add("TableMap", hasTableMap() ? tableMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableMap":
            return Optional.ofNullable(clazz.cast(tableMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableMap", TABLE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticModelConfiguration, T> g) {
        return obj -> g.apply((SemanticModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SemanticModelConfiguration> {
        /**
         * <p>
         * A map of semantic tables that define the analytical structure.
         * </p>
         * 
         * @param tableMap
         *        A map of semantic tables that define the analytical structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableMap(Map<String, SemanticTable> tableMap);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, SemanticTable> tableMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticModelConfiguration model) {
            tableMap(model.tableMap);
        }

        public final Map<String, SemanticTable.Builder> getTableMap() {
            Map<String, SemanticTable.Builder> result = SemanticTableMapCopier.copyToBuilder(this.tableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTableMap(Map<String, SemanticTable.BuilderImpl> tableMap) {
            this.tableMap = SemanticTableMapCopier.copyFromBuilder(tableMap);
        }

        @Override
        public final Builder tableMap(Map<String, SemanticTable> tableMap) {
            this.tableMap = SemanticTableMapCopier.copy(tableMap);
            return this;
        }

        @Override
        public SemanticModelConfiguration build() {
            return new SemanticModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
