/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The general textbox interactions setup for textbox publish options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextBoxInteractionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TextBoxInteractionOptions.Builder, TextBoxInteractionOptions> {
    private static final SdkField<TextBoxMenuOption> TEXT_BOX_MENU_OPTION_FIELD = SdkField
            .<TextBoxMenuOption> builder(MarshallingType.SDK_POJO).memberName("TextBoxMenuOption")
            .getter(getter(TextBoxInteractionOptions::textBoxMenuOption)).setter(setter(Builder::textBoxMenuOption))
            .constructor(TextBoxMenuOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextBoxMenuOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_BOX_MENU_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TextBoxMenuOption textBoxMenuOption;

    private TextBoxInteractionOptions(BuilderImpl builder) {
        this.textBoxMenuOption = builder.textBoxMenuOption;
    }

    /**
     * <p>
     * The menu options for the textbox.
     * </p>
     * 
     * @return The menu options for the textbox.
     */
    public final TextBoxMenuOption textBoxMenuOption() {
        return textBoxMenuOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textBoxMenuOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextBoxInteractionOptions)) {
            return false;
        }
        TextBoxInteractionOptions other = (TextBoxInteractionOptions) obj;
        return Objects.equals(textBoxMenuOption(), other.textBoxMenuOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextBoxInteractionOptions").add("TextBoxMenuOption", textBoxMenuOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextBoxMenuOption":
            return Optional.ofNullable(clazz.cast(textBoxMenuOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TextBoxMenuOption", TEXT_BOX_MENU_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextBoxInteractionOptions, T> g) {
        return obj -> g.apply((TextBoxInteractionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextBoxInteractionOptions> {
        /**
         * <p>
         * The menu options for the textbox.
         * </p>
         * 
         * @param textBoxMenuOption
         *        The menu options for the textbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textBoxMenuOption(TextBoxMenuOption textBoxMenuOption);

        /**
         * <p>
         * The menu options for the textbox.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextBoxMenuOption.Builder} avoiding the
         * need to create one manually via {@link TextBoxMenuOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextBoxMenuOption.Builder#build()} is called immediately and its
         * result is passed to {@link #textBoxMenuOption(TextBoxMenuOption)}.
         * 
         * @param textBoxMenuOption
         *        a consumer that will call methods on {@link TextBoxMenuOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textBoxMenuOption(TextBoxMenuOption)
         */
        default Builder textBoxMenuOption(Consumer<TextBoxMenuOption.Builder> textBoxMenuOption) {
            return textBoxMenuOption(TextBoxMenuOption.builder().applyMutation(textBoxMenuOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TextBoxMenuOption textBoxMenuOption;

        private BuilderImpl() {
        }

        private BuilderImpl(TextBoxInteractionOptions model) {
            textBoxMenuOption(model.textBoxMenuOption);
        }

        public final TextBoxMenuOption.Builder getTextBoxMenuOption() {
            return textBoxMenuOption != null ? textBoxMenuOption.toBuilder() : null;
        }

        public final void setTextBoxMenuOption(TextBoxMenuOption.BuilderImpl textBoxMenuOption) {
            this.textBoxMenuOption = textBoxMenuOption != null ? textBoxMenuOption.build() : null;
        }

        @Override
        public final Builder textBoxMenuOption(TextBoxMenuOption textBoxMenuOption) {
            this.textBoxMenuOption = textBoxMenuOption;
            return this;
        }

        @Override
        public TextBoxInteractionOptions build() {
            return new TextBoxInteractionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
