/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A <code>TimeRangeFilter</code> filters values that are between two specified values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeRangeFilter implements SdkPojo, Serializable, ToCopyableBuilder<TimeRangeFilter.Builder, TimeRangeFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterId").getter(getter(TimeRangeFilter::filterId)).setter(setter(Builder::filterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(TimeRangeFilter::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<Boolean> INCLUDE_MINIMUM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeMinimum").getter(getter(TimeRangeFilter::includeMinimum)).setter(setter(Builder::includeMinimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMinimum").build()).build();

    private static final SdkField<Boolean> INCLUDE_MAXIMUM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeMaximum").getter(getter(TimeRangeFilter::includeMaximum)).setter(setter(Builder::includeMaximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMaximum").build()).build();

    private static final SdkField<TimeRangeFilterValue> RANGE_MINIMUM_VALUE_FIELD = SdkField
            .<TimeRangeFilterValue> builder(MarshallingType.SDK_POJO).memberName("RangeMinimumValue")
            .getter(getter(TimeRangeFilter::rangeMinimumValue)).setter(setter(Builder::rangeMinimumValue))
            .constructor(TimeRangeFilterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMinimumValue").build()).build();

    private static final SdkField<TimeRangeFilterValue> RANGE_MAXIMUM_VALUE_FIELD = SdkField
            .<TimeRangeFilterValue> builder(MarshallingType.SDK_POJO).memberName("RangeMaximumValue")
            .getter(getter(TimeRangeFilter::rangeMaximumValue)).setter(setter(Builder::rangeMaximumValue))
            .constructor(TimeRangeFilterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMaximumValue").build()).build();

    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullOption").getter(getter(TimeRangeFilter::nullOptionAsString)).setter(setter(Builder::nullOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()).build();

    private static final SdkField<ExcludePeriodConfiguration> EXCLUDE_PERIOD_CONFIGURATION_FIELD = SdkField
            .<ExcludePeriodConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExcludePeriodConfiguration")
            .getter(getter(TimeRangeFilter::excludePeriodConfiguration))
            .setter(setter(Builder::excludePeriodConfiguration))
            .constructor(ExcludePeriodConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludePeriodConfiguration").build())
            .build();

    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeGranularity").getter(getter(TimeRangeFilter::timeGranularityAsString))
            .setter(setter(Builder::timeGranularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()).build();

    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField
            .<DefaultFilterControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultFilterControlConfiguration")
            .getter(getter(TimeRangeFilter::defaultFilterControlConfiguration))
            .setter(setter(Builder::defaultFilterControlConfiguration))
            .constructor(DefaultFilterControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD,
            INCLUDE_MINIMUM_FIELD, INCLUDE_MAXIMUM_FIELD, RANGE_MINIMUM_VALUE_FIELD, RANGE_MAXIMUM_VALUE_FIELD,
            NULL_OPTION_FIELD, EXCLUDE_PERIOD_CONFIGURATION_FIELD, TIME_GRANULARITY_FIELD,
            DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterId;

    private final ColumnIdentifier column;

    private final Boolean includeMinimum;

    private final Boolean includeMaximum;

    private final TimeRangeFilterValue rangeMinimumValue;

    private final TimeRangeFilterValue rangeMaximumValue;

    private final String nullOption;

    private final ExcludePeriodConfiguration excludePeriodConfiguration;

    private final String timeGranularity;

    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private TimeRangeFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.includeMinimum = builder.includeMinimum;
        this.includeMaximum = builder.includeMaximum;
        this.rangeMinimumValue = builder.rangeMinimumValue;
        this.rangeMaximumValue = builder.rangeMaximumValue;
        this.nullOption = builder.nullOption;
        this.excludePeriodConfiguration = builder.excludePeriodConfiguration;
        this.timeGranularity = builder.timeGranularity;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    /**
     * <p>
     * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     * </p>
     * 
     * @return An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
     */
    public final String filterId() {
        return filterId;
    }

    /**
     * <p>
     * The column that the filter is applied to.
     * </p>
     * 
     * @return The column that the filter is applied to.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * Determines whether the minimum value in the filter value range should be included in the filtered results.
     * </p>
     * 
     * @return Determines whether the minimum value in the filter value range should be included in the filtered
     *         results.
     */
    public final Boolean includeMinimum() {
        return includeMinimum;
    }

    /**
     * <p>
     * Determines whether the maximum value in the filter value range should be included in the filtered results.
     * </p>
     * 
     * @return Determines whether the maximum value in the filter value range should be included in the filtered
     *         results.
     */
    public final Boolean includeMaximum() {
        return includeMaximum;
    }

    /**
     * <p>
     * The minimum value for the filter value range.
     * </p>
     * 
     * @return The minimum value for the filter value range.
     */
    public final TimeRangeFilterValue rangeMinimumValue() {
        return rangeMinimumValue;
    }

    /**
     * <p>
     * The maximum value for the filter value range.
     * </p>
     * 
     * @return The maximum value for the filter value range.
     */
    public final TimeRangeFilterValue rangeMaximumValue() {
        return rangeMaximumValue;
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(nullOption);
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final String nullOptionAsString() {
        return nullOption;
    }

    /**
     * <p>
     * The exclude period of the time range filter.
     * </p>
     * 
     * @return The exclude period of the time range filter.
     */
    public final ExcludePeriodConfiguration excludePeriodConfiguration() {
        return excludePeriodConfiguration;
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(timeGranularity);
    }

    /**
     * <p>
     * The level of time precision that is used to aggregate <code>DateTime</code> values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeGranularity}
     * will return {@link TimeGranularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeGranularityAsString}.
     * </p>
     * 
     * @return The level of time precision that is used to aggregate <code>DateTime</code> values.
     * @see TimeGranularity
     */
    public final String timeGranularityAsString() {
        return timeGranularity;
    }

    /**
     * <p>
     * The default configurations for the associated controls. This applies only for filters that are scoped to multiple
     * sheets.
     * </p>
     * 
     * @return The default configurations for the associated controls. This applies only for filters that are scoped to
     *         multiple sheets.
     */
    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return defaultFilterControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(includeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(includeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(rangeMinimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(rangeMaximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(nullOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(excludePeriodConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultFilterControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRangeFilter)) {
            return false;
        }
        TimeRangeFilter other = (TimeRangeFilter) obj;
        return Objects.equals(filterId(), other.filterId()) && Objects.equals(column(), other.column())
                && Objects.equals(includeMinimum(), other.includeMinimum())
                && Objects.equals(includeMaximum(), other.includeMaximum())
                && Objects.equals(rangeMinimumValue(), other.rangeMinimumValue())
                && Objects.equals(rangeMaximumValue(), other.rangeMaximumValue())
                && Objects.equals(nullOptionAsString(), other.nullOptionAsString())
                && Objects.equals(excludePeriodConfiguration(), other.excludePeriodConfiguration())
                && Objects.equals(timeGranularityAsString(), other.timeGranularityAsString())
                && Objects.equals(defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeRangeFilter").add("FilterId", filterId()).add("Column", column())
                .add("IncludeMinimum", includeMinimum()).add("IncludeMaximum", includeMaximum())
                .add("RangeMinimumValue", rangeMinimumValue()).add("RangeMaximumValue", rangeMaximumValue())
                .add("NullOption", nullOptionAsString()).add("ExcludePeriodConfiguration", excludePeriodConfiguration())
                .add("TimeGranularity", timeGranularityAsString())
                .add("DefaultFilterControlConfiguration", defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterId":
            return Optional.ofNullable(clazz.cast(filterId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "IncludeMinimum":
            return Optional.ofNullable(clazz.cast(includeMinimum()));
        case "IncludeMaximum":
            return Optional.ofNullable(clazz.cast(includeMaximum()));
        case "RangeMinimumValue":
            return Optional.ofNullable(clazz.cast(rangeMinimumValue()));
        case "RangeMaximumValue":
            return Optional.ofNullable(clazz.cast(rangeMaximumValue()));
        case "NullOption":
            return Optional.ofNullable(clazz.cast(nullOptionAsString()));
        case "ExcludePeriodConfiguration":
            return Optional.ofNullable(clazz.cast(excludePeriodConfiguration()));
        case "TimeGranularity":
            return Optional.ofNullable(clazz.cast(timeGranularityAsString()));
        case "DefaultFilterControlConfiguration":
            return Optional.ofNullable(clazz.cast(defaultFilterControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterId", FILTER_ID_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("IncludeMinimum", INCLUDE_MINIMUM_FIELD);
        map.put("IncludeMaximum", INCLUDE_MAXIMUM_FIELD);
        map.put("RangeMinimumValue", RANGE_MINIMUM_VALUE_FIELD);
        map.put("RangeMaximumValue", RANGE_MAXIMUM_VALUE_FIELD);
        map.put("NullOption", NULL_OPTION_FIELD);
        map.put("ExcludePeriodConfiguration", EXCLUDE_PERIOD_CONFIGURATION_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        map.put("DefaultFilterControlConfiguration", DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeRangeFilter, T> g) {
        return obj -> g.apply((TimeRangeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeRangeFilter> {
        /**
         * <p>
         * An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * </p>
         * 
         * @param filterId
         *        An identifier that uniquely identifies a filter within a dashboard, analysis, or template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterId(String filterId);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * 
         * @param column
         *        The column that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * Determines whether the minimum value in the filter value range should be included in the filtered results.
         * </p>
         * 
         * @param includeMinimum
         *        Determines whether the minimum value in the filter value range should be included in the filtered
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMinimum(Boolean includeMinimum);

        /**
         * <p>
         * Determines whether the maximum value in the filter value range should be included in the filtered results.
         * </p>
         * 
         * @param includeMaximum
         *        Determines whether the maximum value in the filter value range should be included in the filtered
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMaximum(Boolean includeMaximum);

        /**
         * <p>
         * The minimum value for the filter value range.
         * </p>
         * 
         * @param rangeMinimumValue
         *        The minimum value for the filter value range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeMinimumValue(TimeRangeFilterValue rangeMinimumValue);

        /**
         * <p>
         * The minimum value for the filter value range.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRangeFilterValue.Builder} avoiding
         * the need to create one manually via {@link TimeRangeFilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRangeFilterValue.Builder#build()} is called immediately and
         * its result is passed to {@link #rangeMinimumValue(TimeRangeFilterValue)}.
         * 
         * @param rangeMinimumValue
         *        a consumer that will call methods on {@link TimeRangeFilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeMinimumValue(TimeRangeFilterValue)
         */
        default Builder rangeMinimumValue(Consumer<TimeRangeFilterValue.Builder> rangeMinimumValue) {
            return rangeMinimumValue(TimeRangeFilterValue.builder().applyMutation(rangeMinimumValue).build());
        }

        /**
         * <p>
         * The maximum value for the filter value range.
         * </p>
         * 
         * @param rangeMaximumValue
         *        The maximum value for the filter value range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rangeMaximumValue(TimeRangeFilterValue rangeMaximumValue);

        /**
         * <p>
         * The maximum value for the filter value range.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRangeFilterValue.Builder} avoiding
         * the need to create one manually via {@link TimeRangeFilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRangeFilterValue.Builder#build()} is called immediately and
         * its result is passed to {@link #rangeMaximumValue(TimeRangeFilterValue)}.
         * 
         * @param rangeMaximumValue
         *        a consumer that will call methods on {@link TimeRangeFilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rangeMaximumValue(TimeRangeFilterValue)
         */
        default Builder rangeMaximumValue(Consumer<TimeRangeFilterValue.Builder> rangeMaximumValue) {
            return rangeMaximumValue(TimeRangeFilterValue.builder().applyMutation(rangeMaximumValue).build());
        }

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(String nullOption);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(FilterNullOption nullOption);

        /**
         * <p>
         * The exclude period of the time range filter.
         * </p>
         * 
         * @param excludePeriodConfiguration
         *        The exclude period of the time range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludePeriodConfiguration(ExcludePeriodConfiguration excludePeriodConfiguration);

        /**
         * <p>
         * The exclude period of the time range filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExcludePeriodConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExcludePeriodConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExcludePeriodConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #excludePeriodConfiguration(ExcludePeriodConfiguration)}.
         * 
         * @param excludePeriodConfiguration
         *        a consumer that will call methods on {@link ExcludePeriodConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludePeriodConfiguration(ExcludePeriodConfiguration)
         */
        default Builder excludePeriodConfiguration(Consumer<ExcludePeriodConfiguration.Builder> excludePeriodConfiguration) {
            return excludePeriodConfiguration(ExcludePeriodConfiguration.builder().applyMutation(excludePeriodConfiguration)
                    .build());
        }

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(String timeGranularity);

        /**
         * <p>
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * </p>
         * 
         * @param timeGranularity
         *        The level of time precision that is used to aggregate <code>DateTime</code> values.
         * @see TimeGranularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeGranularity
         */
        Builder timeGranularity(TimeGranularity timeGranularity);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * 
         * @param defaultFilterControlConfiguration
         *        The default configurations for the associated controls. This applies only for filters that are scoped
         *        to multiple sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration);

        /**
         * <p>
         * The default configurations for the associated controls. This applies only for filters that are scoped to
         * multiple sheets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultFilterControlConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultFilterControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultFilterControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)}.
         * 
         * @param defaultFilterControlConfiguration
         *        a consumer that will call methods on {@link DefaultFilterControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultFilterControlConfiguration(DefaultFilterControlConfiguration)
         */
        default Builder defaultFilterControlConfiguration(
                Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return defaultFilterControlConfiguration(DefaultFilterControlConfiguration.builder()
                    .applyMutation(defaultFilterControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterId;

        private ColumnIdentifier column;

        private Boolean includeMinimum;

        private Boolean includeMaximum;

        private TimeRangeFilterValue rangeMinimumValue;

        private TimeRangeFilterValue rangeMaximumValue;

        private String nullOption;

        private ExcludePeriodConfiguration excludePeriodConfiguration;

        private String timeGranularity;

        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRangeFilter model) {
            filterId(model.filterId);
            column(model.column);
            includeMinimum(model.includeMinimum);
            includeMaximum(model.includeMaximum);
            rangeMinimumValue(model.rangeMinimumValue);
            rangeMaximumValue(model.rangeMaximumValue);
            nullOption(model.nullOption);
            excludePeriodConfiguration(model.excludePeriodConfiguration);
            timeGranularity(model.timeGranularity);
            defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final String getFilterId() {
            return filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Boolean getIncludeMinimum() {
            return includeMinimum;
        }

        public final void setIncludeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
        }

        @Override
        public final Builder includeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
            return this;
        }

        public final Boolean getIncludeMaximum() {
            return includeMaximum;
        }

        public final void setIncludeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
        }

        @Override
        public final Builder includeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
            return this;
        }

        public final TimeRangeFilterValue.Builder getRangeMinimumValue() {
            return rangeMinimumValue != null ? rangeMinimumValue.toBuilder() : null;
        }

        public final void setRangeMinimumValue(TimeRangeFilterValue.BuilderImpl rangeMinimumValue) {
            this.rangeMinimumValue = rangeMinimumValue != null ? rangeMinimumValue.build() : null;
        }

        @Override
        public final Builder rangeMinimumValue(TimeRangeFilterValue rangeMinimumValue) {
            this.rangeMinimumValue = rangeMinimumValue;
            return this;
        }

        public final TimeRangeFilterValue.Builder getRangeMaximumValue() {
            return rangeMaximumValue != null ? rangeMaximumValue.toBuilder() : null;
        }

        public final void setRangeMaximumValue(TimeRangeFilterValue.BuilderImpl rangeMaximumValue) {
            this.rangeMaximumValue = rangeMaximumValue != null ? rangeMaximumValue.build() : null;
        }

        @Override
        public final Builder rangeMaximumValue(TimeRangeFilterValue rangeMaximumValue) {
            this.rangeMaximumValue = rangeMaximumValue;
            return this;
        }

        public final String getNullOption() {
            return nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public final ExcludePeriodConfiguration.Builder getExcludePeriodConfiguration() {
            return excludePeriodConfiguration != null ? excludePeriodConfiguration.toBuilder() : null;
        }

        public final void setExcludePeriodConfiguration(ExcludePeriodConfiguration.BuilderImpl excludePeriodConfiguration) {
            this.excludePeriodConfiguration = excludePeriodConfiguration != null ? excludePeriodConfiguration.build() : null;
        }

        @Override
        public final Builder excludePeriodConfiguration(ExcludePeriodConfiguration excludePeriodConfiguration) {
            this.excludePeriodConfiguration = excludePeriodConfiguration;
            return this;
        }

        public final String getTimeGranularity() {
            return timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(
                DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration
                    .build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        @Override
        public TimeRangeFilter build() {
            return new TimeRangeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
