/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicTemplate</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicTemplate implements SdkPojo, Serializable, ToCopyableBuilder<TopicTemplate.Builder, TopicTemplate> {
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateType").getter(getter(TopicTemplate::templateType)).setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()).build();

    private static final SdkField<List<Slot>> SLOTS_FIELD = SdkField
            .<List<Slot>> builder(MarshallingType.LIST)
            .memberName("Slots")
            .getter(getter(TopicTemplate::slots))
            .setter(setter(Builder::slots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Slot> builder(MarshallingType.SDK_POJO)
                                            .constructor(Slot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_TYPE_FIELD,
            SLOTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateType;

    private final List<Slot> slots;

    private TopicTemplate(BuilderImpl builder) {
        this.templateType = builder.templateType;
        this.slots = builder.slots;
    }

    /**
     * <p>
     * The template type for the <code>TopicTemplate</code>.
     * </p>
     * 
     * @return The template type for the <code>TopicTemplate</code>.
     */
    public final String templateType() {
        return templateType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Slots property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSlots() {
        return slots != null && !(slots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The slots for the <code>TopicTemplate</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSlots} method.
     * </p>
     * 
     * @return The slots for the <code>TopicTemplate</code>.
     */
    public final List<Slot> slots() {
        return slots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateType());
        hashCode = 31 * hashCode + Objects.hashCode(hasSlots() ? slots() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicTemplate)) {
            return false;
        }
        TopicTemplate other = (TopicTemplate) obj;
        return Objects.equals(templateType(), other.templateType()) && hasSlots() == other.hasSlots()
                && Objects.equals(slots(), other.slots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicTemplate").add("TemplateType", templateType()).add("Slots", hasSlots() ? slots() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateType()));
        case "Slots":
            return Optional.ofNullable(clazz.cast(slots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateType", TEMPLATE_TYPE_FIELD);
        map.put("Slots", SLOTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicTemplate, T> g) {
        return obj -> g.apply((TopicTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicTemplate> {
        /**
         * <p>
         * The template type for the <code>TopicTemplate</code>.
         * </p>
         * 
         * @param templateType
         *        The template type for the <code>TopicTemplate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The slots for the <code>TopicTemplate</code>.
         * </p>
         * 
         * @param slots
         *        The slots for the <code>TopicTemplate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Collection<Slot> slots);

        /**
         * <p>
         * The slots for the <code>TopicTemplate</code>.
         * </p>
         * 
         * @param slots
         *        The slots for the <code>TopicTemplate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slots(Slot... slots);

        /**
         * <p>
         * The slots for the <code>TopicTemplate</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Slot.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Slot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Slot.Builder#build()} is called immediately and its
         * result is passed to {@link #slots(List<Slot>)}.
         * 
         * @param slots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Slot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slots(java.util.Collection<Slot>)
         */
        Builder slots(Consumer<Slot.Builder>... slots);
    }

    static final class BuilderImpl implements Builder {
        private String templateType;

        private List<Slot> slots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicTemplate model) {
            templateType(model.templateType);
            slots(model.slots);
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        public final List<Slot.Builder> getSlots() {
            List<Slot.Builder> result = SlotsCopier.copyToBuilder(this.slots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlots(Collection<Slot.BuilderImpl> slots) {
            this.slots = SlotsCopier.copyFromBuilder(slots);
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotsCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot... slots) {
            slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<Slot.Builder>... slots) {
            slots(Stream.of(slots).map(c -> Slot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TopicTemplate build() {
            return new TopicTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
