/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that converts columns into rows, normalizing the data structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnpivotOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<UnpivotOperation.Builder, UnpivotOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(UnpivotOperation::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField
            .<TransformOperationSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(UnpivotOperation::source)).setter(setter(Builder::source))
            .constructor(TransformOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<ColumnToUnpivot>> COLUMNS_TO_UNPIVOT_FIELD = SdkField
            .<List<ColumnToUnpivot>> builder(MarshallingType.LIST)
            .memberName("ColumnsToUnpivot")
            .getter(getter(UnpivotOperation::columnsToUnpivot))
            .setter(setter(Builder::columnsToUnpivot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnsToUnpivot").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnToUnpivot> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnToUnpivot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UNPIVOTED_LABEL_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnpivotedLabelColumnName").getter(getter(UnpivotOperation::unpivotedLabelColumnName))
            .setter(setter(Builder::unpivotedLabelColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotedLabelColumnName").build())
            .build();

    private static final SdkField<String> UNPIVOTED_LABEL_COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnpivotedLabelColumnId").getter(getter(UnpivotOperation::unpivotedLabelColumnId))
            .setter(setter(Builder::unpivotedLabelColumnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotedLabelColumnId").build())
            .build();

    private static final SdkField<String> UNPIVOTED_VALUE_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnpivotedValueColumnName").getter(getter(UnpivotOperation::unpivotedValueColumnName))
            .setter(setter(Builder::unpivotedValueColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotedValueColumnName").build())
            .build();

    private static final SdkField<String> UNPIVOTED_VALUE_COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnpivotedValueColumnId").getter(getter(UnpivotOperation::unpivotedValueColumnId))
            .setter(setter(Builder::unpivotedValueColumnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotedValueColumnId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD,
            COLUMNS_TO_UNPIVOT_FIELD, UNPIVOTED_LABEL_COLUMN_NAME_FIELD, UNPIVOTED_LABEL_COLUMN_ID_FIELD,
            UNPIVOTED_VALUE_COLUMN_NAME_FIELD, UNPIVOTED_VALUE_COLUMN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final TransformOperationSource source;

    private final List<ColumnToUnpivot> columnsToUnpivot;

    private final String unpivotedLabelColumnName;

    private final String unpivotedLabelColumnId;

    private final String unpivotedValueColumnName;

    private final String unpivotedValueColumnId;

    private UnpivotOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.columnsToUnpivot = builder.columnsToUnpivot;
        this.unpivotedLabelColumnName = builder.unpivotedLabelColumnName;
        this.unpivotedLabelColumnId = builder.unpivotedLabelColumnId;
        this.unpivotedValueColumnName = builder.unpivotedValueColumnName;
        this.unpivotedValueColumnId = builder.unpivotedValueColumnId;
    }

    /**
     * <p>
     * Alias for this operation.
     * </p>
     * 
     * @return Alias for this operation.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The source transform operation that provides input data for unpivoting.
     * </p>
     * 
     * @return The source transform operation that provides input data for unpivoting.
     */
    public final TransformOperationSource source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnsToUnpivot property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnsToUnpivot() {
        return columnsToUnpivot != null && !(columnsToUnpivot instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of columns to unpivot from the source data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnsToUnpivot} method.
     * </p>
     * 
     * @return The list of columns to unpivot from the source data.
     */
    public final List<ColumnToUnpivot> columnsToUnpivot() {
        return columnsToUnpivot;
    }

    /**
     * <p>
     * The name for the new column that will contain the unpivoted column names.
     * </p>
     * 
     * @return The name for the new column that will contain the unpivoted column names.
     */
    public final String unpivotedLabelColumnName() {
        return unpivotedLabelColumnName;
    }

    /**
     * <p>
     * A unique identifier for the new column that will contain the unpivoted column names.
     * </p>
     * 
     * @return A unique identifier for the new column that will contain the unpivoted column names.
     */
    public final String unpivotedLabelColumnId() {
        return unpivotedLabelColumnId;
    }

    /**
     * <p>
     * The name for the new column that will contain the unpivoted values.
     * </p>
     * 
     * @return The name for the new column that will contain the unpivoted values.
     */
    public final String unpivotedValueColumnName() {
        return unpivotedValueColumnName;
    }

    /**
     * <p>
     * A unique identifier for the new column that will contain the unpivoted values.
     * </p>
     * 
     * @return A unique identifier for the new column that will contain the unpivoted values.
     */
    public final String unpivotedValueColumnId() {
        return unpivotedValueColumnId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnsToUnpivot() ? columnsToUnpivot() : null);
        hashCode = 31 * hashCode + Objects.hashCode(unpivotedLabelColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(unpivotedLabelColumnId());
        hashCode = 31 * hashCode + Objects.hashCode(unpivotedValueColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(unpivotedValueColumnId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnpivotOperation)) {
            return false;
        }
        UnpivotOperation other = (UnpivotOperation) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(source(), other.source())
                && hasColumnsToUnpivot() == other.hasColumnsToUnpivot()
                && Objects.equals(columnsToUnpivot(), other.columnsToUnpivot())
                && Objects.equals(unpivotedLabelColumnName(), other.unpivotedLabelColumnName())
                && Objects.equals(unpivotedLabelColumnId(), other.unpivotedLabelColumnId())
                && Objects.equals(unpivotedValueColumnName(), other.unpivotedValueColumnName())
                && Objects.equals(unpivotedValueColumnId(), other.unpivotedValueColumnId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnpivotOperation").add("Alias", alias()).add("Source", source())
                .add("ColumnsToUnpivot", hasColumnsToUnpivot() ? columnsToUnpivot() : null)
                .add("UnpivotedLabelColumnName", unpivotedLabelColumnName())
                .add("UnpivotedLabelColumnId", unpivotedLabelColumnId())
                .add("UnpivotedValueColumnName", unpivotedValueColumnName())
                .add("UnpivotedValueColumnId", unpivotedValueColumnId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ColumnsToUnpivot":
            return Optional.ofNullable(clazz.cast(columnsToUnpivot()));
        case "UnpivotedLabelColumnName":
            return Optional.ofNullable(clazz.cast(unpivotedLabelColumnName()));
        case "UnpivotedLabelColumnId":
            return Optional.ofNullable(clazz.cast(unpivotedLabelColumnId()));
        case "UnpivotedValueColumnName":
            return Optional.ofNullable(clazz.cast(unpivotedValueColumnName()));
        case "UnpivotedValueColumnId":
            return Optional.ofNullable(clazz.cast(unpivotedValueColumnId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("ColumnsToUnpivot", COLUMNS_TO_UNPIVOT_FIELD);
        map.put("UnpivotedLabelColumnName", UNPIVOTED_LABEL_COLUMN_NAME_FIELD);
        map.put("UnpivotedLabelColumnId", UNPIVOTED_LABEL_COLUMN_ID_FIELD);
        map.put("UnpivotedValueColumnName", UNPIVOTED_VALUE_COLUMN_NAME_FIELD);
        map.put("UnpivotedValueColumnId", UNPIVOTED_VALUE_COLUMN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnpivotOperation, T> g) {
        return obj -> g.apply((UnpivotOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnpivotOperation> {
        /**
         * <p>
         * Alias for this operation.
         * </p>
         * 
         * @param alias
         *        Alias for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The source transform operation that provides input data for unpivoting.
         * </p>
         * 
         * @param source
         *        The source transform operation that provides input data for unpivoting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TransformOperationSource source);

        /**
         * <p>
         * The source transform operation that provides input data for unpivoting.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformOperationSource.Builder}
         * avoiding the need to create one manually via {@link TransformOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(TransformOperationSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TransformOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TransformOperationSource)
         */
        default Builder source(Consumer<TransformOperationSource.Builder> source) {
            return source(TransformOperationSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The list of columns to unpivot from the source data.
         * </p>
         * 
         * @param columnsToUnpivot
         *        The list of columns to unpivot from the source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnsToUnpivot(Collection<ColumnToUnpivot> columnsToUnpivot);

        /**
         * <p>
         * The list of columns to unpivot from the source data.
         * </p>
         * 
         * @param columnsToUnpivot
         *        The list of columns to unpivot from the source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnsToUnpivot(ColumnToUnpivot... columnsToUnpivot);

        /**
         * <p>
         * The list of columns to unpivot from the source data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnToUnpivot.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.ColumnToUnpivot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnToUnpivot.Builder#build()} is called
         * immediately and its result is passed to {@link #columnsToUnpivot(List<ColumnToUnpivot>)}.
         * 
         * @param columnsToUnpivot
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnToUnpivot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnsToUnpivot(java.util.Collection<ColumnToUnpivot>)
         */
        Builder columnsToUnpivot(Consumer<ColumnToUnpivot.Builder>... columnsToUnpivot);

        /**
         * <p>
         * The name for the new column that will contain the unpivoted column names.
         * </p>
         * 
         * @param unpivotedLabelColumnName
         *        The name for the new column that will contain the unpivoted column names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpivotedLabelColumnName(String unpivotedLabelColumnName);

        /**
         * <p>
         * A unique identifier for the new column that will contain the unpivoted column names.
         * </p>
         * 
         * @param unpivotedLabelColumnId
         *        A unique identifier for the new column that will contain the unpivoted column names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpivotedLabelColumnId(String unpivotedLabelColumnId);

        /**
         * <p>
         * The name for the new column that will contain the unpivoted values.
         * </p>
         * 
         * @param unpivotedValueColumnName
         *        The name for the new column that will contain the unpivoted values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpivotedValueColumnName(String unpivotedValueColumnName);

        /**
         * <p>
         * A unique identifier for the new column that will contain the unpivoted values.
         * </p>
         * 
         * @param unpivotedValueColumnId
         *        A unique identifier for the new column that will contain the unpivoted values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpivotedValueColumnId(String unpivotedValueColumnId);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private TransformOperationSource source;

        private List<ColumnToUnpivot> columnsToUnpivot = DefaultSdkAutoConstructList.getInstance();

        private String unpivotedLabelColumnName;

        private String unpivotedLabelColumnId;

        private String unpivotedValueColumnName;

        private String unpivotedValueColumnId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnpivotOperation model) {
            alias(model.alias);
            source(model.source);
            columnsToUnpivot(model.columnsToUnpivot);
            unpivotedLabelColumnName(model.unpivotedLabelColumnName);
            unpivotedLabelColumnId(model.unpivotedLabelColumnId);
            unpivotedValueColumnName(model.unpivotedValueColumnName);
            unpivotedValueColumnId(model.unpivotedValueColumnId);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final List<ColumnToUnpivot.Builder> getColumnsToUnpivot() {
            List<ColumnToUnpivot.Builder> result = ColumnToUnpivotListCopier.copyToBuilder(this.columnsToUnpivot);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnsToUnpivot(Collection<ColumnToUnpivot.BuilderImpl> columnsToUnpivot) {
            this.columnsToUnpivot = ColumnToUnpivotListCopier.copyFromBuilder(columnsToUnpivot);
        }

        @Override
        public final Builder columnsToUnpivot(Collection<ColumnToUnpivot> columnsToUnpivot) {
            this.columnsToUnpivot = ColumnToUnpivotListCopier.copy(columnsToUnpivot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnsToUnpivot(ColumnToUnpivot... columnsToUnpivot) {
            columnsToUnpivot(Arrays.asList(columnsToUnpivot));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnsToUnpivot(Consumer<ColumnToUnpivot.Builder>... columnsToUnpivot) {
            columnsToUnpivot(Stream.of(columnsToUnpivot).map(c -> ColumnToUnpivot.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUnpivotedLabelColumnName() {
            return unpivotedLabelColumnName;
        }

        public final void setUnpivotedLabelColumnName(String unpivotedLabelColumnName) {
            this.unpivotedLabelColumnName = unpivotedLabelColumnName;
        }

        @Override
        public final Builder unpivotedLabelColumnName(String unpivotedLabelColumnName) {
            this.unpivotedLabelColumnName = unpivotedLabelColumnName;
            return this;
        }

        public final String getUnpivotedLabelColumnId() {
            return unpivotedLabelColumnId;
        }

        public final void setUnpivotedLabelColumnId(String unpivotedLabelColumnId) {
            this.unpivotedLabelColumnId = unpivotedLabelColumnId;
        }

        @Override
        public final Builder unpivotedLabelColumnId(String unpivotedLabelColumnId) {
            this.unpivotedLabelColumnId = unpivotedLabelColumnId;
            return this;
        }

        public final String getUnpivotedValueColumnName() {
            return unpivotedValueColumnName;
        }

        public final void setUnpivotedValueColumnName(String unpivotedValueColumnName) {
            this.unpivotedValueColumnName = unpivotedValueColumnName;
        }

        @Override
        public final Builder unpivotedValueColumnName(String unpivotedValueColumnName) {
            this.unpivotedValueColumnName = unpivotedValueColumnName;
            return this;
        }

        public final String getUnpivotedValueColumnId() {
            return unpivotedValueColumnId;
        }

        public final void setUnpivotedValueColumnId(String unpivotedValueColumnId) {
            this.unpivotedValueColumnId = unpivotedValueColumnId;
        }

        @Override
        public final Builder unpivotedValueColumnId(String unpivotedValueColumnId) {
            this.unpivotedValueColumnId = unpivotedValueColumnId;
            return this;
        }

        @Override
        public UnpivotOperation build() {
            return new UnpivotOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
