/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowPermissionsRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateFlowPermissionsRequest.Builder, UpdateFlowPermissionsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateFlowPermissionsRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FlowId")
            .getter(getter(UpdateFlowPermissionsRequest::flowId)).setter(setter(Builder::flowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FlowId").build()).build();

    private static final SdkField<List<Permission>> GRANT_PERMISSIONS_FIELD = SdkField
            .<List<Permission>> builder(MarshallingType.LIST)
            .memberName("GrantPermissions")
            .getter(getter(UpdateFlowPermissionsRequest::grantPermissions))
            .setter(setter(Builder::grantPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Permission> builder(MarshallingType.SDK_POJO)
                                            .constructor(Permission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Permission>> REVOKE_PERMISSIONS_FIELD = SdkField
            .<List<Permission>> builder(MarshallingType.LIST)
            .memberName("RevokePermissions")
            .getter(getter(UpdateFlowPermissionsRequest::revokePermissions))
            .setter(setter(Builder::revokePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokePermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Permission> builder(MarshallingType.SDK_POJO)
                                            .constructor(Permission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            FLOW_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String flowId;

    private final List<Permission> grantPermissions;

    private final List<Permission> revokePermissions;

    private UpdateFlowPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.flowId = builder.flowId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the flow you are updating permissions against.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the flow you are updating permissions against.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The unique identifier of the flow to update permissions for.
     * </p>
     * 
     * @return The unique identifier of the flow to update permissions for.
     */
    public final String flowId() {
        return flowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the GrantPermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGrantPermissions() {
        return grantPermissions != null && !(grantPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions that you want to grant on this flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrantPermissions} method.
     * </p>
     * 
     * @return The permissions that you want to grant on this flow.
     */
    public final List<Permission> grantPermissions() {
        return grantPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RevokePermissions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRevokePermissions() {
        return revokePermissions != null && !(revokePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions that you want to revoke from this flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevokePermissions} method.
     * </p>
     * 
     * @return The permissions that you want to revoke from this flow.
     */
    public final List<Permission> revokePermissions() {
        return revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(flowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasGrantPermissions() ? grantPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRevokePermissions() ? revokePermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowPermissionsRequest)) {
            return false;
        }
        UpdateFlowPermissionsRequest other = (UpdateFlowPermissionsRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(flowId(), other.flowId())
                && hasGrantPermissions() == other.hasGrantPermissions()
                && Objects.equals(grantPermissions(), other.grantPermissions())
                && hasRevokePermissions() == other.hasRevokePermissions()
                && Objects.equals(revokePermissions(), other.revokePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowPermissionsRequest").add("AwsAccountId", awsAccountId()).add("FlowId", flowId())
                .add("GrantPermissions", hasGrantPermissions() ? grantPermissions() : null)
                .add("RevokePermissions", hasRevokePermissions() ? revokePermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "FlowId":
            return Optional.ofNullable(clazz.cast(flowId()));
        case "GrantPermissions":
            return Optional.ofNullable(clazz.cast(grantPermissions()));
        case "RevokePermissions":
            return Optional.ofNullable(clazz.cast(revokePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("FlowId", FLOW_ID_FIELD);
        map.put("GrantPermissions", GRANT_PERMISSIONS_FIELD);
        map.put("RevokePermissions", REVOKE_PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateFlowPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowPermissionsRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the flow you are updating permissions against.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the flow you are updating permissions against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The unique identifier of the flow to update permissions for.
         * </p>
         * 
         * @param flowId
         *        The unique identifier of the flow to update permissions for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowId(String flowId);

        /**
         * <p>
         * The permissions that you want to grant on this flow.
         * </p>
         * 
         * @param grantPermissions
         *        The permissions that you want to grant on this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(Collection<Permission> grantPermissions);

        /**
         * <p>
         * The permissions that you want to grant on this flow.
         * </p>
         * 
         * @param grantPermissions
         *        The permissions that you want to grant on this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(Permission... grantPermissions);

        /**
         * <p>
         * The permissions that you want to grant on this flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Permission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Permission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Permission.Builder#build()} is called immediately and
         * its result is passed to {@link #grantPermissions(List<Permission>)}.
         * 
         * @param grantPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Permission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantPermissions(java.util.Collection<Permission>)
         */
        Builder grantPermissions(Consumer<Permission.Builder>... grantPermissions);

        /**
         * <p>
         * The permissions that you want to revoke from this flow.
         * </p>
         * 
         * @param revokePermissions
         *        The permissions that you want to revoke from this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(Collection<Permission> revokePermissions);

        /**
         * <p>
         * The permissions that you want to revoke from this flow.
         * </p>
         * 
         * @param revokePermissions
         *        The permissions that you want to revoke from this flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(Permission... revokePermissions);

        /**
         * <p>
         * The permissions that you want to revoke from this flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Permission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Permission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Permission.Builder#build()} is called immediately and
         * its result is passed to {@link #revokePermissions(List<Permission>)}.
         * 
         * @param revokePermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Permission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokePermissions(java.util.Collection<Permission>)
         */
        Builder revokePermissions(Consumer<Permission.Builder>... revokePermissions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String flowId;

        private List<Permission> grantPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<Permission> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowPermissionsRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            flowId(model.flowId);
            grantPermissions(model.grantPermissions);
            revokePermissions(model.revokePermissions);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getFlowId() {
            return flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public final List<Permission.Builder> getGrantPermissions() {
            List<Permission.Builder> result = UpdateFlowPermissionsInputGrantPermissionsListCopier
                    .copyToBuilder(this.grantPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantPermissions(Collection<Permission.BuilderImpl> grantPermissions) {
            this.grantPermissions = UpdateFlowPermissionsInputGrantPermissionsListCopier.copyFromBuilder(grantPermissions);
        }

        @Override
        public final Builder grantPermissions(Collection<Permission> grantPermissions) {
            this.grantPermissions = UpdateFlowPermissionsInputGrantPermissionsListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Permission... grantPermissions) {
            grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grantPermissions(Consumer<Permission.Builder>... grantPermissions) {
            grantPermissions(Stream.of(grantPermissions).map(c -> Permission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Permission.Builder> getRevokePermissions() {
            List<Permission.Builder> result = UpdateFlowPermissionsInputRevokePermissionsListCopier
                    .copyToBuilder(this.revokePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokePermissions(Collection<Permission.BuilderImpl> revokePermissions) {
            this.revokePermissions = UpdateFlowPermissionsInputRevokePermissionsListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        public final Builder revokePermissions(Collection<Permission> revokePermissions) {
            this.revokePermissions = UpdateFlowPermissionsInputRevokePermissionsListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Permission... revokePermissions) {
            revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revokePermissions(Consumer<Permission.Builder>... revokePermissions) {
            revokePermissions(Stream.of(revokePermissions).map(c -> Permission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowPermissionsRequest build() {
            return new UpdateFlowPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
