/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for how to handle value columns in pivot operations, including aggregation settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValueColumnConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ValueColumnConfiguration.Builder, ValueColumnConfiguration> {
    private static final SdkField<DataPrepAggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField
            .<DataPrepAggregationFunction> builder(MarshallingType.SDK_POJO).memberName("AggregationFunction")
            .getter(getter(ValueColumnConfiguration::aggregationFunction)).setter(setter(Builder::aggregationFunction))
            .constructor(DataPrepAggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataPrepAggregationFunction aggregationFunction;

    private ValueColumnConfiguration(BuilderImpl builder) {
        this.aggregationFunction = builder.aggregationFunction;
    }

    /**
     * <p>
     * The aggregation function to apply when multiple values map to the same pivoted cell.
     * </p>
     * 
     * @return The aggregation function to apply when multiple values map to the same pivoted cell.
     */
    public final DataPrepAggregationFunction aggregationFunction() {
        return aggregationFunction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationFunction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValueColumnConfiguration)) {
            return false;
        }
        ValueColumnConfiguration other = (ValueColumnConfiguration) obj;
        return Objects.equals(aggregationFunction(), other.aggregationFunction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValueColumnConfiguration").add("AggregationFunction", aggregationFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregationFunction":
            return Optional.ofNullable(clazz.cast(aggregationFunction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValueColumnConfiguration, T> g) {
        return obj -> g.apply((ValueColumnConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValueColumnConfiguration> {
        /**
         * <p>
         * The aggregation function to apply when multiple values map to the same pivoted cell.
         * </p>
         * 
         * @param aggregationFunction
         *        The aggregation function to apply when multiple values map to the same pivoted cell.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunction(DataPrepAggregationFunction aggregationFunction);

        /**
         * <p>
         * The aggregation function to apply when multiple values map to the same pivoted cell.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrepAggregationFunction.Builder}
         * avoiding the need to create one manually via {@link DataPrepAggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrepAggregationFunction.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregationFunction(DataPrepAggregationFunction)}.
         * 
         * @param aggregationFunction
         *        a consumer that will call methods on {@link DataPrepAggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationFunction(DataPrepAggregationFunction)
         */
        default Builder aggregationFunction(Consumer<DataPrepAggregationFunction.Builder> aggregationFunction) {
            return aggregationFunction(DataPrepAggregationFunction.builder().applyMutation(aggregationFunction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataPrepAggregationFunction aggregationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(ValueColumnConfiguration model) {
            aggregationFunction(model.aggregationFunction);
        }

        public final DataPrepAggregationFunction.Builder getAggregationFunction() {
            return aggregationFunction != null ? aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(DataPrepAggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(DataPrepAggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        @Override
        public ValueColumnConfiguration build() {
            return new ValueColumnConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
