/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataPrepAggregationFunction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Aggregation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Aggregation> {
    private static final SdkField<DataPrepAggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AggregationFunction").getter(Aggregation.getter(Aggregation::aggregationFunction)).setter(Aggregation.setter(Builder::aggregationFunction)).constructor(DataPrepAggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build()}).build();
    private static final SdkField<String> NEW_COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewColumnName").getter(Aggregation.getter(Aggregation::newColumnName)).setter(Aggregation.setter(Builder::newColumnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnName").build()}).build();
    private static final SdkField<String> NEW_COLUMN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewColumnId").getter(Aggregation.getter(Aggregation::newColumnId)).setter(Aggregation.setter(Builder::newColumnId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_FUNCTION_FIELD, NEW_COLUMN_NAME_FIELD, NEW_COLUMN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Aggregation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataPrepAggregationFunction aggregationFunction;
    private final String newColumnName;
    private final String newColumnId;

    private Aggregation(BuilderImpl builder) {
        this.aggregationFunction = builder.aggregationFunction;
        this.newColumnName = builder.newColumnName;
        this.newColumnId = builder.newColumnId;
    }

    public final DataPrepAggregationFunction aggregationFunction() {
        return this.aggregationFunction;
    }

    public final String newColumnName() {
        return this.newColumnName;
    }

    public final String newColumnId() {
        return this.newColumnId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.newColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newColumnId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Aggregation)) {
            return false;
        }
        Aggregation other = (Aggregation)obj;
        return Objects.equals(this.aggregationFunction(), other.aggregationFunction()) && Objects.equals(this.newColumnName(), other.newColumnName()) && Objects.equals(this.newColumnId(), other.newColumnId());
    }

    public final String toString() {
        return ToString.builder((String)"Aggregation").add("AggregationFunction", (Object)this.aggregationFunction()).add("NewColumnName", (Object)this.newColumnName()).add("NewColumnId", (Object)this.newColumnId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunction()));
            }
            case "NewColumnName": {
                return Optional.ofNullable(clazz.cast(this.newColumnName()));
            }
            case "NewColumnId": {
                return Optional.ofNullable(clazz.cast(this.newColumnId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        map.put("NewColumnName", NEW_COLUMN_NAME_FIELD);
        map.put("NewColumnId", NEW_COLUMN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Aggregation, T> g) {
        return obj -> g.apply((Aggregation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataPrepAggregationFunction aggregationFunction;
        private String newColumnName;
        private String newColumnId;

        private BuilderImpl() {
        }

        private BuilderImpl(Aggregation model) {
            this.aggregationFunction(model.aggregationFunction);
            this.newColumnName(model.newColumnName);
            this.newColumnId(model.newColumnId);
        }

        public final DataPrepAggregationFunction.Builder getAggregationFunction() {
            return this.aggregationFunction != null ? this.aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(DataPrepAggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(DataPrepAggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public final String getNewColumnName() {
            return this.newColumnName;
        }

        public final void setNewColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
        }

        @Override
        public final Builder newColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
            return this;
        }

        public final String getNewColumnId() {
            return this.newColumnId;
        }

        public final void setNewColumnId(String newColumnId) {
            this.newColumnId = newColumnId;
        }

        @Override
        public final Builder newColumnId(String newColumnId) {
            this.newColumnId = newColumnId;
            return this;
        }

        public Aggregation build() {
            return new Aggregation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Aggregation> {
        public Builder aggregationFunction(DataPrepAggregationFunction var1);

        default public Builder aggregationFunction(Consumer<DataPrepAggregationFunction.Builder> aggregationFunction) {
            return this.aggregationFunction((DataPrepAggregationFunction)((DataPrepAggregationFunction.Builder)DataPrepAggregationFunction.builder().applyMutation(aggregationFunction)).build());
        }

        public Builder newColumnName(String var1);

        public Builder newColumnId(String var1);
    }
}

