/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionAuthType {
    BASIC("BASIC"),
    API_KEY("API_KEY"),
    OAUTH2_CLIENT_CREDENTIALS("OAUTH2_CLIENT_CREDENTIALS"),
    NONE("NONE"),
    IAM("IAM"),
    OAUTH2_AUTHORIZATION_CODE("OAUTH2_AUTHORIZATION_CODE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionAuthType> VALUE_MAP;
    private final String value;

    private ConnectionAuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionAuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionAuthType> knownValues() {
        EnumSet<ConnectionAuthType> knownValues = EnumSet.allOf(ConnectionAuthType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionAuthType.class, ConnectionAuthType::toString);
    }
}

