/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.RenameColumnOperation;
import software.amazon.awssdk.services.quicksight.model.RenameColumnOperationListCopier;
import software.amazon.awssdk.services.quicksight.model.TransformOperationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenameColumnsOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenameColumnsOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(RenameColumnsOperation.getter(RenameColumnsOperation::alias)).setter(RenameColumnsOperation.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(RenameColumnsOperation.getter(RenameColumnsOperation::source)).setter(RenameColumnsOperation.setter(Builder::source)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<RenameColumnOperation>> RENAME_COLUMN_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RenameColumnOperations").getter(RenameColumnsOperation.getter(RenameColumnsOperation::renameColumnOperations)).setter(RenameColumnsOperation.setter(Builder::renameColumnOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameColumnOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RenameColumnOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD, RENAME_COLUMN_OPERATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RenameColumnsOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final TransformOperationSource source;
    private final List<RenameColumnOperation> renameColumnOperations;

    private RenameColumnsOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.renameColumnOperations = builder.renameColumnOperations;
    }

    public final String alias() {
        return this.alias;
    }

    public final TransformOperationSource source() {
        return this.source;
    }

    public final boolean hasRenameColumnOperations() {
        return this.renameColumnOperations != null && !(this.renameColumnOperations instanceof SdkAutoConstructList);
    }

    public final List<RenameColumnOperation> renameColumnOperations() {
        return this.renameColumnOperations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRenameColumnOperations() ? this.renameColumnOperations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenameColumnsOperation)) {
            return false;
        }
        RenameColumnsOperation other = (RenameColumnsOperation)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.source(), other.source()) && this.hasRenameColumnOperations() == other.hasRenameColumnOperations() && Objects.equals(this.renameColumnOperations(), other.renameColumnOperations());
    }

    public final String toString() {
        return ToString.builder((String)"RenameColumnsOperation").add("Alias", (Object)this.alias()).add("Source", (Object)this.source()).add("RenameColumnOperations", this.hasRenameColumnOperations() ? this.renameColumnOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "RenameColumnOperations": {
                return Optional.ofNullable(clazz.cast(this.renameColumnOperations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("RenameColumnOperations", RENAME_COLUMN_OPERATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RenameColumnsOperation, T> g) {
        return obj -> g.apply((RenameColumnsOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private TransformOperationSource source;
        private List<RenameColumnOperation> renameColumnOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenameColumnsOperation model) {
            this.alias(model.alias);
            this.source(model.source);
            this.renameColumnOperations(model.renameColumnOperations);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final List<RenameColumnOperation.Builder> getRenameColumnOperations() {
            List<RenameColumnOperation.Builder> result = RenameColumnOperationListCopier.copyToBuilder(this.renameColumnOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRenameColumnOperations(Collection<RenameColumnOperation.BuilderImpl> renameColumnOperations) {
            this.renameColumnOperations = RenameColumnOperationListCopier.copyFromBuilder(renameColumnOperations);
        }

        @Override
        public final Builder renameColumnOperations(Collection<RenameColumnOperation> renameColumnOperations) {
            this.renameColumnOperations = RenameColumnOperationListCopier.copy(renameColumnOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renameColumnOperations(RenameColumnOperation ... renameColumnOperations) {
            this.renameColumnOperations(Arrays.asList(renameColumnOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder renameColumnOperations(Consumer<RenameColumnOperation.Builder> ... renameColumnOperations) {
            this.renameColumnOperations(Stream.of(renameColumnOperations).map(c -> (RenameColumnOperation)((RenameColumnOperation.Builder)RenameColumnOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RenameColumnsOperation build() {
            return new RenameColumnsOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenameColumnsOperation> {
        public Builder alias(String var1);

        public Builder source(TransformOperationSource var1);

        default public Builder source(Consumer<TransformOperationSource.Builder> source) {
            return this.source((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(source)).build());
        }

        public Builder renameColumnOperations(Collection<RenameColumnOperation> var1);

        public Builder renameColumnOperations(RenameColumnOperation ... var1);

        public Builder renameColumnOperations(Consumer<RenameColumnOperation.Builder> ... var1);
    }
}

