/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3KnowledgeBaseParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3KnowledgeBaseParameters> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(S3KnowledgeBaseParameters.getter(S3KnowledgeBaseParameters::roleArn)).setter(S3KnowledgeBaseParameters.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> BUCKET_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketUrl").getter(S3KnowledgeBaseParameters.getter(S3KnowledgeBaseParameters::bucketUrl)).setter(S3KnowledgeBaseParameters.setter(Builder::bucketUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketUrl").build()}).build();
    private static final SdkField<String> METADATA_FILES_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataFilesLocation").getter(S3KnowledgeBaseParameters.getter(S3KnowledgeBaseParameters::metadataFilesLocation)).setter(S3KnowledgeBaseParameters.setter(Builder::metadataFilesLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataFilesLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, BUCKET_URL_FIELD, METADATA_FILES_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3KnowledgeBaseParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String bucketUrl;
    private final String metadataFilesLocation;

    private S3KnowledgeBaseParameters(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.bucketUrl = builder.bucketUrl;
        this.metadataFilesLocation = builder.metadataFilesLocation;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String bucketUrl() {
        return this.bucketUrl;
    }

    public final String metadataFilesLocation() {
        return this.metadataFilesLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataFilesLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3KnowledgeBaseParameters)) {
            return false;
        }
        S3KnowledgeBaseParameters other = (S3KnowledgeBaseParameters)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.bucketUrl(), other.bucketUrl()) && Objects.equals(this.metadataFilesLocation(), other.metadataFilesLocation());
    }

    public final String toString() {
        return ToString.builder((String)"S3KnowledgeBaseParameters").add("RoleArn", (Object)this.roleArn()).add("BucketUrl", (Object)this.bucketUrl()).add("MetadataFilesLocation", (Object)this.metadataFilesLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "BucketUrl": {
                return Optional.ofNullable(clazz.cast(this.bucketUrl()));
            }
            case "MetadataFilesLocation": {
                return Optional.ofNullable(clazz.cast(this.metadataFilesLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("BucketUrl", BUCKET_URL_FIELD);
        map.put("MetadataFilesLocation", METADATA_FILES_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3KnowledgeBaseParameters, T> g) {
        return obj -> g.apply((S3KnowledgeBaseParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String bucketUrl;
        private String metadataFilesLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(S3KnowledgeBaseParameters model) {
            this.roleArn(model.roleArn);
            this.bucketUrl(model.bucketUrl);
            this.metadataFilesLocation(model.metadataFilesLocation);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getBucketUrl() {
            return this.bucketUrl;
        }

        public final void setBucketUrl(String bucketUrl) {
            this.bucketUrl = bucketUrl;
        }

        @Override
        public final Builder bucketUrl(String bucketUrl) {
            this.bucketUrl = bucketUrl;
            return this;
        }

        public final String getMetadataFilesLocation() {
            return this.metadataFilesLocation;
        }

        public final void setMetadataFilesLocation(String metadataFilesLocation) {
            this.metadataFilesLocation = metadataFilesLocation;
        }

        @Override
        public final Builder metadataFilesLocation(String metadataFilesLocation) {
            this.metadataFilesLocation = metadataFilesLocation;
            return this;
        }

        public S3KnowledgeBaseParameters build() {
            return new S3KnowledgeBaseParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3KnowledgeBaseParameters> {
        public Builder roleArn(String var1);

        public Builder bucketUrl(String var1);

        public Builder metadataFilesLocation(String var1);
    }
}

