/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AggregateOperation;
import software.amazon.awssdk.services.quicksight.model.AppendOperation;
import software.amazon.awssdk.services.quicksight.model.CastColumnTypesOperation;
import software.amazon.awssdk.services.quicksight.model.CreateColumnsOperation;
import software.amazon.awssdk.services.quicksight.model.FiltersOperation;
import software.amazon.awssdk.services.quicksight.model.ImportTableOperation;
import software.amazon.awssdk.services.quicksight.model.JoinOperation;
import software.amazon.awssdk.services.quicksight.model.PivotOperation;
import software.amazon.awssdk.services.quicksight.model.ProjectOperation;
import software.amazon.awssdk.services.quicksight.model.RenameColumnsOperation;
import software.amazon.awssdk.services.quicksight.model.UnpivotOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformStep> {
    private static final SdkField<ImportTableOperation> IMPORT_TABLE_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportTableStep").getter(TransformStep.getter(TransformStep::importTableStep)).setter(TransformStep.setter(Builder::importTableStep)).constructor(ImportTableOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTableStep").build()}).build();
    private static final SdkField<ProjectOperation> PROJECT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProjectStep").getter(TransformStep.getter(TransformStep::projectStep)).setter(TransformStep.setter(Builder::projectStep)).constructor(ProjectOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectStep").build()}).build();
    private static final SdkField<FiltersOperation> FILTERS_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FiltersStep").getter(TransformStep.getter(TransformStep::filtersStep)).setter(TransformStep.setter(Builder::filtersStep)).constructor(FiltersOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FiltersStep").build()}).build();
    private static final SdkField<CreateColumnsOperation> CREATE_COLUMNS_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateColumnsStep").getter(TransformStep.getter(TransformStep::createColumnsStep)).setter(TransformStep.setter(Builder::createColumnsStep)).constructor(CreateColumnsOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateColumnsStep").build()}).build();
    private static final SdkField<RenameColumnsOperation> RENAME_COLUMNS_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RenameColumnsStep").getter(TransformStep.getter(TransformStep::renameColumnsStep)).setter(TransformStep.setter(Builder::renameColumnsStep)).constructor(RenameColumnsOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameColumnsStep").build()}).build();
    private static final SdkField<CastColumnTypesOperation> CAST_COLUMN_TYPES_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CastColumnTypesStep").getter(TransformStep.getter(TransformStep::castColumnTypesStep)).setter(TransformStep.setter(Builder::castColumnTypesStep)).constructor(CastColumnTypesOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CastColumnTypesStep").build()}).build();
    private static final SdkField<JoinOperation> JOIN_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JoinStep").getter(TransformStep.getter(TransformStep::joinStep)).setter(TransformStep.setter(Builder::joinStep)).constructor(JoinOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinStep").build()}).build();
    private static final SdkField<AggregateOperation> AGGREGATE_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AggregateStep").getter(TransformStep.getter(TransformStep::aggregateStep)).setter(TransformStep.setter(Builder::aggregateStep)).constructor(AggregateOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregateStep").build()}).build();
    private static final SdkField<PivotOperation> PIVOT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PivotStep").getter(TransformStep.getter(TransformStep::pivotStep)).setter(TransformStep.setter(Builder::pivotStep)).constructor(PivotOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PivotStep").build()}).build();
    private static final SdkField<UnpivotOperation> UNPIVOT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UnpivotStep").getter(TransformStep.getter(TransformStep::unpivotStep)).setter(TransformStep.setter(Builder::unpivotStep)).constructor(UnpivotOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpivotStep").build()}).build();
    private static final SdkField<AppendOperation> APPEND_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppendStep").getter(TransformStep.getter(TransformStep::appendStep)).setter(TransformStep.setter(Builder::appendStep)).constructor(AppendOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppendStep").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TABLE_STEP_FIELD, PROJECT_STEP_FIELD, FILTERS_STEP_FIELD, CREATE_COLUMNS_STEP_FIELD, RENAME_COLUMNS_STEP_FIELD, CAST_COLUMN_TYPES_STEP_FIELD, JOIN_STEP_FIELD, AGGREGATE_STEP_FIELD, PIVOT_STEP_FIELD, UNPIVOT_STEP_FIELD, APPEND_STEP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransformStep.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ImportTableOperation importTableStep;
    private final ProjectOperation projectStep;
    private final FiltersOperation filtersStep;
    private final CreateColumnsOperation createColumnsStep;
    private final RenameColumnsOperation renameColumnsStep;
    private final CastColumnTypesOperation castColumnTypesStep;
    private final JoinOperation joinStep;
    private final AggregateOperation aggregateStep;
    private final PivotOperation pivotStep;
    private final UnpivotOperation unpivotStep;
    private final AppendOperation appendStep;

    private TransformStep(BuilderImpl builder) {
        this.importTableStep = builder.importTableStep;
        this.projectStep = builder.projectStep;
        this.filtersStep = builder.filtersStep;
        this.createColumnsStep = builder.createColumnsStep;
        this.renameColumnsStep = builder.renameColumnsStep;
        this.castColumnTypesStep = builder.castColumnTypesStep;
        this.joinStep = builder.joinStep;
        this.aggregateStep = builder.aggregateStep;
        this.pivotStep = builder.pivotStep;
        this.unpivotStep = builder.unpivotStep;
        this.appendStep = builder.appendStep;
    }

    public final ImportTableOperation importTableStep() {
        return this.importTableStep;
    }

    public final ProjectOperation projectStep() {
        return this.projectStep;
    }

    public final FiltersOperation filtersStep() {
        return this.filtersStep;
    }

    public final CreateColumnsOperation createColumnsStep() {
        return this.createColumnsStep;
    }

    public final RenameColumnsOperation renameColumnsStep() {
        return this.renameColumnsStep;
    }

    public final CastColumnTypesOperation castColumnTypesStep() {
        return this.castColumnTypesStep;
    }

    public final JoinOperation joinStep() {
        return this.joinStep;
    }

    public final AggregateOperation aggregateStep() {
        return this.aggregateStep;
    }

    public final PivotOperation pivotStep() {
        return this.pivotStep;
    }

    public final UnpivotOperation unpivotStep() {
        return this.unpivotStep;
    }

    public final AppendOperation appendStep() {
        return this.appendStep;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importTableStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.filtersStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.createColumnsStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.renameColumnsStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.castColumnTypesStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.pivotStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.unpivotStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.appendStep());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformStep)) {
            return false;
        }
        TransformStep other = (TransformStep)obj;
        return Objects.equals(this.importTableStep(), other.importTableStep()) && Objects.equals(this.projectStep(), other.projectStep()) && Objects.equals(this.filtersStep(), other.filtersStep()) && Objects.equals(this.createColumnsStep(), other.createColumnsStep()) && Objects.equals(this.renameColumnsStep(), other.renameColumnsStep()) && Objects.equals(this.castColumnTypesStep(), other.castColumnTypesStep()) && Objects.equals(this.joinStep(), other.joinStep()) && Objects.equals(this.aggregateStep(), other.aggregateStep()) && Objects.equals(this.pivotStep(), other.pivotStep()) && Objects.equals(this.unpivotStep(), other.unpivotStep()) && Objects.equals(this.appendStep(), other.appendStep());
    }

    public final String toString() {
        return ToString.builder((String)"TransformStep").add("ImportTableStep", (Object)this.importTableStep()).add("ProjectStep", (Object)this.projectStep()).add("FiltersStep", (Object)this.filtersStep()).add("CreateColumnsStep", (Object)this.createColumnsStep()).add("RenameColumnsStep", (Object)this.renameColumnsStep()).add("CastColumnTypesStep", (Object)this.castColumnTypesStep()).add("JoinStep", (Object)this.joinStep()).add("AggregateStep", (Object)this.aggregateStep()).add("PivotStep", (Object)this.pivotStep()).add("UnpivotStep", (Object)this.unpivotStep()).add("AppendStep", (Object)this.appendStep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportTableStep": {
                return Optional.ofNullable(clazz.cast(this.importTableStep()));
            }
            case "ProjectStep": {
                return Optional.ofNullable(clazz.cast(this.projectStep()));
            }
            case "FiltersStep": {
                return Optional.ofNullable(clazz.cast(this.filtersStep()));
            }
            case "CreateColumnsStep": {
                return Optional.ofNullable(clazz.cast(this.createColumnsStep()));
            }
            case "RenameColumnsStep": {
                return Optional.ofNullable(clazz.cast(this.renameColumnsStep()));
            }
            case "CastColumnTypesStep": {
                return Optional.ofNullable(clazz.cast(this.castColumnTypesStep()));
            }
            case "JoinStep": {
                return Optional.ofNullable(clazz.cast(this.joinStep()));
            }
            case "AggregateStep": {
                return Optional.ofNullable(clazz.cast(this.aggregateStep()));
            }
            case "PivotStep": {
                return Optional.ofNullable(clazz.cast(this.pivotStep()));
            }
            case "UnpivotStep": {
                return Optional.ofNullable(clazz.cast(this.unpivotStep()));
            }
            case "AppendStep": {
                return Optional.ofNullable(clazz.cast(this.appendStep()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImportTableStep", IMPORT_TABLE_STEP_FIELD);
        map.put("ProjectStep", PROJECT_STEP_FIELD);
        map.put("FiltersStep", FILTERS_STEP_FIELD);
        map.put("CreateColumnsStep", CREATE_COLUMNS_STEP_FIELD);
        map.put("RenameColumnsStep", RENAME_COLUMNS_STEP_FIELD);
        map.put("CastColumnTypesStep", CAST_COLUMN_TYPES_STEP_FIELD);
        map.put("JoinStep", JOIN_STEP_FIELD);
        map.put("AggregateStep", AGGREGATE_STEP_FIELD);
        map.put("PivotStep", PIVOT_STEP_FIELD);
        map.put("UnpivotStep", UNPIVOT_STEP_FIELD);
        map.put("AppendStep", APPEND_STEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformStep, T> g) {
        return obj -> g.apply((TransformStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImportTableOperation importTableStep;
        private ProjectOperation projectStep;
        private FiltersOperation filtersStep;
        private CreateColumnsOperation createColumnsStep;
        private RenameColumnsOperation renameColumnsStep;
        private CastColumnTypesOperation castColumnTypesStep;
        private JoinOperation joinStep;
        private AggregateOperation aggregateStep;
        private PivotOperation pivotStep;
        private UnpivotOperation unpivotStep;
        private AppendOperation appendStep;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformStep model) {
            this.importTableStep(model.importTableStep);
            this.projectStep(model.projectStep);
            this.filtersStep(model.filtersStep);
            this.createColumnsStep(model.createColumnsStep);
            this.renameColumnsStep(model.renameColumnsStep);
            this.castColumnTypesStep(model.castColumnTypesStep);
            this.joinStep(model.joinStep);
            this.aggregateStep(model.aggregateStep);
            this.pivotStep(model.pivotStep);
            this.unpivotStep(model.unpivotStep);
            this.appendStep(model.appendStep);
        }

        public final ImportTableOperation.Builder getImportTableStep() {
            return this.importTableStep != null ? this.importTableStep.toBuilder() : null;
        }

        public final void setImportTableStep(ImportTableOperation.BuilderImpl importTableStep) {
            this.importTableStep = importTableStep != null ? importTableStep.build() : null;
        }

        @Override
        public final Builder importTableStep(ImportTableOperation importTableStep) {
            this.importTableStep = importTableStep;
            return this;
        }

        public final ProjectOperation.Builder getProjectStep() {
            return this.projectStep != null ? this.projectStep.toBuilder() : null;
        }

        public final void setProjectStep(ProjectOperation.BuilderImpl projectStep) {
            this.projectStep = projectStep != null ? projectStep.build() : null;
        }

        @Override
        public final Builder projectStep(ProjectOperation projectStep) {
            this.projectStep = projectStep;
            return this;
        }

        public final FiltersOperation.Builder getFiltersStep() {
            return this.filtersStep != null ? this.filtersStep.toBuilder() : null;
        }

        public final void setFiltersStep(FiltersOperation.BuilderImpl filtersStep) {
            this.filtersStep = filtersStep != null ? filtersStep.build() : null;
        }

        @Override
        public final Builder filtersStep(FiltersOperation filtersStep) {
            this.filtersStep = filtersStep;
            return this;
        }

        public final CreateColumnsOperation.Builder getCreateColumnsStep() {
            return this.createColumnsStep != null ? this.createColumnsStep.toBuilder() : null;
        }

        public final void setCreateColumnsStep(CreateColumnsOperation.BuilderImpl createColumnsStep) {
            this.createColumnsStep = createColumnsStep != null ? createColumnsStep.build() : null;
        }

        @Override
        public final Builder createColumnsStep(CreateColumnsOperation createColumnsStep) {
            this.createColumnsStep = createColumnsStep;
            return this;
        }

        public final RenameColumnsOperation.Builder getRenameColumnsStep() {
            return this.renameColumnsStep != null ? this.renameColumnsStep.toBuilder() : null;
        }

        public final void setRenameColumnsStep(RenameColumnsOperation.BuilderImpl renameColumnsStep) {
            this.renameColumnsStep = renameColumnsStep != null ? renameColumnsStep.build() : null;
        }

        @Override
        public final Builder renameColumnsStep(RenameColumnsOperation renameColumnsStep) {
            this.renameColumnsStep = renameColumnsStep;
            return this;
        }

        public final CastColumnTypesOperation.Builder getCastColumnTypesStep() {
            return this.castColumnTypesStep != null ? this.castColumnTypesStep.toBuilder() : null;
        }

        public final void setCastColumnTypesStep(CastColumnTypesOperation.BuilderImpl castColumnTypesStep) {
            this.castColumnTypesStep = castColumnTypesStep != null ? castColumnTypesStep.build() : null;
        }

        @Override
        public final Builder castColumnTypesStep(CastColumnTypesOperation castColumnTypesStep) {
            this.castColumnTypesStep = castColumnTypesStep;
            return this;
        }

        public final JoinOperation.Builder getJoinStep() {
            return this.joinStep != null ? this.joinStep.toBuilder() : null;
        }

        public final void setJoinStep(JoinOperation.BuilderImpl joinStep) {
            this.joinStep = joinStep != null ? joinStep.build() : null;
        }

        @Override
        public final Builder joinStep(JoinOperation joinStep) {
            this.joinStep = joinStep;
            return this;
        }

        public final AggregateOperation.Builder getAggregateStep() {
            return this.aggregateStep != null ? this.aggregateStep.toBuilder() : null;
        }

        public final void setAggregateStep(AggregateOperation.BuilderImpl aggregateStep) {
            this.aggregateStep = aggregateStep != null ? aggregateStep.build() : null;
        }

        @Override
        public final Builder aggregateStep(AggregateOperation aggregateStep) {
            this.aggregateStep = aggregateStep;
            return this;
        }

        public final PivotOperation.Builder getPivotStep() {
            return this.pivotStep != null ? this.pivotStep.toBuilder() : null;
        }

        public final void setPivotStep(PivotOperation.BuilderImpl pivotStep) {
            this.pivotStep = pivotStep != null ? pivotStep.build() : null;
        }

        @Override
        public final Builder pivotStep(PivotOperation pivotStep) {
            this.pivotStep = pivotStep;
            return this;
        }

        public final UnpivotOperation.Builder getUnpivotStep() {
            return this.unpivotStep != null ? this.unpivotStep.toBuilder() : null;
        }

        public final void setUnpivotStep(UnpivotOperation.BuilderImpl unpivotStep) {
            this.unpivotStep = unpivotStep != null ? unpivotStep.build() : null;
        }

        @Override
        public final Builder unpivotStep(UnpivotOperation unpivotStep) {
            this.unpivotStep = unpivotStep;
            return this;
        }

        public final AppendOperation.Builder getAppendStep() {
            return this.appendStep != null ? this.appendStep.toBuilder() : null;
        }

        public final void setAppendStep(AppendOperation.BuilderImpl appendStep) {
            this.appendStep = appendStep != null ? appendStep.build() : null;
        }

        @Override
        public final Builder appendStep(AppendOperation appendStep) {
            this.appendStep = appendStep;
            return this;
        }

        public TransformStep build() {
            return new TransformStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformStep> {
        public Builder importTableStep(ImportTableOperation var1);

        default public Builder importTableStep(Consumer<ImportTableOperation.Builder> importTableStep) {
            return this.importTableStep((ImportTableOperation)((ImportTableOperation.Builder)ImportTableOperation.builder().applyMutation(importTableStep)).build());
        }

        public Builder projectStep(ProjectOperation var1);

        default public Builder projectStep(Consumer<ProjectOperation.Builder> projectStep) {
            return this.projectStep((ProjectOperation)((ProjectOperation.Builder)ProjectOperation.builder().applyMutation(projectStep)).build());
        }

        public Builder filtersStep(FiltersOperation var1);

        default public Builder filtersStep(Consumer<FiltersOperation.Builder> filtersStep) {
            return this.filtersStep((FiltersOperation)((FiltersOperation.Builder)FiltersOperation.builder().applyMutation(filtersStep)).build());
        }

        public Builder createColumnsStep(CreateColumnsOperation var1);

        default public Builder createColumnsStep(Consumer<CreateColumnsOperation.Builder> createColumnsStep) {
            return this.createColumnsStep((CreateColumnsOperation)((CreateColumnsOperation.Builder)CreateColumnsOperation.builder().applyMutation(createColumnsStep)).build());
        }

        public Builder renameColumnsStep(RenameColumnsOperation var1);

        default public Builder renameColumnsStep(Consumer<RenameColumnsOperation.Builder> renameColumnsStep) {
            return this.renameColumnsStep((RenameColumnsOperation)((RenameColumnsOperation.Builder)RenameColumnsOperation.builder().applyMutation(renameColumnsStep)).build());
        }

        public Builder castColumnTypesStep(CastColumnTypesOperation var1);

        default public Builder castColumnTypesStep(Consumer<CastColumnTypesOperation.Builder> castColumnTypesStep) {
            return this.castColumnTypesStep((CastColumnTypesOperation)((CastColumnTypesOperation.Builder)CastColumnTypesOperation.builder().applyMutation(castColumnTypesStep)).build());
        }

        public Builder joinStep(JoinOperation var1);

        default public Builder joinStep(Consumer<JoinOperation.Builder> joinStep) {
            return this.joinStep((JoinOperation)((JoinOperation.Builder)JoinOperation.builder().applyMutation(joinStep)).build());
        }

        public Builder aggregateStep(AggregateOperation var1);

        default public Builder aggregateStep(Consumer<AggregateOperation.Builder> aggregateStep) {
            return this.aggregateStep((AggregateOperation)((AggregateOperation.Builder)AggregateOperation.builder().applyMutation(aggregateStep)).build());
        }

        public Builder pivotStep(PivotOperation var1);

        default public Builder pivotStep(Consumer<PivotOperation.Builder> pivotStep) {
            return this.pivotStep((PivotOperation)((PivotOperation.Builder)PivotOperation.builder().applyMutation(pivotStep)).build());
        }

        public Builder unpivotStep(UnpivotOperation var1);

        default public Builder unpivotStep(Consumer<UnpivotOperation.Builder> unpivotStep) {
            return this.unpivotStep((UnpivotOperation)((UnpivotOperation.Builder)UnpivotOperation.builder().applyMutation(unpivotStep)).build());
        }

        public Builder appendStep(AppendOperation var1);

        default public Builder appendStep(Consumer<AppendOperation.Builder> appendStep) {
            return this.appendStep((AppendOperation)((AppendOperation.Builder)AppendOperation.builder().applyMutation(appendStep)).build());
        }
    }
}

