/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.FlowSummary;
import software.amazon.awssdk.services.quicksight.model.ListFlowsRequest;
import software.amazon.awssdk.services.quicksight.model.ListFlowsResponse;

public class ListFlowsPublisher
implements SdkPublisher<ListFlowsResponse> {
    private final QuickSightAsyncClient client;
    private final ListFlowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowsPublisher(QuickSightAsyncClient client, ListFlowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowsPublisher(QuickSightAsyncClient client, ListFlowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowSummary> flowSummaryList() {
        Function<ListFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowSummaryList() != null) {
                return response.flowSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowsResponseFetcher
    implements AsyncPageFetcher<ListFlowsResponse> {
        private ListFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowsResponse> nextPage(ListFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowsPublisher.this.client.listFlows(ListFlowsPublisher.this.firstRequest);
            }
            return ListFlowsPublisher.this.client.listFlows((ListFlowsRequest)((Object)ListFlowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

