/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.FlowSummary;
import software.amazon.awssdk.services.quicksight.model.SearchFlowsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFlowsResponse;

public class SearchFlowsIterable
implements SdkIterable<SearchFlowsResponse> {
    private final QuickSightClient client;
    private final SearchFlowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchFlowsIterable(QuickSightClient client, SearchFlowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchFlowsResponseFetcher();
    }

    public Iterator<SearchFlowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowSummary> flowSummaryList() {
        Function<SearchFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowSummaryList() != null) {
                return response.flowSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchFlowsResponseFetcher
    implements SyncPageFetcher<SearchFlowsResponse> {
        private SearchFlowsResponseFetcher() {
        }

        public boolean hasNextPage(SearchFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchFlowsResponse nextPage(SearchFlowsResponse previousPage) {
            if (previousPage == null) {
                return SearchFlowsIterable.this.client.searchFlows(SearchFlowsIterable.this.firstRequest);
            }
            return SearchFlowsIterable.this.client.searchFlows((SearchFlowsRequest)((Object)SearchFlowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

