/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for API key-based authentication to external services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class APIKeyConnectionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<APIKeyConnectionMetadata.Builder, APIKeyConnectionMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseEndpoint").getter(getter(APIKeyConnectionMetadata::baseEndpoint))
            .setter(setter(Builder::baseEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()).build();

    private static final SdkField<String> API_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiKey")
            .getter(getter(APIKeyConnectionMetadata::apiKey)).setter(setter(Builder::apiKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(APIKeyConnectionMetadata::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD,
            API_KEY_FIELD, EMAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String baseEndpoint;

    private final String apiKey;

    private final String email;

    private APIKeyConnectionMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.apiKey = builder.apiKey;
        this.email = builder.email;
    }

    /**
     * <p>
     * The base URL endpoint for the external service.
     * </p>
     * 
     * @return The base URL endpoint for the external service.
     */
    public final String baseEndpoint() {
        return baseEndpoint;
    }

    /**
     * <p>
     * The API key used for authentication.
     * </p>
     * 
     * @return The API key used for authentication.
     */
    public final String apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * The email address associated with the API key, if required.
     * </p>
     * 
     * @return The email address associated with the API key, if required.
     */
    public final String email() {
        return email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APIKeyConnectionMetadata)) {
            return false;
        }
        APIKeyConnectionMetadata other = (APIKeyConnectionMetadata) obj;
        return Objects.equals(baseEndpoint(), other.baseEndpoint()) && Objects.equals(apiKey(), other.apiKey())
                && Objects.equals(email(), other.email());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("APIKeyConnectionMetadata").add("BaseEndpoint", baseEndpoint())
                .add("ApiKey", apiKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Email", email() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseEndpoint":
            return Optional.ofNullable(clazz.cast(baseEndpoint()));
        case "ApiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("ApiKey", API_KEY_FIELD);
        map.put("Email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<APIKeyConnectionMetadata, T> g) {
        return obj -> g.apply((APIKeyConnectionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, APIKeyConnectionMetadata> {
        /**
         * <p>
         * The base URL endpoint for the external service.
         * </p>
         * 
         * @param baseEndpoint
         *        The base URL endpoint for the external service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpoint(String baseEndpoint);

        /**
         * <p>
         * The API key used for authentication.
         * </p>
         * 
         * @param apiKey
         *        The API key used for authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * <p>
         * The email address associated with the API key, if required.
         * </p>
         * 
         * @param email
         *        The email address associated with the API key, if required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);
    }

    static final class BuilderImpl implements Builder {
        private String baseEndpoint;

        private String apiKey;

        private String email;

        private BuilderImpl() {
        }

        private BuilderImpl(APIKeyConnectionMetadata model) {
            baseEndpoint(model.baseEndpoint);
            apiKey(model.apiKey);
            email(model.email);
        }

        public final String getBaseEndpoint() {
            return baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final String getApiKey() {
            return apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        @Override
        public APIKeyConnectionMetadata build() {
            return new APIKeyConnectionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
