/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about an action connector, used in list and search operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionConnectorSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionConnectorSummary.Builder, ActionConnectorSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ActionConnectorSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ACTION_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionConnectorId").getter(getter(ActionConnectorSummary::actionConnectorId))
            .setter(setter(Builder::actionConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionConnectorId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ActionConnectorSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ActionConnectorSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ActionConnectorSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(ActionConnectorSummary::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ActionConnectorSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ActionConnectorError> ERROR_FIELD = SdkField
            .<ActionConnectorError> builder(MarshallingType.SDK_POJO).memberName("Error")
            .getter(getter(ActionConnectorSummary::error)).setter(setter(Builder::error))
            .constructor(ActionConnectorError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ACTION_CONNECTOR_ID_FIELD, TYPE_FIELD, NAME_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, STATUS_FIELD,
            ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String actionConnectorId;

    private final String type;

    private final String name;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String status;

    private final ActionConnectorError error;

    private ActionConnectorSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.actionConnectorId = builder.actionConnectorId;
        this.type = builder.type;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.status = builder.status;
        this.error = builder.error;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the action connector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the action connector.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the action connector.
     * </p>
     * 
     * @return The unique identifier of the action connector.
     */
    public final String actionConnectorId() {
        return actionConnectorId;
    }

    /**
     * <p>
     * The type of action connector (e.g., SALESFORCE, JIRA, CUSTOM, BEDROCK).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action connector (e.g., SALESFORCE, JIRA, CUSTOM, BEDROCK).
     * @see ActionConnectorType
     */
    public final ActionConnectorType type() {
        return ActionConnectorType.fromValue(type);
    }

    /**
     * <p>
     * The type of action connector (e.g., SALESFORCE, JIRA, CUSTOM, BEDROCK).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action connector (e.g., SALESFORCE, JIRA, CUSTOM, BEDROCK).
     * @see ActionConnectorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the action connector.
     * </p>
     * 
     * @return The name of the action connector.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date and time when the action connector was created.
     * </p>
     * 
     * @return The date and time when the action connector was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time when the action connector was last updated.
     * </p>
     * 
     * @return The date and time when the action connector was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The current status of the action connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the action connector.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the action connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the action connector.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Error information if the action connector is in an error state.
     * </p>
     * 
     * @return Error information if the action connector is in an error state.
     */
    public final ActionConnectorError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(actionConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionConnectorSummary)) {
            return false;
        }
        ActionConnectorSummary other = (ActionConnectorSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(actionConnectorId(), other.actionConnectorId())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionConnectorSummary").add("Arn", arn()).add("ActionConnectorId", actionConnectorId())
                .add("Type", typeAsString()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime()).add("Status", statusAsString())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ActionConnectorId":
            return Optional.ofNullable(clazz.cast(actionConnectorId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("ActionConnectorId", ACTION_CONNECTOR_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionConnectorSummary, T> g) {
        return obj -> g.apply((ActionConnectorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionConnectorSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the action connector.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the action connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the action connector.
         * </p>
         * 
         * @param actionConnectorId
         *        The unique identifier of the action connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConnectorId(String actionConnectorId);

        /**
         * <p>
         * The type of action connector (e.g., SALESFORCE, JIRA, CUSTOM, BEDROCK).
         * </p>
         * 
         * @param type
         *        The type of action connector (e.g., SALESFORCE, JIRA, CUSTOM, BEDROCK).
         * @see ActionConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionConnectorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of action connector (e.g., SALESFORCE, JIRA, CUSTOM, BEDROCK).
         * </p>
         * 
         * @param type
         *        The type of action connector (e.g., SALESFORCE, JIRA, CUSTOM, BEDROCK).
         * @see ActionConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionConnectorType
         */
        Builder type(ActionConnectorType type);

        /**
         * <p>
         * The name of the action connector.
         * </p>
         * 
         * @param name
         *        The name of the action connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date and time when the action connector was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time when the action connector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time when the action connector was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time when the action connector was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The current status of the action connector.
         * </p>
         * 
         * @param status
         *        The current status of the action connector.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the action connector.
         * </p>
         * 
         * @param status
         *        The current status of the action connector.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Error information if the action connector is in an error state.
         * </p>
         * 
         * @param error
         *        Error information if the action connector is in an error state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ActionConnectorError error);

        /**
         * <p>
         * Error information if the action connector is in an error state.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionConnectorError.Builder} avoiding
         * the need to create one manually via {@link ActionConnectorError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionConnectorError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(ActionConnectorError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ActionConnectorError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ActionConnectorError)
         */
        default Builder error(Consumer<ActionConnectorError.Builder> error) {
            return error(ActionConnectorError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String actionConnectorId;

        private String type;

        private String name;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String status;

        private ActionConnectorError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionConnectorSummary model) {
            arn(model.arn);
            actionConnectorId(model.actionConnectorId);
            type(model.type);
            name(model.name);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            status(model.status);
            error(model.error);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getActionConnectorId() {
            return actionConnectorId;
        }

        public final void setActionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
        }

        @Override
        public final Builder actionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionConnectorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ActionConnectorError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ActionConnectorError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ActionConnectorError error) {
            this.error = error;
            return this;
        }

        @Override
        public ActionConnectorSummary build() {
            return new ActionConnectorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
