/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ActionConnectorType {
    GENERIC_HTTP("GENERIC_HTTP"),

    SERVICENOW_NOW_PLATFORM("SERVICENOW_NOW_PLATFORM"),

    SALESFORCE_CRM("SALESFORCE_CRM"),

    MICROSOFT_OUTLOOK("MICROSOFT_OUTLOOK"),

    PAGERDUTY_ADVANCE("PAGERDUTY_ADVANCE"),

    JIRA_CLOUD("JIRA_CLOUD"),

    ATLASSIAN_CONFLUENCE("ATLASSIAN_CONFLUENCE"),

    AMAZON_S3("AMAZON_S3"),

    AMAZON_BEDROCK_AGENT_RUNTIME("AMAZON_BEDROCK_AGENT_RUNTIME"),

    AMAZON_BEDROCK_RUNTIME("AMAZON_BEDROCK_RUNTIME"),

    AMAZON_BEDROCK_DATA_AUTOMATION_RUNTIME("AMAZON_BEDROCK_DATA_AUTOMATION_RUNTIME"),

    AMAZON_TEXTRACT("AMAZON_TEXTRACT"),

    AMAZON_COMPREHEND("AMAZON_COMPREHEND"),

    AMAZON_COMPREHEND_MEDICAL("AMAZON_COMPREHEND_MEDICAL"),

    MICROSOFT_ONEDRIVE("MICROSOFT_ONEDRIVE"),

    MICROSOFT_SHAREPOINT("MICROSOFT_SHAREPOINT"),

    MICROSOFT_TEAMS("MICROSOFT_TEAMS"),

    SAP_BUSINESSPARTNER("SAP_BUSINESSPARTNER"),

    SAP_PRODUCTMASTERDATA("SAP_PRODUCTMASTERDATA"),

    SAP_PHYSICALINVENTORY("SAP_PHYSICALINVENTORY"),

    SAP_BILLOFMATERIALS("SAP_BILLOFMATERIALS"),

    SAP_MATERIALSTOCK("SAP_MATERIALSTOCK"),

    ZENDESK_SUITE("ZENDESK_SUITE"),

    SMARTSHEET("SMARTSHEET"),

    SLACK("SLACK"),

    ASANA("ASANA"),

    BAMBOO_HR("BAMBOO_HR"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionConnectorType> VALUE_MAP = EnumUtils.uniqueIndex(ActionConnectorType.class,
            ActionConnectorType::toString);

    private final String value;

    private ActionConnectorType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ActionConnectorType corresponding to the value
     */
    public static ActionConnectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ActionConnectorType}s
     */
    public static Set<ActionConnectorType> knownValues() {
        Set<ActionConnectorType> knownValues = EnumSet.allOf(ActionConnectorType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
