/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a column that will be included in the result of an append operation, combining data from multiple sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppendedColumn implements SdkPojo, Serializable, ToCopyableBuilder<AppendedColumn.Builder, AppendedColumn> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(AppendedColumn::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> NEW_COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewColumnId").getter(getter(AppendedColumn::newColumnId)).setter(setter(Builder::newColumnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            NEW_COLUMN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String newColumnId;

    private AppendedColumn(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.newColumnId = builder.newColumnId;
    }

    /**
     * <p>
     * The name of the column to include in the appended result.
     * </p>
     * 
     * @return The name of the column to include in the appended result.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * A unique identifier for the column in the appended result.
     * </p>
     * 
     * @return A unique identifier for the column in the appended result.
     */
    public final String newColumnId() {
        return newColumnId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(newColumnId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppendedColumn)) {
            return false;
        }
        AppendedColumn other = (AppendedColumn) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(newColumnId(), other.newColumnId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppendedColumn").add("ColumnName", columnName()).add("NewColumnId", newColumnId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "NewColumnId":
            return Optional.ofNullable(clazz.cast(newColumnId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("NewColumnId", NEW_COLUMN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppendedColumn, T> g) {
        return obj -> g.apply((AppendedColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppendedColumn> {
        /**
         * <p>
         * The name of the column to include in the appended result.
         * </p>
         * 
         * @param columnName
         *        The name of the column to include in the appended result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * A unique identifier for the column in the appended result.
         * </p>
         * 
         * @param newColumnId
         *        A unique identifier for the column in the appended result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newColumnId(String newColumnId);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String newColumnId;

        private BuilderImpl() {
        }

        private BuilderImpl(AppendedColumn model) {
            columnName(model.columnName);
            newColumnId(model.newColumnId);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getNewColumnId() {
            return newColumnId;
        }

        public final void setNewColumnId(String newColumnId) {
            this.newColumnId = newColumnId;
        }

        @Override
        public final Builder newColumnId(String newColumnId) {
            this.newColumnId = newColumnId;
            return this;
        }

        @Override
        public AppendedColumn build() {
            return new AppendedColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
