/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The application theme.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationTheme implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationTheme.Builder, ApplicationTheme> {
    private static final SdkField<BrandColorPalette> BRAND_COLOR_PALETTE_FIELD = SdkField
            .<BrandColorPalette> builder(MarshallingType.SDK_POJO).memberName("BrandColorPalette")
            .getter(getter(ApplicationTheme::brandColorPalette)).setter(setter(Builder::brandColorPalette))
            .constructor(BrandColorPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandColorPalette").build()).build();

    private static final SdkField<ContextualAccentPalette> CONTEXTUAL_ACCENT_PALETTE_FIELD = SdkField
            .<ContextualAccentPalette> builder(MarshallingType.SDK_POJO).memberName("ContextualAccentPalette")
            .getter(getter(ApplicationTheme::contextualAccentPalette)).setter(setter(Builder::contextualAccentPalette))
            .constructor(ContextualAccentPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextualAccentPalette").build())
            .build();

    private static final SdkField<BrandElementStyle> BRAND_ELEMENT_STYLE_FIELD = SdkField
            .<BrandElementStyle> builder(MarshallingType.SDK_POJO).memberName("BrandElementStyle")
            .getter(getter(ApplicationTheme::brandElementStyle)).setter(setter(Builder::brandElementStyle))
            .constructor(BrandElementStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandElementStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAND_COLOR_PALETTE_FIELD,
            CONTEXTUAL_ACCENT_PALETTE_FIELD, BRAND_ELEMENT_STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BrandColorPalette brandColorPalette;

    private final ContextualAccentPalette contextualAccentPalette;

    private final BrandElementStyle brandElementStyle;

    private ApplicationTheme(BuilderImpl builder) {
        this.brandColorPalette = builder.brandColorPalette;
        this.contextualAccentPalette = builder.contextualAccentPalette;
        this.brandElementStyle = builder.brandElementStyle;
    }

    /**
     * <p>
     * The color palette.
     * </p>
     * 
     * @return The color palette.
     */
    public final BrandColorPalette brandColorPalette() {
        return brandColorPalette;
    }

    /**
     * <p>
     * The contextual accent palette.
     * </p>
     * 
     * @return The contextual accent palette.
     */
    public final ContextualAccentPalette contextualAccentPalette() {
        return contextualAccentPalette;
    }

    /**
     * <p>
     * The element style.
     * </p>
     * 
     * @return The element style.
     */
    public final BrandElementStyle brandElementStyle() {
        return brandElementStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brandColorPalette());
        hashCode = 31 * hashCode + Objects.hashCode(contextualAccentPalette());
        hashCode = 31 * hashCode + Objects.hashCode(brandElementStyle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationTheme)) {
            return false;
        }
        ApplicationTheme other = (ApplicationTheme) obj;
        return Objects.equals(brandColorPalette(), other.brandColorPalette())
                && Objects.equals(contextualAccentPalette(), other.contextualAccentPalette())
                && Objects.equals(brandElementStyle(), other.brandElementStyle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationTheme").add("BrandColorPalette", brandColorPalette())
                .add("ContextualAccentPalette", contextualAccentPalette()).add("BrandElementStyle", brandElementStyle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrandColorPalette":
            return Optional.ofNullable(clazz.cast(brandColorPalette()));
        case "ContextualAccentPalette":
            return Optional.ofNullable(clazz.cast(contextualAccentPalette()));
        case "BrandElementStyle":
            return Optional.ofNullable(clazz.cast(brandElementStyle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BrandColorPalette", BRAND_COLOR_PALETTE_FIELD);
        map.put("ContextualAccentPalette", CONTEXTUAL_ACCENT_PALETTE_FIELD);
        map.put("BrandElementStyle", BRAND_ELEMENT_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationTheme, T> g) {
        return obj -> g.apply((ApplicationTheme) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationTheme> {
        /**
         * <p>
         * The color palette.
         * </p>
         * 
         * @param brandColorPalette
         *        The color palette.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandColorPalette(BrandColorPalette brandColorPalette);

        /**
         * <p>
         * The color palette.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrandColorPalette.Builder} avoiding the
         * need to create one manually via {@link BrandColorPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrandColorPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #brandColorPalette(BrandColorPalette)}.
         * 
         * @param brandColorPalette
         *        a consumer that will call methods on {@link BrandColorPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brandColorPalette(BrandColorPalette)
         */
        default Builder brandColorPalette(Consumer<BrandColorPalette.Builder> brandColorPalette) {
            return brandColorPalette(BrandColorPalette.builder().applyMutation(brandColorPalette).build());
        }

        /**
         * <p>
         * The contextual accent palette.
         * </p>
         * 
         * @param contextualAccentPalette
         *        The contextual accent palette.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextualAccentPalette(ContextualAccentPalette contextualAccentPalette);

        /**
         * <p>
         * The contextual accent palette.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextualAccentPalette.Builder} avoiding
         * the need to create one manually via {@link ContextualAccentPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextualAccentPalette.Builder#build()} is called immediately
         * and its result is passed to {@link #contextualAccentPalette(ContextualAccentPalette)}.
         * 
         * @param contextualAccentPalette
         *        a consumer that will call methods on {@link ContextualAccentPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextualAccentPalette(ContextualAccentPalette)
         */
        default Builder contextualAccentPalette(Consumer<ContextualAccentPalette.Builder> contextualAccentPalette) {
            return contextualAccentPalette(ContextualAccentPalette.builder().applyMutation(contextualAccentPalette).build());
        }

        /**
         * <p>
         * The element style.
         * </p>
         * 
         * @param brandElementStyle
         *        The element style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandElementStyle(BrandElementStyle brandElementStyle);

        /**
         * <p>
         * The element style.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrandElementStyle.Builder} avoiding the
         * need to create one manually via {@link BrandElementStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrandElementStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #brandElementStyle(BrandElementStyle)}.
         * 
         * @param brandElementStyle
         *        a consumer that will call methods on {@link BrandElementStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #brandElementStyle(BrandElementStyle)
         */
        default Builder brandElementStyle(Consumer<BrandElementStyle.Builder> brandElementStyle) {
            return brandElementStyle(BrandElementStyle.builder().applyMutation(brandElementStyle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BrandColorPalette brandColorPalette;

        private ContextualAccentPalette contextualAccentPalette;

        private BrandElementStyle brandElementStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationTheme model) {
            brandColorPalette(model.brandColorPalette);
            contextualAccentPalette(model.contextualAccentPalette);
            brandElementStyle(model.brandElementStyle);
        }

        public final BrandColorPalette.Builder getBrandColorPalette() {
            return brandColorPalette != null ? brandColorPalette.toBuilder() : null;
        }

        public final void setBrandColorPalette(BrandColorPalette.BuilderImpl brandColorPalette) {
            this.brandColorPalette = brandColorPalette != null ? brandColorPalette.build() : null;
        }

        @Override
        public final Builder brandColorPalette(BrandColorPalette brandColorPalette) {
            this.brandColorPalette = brandColorPalette;
            return this;
        }

        public final ContextualAccentPalette.Builder getContextualAccentPalette() {
            return contextualAccentPalette != null ? contextualAccentPalette.toBuilder() : null;
        }

        public final void setContextualAccentPalette(ContextualAccentPalette.BuilderImpl contextualAccentPalette) {
            this.contextualAccentPalette = contextualAccentPalette != null ? contextualAccentPalette.build() : null;
        }

        @Override
        public final Builder contextualAccentPalette(ContextualAccentPalette contextualAccentPalette) {
            this.contextualAccentPalette = contextualAccentPalette;
            return this;
        }

        public final BrandElementStyle.Builder getBrandElementStyle() {
            return brandElementStyle != null ? brandElementStyle.toBuilder() : null;
        }

        public final void setBrandElementStyle(BrandElementStyle.BuilderImpl brandElementStyle) {
            this.brandElementStyle = brandElementStyle != null ? brandElementStyle.build() : null;
        }

        @Override
        public final Builder brandElementStyle(BrandElementStyle brandElementStyle) {
            this.brandElementStyle = brandElementStyle;
            return this;
        }

        @Override
        public ApplicationTheme build() {
            return new ApplicationTheme(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
