/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Authentication configuration for connecting to external services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthConfig implements SdkPojo, Serializable, ToCopyableBuilder<AuthConfig.Builder, AuthConfig> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(AuthConfig::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<AuthenticationMetadata> AUTHENTICATION_METADATA_FIELD = SdkField
            .<AuthenticationMetadata> builder(MarshallingType.SDK_POJO).memberName("AuthenticationMetadata")
            .getter(getter(AuthConfig::authenticationMetadata)).setter(setter(Builder::authenticationMetadata))
            .constructor(AuthenticationMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            AUTHENTICATION_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final AuthenticationMetadata authenticationMetadata;

    private AuthConfig(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.authenticationMetadata = builder.authenticationMetadata;
    }

    /**
     * <p>
     * The type of authentication method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link ConnectionAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication method.
     * @see ConnectionAuthType
     */
    public final ConnectionAuthType authenticationType() {
        return ConnectionAuthType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The type of authentication method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link ConnectionAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication method.
     * @see ConnectionAuthType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The authentication metadata containing the specific configuration for the chosen authentication type.
     * </p>
     * 
     * @return The authentication metadata containing the specific configuration for the chosen authentication type.
     */
    public final AuthenticationMetadata authenticationMetadata() {
        return authenticationMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthConfig)) {
            return false;
        }
        AuthConfig other = (AuthConfig) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(authenticationMetadata(), other.authenticationMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthConfig").add("AuthenticationType", authenticationTypeAsString())
                .add("AuthenticationMetadata", authenticationMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "AuthenticationMetadata":
            return Optional.ofNullable(clazz.cast(authenticationMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("AuthenticationMetadata", AUTHENTICATION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthConfig, T> g) {
        return obj -> g.apply((AuthConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthConfig> {
        /**
         * <p>
         * The type of authentication method.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication method.
         * @see ConnectionAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionAuthType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The type of authentication method.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication method.
         * @see ConnectionAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionAuthType
         */
        Builder authenticationType(ConnectionAuthType authenticationType);

        /**
         * <p>
         * The authentication metadata containing the specific configuration for the chosen authentication type.
         * </p>
         * 
         * @param authenticationMetadata
         *        The authentication metadata containing the specific configuration for the chosen authentication type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationMetadata(AuthenticationMetadata authenticationMetadata);

        /**
         * <p>
         * The authentication metadata containing the specific configuration for the chosen authentication type.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationMetadata.Builder} avoiding
         * the need to create one manually via {@link AuthenticationMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #authenticationMetadata(AuthenticationMetadata)}.
         * 
         * @param authenticationMetadata
         *        a consumer that will call methods on {@link AuthenticationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationMetadata(AuthenticationMetadata)
         */
        default Builder authenticationMetadata(Consumer<AuthenticationMetadata.Builder> authenticationMetadata) {
            return authenticationMetadata(AuthenticationMetadata.builder().applyMutation(authenticationMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private AuthenticationMetadata authenticationMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthConfig model) {
            authenticationType(model.authenticationType);
            authenticationMetadata(model.authenticationMetadata);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(ConnectionAuthType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final AuthenticationMetadata.Builder getAuthenticationMetadata() {
            return authenticationMetadata != null ? authenticationMetadata.toBuilder() : null;
        }

        public final void setAuthenticationMetadata(AuthenticationMetadata.BuilderImpl authenticationMetadata) {
            this.authenticationMetadata = authenticationMetadata != null ? authenticationMetadata.build() : null;
        }

        @Override
        public final Builder authenticationMetadata(AuthenticationMetadata authenticationMetadata) {
            this.authenticationMetadata = authenticationMetadata;
            return this;
        }

        @Override
        public AuthConfig build() {
            return new AuthConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
