/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tick label options of an axis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AxisTickLabelOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<AxisTickLabelOptions.Builder, AxisTickLabelOptions> {
    private static final SdkField<LabelOptions> LABEL_OPTIONS_FIELD = SdkField.<LabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("LabelOptions").getter(getter(AxisTickLabelOptions::labelOptions)).setter(setter(Builder::labelOptions))
            .constructor(LabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelOptions").build()).build();

    private static final SdkField<Double> ROTATION_ANGLE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("RotationAngle").getter(getter(AxisTickLabelOptions::rotationAngle))
            .setter(setter(Builder::rotationAngle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationAngle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_OPTIONS_FIELD,
            ROTATION_ANGLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LabelOptions labelOptions;

    private final Double rotationAngle;

    private AxisTickLabelOptions(BuilderImpl builder) {
        this.labelOptions = builder.labelOptions;
        this.rotationAngle = builder.rotationAngle;
    }

    /**
     * <p>
     * Determines whether or not the axis ticks are visible.
     * </p>
     * 
     * @return Determines whether or not the axis ticks are visible.
     */
    public final LabelOptions labelOptions() {
        return labelOptions;
    }

    /**
     * <p>
     * The rotation angle of the axis tick labels.
     * </p>
     * 
     * @return The rotation angle of the axis tick labels.
     */
    public final Double rotationAngle() {
        return rotationAngle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(rotationAngle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisTickLabelOptions)) {
            return false;
        }
        AxisTickLabelOptions other = (AxisTickLabelOptions) obj;
        return Objects.equals(labelOptions(), other.labelOptions()) && Objects.equals(rotationAngle(), other.rotationAngle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AxisTickLabelOptions").add("LabelOptions", labelOptions()).add("RotationAngle", rotationAngle())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelOptions":
            return Optional.ofNullable(clazz.cast(labelOptions()));
        case "RotationAngle":
            return Optional.ofNullable(clazz.cast(rotationAngle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabelOptions", LABEL_OPTIONS_FIELD);
        map.put("RotationAngle", ROTATION_ANGLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AxisTickLabelOptions, T> g) {
        return obj -> g.apply((AxisTickLabelOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AxisTickLabelOptions> {
        /**
         * <p>
         * Determines whether or not the axis ticks are visible.
         * </p>
         * 
         * @param labelOptions
         *        Determines whether or not the axis ticks are visible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelOptions(LabelOptions labelOptions);

        /**
         * <p>
         * Determines whether or not the axis ticks are visible.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelOptions.Builder} avoiding the need
         * to create one manually via {@link LabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #labelOptions(LabelOptions)}.
         * 
         * @param labelOptions
         *        a consumer that will call methods on {@link LabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelOptions(LabelOptions)
         */
        default Builder labelOptions(Consumer<LabelOptions.Builder> labelOptions) {
            return labelOptions(LabelOptions.builder().applyMutation(labelOptions).build());
        }

        /**
         * <p>
         * The rotation angle of the axis tick labels.
         * </p>
         * 
         * @param rotationAngle
         *        The rotation angle of the axis tick labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationAngle(Double rotationAngle);
    }

    static final class BuilderImpl implements Builder {
        private LabelOptions labelOptions;

        private Double rotationAngle;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisTickLabelOptions model) {
            labelOptions(model.labelOptions);
            rotationAngle(model.rotationAngle);
        }

        public final LabelOptions.Builder getLabelOptions() {
            return labelOptions != null ? labelOptions.toBuilder() : null;
        }

        public final void setLabelOptions(LabelOptions.BuilderImpl labelOptions) {
            this.labelOptions = labelOptions != null ? labelOptions.build() : null;
        }

        @Override
        public final Builder labelOptions(LabelOptions labelOptions) {
            this.labelOptions = labelOptions;
            return this;
        }

        public final Double getRotationAngle() {
            return rotationAngle;
        }

        public final void setRotationAngle(Double rotationAngle) {
            this.rotationAngle = rotationAngle;
        }

        @Override
        public final Builder rotationAngle(Double rotationAngle) {
            this.rotationAngle = rotationAngle;
            return this;
        }

        @Override
        public AxisTickLabelOptions build() {
            return new AxisTickLabelOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
