/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The color palette.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrandColorPalette implements SdkPojo, Serializable,
        ToCopyableBuilder<BrandColorPalette.Builder, BrandColorPalette> {
    private static final SdkField<Palette> PRIMARY_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Primary").getter(getter(BrandColorPalette::primary)).setter(setter(Builder::primary))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final SdkField<Palette> SECONDARY_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Secondary").getter(getter(BrandColorPalette::secondary)).setter(setter(Builder::secondary))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Secondary").build()).build();

    private static final SdkField<Palette> ACCENT_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Accent").getter(getter(BrandColorPalette::accent)).setter(setter(Builder::accent))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accent").build()).build();

    private static final SdkField<Palette> MEASURE_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Measure").getter(getter(BrandColorPalette::measure)).setter(setter(Builder::measure))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Measure").build()).build();

    private static final SdkField<Palette> DIMENSION_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Dimension").getter(getter(BrandColorPalette::dimension)).setter(setter(Builder::dimension))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()).build();

    private static final SdkField<Palette> SUCCESS_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Success").getter(getter(BrandColorPalette::success)).setter(setter(Builder::success))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Success").build()).build();

    private static final SdkField<Palette> INFO_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO).memberName("Info")
            .getter(getter(BrandColorPalette::info)).setter(setter(Builder::info)).constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Info").build()).build();

    private static final SdkField<Palette> WARNING_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Warning").getter(getter(BrandColorPalette::warning)).setter(setter(Builder::warning))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()).build();

    private static final SdkField<Palette> DANGER_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Danger").getter(getter(BrandColorPalette::danger)).setter(setter(Builder::danger))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Danger").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRIMARY_FIELD, SECONDARY_FIELD, ACCENT_FIELD, MEASURE_FIELD, DIMENSION_FIELD, SUCCESS_FIELD, INFO_FIELD,
                    WARNING_FIELD, DANGER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Palette primary;

    private final Palette secondary;

    private final Palette accent;

    private final Palette measure;

    private final Palette dimension;

    private final Palette success;

    private final Palette info;

    private final Palette warning;

    private final Palette danger;

    private BrandColorPalette(BuilderImpl builder) {
        this.primary = builder.primary;
        this.secondary = builder.secondary;
        this.accent = builder.accent;
        this.measure = builder.measure;
        this.dimension = builder.dimension;
        this.success = builder.success;
        this.info = builder.info;
        this.warning = builder.warning;
        this.danger = builder.danger;
    }

    /**
     * <p>
     * The primary color.
     * </p>
     * 
     * @return The primary color.
     */
    public final Palette primary() {
        return primary;
    }

    /**
     * <p>
     * The secondary color.
     * </p>
     * 
     * @return The secondary color.
     */
    public final Palette secondary() {
        return secondary;
    }

    /**
     * <p>
     * The color that is used for accent elements.
     * </p>
     * 
     * @return The color that is used for accent elements.
     */
    public final Palette accent() {
        return accent;
    }

    /**
     * <p>
     * The color that is used for measure elements.
     * </p>
     * 
     * @return The color that is used for measure elements.
     */
    public final Palette measure() {
        return measure;
    }

    /**
     * <p>
     * The color that is used for dimension elements.
     * </p>
     * 
     * @return The color that is used for dimension elements.
     */
    public final Palette dimension() {
        return dimension;
    }

    /**
     * <p>
     * The color that is used for success elements.
     * </p>
     * 
     * @return The color that is used for success elements.
     */
    public final Palette success() {
        return success;
    }

    /**
     * <p>
     * The color that is used for info elements.
     * </p>
     * 
     * @return The color that is used for info elements.
     */
    public final Palette info() {
        return info;
    }

    /**
     * <p>
     * The color that is used for warning elements.
     * </p>
     * 
     * @return The color that is used for warning elements.
     */
    public final Palette warning() {
        return warning;
    }

    /**
     * <p>
     * The color that is used for danger elements.
     * </p>
     * 
     * @return The color that is used for danger elements.
     */
    public final Palette danger() {
        return danger;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(secondary());
        hashCode = 31 * hashCode + Objects.hashCode(accent());
        hashCode = 31 * hashCode + Objects.hashCode(measure());
        hashCode = 31 * hashCode + Objects.hashCode(dimension());
        hashCode = 31 * hashCode + Objects.hashCode(success());
        hashCode = 31 * hashCode + Objects.hashCode(info());
        hashCode = 31 * hashCode + Objects.hashCode(warning());
        hashCode = 31 * hashCode + Objects.hashCode(danger());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandColorPalette)) {
            return false;
        }
        BrandColorPalette other = (BrandColorPalette) obj;
        return Objects.equals(primary(), other.primary()) && Objects.equals(secondary(), other.secondary())
                && Objects.equals(accent(), other.accent()) && Objects.equals(measure(), other.measure())
                && Objects.equals(dimension(), other.dimension()) && Objects.equals(success(), other.success())
                && Objects.equals(info(), other.info()) && Objects.equals(warning(), other.warning())
                && Objects.equals(danger(), other.danger());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrandColorPalette").add("Primary", primary()).add("Secondary", secondary())
                .add("Accent", accent()).add("Measure", measure()).add("Dimension", dimension()).add("Success", success())
                .add("Info", info()).add("Warning", warning()).add("Danger", danger()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "Secondary":
            return Optional.ofNullable(clazz.cast(secondary()));
        case "Accent":
            return Optional.ofNullable(clazz.cast(accent()));
        case "Measure":
            return Optional.ofNullable(clazz.cast(measure()));
        case "Dimension":
            return Optional.ofNullable(clazz.cast(dimension()));
        case "Success":
            return Optional.ofNullable(clazz.cast(success()));
        case "Info":
            return Optional.ofNullable(clazz.cast(info()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        case "Danger":
            return Optional.ofNullable(clazz.cast(danger()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Primary", PRIMARY_FIELD);
        map.put("Secondary", SECONDARY_FIELD);
        map.put("Accent", ACCENT_FIELD);
        map.put("Measure", MEASURE_FIELD);
        map.put("Dimension", DIMENSION_FIELD);
        map.put("Success", SUCCESS_FIELD);
        map.put("Info", INFO_FIELD);
        map.put("Warning", WARNING_FIELD);
        map.put("Danger", DANGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandColorPalette, T> g) {
        return obj -> g.apply((BrandColorPalette) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrandColorPalette> {
        /**
         * <p>
         * The primary color.
         * </p>
         * 
         * @param primary
         *        The primary color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Palette primary);

        /**
         * <p>
         * The primary color.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #primary(Palette)}.
         * 
         * @param primary
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primary(Palette)
         */
        default Builder primary(Consumer<Palette.Builder> primary) {
            return primary(Palette.builder().applyMutation(primary).build());
        }

        /**
         * <p>
         * The secondary color.
         * </p>
         * 
         * @param secondary
         *        The secondary color.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondary(Palette secondary);

        /**
         * <p>
         * The secondary color.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #secondary(Palette)}.
         * 
         * @param secondary
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondary(Palette)
         */
        default Builder secondary(Consumer<Palette.Builder> secondary) {
            return secondary(Palette.builder().applyMutation(secondary).build());
        }

        /**
         * <p>
         * The color that is used for accent elements.
         * </p>
         * 
         * @param accent
         *        The color that is used for accent elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accent(Palette accent);

        /**
         * <p>
         * The color that is used for accent elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #accent(Palette)}.
         * 
         * @param accent
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accent(Palette)
         */
        default Builder accent(Consumer<Palette.Builder> accent) {
            return accent(Palette.builder().applyMutation(accent).build());
        }

        /**
         * <p>
         * The color that is used for measure elements.
         * </p>
         * 
         * @param measure
         *        The color that is used for measure elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measure(Palette measure);

        /**
         * <p>
         * The color that is used for measure elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #measure(Palette)}.
         * 
         * @param measure
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #measure(Palette)
         */
        default Builder measure(Consumer<Palette.Builder> measure) {
            return measure(Palette.builder().applyMutation(measure).build());
        }

        /**
         * <p>
         * The color that is used for dimension elements.
         * </p>
         * 
         * @param dimension
         *        The color that is used for dimension elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimension(Palette dimension);

        /**
         * <p>
         * The color that is used for dimension elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #dimension(Palette)}.
         * 
         * @param dimension
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimension(Palette)
         */
        default Builder dimension(Consumer<Palette.Builder> dimension) {
            return dimension(Palette.builder().applyMutation(dimension).build());
        }

        /**
         * <p>
         * The color that is used for success elements.
         * </p>
         * 
         * @param success
         *        The color that is used for success elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder success(Palette success);

        /**
         * <p>
         * The color that is used for success elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #success(Palette)}.
         * 
         * @param success
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #success(Palette)
         */
        default Builder success(Consumer<Palette.Builder> success) {
            return success(Palette.builder().applyMutation(success).build());
        }

        /**
         * <p>
         * The color that is used for info elements.
         * </p>
         * 
         * @param info
         *        The color that is used for info elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(Palette info);

        /**
         * <p>
         * The color that is used for info elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #info(Palette)}.
         * 
         * @param info
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #info(Palette)
         */
        default Builder info(Consumer<Palette.Builder> info) {
            return info(Palette.builder().applyMutation(info).build());
        }

        /**
         * <p>
         * The color that is used for warning elements.
         * </p>
         * 
         * @param warning
         *        The color that is used for warning elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(Palette warning);

        /**
         * <p>
         * The color that is used for warning elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #warning(Palette)}.
         * 
         * @param warning
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warning(Palette)
         */
        default Builder warning(Consumer<Palette.Builder> warning) {
            return warning(Palette.builder().applyMutation(warning).build());
        }

        /**
         * <p>
         * The color that is used for danger elements.
         * </p>
         * 
         * @param danger
         *        The color that is used for danger elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder danger(Palette danger);

        /**
         * <p>
         * The color that is used for danger elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #danger(Palette)}.
         * 
         * @param danger
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #danger(Palette)
         */
        default Builder danger(Consumer<Palette.Builder> danger) {
            return danger(Palette.builder().applyMutation(danger).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Palette primary;

        private Palette secondary;

        private Palette accent;

        private Palette measure;

        private Palette dimension;

        private Palette success;

        private Palette info;

        private Palette warning;

        private Palette danger;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandColorPalette model) {
            primary(model.primary);
            secondary(model.secondary);
            accent(model.accent);
            measure(model.measure);
            dimension(model.dimension);
            success(model.success);
            info(model.info);
            warning(model.warning);
            danger(model.danger);
        }

        public final Palette.Builder getPrimary() {
            return primary != null ? primary.toBuilder() : null;
        }

        public final void setPrimary(Palette.BuilderImpl primary) {
            this.primary = primary != null ? primary.build() : null;
        }

        @Override
        public final Builder primary(Palette primary) {
            this.primary = primary;
            return this;
        }

        public final Palette.Builder getSecondary() {
            return secondary != null ? secondary.toBuilder() : null;
        }

        public final void setSecondary(Palette.BuilderImpl secondary) {
            this.secondary = secondary != null ? secondary.build() : null;
        }

        @Override
        public final Builder secondary(Palette secondary) {
            this.secondary = secondary;
            return this;
        }

        public final Palette.Builder getAccent() {
            return accent != null ? accent.toBuilder() : null;
        }

        public final void setAccent(Palette.BuilderImpl accent) {
            this.accent = accent != null ? accent.build() : null;
        }

        @Override
        public final Builder accent(Palette accent) {
            this.accent = accent;
            return this;
        }

        public final Palette.Builder getMeasure() {
            return measure != null ? measure.toBuilder() : null;
        }

        public final void setMeasure(Palette.BuilderImpl measure) {
            this.measure = measure != null ? measure.build() : null;
        }

        @Override
        public final Builder measure(Palette measure) {
            this.measure = measure;
            return this;
        }

        public final Palette.Builder getDimension() {
            return dimension != null ? dimension.toBuilder() : null;
        }

        public final void setDimension(Palette.BuilderImpl dimension) {
            this.dimension = dimension != null ? dimension.build() : null;
        }

        @Override
        public final Builder dimension(Palette dimension) {
            this.dimension = dimension;
            return this;
        }

        public final Palette.Builder getSuccess() {
            return success != null ? success.toBuilder() : null;
        }

        public final void setSuccess(Palette.BuilderImpl success) {
            this.success = success != null ? success.build() : null;
        }

        @Override
        public final Builder success(Palette success) {
            this.success = success;
            return this;
        }

        public final Palette.Builder getInfo() {
            return info != null ? info.toBuilder() : null;
        }

        public final void setInfo(Palette.BuilderImpl info) {
            this.info = info != null ? info.build() : null;
        }

        @Override
        public final Builder info(Palette info) {
            this.info = info;
            return this;
        }

        public final Palette.Builder getWarning() {
            return warning != null ? warning.toBuilder() : null;
        }

        public final void setWarning(Palette.BuilderImpl warning) {
            this.warning = warning != null ? warning.build() : null;
        }

        @Override
        public final Builder warning(Palette warning) {
            this.warning = warning;
            return this;
        }

        public final Palette.Builder getDanger() {
            return danger != null ? danger.toBuilder() : null;
        }

        public final void setDanger(Palette.BuilderImpl danger) {
            this.danger = danger != null ? danger.build() : null;
        }

        @Override
        public final Builder danger(Palette danger) {
            this.danger = danger;
            return this;
        }

        @Override
        public BrandColorPalette build() {
            return new BrandColorPalette(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
