/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the brand.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrandDetail implements SdkPojo, Serializable, ToCopyableBuilder<BrandDetail.Builder, BrandDetail> {
    private static final SdkField<String> BRAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandId").getter(getter(BrandDetail::brandId)).setter(setter(Builder::brandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(BrandDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> BRAND_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrandStatus").getter(getter(BrandDetail::brandStatusAsString)).setter(setter(Builder::brandStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(BrandDetail::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(BrandDetail::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(BrandDetail::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionStatus").getter(getter(BrandDetail::versionStatusAsString))
            .setter(setter(Builder::versionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionStatus").build()).build();

    private static final SdkField<List<String>> ERRORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BrandDetail::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Logo> LOGO_FIELD = SdkField.<Logo> builder(MarshallingType.SDK_POJO).memberName("Logo")
            .getter(getter(BrandDetail::logo)).setter(setter(Builder::logo)).constructor(Logo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAND_ID_FIELD, ARN_FIELD,
            BRAND_STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, VERSION_ID_FIELD, VERSION_STATUS_FIELD,
            ERRORS_FIELD, LOGO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String brandId;

    private final String arn;

    private final String brandStatus;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String versionId;

    private final String versionStatus;

    private final List<String> errors;

    private final Logo logo;

    private BrandDetail(BuilderImpl builder) {
        this.brandId = builder.brandId;
        this.arn = builder.arn;
        this.brandStatus = builder.brandStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.versionId = builder.versionId;
        this.versionStatus = builder.versionStatus;
        this.errors = builder.errors;
        this.logo = builder.logo;
    }

    /**
     * <p>
     * The ID of the Quick Suite brand.
     * </p>
     * 
     * @return The ID of the Quick Suite brand.
     */
    public final String brandId() {
        return brandId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the brand.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the brand.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the brand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brandStatus} will
     * return {@link BrandStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brandStatusAsString}.
     * </p>
     * 
     * @return The status of the brand.
     * @see BrandStatus
     */
    public final BrandStatus brandStatus() {
        return BrandStatus.fromValue(brandStatus);
    }

    /**
     * <p>
     * The status of the brand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brandStatus} will
     * return {@link BrandStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brandStatusAsString}.
     * </p>
     * 
     * @return The status of the brand.
     * @see BrandStatus
     */
    public final String brandStatusAsString() {
        return brandStatus;
    }

    /**
     * <p>
     * The time that the brand was created.
     * </p>
     * 
     * @return The time that the brand was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The last time the brand was updated.
     * </p>
     * 
     * @return The last time the brand was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The ID of the version.
     * </p>
     * 
     * @return The ID of the version.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The status of the version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionStatus}
     * will return {@link BrandVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #versionStatusAsString}.
     * </p>
     * 
     * @return The status of the version.
     * @see BrandVersionStatus
     */
    public final BrandVersionStatus versionStatus() {
        return BrandVersionStatus.fromValue(versionStatus);
    }

    /**
     * <p>
     * The status of the version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #versionStatus}
     * will return {@link BrandVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #versionStatusAsString}.
     * </p>
     * 
     * @return The status of the version.
     * @see BrandVersionStatus
     */
    public final String versionStatusAsString() {
        return versionStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors that occurred during the most recent brand operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors that occurred during the most recent brand operation.
     */
    public final List<String> errors() {
        return errors;
    }

    /**
     * <p>
     * The logo details.
     * </p>
     * 
     * @return The logo details.
     */
    public final Logo logo() {
        return logo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(brandId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(brandStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(versionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandDetail)) {
            return false;
        }
        BrandDetail other = (BrandDetail) obj;
        return Objects.equals(brandId(), other.brandId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(brandStatusAsString(), other.brandStatusAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(versionStatusAsString(), other.versionStatusAsString()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && Objects.equals(logo(), other.logo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrandDetail").add("BrandId", brandId()).add("Arn", arn())
                .add("BrandStatus", brandStatusAsString()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("VersionId", versionId())
                .add("VersionStatus", versionStatusAsString()).add("Errors", hasErrors() ? errors() : null).add("Logo", logo())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrandId":
            return Optional.ofNullable(clazz.cast(brandId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "BrandStatus":
            return Optional.ofNullable(clazz.cast(brandStatusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "VersionStatus":
            return Optional.ofNullable(clazz.cast(versionStatusAsString()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Logo":
            return Optional.ofNullable(clazz.cast(logo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BrandId", BRAND_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("BrandStatus", BRAND_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("VersionStatus", VERSION_STATUS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("Logo", LOGO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandDetail, T> g) {
        return obj -> g.apply((BrandDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrandDetail> {
        /**
         * <p>
         * The ID of the Quick Suite brand.
         * </p>
         * 
         * @param brandId
         *        The ID of the Quick Suite brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brandId(String brandId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the brand.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the brand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the brand.
         * </p>
         * 
         * @param brandStatus
         *        The status of the brand.
         * @see BrandStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrandStatus
         */
        Builder brandStatus(String brandStatus);

        /**
         * <p>
         * The status of the brand.
         * </p>
         * 
         * @param brandStatus
         *        The status of the brand.
         * @see BrandStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrandStatus
         */
        Builder brandStatus(BrandStatus brandStatus);

        /**
         * <p>
         * The time that the brand was created.
         * </p>
         * 
         * @param createdTime
         *        The time that the brand was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The last time the brand was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time the brand was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The ID of the version.
         * </p>
         * 
         * @param versionId
         *        The ID of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The status of the version.
         * </p>
         * 
         * @param versionStatus
         *        The status of the version.
         * @see BrandVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrandVersionStatus
         */
        Builder versionStatus(String versionStatus);

        /**
         * <p>
         * The status of the version.
         * </p>
         * 
         * @param versionStatus
         *        The status of the version.
         * @see BrandVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrandVersionStatus
         */
        Builder versionStatus(BrandVersionStatus versionStatus);

        /**
         * <p>
         * A list of errors that occurred during the most recent brand operation.
         * </p>
         * 
         * @param errors
         *        A list of errors that occurred during the most recent brand operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<String> errors);

        /**
         * <p>
         * A list of errors that occurred during the most recent brand operation.
         * </p>
         * 
         * @param errors
         *        A list of errors that occurred during the most recent brand operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(String... errors);

        /**
         * <p>
         * The logo details.
         * </p>
         * 
         * @param logo
         *        The logo details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logo(Logo logo);

        /**
         * <p>
         * The logo details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Logo.Builder} avoiding the need to create
         * one manually via {@link Logo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Logo.Builder#build()} is called immediately and its result is
         * passed to {@link #logo(Logo)}.
         * 
         * @param logo
         *        a consumer that will call methods on {@link Logo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logo(Logo)
         */
        default Builder logo(Consumer<Logo.Builder> logo) {
            return logo(Logo.builder().applyMutation(logo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String brandId;

        private String arn;

        private String brandStatus;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String versionId;

        private String versionStatus;

        private List<String> errors = DefaultSdkAutoConstructList.getInstance();

        private Logo logo;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandDetail model) {
            brandId(model.brandId);
            arn(model.arn);
            brandStatus(model.brandStatus);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            versionId(model.versionId);
            versionStatus(model.versionStatus);
            errors(model.errors);
            logo(model.logo);
        }

        public final String getBrandId() {
            return brandId;
        }

        public final void setBrandId(String brandId) {
            this.brandId = brandId;
        }

        @Override
        public final Builder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBrandStatus() {
            return brandStatus;
        }

        public final void setBrandStatus(String brandStatus) {
            this.brandStatus = brandStatus;
        }

        @Override
        public final Builder brandStatus(String brandStatus) {
            this.brandStatus = brandStatus;
            return this;
        }

        @Override
        public final Builder brandStatus(BrandStatus brandStatus) {
            this.brandStatus(brandStatus == null ? null : brandStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getVersionStatus() {
            return versionStatus;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(BrandVersionStatus versionStatus) {
            this.versionStatus(versionStatus == null ? null : versionStatus.toString());
            return this;
        }

        public final Collection<String> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors;
        }

        public final void setErrors(Collection<String> errors) {
            this.errors = ErrorListCopier.copy(errors);
        }

        @Override
        public final Builder errors(Collection<String> errors) {
            this.errors = ErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(String... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        public final Logo.Builder getLogo() {
            return logo != null ? logo.toBuilder() : null;
        }

        public final void setLogo(Logo.BuilderImpl logo) {
            this.logo = logo != null ? logo.build() : null;
        }

        @Override
        public final Builder logo(Logo logo) {
            this.logo = logo;
            return this;
        }

        @Override
        public BrandDetail build() {
            return new BrandDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
