/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of actions that correspond to Amazon Quick Sight permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Capabilities implements SdkPojo, Serializable, ToCopyableBuilder<Capabilities.Builder, Capabilities> {
    private static final SdkField<String> EXPORT_TO_CSV_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportToCsv").getter(getter(Capabilities::exportToCsvAsString)).setter(setter(Builder::exportToCsv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCsv").build()).build();

    private static final SdkField<String> EXPORT_TO_EXCEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportToExcel").getter(getter(Capabilities::exportToExcelAsString))
            .setter(setter(Builder::exportToExcel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToExcel").build()).build();

    private static final SdkField<String> EXPORT_TO_PDF_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportToPdf").getter(getter(Capabilities::exportToPdfAsString)).setter(setter(Builder::exportToPdf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToPdf").build()).build();

    private static final SdkField<String> PRINT_REPORTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrintReports").getter(getter(Capabilities::printReportsAsString)).setter(setter(Builder::printReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrintReports").build()).build();

    private static final SdkField<String> CREATE_AND_UPDATE_THEMES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateAndUpdateThemes").getter(getter(Capabilities::createAndUpdateThemesAsString))
            .setter(setter(Builder::createAndUpdateThemes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateThemes").build())
            .build();

    private static final SdkField<String> ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AddOrRunAnomalyDetectionForAnalyses")
            .getter(getter(Capabilities::addOrRunAnomalyDetectionForAnalysesAsString))
            .setter(setter(Builder::addOrRunAnomalyDetectionForAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AddOrRunAnomalyDetectionForAnalyses").build()).build();

    private static final SdkField<String> SHARE_ANALYSES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareAnalyses").getter(getter(Capabilities::shareAnalysesAsString))
            .setter(setter(Builder::shareAnalyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareAnalyses").build()).build();

    private static final SdkField<String> CREATE_AND_UPDATE_DATASETS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateAndUpdateDatasets").getter(getter(Capabilities::createAndUpdateDatasetsAsString))
            .setter(setter(Builder::createAndUpdateDatasets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateDatasets").build())
            .build();

    private static final SdkField<String> SHARE_DATASETS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareDatasets").getter(getter(Capabilities::shareDatasetsAsString))
            .setter(setter(Builder::shareDatasets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDatasets").build()).build();

    private static final SdkField<String> SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SubscribeDashboardEmailReports")
            .getter(getter(Capabilities::subscribeDashboardEmailReportsAsString))
            .setter(setter(Builder::subscribeDashboardEmailReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribeDashboardEmailReports")
                    .build()).build();

    private static final SdkField<String> CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreateAndUpdateDashboardEmailReports")
            .getter(getter(Capabilities::createAndUpdateDashboardEmailReportsAsString))
            .setter(setter(Builder::createAndUpdateDashboardEmailReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CreateAndUpdateDashboardEmailReports").build()).build();

    private static final SdkField<String> SHARE_DASHBOARDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareDashboards").getter(getter(Capabilities::shareDashboardsAsString))
            .setter(setter(Builder::shareDashboards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDashboards").build()).build();

    private static final SdkField<String> CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreateAndUpdateThresholdAlerts")
            .getter(getter(Capabilities::createAndUpdateThresholdAlertsAsString))
            .setter(setter(Builder::createAndUpdateThresholdAlerts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateThresholdAlerts")
                    .build()).build();

    private static final SdkField<String> RENAME_SHARED_FOLDERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenameSharedFolders").getter(getter(Capabilities::renameSharedFoldersAsString))
            .setter(setter(Builder::renameSharedFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameSharedFolders").build())
            .build();

    private static final SdkField<String> CREATE_SHARED_FOLDERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateSharedFolders").getter(getter(Capabilities::createSharedFoldersAsString))
            .setter(setter(Builder::createSharedFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSharedFolders").build())
            .build();

    private static final SdkField<String> CREATE_AND_UPDATE_DATA_SOURCES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreateAndUpdateDataSources")
            .getter(getter(Capabilities::createAndUpdateDataSourcesAsString))
            .setter(setter(Builder::createAndUpdateDataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateAndUpdateDataSources").build())
            .build();

    private static final SdkField<String> SHARE_DATA_SOURCES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareDataSources").getter(getter(Capabilities::shareDataSourcesAsString))
            .setter(setter(Builder::shareDataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareDataSources").build()).build();

    private static final SdkField<String> VIEW_ACCOUNT_SPICE_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewAccountSPICECapacity").getter(getter(Capabilities::viewAccountSPICECapacityAsString))
            .setter(setter(Builder::viewAccountSPICECapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewAccountSPICECapacity").build())
            .build();

    private static final SdkField<String> CREATE_SPICE_DATASET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateSPICEDataset").getter(getter(Capabilities::createSPICEDatasetAsString))
            .setter(setter(Builder::createSPICEDataset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSPICEDataset").build())
            .build();

    private static final SdkField<String> EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExportToPdfInScheduledReports")
            .getter(getter(Capabilities::exportToPdfInScheduledReportsAsString))
            .setter(setter(Builder::exportToPdfInScheduledReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToPdfInScheduledReports")
                    .build()).build();

    private static final SdkField<String> EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExportToCsvInScheduledReports")
            .getter(getter(Capabilities::exportToCsvInScheduledReportsAsString))
            .setter(setter(Builder::exportToCsvInScheduledReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCsvInScheduledReports")
                    .build()).build();

    private static final SdkField<String> EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExportToExcelInScheduledReports")
            .getter(getter(Capabilities::exportToExcelInScheduledReportsAsString))
            .setter(setter(Builder::exportToExcelInScheduledReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToExcelInScheduledReports")
                    .build()).build();

    private static final SdkField<String> INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IncludeContentInScheduledReportsEmail")
            .getter(getter(Capabilities::includeContentInScheduledReportsEmailAsString))
            .setter(setter(Builder::includeContentInScheduledReportsEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("IncludeContentInScheduledReportsEmail").build()).build();

    private static final SdkField<String> DASHBOARD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Dashboard").getter(getter(Capabilities::dashboardAsString)).setter(setter(Builder::dashboard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboard").build()).build();

    private static final SdkField<String> ANALYSIS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Analysis").getter(getter(Capabilities::analysisAsString)).setter(setter(Builder::analysis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()).build();

    private static final SdkField<String> AUTOMATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Automate").getter(getter(Capabilities::automateAsString)).setter(setter(Builder::automate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automate").build()).build();

    private static final SdkField<String> FLOW_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Flow")
            .getter(getter(Capabilities::flowAsString)).setter(setter(Builder::flow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flow").build()).build();

    private static final SdkField<String> PUBLISH_WITHOUT_APPROVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishWithoutApproval").getter(getter(Capabilities::publishWithoutApprovalAsString))
            .setter(setter(Builder::publishWithoutApproval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishWithoutApproval").build())
            .build();

    private static final SdkField<String> USE_BEDROCK_MODELS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseBedrockModels").getter(getter(Capabilities::useBedrockModelsAsString))
            .setter(setter(Builder::useBedrockModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBedrockModels").build()).build();

    private static final SdkField<String> PERFORM_FLOW_UI_TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PerformFlowUiTask").getter(getter(Capabilities::performFlowUiTaskAsString))
            .setter(setter(Builder::performFlowUiTask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformFlowUiTask").build()).build();

    private static final SdkField<String> USE_AGENT_WEB_SEARCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseAgentWebSearch").getter(getter(Capabilities::useAgentWebSearchAsString))
            .setter(setter(Builder::useAgentWebSearch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseAgentWebSearch").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KnowledgeBase").getter(getter(Capabilities::knowledgeBaseAsString))
            .setter(setter(Builder::knowledgeBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnowledgeBase").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(Capabilities::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> SPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Space")
            .getter(getter(Capabilities::spaceAsString)).setter(setter(Builder::space))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Space").build()).build();

    private static final SdkField<String> CHAT_AGENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChatAgent").getter(getter(Capabilities::chatAgentAsString)).setter(setter(Builder::chatAgent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatAgent").build()).build();

    private static final SdkField<String> CREATE_CHAT_AGENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateChatAgents").getter(getter(Capabilities::createChatAgentsAsString))
            .setter(setter(Builder::createChatAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateChatAgents").build()).build();

    private static final SdkField<String> RESEARCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Research").getter(getter(Capabilities::researchAsString)).setter(setter(Builder::research))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Research").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TO_CSV_FIELD,
            EXPORT_TO_EXCEL_FIELD, EXPORT_TO_PDF_FIELD, PRINT_REPORTS_FIELD, CREATE_AND_UPDATE_THEMES_FIELD,
            ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD, SHARE_ANALYSES_FIELD, CREATE_AND_UPDATE_DATASETS_FIELD,
            SHARE_DATASETS_FIELD, SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD, CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD,
            SHARE_DASHBOARDS_FIELD, CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD, RENAME_SHARED_FOLDERS_FIELD,
            CREATE_SHARED_FOLDERS_FIELD, CREATE_AND_UPDATE_DATA_SOURCES_FIELD, SHARE_DATA_SOURCES_FIELD,
            VIEW_ACCOUNT_SPICE_CAPACITY_FIELD, CREATE_SPICE_DATASET_FIELD, EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD,
            EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD, EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD,
            INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD, DASHBOARD_FIELD, ANALYSIS_FIELD, AUTOMATE_FIELD, FLOW_FIELD,
            PUBLISH_WITHOUT_APPROVAL_FIELD, USE_BEDROCK_MODELS_FIELD, PERFORM_FLOW_UI_TASK_FIELD, USE_AGENT_WEB_SEARCH_FIELD,
            KNOWLEDGE_BASE_FIELD, ACTION_FIELD, SPACE_FIELD, CHAT_AGENT_FIELD, CREATE_CHAT_AGENTS_FIELD, RESEARCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String exportToCsv;

    private final String exportToExcel;

    private final String exportToPdf;

    private final String printReports;

    private final String createAndUpdateThemes;

    private final String addOrRunAnomalyDetectionForAnalyses;

    private final String shareAnalyses;

    private final String createAndUpdateDatasets;

    private final String shareDatasets;

    private final String subscribeDashboardEmailReports;

    private final String createAndUpdateDashboardEmailReports;

    private final String shareDashboards;

    private final String createAndUpdateThresholdAlerts;

    private final String renameSharedFolders;

    private final String createSharedFolders;

    private final String createAndUpdateDataSources;

    private final String shareDataSources;

    private final String viewAccountSPICECapacity;

    private final String createSPICEDataset;

    private final String exportToPdfInScheduledReports;

    private final String exportToCsvInScheduledReports;

    private final String exportToExcelInScheduledReports;

    private final String includeContentInScheduledReportsEmail;

    private final String dashboard;

    private final String analysis;

    private final String automate;

    private final String flow;

    private final String publishWithoutApproval;

    private final String useBedrockModels;

    private final String performFlowUiTask;

    private final String useAgentWebSearch;

    private final String knowledgeBase;

    private final String action;

    private final String space;

    private final String chatAgent;

    private final String createChatAgents;

    private final String research;

    private Capabilities(BuilderImpl builder) {
        this.exportToCsv = builder.exportToCsv;
        this.exportToExcel = builder.exportToExcel;
        this.exportToPdf = builder.exportToPdf;
        this.printReports = builder.printReports;
        this.createAndUpdateThemes = builder.createAndUpdateThemes;
        this.addOrRunAnomalyDetectionForAnalyses = builder.addOrRunAnomalyDetectionForAnalyses;
        this.shareAnalyses = builder.shareAnalyses;
        this.createAndUpdateDatasets = builder.createAndUpdateDatasets;
        this.shareDatasets = builder.shareDatasets;
        this.subscribeDashboardEmailReports = builder.subscribeDashboardEmailReports;
        this.createAndUpdateDashboardEmailReports = builder.createAndUpdateDashboardEmailReports;
        this.shareDashboards = builder.shareDashboards;
        this.createAndUpdateThresholdAlerts = builder.createAndUpdateThresholdAlerts;
        this.renameSharedFolders = builder.renameSharedFolders;
        this.createSharedFolders = builder.createSharedFolders;
        this.createAndUpdateDataSources = builder.createAndUpdateDataSources;
        this.shareDataSources = builder.shareDataSources;
        this.viewAccountSPICECapacity = builder.viewAccountSPICECapacity;
        this.createSPICEDataset = builder.createSPICEDataset;
        this.exportToPdfInScheduledReports = builder.exportToPdfInScheduledReports;
        this.exportToCsvInScheduledReports = builder.exportToCsvInScheduledReports;
        this.exportToExcelInScheduledReports = builder.exportToExcelInScheduledReports;
        this.includeContentInScheduledReportsEmail = builder.includeContentInScheduledReportsEmail;
        this.dashboard = builder.dashboard;
        this.analysis = builder.analysis;
        this.automate = builder.automate;
        this.flow = builder.flow;
        this.publishWithoutApproval = builder.publishWithoutApproval;
        this.useBedrockModels = builder.useBedrockModels;
        this.performFlowUiTask = builder.performFlowUiTask;
        this.useAgentWebSearch = builder.useAgentWebSearch;
        this.knowledgeBase = builder.knowledgeBase;
        this.action = builder.action;
        this.space = builder.space;
        this.chatAgent = builder.chatAgent;
        this.createChatAgents = builder.createChatAgents;
        this.research = builder.research;
    }

    /**
     * <p>
     * The ability to export to CSV files from the UI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportToCsv} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportToCsvAsString}.
     * </p>
     * 
     * @return The ability to export to CSV files from the UI.
     * @see CapabilityState
     */
    public final CapabilityState exportToCsv() {
        return CapabilityState.fromValue(exportToCsv);
    }

    /**
     * <p>
     * The ability to export to CSV files from the UI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportToCsv} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportToCsvAsString}.
     * </p>
     * 
     * @return The ability to export to CSV files from the UI.
     * @see CapabilityState
     */
    public final String exportToCsvAsString() {
        return exportToCsv;
    }

    /**
     * <p>
     * The ability to export to Excel files from the UI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportToExcel}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportToExcelAsString}.
     * </p>
     * 
     * @return The ability to export to Excel files from the UI.
     * @see CapabilityState
     */
    public final CapabilityState exportToExcel() {
        return CapabilityState.fromValue(exportToExcel);
    }

    /**
     * <p>
     * The ability to export to Excel files from the UI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportToExcel}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exportToExcelAsString}.
     * </p>
     * 
     * @return The ability to export to Excel files from the UI.
     * @see CapabilityState
     */
    public final String exportToExcelAsString() {
        return exportToExcel;
    }

    /**
     * <p>
     * The ability to export to PDF files from the UI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportToPdf} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportToPdfAsString}.
     * </p>
     * 
     * @return The ability to export to PDF files from the UI.
     * @see CapabilityState
     */
    public final CapabilityState exportToPdf() {
        return CapabilityState.fromValue(exportToPdf);
    }

    /**
     * <p>
     * The ability to export to PDF files from the UI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportToPdf} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exportToPdfAsString}.
     * </p>
     * 
     * @return The ability to export to PDF files from the UI.
     * @see CapabilityState
     */
    public final String exportToPdfAsString() {
        return exportToPdf;
    }

    /**
     * <p>
     * The ability to print reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #printReports} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #printReportsAsString}.
     * </p>
     * 
     * @return The ability to print reports.
     * @see CapabilityState
     */
    public final CapabilityState printReports() {
        return CapabilityState.fromValue(printReports);
    }

    /**
     * <p>
     * The ability to print reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #printReports} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #printReportsAsString}.
     * </p>
     * 
     * @return The ability to print reports.
     * @see CapabilityState
     */
    public final String printReportsAsString() {
        return printReports;
    }

    /**
     * <p>
     * The ability to export to Create and Update themes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateThemes} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #createAndUpdateThemesAsString}.
     * </p>
     * 
     * @return The ability to export to Create and Update themes.
     * @see CapabilityState
     */
    public final CapabilityState createAndUpdateThemes() {
        return CapabilityState.fromValue(createAndUpdateThemes);
    }

    /**
     * <p>
     * The ability to export to Create and Update themes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateThemes} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #createAndUpdateThemesAsString}.
     * </p>
     * 
     * @return The ability to export to Create and Update themes.
     * @see CapabilityState
     */
    public final String createAndUpdateThemesAsString() {
        return createAndUpdateThemes;
    }

    /**
     * <p>
     * The ability to add or run anomaly detection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #addOrRunAnomalyDetectionForAnalyses} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #addOrRunAnomalyDetectionForAnalysesAsString}.
     * </p>
     * 
     * @return The ability to add or run anomaly detection.
     * @see CapabilityState
     */
    public final CapabilityState addOrRunAnomalyDetectionForAnalyses() {
        return CapabilityState.fromValue(addOrRunAnomalyDetectionForAnalyses);
    }

    /**
     * <p>
     * The ability to add or run anomaly detection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #addOrRunAnomalyDetectionForAnalyses} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #addOrRunAnomalyDetectionForAnalysesAsString}.
     * </p>
     * 
     * @return The ability to add or run anomaly detection.
     * @see CapabilityState
     */
    public final String addOrRunAnomalyDetectionForAnalysesAsString() {
        return addOrRunAnomalyDetectionForAnalyses;
    }

    /**
     * <p>
     * The ability to share analyses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareAnalyses}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareAnalysesAsString}.
     * </p>
     * 
     * @return The ability to share analyses.
     * @see CapabilityState
     */
    public final CapabilityState shareAnalyses() {
        return CapabilityState.fromValue(shareAnalyses);
    }

    /**
     * <p>
     * The ability to share analyses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareAnalyses}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareAnalysesAsString}.
     * </p>
     * 
     * @return The ability to share analyses.
     * @see CapabilityState
     */
    public final String shareAnalysesAsString() {
        return shareAnalyses;
    }

    /**
     * <p>
     * The ability to create and update datasets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateDatasets} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #createAndUpdateDatasetsAsString}.
     * </p>
     * 
     * @return The ability to create and update datasets.
     * @see CapabilityState
     */
    public final CapabilityState createAndUpdateDatasets() {
        return CapabilityState.fromValue(createAndUpdateDatasets);
    }

    /**
     * <p>
     * The ability to create and update datasets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateDatasets} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #createAndUpdateDatasetsAsString}.
     * </p>
     * 
     * @return The ability to create and update datasets.
     * @see CapabilityState
     */
    public final String createAndUpdateDatasetsAsString() {
        return createAndUpdateDatasets;
    }

    /**
     * <p>
     * The ability to share datasets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareDatasets}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareDatasetsAsString}.
     * </p>
     * 
     * @return The ability to share datasets.
     * @see CapabilityState
     */
    public final CapabilityState shareDatasets() {
        return CapabilityState.fromValue(shareDatasets);
    }

    /**
     * <p>
     * The ability to share datasets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareDatasets}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareDatasetsAsString}.
     * </p>
     * 
     * @return The ability to share datasets.
     * @see CapabilityState
     */
    public final String shareDatasetsAsString() {
        return shareDatasets;
    }

    /**
     * <p>
     * The ability to subscribe to email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscribeDashboardEmailReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #subscribeDashboardEmailReportsAsString}.
     * </p>
     * 
     * @return The ability to subscribe to email reports.
     * @see CapabilityState
     */
    public final CapabilityState subscribeDashboardEmailReports() {
        return CapabilityState.fromValue(subscribeDashboardEmailReports);
    }

    /**
     * <p>
     * The ability to subscribe to email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #subscribeDashboardEmailReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #subscribeDashboardEmailReportsAsString}.
     * </p>
     * 
     * @return The ability to subscribe to email reports.
     * @see CapabilityState
     */
    public final String subscribeDashboardEmailReportsAsString() {
        return subscribeDashboardEmailReports;
    }

    /**
     * <p>
     * The ability to create and update email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateDashboardEmailReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #createAndUpdateDashboardEmailReportsAsString}.
     * </p>
     * 
     * @return The ability to create and update email reports.
     * @see CapabilityState
     */
    public final CapabilityState createAndUpdateDashboardEmailReports() {
        return CapabilityState.fromValue(createAndUpdateDashboardEmailReports);
    }

    /**
     * <p>
     * The ability to create and update email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateDashboardEmailReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #createAndUpdateDashboardEmailReportsAsString}.
     * </p>
     * 
     * @return The ability to create and update email reports.
     * @see CapabilityState
     */
    public final String createAndUpdateDashboardEmailReportsAsString() {
        return createAndUpdateDashboardEmailReports;
    }

    /**
     * <p>
     * The ability to share dashboards.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareDashboards}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareDashboardsAsString}.
     * </p>
     * 
     * @return The ability to share dashboards.
     * @see CapabilityState
     */
    public final CapabilityState shareDashboards() {
        return CapabilityState.fromValue(shareDashboards);
    }

    /**
     * <p>
     * The ability to share dashboards.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareDashboards}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareDashboardsAsString}.
     * </p>
     * 
     * @return The ability to share dashboards.
     * @see CapabilityState
     */
    public final String shareDashboardsAsString() {
        return shareDashboards;
    }

    /**
     * <p>
     * The ability to create and update threshold alerts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateThresholdAlerts} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #createAndUpdateThresholdAlertsAsString}.
     * </p>
     * 
     * @return The ability to create and update threshold alerts.
     * @see CapabilityState
     */
    public final CapabilityState createAndUpdateThresholdAlerts() {
        return CapabilityState.fromValue(createAndUpdateThresholdAlerts);
    }

    /**
     * <p>
     * The ability to create and update threshold alerts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateThresholdAlerts} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #createAndUpdateThresholdAlertsAsString}.
     * </p>
     * 
     * @return The ability to create and update threshold alerts.
     * @see CapabilityState
     */
    public final String createAndUpdateThresholdAlertsAsString() {
        return createAndUpdateThresholdAlerts;
    }

    /**
     * <p>
     * The ability to rename shared folders.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #renameSharedFolders} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #renameSharedFoldersAsString}.
     * </p>
     * 
     * @return The ability to rename shared folders.
     * @see CapabilityState
     */
    public final CapabilityState renameSharedFolders() {
        return CapabilityState.fromValue(renameSharedFolders);
    }

    /**
     * <p>
     * The ability to rename shared folders.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #renameSharedFolders} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #renameSharedFoldersAsString}.
     * </p>
     * 
     * @return The ability to rename shared folders.
     * @see CapabilityState
     */
    public final String renameSharedFoldersAsString() {
        return renameSharedFolders;
    }

    /**
     * <p>
     * The ability to create shared folders.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createSharedFolders} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #createSharedFoldersAsString}.
     * </p>
     * 
     * @return The ability to create shared folders.
     * @see CapabilityState
     */
    public final CapabilityState createSharedFolders() {
        return CapabilityState.fromValue(createSharedFolders);
    }

    /**
     * <p>
     * The ability to create shared folders.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createSharedFolders} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #createSharedFoldersAsString}.
     * </p>
     * 
     * @return The ability to create shared folders.
     * @see CapabilityState
     */
    public final String createSharedFoldersAsString() {
        return createSharedFolders;
    }

    /**
     * <p>
     * The ability to create and update data sources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateDataSources} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #createAndUpdateDataSourcesAsString}.
     * </p>
     * 
     * @return The ability to create and update data sources.
     * @see CapabilityState
     */
    public final CapabilityState createAndUpdateDataSources() {
        return CapabilityState.fromValue(createAndUpdateDataSources);
    }

    /**
     * <p>
     * The ability to create and update data sources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createAndUpdateDataSources} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #createAndUpdateDataSourcesAsString}.
     * </p>
     * 
     * @return The ability to create and update data sources.
     * @see CapabilityState
     */
    public final String createAndUpdateDataSourcesAsString() {
        return createAndUpdateDataSources;
    }

    /**
     * <p>
     * The ability to share data sources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareDataSources}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareDataSourcesAsString}.
     * </p>
     * 
     * @return The ability to share data sources.
     * @see CapabilityState
     */
    public final CapabilityState shareDataSources() {
        return CapabilityState.fromValue(shareDataSources);
    }

    /**
     * <p>
     * The ability to share data sources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareDataSources}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareDataSourcesAsString}.
     * </p>
     * 
     * @return The ability to share data sources.
     * @see CapabilityState
     */
    public final String shareDataSourcesAsString() {
        return shareDataSources;
    }

    /**
     * <p>
     * The ability to view account SPICE capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #viewAccountSPICECapacity} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #viewAccountSPICECapacityAsString}.
     * </p>
     * 
     * @return The ability to view account SPICE capacity.
     * @see CapabilityState
     */
    public final CapabilityState viewAccountSPICECapacity() {
        return CapabilityState.fromValue(viewAccountSPICECapacity);
    }

    /**
     * <p>
     * The ability to view account SPICE capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #viewAccountSPICECapacity} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #viewAccountSPICECapacityAsString}.
     * </p>
     * 
     * @return The ability to view account SPICE capacity.
     * @see CapabilityState
     */
    public final String viewAccountSPICECapacityAsString() {
        return viewAccountSPICECapacity;
    }

    /**
     * <p>
     * The ability to create a SPICE dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createSPICEDataset} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #createSPICEDatasetAsString}.
     * </p>
     * 
     * @return The ability to create a SPICE dataset.
     * @see CapabilityState
     */
    public final CapabilityState createSPICEDataset() {
        return CapabilityState.fromValue(createSPICEDataset);
    }

    /**
     * <p>
     * The ability to create a SPICE dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #createSPICEDataset} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #createSPICEDatasetAsString}.
     * </p>
     * 
     * @return The ability to create a SPICE dataset.
     * @see CapabilityState
     */
    public final String createSPICEDatasetAsString() {
        return createSPICEDataset;
    }

    /**
     * <p>
     * The ability to export to PDF files in scheduled email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #exportToPdfInScheduledReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #exportToPdfInScheduledReportsAsString}.
     * </p>
     * 
     * @return The ability to export to PDF files in scheduled email reports.
     * @see CapabilityState
     */
    public final CapabilityState exportToPdfInScheduledReports() {
        return CapabilityState.fromValue(exportToPdfInScheduledReports);
    }

    /**
     * <p>
     * The ability to export to PDF files in scheduled email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #exportToPdfInScheduledReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #exportToPdfInScheduledReportsAsString}.
     * </p>
     * 
     * @return The ability to export to PDF files in scheduled email reports.
     * @see CapabilityState
     */
    public final String exportToPdfInScheduledReportsAsString() {
        return exportToPdfInScheduledReports;
    }

    /**
     * <p>
     * The ability to export to CSV files in scheduled email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #exportToCsvInScheduledReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #exportToCsvInScheduledReportsAsString}.
     * </p>
     * 
     * @return The ability to export to CSV files in scheduled email reports.
     * @see CapabilityState
     */
    public final CapabilityState exportToCsvInScheduledReports() {
        return CapabilityState.fromValue(exportToCsvInScheduledReports);
    }

    /**
     * <p>
     * The ability to export to CSV files in scheduled email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #exportToCsvInScheduledReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #exportToCsvInScheduledReportsAsString}.
     * </p>
     * 
     * @return The ability to export to CSV files in scheduled email reports.
     * @see CapabilityState
     */
    public final String exportToCsvInScheduledReportsAsString() {
        return exportToCsvInScheduledReports;
    }

    /**
     * <p>
     * The ability to export to Excel files in scheduled email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #exportToExcelInScheduledReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #exportToExcelInScheduledReportsAsString}.
     * </p>
     * 
     * @return The ability to export to Excel files in scheduled email reports.
     * @see CapabilityState
     */
    public final CapabilityState exportToExcelInScheduledReports() {
        return CapabilityState.fromValue(exportToExcelInScheduledReports);
    }

    /**
     * <p>
     * The ability to export to Excel files in scheduled email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #exportToExcelInScheduledReports} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #exportToExcelInScheduledReportsAsString}.
     * </p>
     * 
     * @return The ability to export to Excel files in scheduled email reports.
     * @see CapabilityState
     */
    public final String exportToExcelInScheduledReportsAsString() {
        return exportToExcelInScheduledReports;
    }

    /**
     * <p>
     * The ability to include content in scheduled email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeContentInScheduledReportsEmail} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #includeContentInScheduledReportsEmailAsString}.
     * </p>
     * 
     * @return The ability to include content in scheduled email reports.
     * @see CapabilityState
     */
    public final CapabilityState includeContentInScheduledReportsEmail() {
        return CapabilityState.fromValue(includeContentInScheduledReportsEmail);
    }

    /**
     * <p>
     * The ability to include content in scheduled email reports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeContentInScheduledReportsEmail} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #includeContentInScheduledReportsEmailAsString}.
     * </p>
     * 
     * @return The ability to include content in scheduled email reports.
     * @see CapabilityState
     */
    public final String includeContentInScheduledReportsEmailAsString() {
        return includeContentInScheduledReportsEmail;
    }

    /**
     * <p>
     * The ability to perform dashboard-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dashboard} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dashboardAsString}.
     * </p>
     * 
     * @return The ability to perform dashboard-related actions.
     * @see CapabilityState
     */
    public final CapabilityState dashboard() {
        return CapabilityState.fromValue(dashboard);
    }

    /**
     * <p>
     * The ability to perform dashboard-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dashboard} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dashboardAsString}.
     * </p>
     * 
     * @return The ability to perform dashboard-related actions.
     * @see CapabilityState
     */
    public final String dashboardAsString() {
        return dashboard;
    }

    /**
     * <p>
     * The ability to perform analysis-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysis} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisAsString}.
     * </p>
     * 
     * @return The ability to perform analysis-related actions.
     * @see CapabilityState
     */
    public final CapabilityState analysis() {
        return CapabilityState.fromValue(analysis);
    }

    /**
     * <p>
     * The ability to perform analysis-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analysis} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #analysisAsString}.
     * </p>
     * 
     * @return The ability to perform analysis-related actions.
     * @see CapabilityState
     */
    public final String analysisAsString() {
        return analysis;
    }

    /**
     * <p>
     * The ability to perform automate-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automate} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #automateAsString}.
     * </p>
     * 
     * @return The ability to perform automate-related actions.
     * @see CapabilityState
     */
    public final CapabilityState automate() {
        return CapabilityState.fromValue(automate);
    }

    /**
     * <p>
     * The ability to perform automate-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automate} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #automateAsString}.
     * </p>
     * 
     * @return The ability to perform automate-related actions.
     * @see CapabilityState
     */
    public final String automateAsString() {
        return automate;
    }

    /**
     * <p>
     * The ability to perform flow-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flow} will return
     * {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowAsString}.
     * </p>
     * 
     * @return The ability to perform flow-related actions.
     * @see CapabilityState
     */
    public final CapabilityState flow() {
        return CapabilityState.fromValue(flow);
    }

    /**
     * <p>
     * The ability to perform flow-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flow} will return
     * {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flowAsString}.
     * </p>
     * 
     * @return The ability to perform flow-related actions.
     * @see CapabilityState
     */
    public final String flowAsString() {
        return flow;
    }

    /**
     * <p>
     * The ability to enable approvals for flow share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publishWithoutApproval} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #publishWithoutApprovalAsString}.
     * </p>
     * 
     * @return The ability to enable approvals for flow share.
     * @see CapabilityState
     */
    public final CapabilityState publishWithoutApproval() {
        return CapabilityState.fromValue(publishWithoutApproval);
    }

    /**
     * <p>
     * The ability to enable approvals for flow share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #publishWithoutApproval} will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #publishWithoutApprovalAsString}.
     * </p>
     * 
     * @return The ability to enable approvals for flow share.
     * @see CapabilityState
     */
    public final String publishWithoutApprovalAsString() {
        return publishWithoutApproval;
    }

    /**
     * <p>
     * The ability to use Bedrock models for general knowledge step in flows.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useBedrockModels}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #useBedrockModelsAsString}.
     * </p>
     * 
     * @return The ability to use Bedrock models for general knowledge step in flows.
     * @see CapabilityState
     */
    public final CapabilityState useBedrockModels() {
        return CapabilityState.fromValue(useBedrockModels);
    }

    /**
     * <p>
     * The ability to use Bedrock models for general knowledge step in flows.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useBedrockModels}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #useBedrockModelsAsString}.
     * </p>
     * 
     * @return The ability to use Bedrock models for general knowledge step in flows.
     * @see CapabilityState
     */
    public final String useBedrockModelsAsString() {
        return useBedrockModels;
    }

    /**
     * <p>
     * The ability to use UI Agent step to perform tasks on public websites.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performFlowUiTask}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performFlowUiTaskAsString}.
     * </p>
     * 
     * @return The ability to use UI Agent step to perform tasks on public websites.
     * @see CapabilityState
     */
    public final CapabilityState performFlowUiTask() {
        return CapabilityState.fromValue(performFlowUiTask);
    }

    /**
     * <p>
     * The ability to use UI Agent step to perform tasks on public websites.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performFlowUiTask}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performFlowUiTaskAsString}.
     * </p>
     * 
     * @return The ability to use UI Agent step to perform tasks on public websites.
     * @see CapabilityState
     */
    public final String performFlowUiTaskAsString() {
        return performFlowUiTask;
    }

    /**
     * <p>
     * The ability to use internet to enhance results in Chat Agents, Flows, and Quick Research. Web search queries will
     * be processed securely in an Amazon Web Services region <code>us-east-1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useAgentWebSearch}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #useAgentWebSearchAsString}.
     * </p>
     * 
     * @return The ability to use internet to enhance results in Chat Agents, Flows, and Quick Research. Web search
     *         queries will be processed securely in an Amazon Web Services region <code>us-east-1</code>.
     * @see CapabilityState
     */
    public final CapabilityState useAgentWebSearch() {
        return CapabilityState.fromValue(useAgentWebSearch);
    }

    /**
     * <p>
     * The ability to use internet to enhance results in Chat Agents, Flows, and Quick Research. Web search queries will
     * be processed securely in an Amazon Web Services region <code>us-east-1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #useAgentWebSearch}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #useAgentWebSearchAsString}.
     * </p>
     * 
     * @return The ability to use internet to enhance results in Chat Agents, Flows, and Quick Research. Web search
     *         queries will be processed securely in an Amazon Web Services region <code>us-east-1</code>.
     * @see CapabilityState
     */
    public final String useAgentWebSearchAsString() {
        return useAgentWebSearch;
    }

    /**
     * <p>
     * The ability to use knowledge bases to specify content from external applications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #knowledgeBase}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #knowledgeBaseAsString}.
     * </p>
     * 
     * @return The ability to use knowledge bases to specify content from external applications.
     * @see CapabilityState
     */
    public final CapabilityState knowledgeBase() {
        return CapabilityState.fromValue(knowledgeBase);
    }

    /**
     * <p>
     * The ability to use knowledge bases to specify content from external applications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #knowledgeBase}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #knowledgeBaseAsString}.
     * </p>
     * 
     * @return The ability to use knowledge bases to specify content from external applications.
     * @see CapabilityState
     */
    public final String knowledgeBaseAsString() {
        return knowledgeBase;
    }

    /**
     * <p>
     * The ability to perform actions in external services through Action connectors. Actions allow users to interact
     * with third-party systems.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The ability to perform actions in external services through Action connectors. Actions allow users to
     *         interact with third-party systems.
     * @see CapabilityState
     */
    public final CapabilityState action() {
        return CapabilityState.fromValue(action);
    }

    /**
     * <p>
     * The ability to perform actions in external services through Action connectors. Actions allow users to interact
     * with third-party systems.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The ability to perform actions in external services through Action connectors. Actions allow users to
     *         interact with third-party systems.
     * @see CapabilityState
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The ability to perform space-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #space} will return
     * {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spaceAsString}.
     * </p>
     * 
     * @return The ability to perform space-related actions.
     * @see CapabilityState
     */
    public final CapabilityState space() {
        return CapabilityState.fromValue(space);
    }

    /**
     * <p>
     * The ability to perform space-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #space} will return
     * {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spaceAsString}.
     * </p>
     * 
     * @return The ability to perform space-related actions.
     * @see CapabilityState
     */
    public final String spaceAsString() {
        return space;
    }

    /**
     * <p>
     * The ability to perform chat-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #chatAgent} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #chatAgentAsString}.
     * </p>
     * 
     * @return The ability to perform chat-related actions.
     * @see CapabilityState
     */
    public final CapabilityState chatAgent() {
        return CapabilityState.fromValue(chatAgent);
    }

    /**
     * <p>
     * The ability to perform chat-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #chatAgent} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #chatAgentAsString}.
     * </p>
     * 
     * @return The ability to perform chat-related actions.
     * @see CapabilityState
     */
    public final String chatAgentAsString() {
        return chatAgent;
    }

    /**
     * <p>
     * The ability to create chat agents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #createChatAgents}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #createChatAgentsAsString}.
     * </p>
     * 
     * @return The ability to create chat agents.
     * @see CapabilityState
     */
    public final CapabilityState createChatAgents() {
        return CapabilityState.fromValue(createChatAgents);
    }

    /**
     * <p>
     * The ability to create chat agents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #createChatAgents}
     * will return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #createChatAgentsAsString}.
     * </p>
     * 
     * @return The ability to create chat agents.
     * @see CapabilityState
     */
    public final String createChatAgentsAsString() {
        return createChatAgents;
    }

    /**
     * <p>
     * The ability to perform research-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #research} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #researchAsString}.
     * </p>
     * 
     * @return The ability to perform research-related actions.
     * @see CapabilityState
     */
    public final CapabilityState research() {
        return CapabilityState.fromValue(research);
    }

    /**
     * <p>
     * The ability to perform research-related actions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #research} will
     * return {@link CapabilityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #researchAsString}.
     * </p>
     * 
     * @return The ability to perform research-related actions.
     * @see CapabilityState
     */
    public final String researchAsString() {
        return research;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportToCsvAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportToExcelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportToPdfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(printReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createAndUpdateThemesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(addOrRunAnomalyDetectionForAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createAndUpdateDatasetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareDatasetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscribeDashboardEmailReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createAndUpdateDashboardEmailReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareDashboardsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createAndUpdateThresholdAlertsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(renameSharedFoldersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createSharedFoldersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createAndUpdateDataSourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareDataSourcesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(viewAccountSPICECapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createSPICEDatasetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportToPdfInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportToCsvInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportToExcelInScheduledReportsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeContentInScheduledReportsEmailAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analysisAsString());
        hashCode = 31 * hashCode + Objects.hashCode(automateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publishWithoutApprovalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(useBedrockModelsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(performFlowUiTaskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(useAgentWebSearchAsString());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(chatAgentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createChatAgentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(researchAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capabilities)) {
            return false;
        }
        Capabilities other = (Capabilities) obj;
        return Objects.equals(exportToCsvAsString(), other.exportToCsvAsString())
                && Objects.equals(exportToExcelAsString(), other.exportToExcelAsString())
                && Objects.equals(exportToPdfAsString(), other.exportToPdfAsString())
                && Objects.equals(printReportsAsString(), other.printReportsAsString())
                && Objects.equals(createAndUpdateThemesAsString(), other.createAndUpdateThemesAsString())
                && Objects.equals(addOrRunAnomalyDetectionForAnalysesAsString(),
                        other.addOrRunAnomalyDetectionForAnalysesAsString())
                && Objects.equals(shareAnalysesAsString(), other.shareAnalysesAsString())
                && Objects.equals(createAndUpdateDatasetsAsString(), other.createAndUpdateDatasetsAsString())
                && Objects.equals(shareDatasetsAsString(), other.shareDatasetsAsString())
                && Objects.equals(subscribeDashboardEmailReportsAsString(), other.subscribeDashboardEmailReportsAsString())
                && Objects.equals(createAndUpdateDashboardEmailReportsAsString(),
                        other.createAndUpdateDashboardEmailReportsAsString())
                && Objects.equals(shareDashboardsAsString(), other.shareDashboardsAsString())
                && Objects.equals(createAndUpdateThresholdAlertsAsString(), other.createAndUpdateThresholdAlertsAsString())
                && Objects.equals(renameSharedFoldersAsString(), other.renameSharedFoldersAsString())
                && Objects.equals(createSharedFoldersAsString(), other.createSharedFoldersAsString())
                && Objects.equals(createAndUpdateDataSourcesAsString(), other.createAndUpdateDataSourcesAsString())
                && Objects.equals(shareDataSourcesAsString(), other.shareDataSourcesAsString())
                && Objects.equals(viewAccountSPICECapacityAsString(), other.viewAccountSPICECapacityAsString())
                && Objects.equals(createSPICEDatasetAsString(), other.createSPICEDatasetAsString())
                && Objects.equals(exportToPdfInScheduledReportsAsString(), other.exportToPdfInScheduledReportsAsString())
                && Objects.equals(exportToCsvInScheduledReportsAsString(), other.exportToCsvInScheduledReportsAsString())
                && Objects.equals(exportToExcelInScheduledReportsAsString(), other.exportToExcelInScheduledReportsAsString())
                && Objects.equals(includeContentInScheduledReportsEmailAsString(),
                        other.includeContentInScheduledReportsEmailAsString())
                && Objects.equals(dashboardAsString(), other.dashboardAsString())
                && Objects.equals(analysisAsString(), other.analysisAsString())
                && Objects.equals(automateAsString(), other.automateAsString())
                && Objects.equals(flowAsString(), other.flowAsString())
                && Objects.equals(publishWithoutApprovalAsString(), other.publishWithoutApprovalAsString())
                && Objects.equals(useBedrockModelsAsString(), other.useBedrockModelsAsString())
                && Objects.equals(performFlowUiTaskAsString(), other.performFlowUiTaskAsString())
                && Objects.equals(useAgentWebSearchAsString(), other.useAgentWebSearchAsString())
                && Objects.equals(knowledgeBaseAsString(), other.knowledgeBaseAsString())
                && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(spaceAsString(), other.spaceAsString())
                && Objects.equals(chatAgentAsString(), other.chatAgentAsString())
                && Objects.equals(createChatAgentsAsString(), other.createChatAgentsAsString())
                && Objects.equals(researchAsString(), other.researchAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Capabilities").add("ExportToCsv", exportToCsvAsString())
                .add("ExportToExcel", exportToExcelAsString()).add("ExportToPdf", exportToPdfAsString())
                .add("PrintReports", printReportsAsString()).add("CreateAndUpdateThemes", createAndUpdateThemesAsString())
                .add("AddOrRunAnomalyDetectionForAnalyses", addOrRunAnomalyDetectionForAnalysesAsString())
                .add("ShareAnalyses", shareAnalysesAsString()).add("CreateAndUpdateDatasets", createAndUpdateDatasetsAsString())
                .add("ShareDatasets", shareDatasetsAsString())
                .add("SubscribeDashboardEmailReports", subscribeDashboardEmailReportsAsString())
                .add("CreateAndUpdateDashboardEmailReports", createAndUpdateDashboardEmailReportsAsString())
                .add("ShareDashboards", shareDashboardsAsString())
                .add("CreateAndUpdateThresholdAlerts", createAndUpdateThresholdAlertsAsString())
                .add("RenameSharedFolders", renameSharedFoldersAsString())
                .add("CreateSharedFolders", createSharedFoldersAsString())
                .add("CreateAndUpdateDataSources", createAndUpdateDataSourcesAsString())
                .add("ShareDataSources", shareDataSourcesAsString())
                .add("ViewAccountSPICECapacity", viewAccountSPICECapacityAsString())
                .add("CreateSPICEDataset", createSPICEDatasetAsString())
                .add("ExportToPdfInScheduledReports", exportToPdfInScheduledReportsAsString())
                .add("ExportToCsvInScheduledReports", exportToCsvInScheduledReportsAsString())
                .add("ExportToExcelInScheduledReports", exportToExcelInScheduledReportsAsString())
                .add("IncludeContentInScheduledReportsEmail", includeContentInScheduledReportsEmailAsString())
                .add("Dashboard", dashboardAsString()).add("Analysis", analysisAsString()).add("Automate", automateAsString())
                .add("Flow", flowAsString()).add("PublishWithoutApproval", publishWithoutApprovalAsString())
                .add("UseBedrockModels", useBedrockModelsAsString()).add("PerformFlowUiTask", performFlowUiTaskAsString())
                .add("UseAgentWebSearch", useAgentWebSearchAsString()).add("KnowledgeBase", knowledgeBaseAsString())
                .add("Action", actionAsString()).add("Space", spaceAsString()).add("ChatAgent", chatAgentAsString())
                .add("CreateChatAgents", createChatAgentsAsString()).add("Research", researchAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportToCsv":
            return Optional.ofNullable(clazz.cast(exportToCsvAsString()));
        case "ExportToExcel":
            return Optional.ofNullable(clazz.cast(exportToExcelAsString()));
        case "ExportToPdf":
            return Optional.ofNullable(clazz.cast(exportToPdfAsString()));
        case "PrintReports":
            return Optional.ofNullable(clazz.cast(printReportsAsString()));
        case "CreateAndUpdateThemes":
            return Optional.ofNullable(clazz.cast(createAndUpdateThemesAsString()));
        case "AddOrRunAnomalyDetectionForAnalyses":
            return Optional.ofNullable(clazz.cast(addOrRunAnomalyDetectionForAnalysesAsString()));
        case "ShareAnalyses":
            return Optional.ofNullable(clazz.cast(shareAnalysesAsString()));
        case "CreateAndUpdateDatasets":
            return Optional.ofNullable(clazz.cast(createAndUpdateDatasetsAsString()));
        case "ShareDatasets":
            return Optional.ofNullable(clazz.cast(shareDatasetsAsString()));
        case "SubscribeDashboardEmailReports":
            return Optional.ofNullable(clazz.cast(subscribeDashboardEmailReportsAsString()));
        case "CreateAndUpdateDashboardEmailReports":
            return Optional.ofNullable(clazz.cast(createAndUpdateDashboardEmailReportsAsString()));
        case "ShareDashboards":
            return Optional.ofNullable(clazz.cast(shareDashboardsAsString()));
        case "CreateAndUpdateThresholdAlerts":
            return Optional.ofNullable(clazz.cast(createAndUpdateThresholdAlertsAsString()));
        case "RenameSharedFolders":
            return Optional.ofNullable(clazz.cast(renameSharedFoldersAsString()));
        case "CreateSharedFolders":
            return Optional.ofNullable(clazz.cast(createSharedFoldersAsString()));
        case "CreateAndUpdateDataSources":
            return Optional.ofNullable(clazz.cast(createAndUpdateDataSourcesAsString()));
        case "ShareDataSources":
            return Optional.ofNullable(clazz.cast(shareDataSourcesAsString()));
        case "ViewAccountSPICECapacity":
            return Optional.ofNullable(clazz.cast(viewAccountSPICECapacityAsString()));
        case "CreateSPICEDataset":
            return Optional.ofNullable(clazz.cast(createSPICEDatasetAsString()));
        case "ExportToPdfInScheduledReports":
            return Optional.ofNullable(clazz.cast(exportToPdfInScheduledReportsAsString()));
        case "ExportToCsvInScheduledReports":
            return Optional.ofNullable(clazz.cast(exportToCsvInScheduledReportsAsString()));
        case "ExportToExcelInScheduledReports":
            return Optional.ofNullable(clazz.cast(exportToExcelInScheduledReportsAsString()));
        case "IncludeContentInScheduledReportsEmail":
            return Optional.ofNullable(clazz.cast(includeContentInScheduledReportsEmailAsString()));
        case "Dashboard":
            return Optional.ofNullable(clazz.cast(dashboardAsString()));
        case "Analysis":
            return Optional.ofNullable(clazz.cast(analysisAsString()));
        case "Automate":
            return Optional.ofNullable(clazz.cast(automateAsString()));
        case "Flow":
            return Optional.ofNullable(clazz.cast(flowAsString()));
        case "PublishWithoutApproval":
            return Optional.ofNullable(clazz.cast(publishWithoutApprovalAsString()));
        case "UseBedrockModels":
            return Optional.ofNullable(clazz.cast(useBedrockModelsAsString()));
        case "PerformFlowUiTask":
            return Optional.ofNullable(clazz.cast(performFlowUiTaskAsString()));
        case "UseAgentWebSearch":
            return Optional.ofNullable(clazz.cast(useAgentWebSearchAsString()));
        case "KnowledgeBase":
            return Optional.ofNullable(clazz.cast(knowledgeBaseAsString()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Space":
            return Optional.ofNullable(clazz.cast(spaceAsString()));
        case "ChatAgent":
            return Optional.ofNullable(clazz.cast(chatAgentAsString()));
        case "CreateChatAgents":
            return Optional.ofNullable(clazz.cast(createChatAgentsAsString()));
        case "Research":
            return Optional.ofNullable(clazz.cast(researchAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportToCsv", EXPORT_TO_CSV_FIELD);
        map.put("ExportToExcel", EXPORT_TO_EXCEL_FIELD);
        map.put("ExportToPdf", EXPORT_TO_PDF_FIELD);
        map.put("PrintReports", PRINT_REPORTS_FIELD);
        map.put("CreateAndUpdateThemes", CREATE_AND_UPDATE_THEMES_FIELD);
        map.put("AddOrRunAnomalyDetectionForAnalyses", ADD_OR_RUN_ANOMALY_DETECTION_FOR_ANALYSES_FIELD);
        map.put("ShareAnalyses", SHARE_ANALYSES_FIELD);
        map.put("CreateAndUpdateDatasets", CREATE_AND_UPDATE_DATASETS_FIELD);
        map.put("ShareDatasets", SHARE_DATASETS_FIELD);
        map.put("SubscribeDashboardEmailReports", SUBSCRIBE_DASHBOARD_EMAIL_REPORTS_FIELD);
        map.put("CreateAndUpdateDashboardEmailReports", CREATE_AND_UPDATE_DASHBOARD_EMAIL_REPORTS_FIELD);
        map.put("ShareDashboards", SHARE_DASHBOARDS_FIELD);
        map.put("CreateAndUpdateThresholdAlerts", CREATE_AND_UPDATE_THRESHOLD_ALERTS_FIELD);
        map.put("RenameSharedFolders", RENAME_SHARED_FOLDERS_FIELD);
        map.put("CreateSharedFolders", CREATE_SHARED_FOLDERS_FIELD);
        map.put("CreateAndUpdateDataSources", CREATE_AND_UPDATE_DATA_SOURCES_FIELD);
        map.put("ShareDataSources", SHARE_DATA_SOURCES_FIELD);
        map.put("ViewAccountSPICECapacity", VIEW_ACCOUNT_SPICE_CAPACITY_FIELD);
        map.put("CreateSPICEDataset", CREATE_SPICE_DATASET_FIELD);
        map.put("ExportToPdfInScheduledReports", EXPORT_TO_PDF_IN_SCHEDULED_REPORTS_FIELD);
        map.put("ExportToCsvInScheduledReports", EXPORT_TO_CSV_IN_SCHEDULED_REPORTS_FIELD);
        map.put("ExportToExcelInScheduledReports", EXPORT_TO_EXCEL_IN_SCHEDULED_REPORTS_FIELD);
        map.put("IncludeContentInScheduledReportsEmail", INCLUDE_CONTENT_IN_SCHEDULED_REPORTS_EMAIL_FIELD);
        map.put("Dashboard", DASHBOARD_FIELD);
        map.put("Analysis", ANALYSIS_FIELD);
        map.put("Automate", AUTOMATE_FIELD);
        map.put("Flow", FLOW_FIELD);
        map.put("PublishWithoutApproval", PUBLISH_WITHOUT_APPROVAL_FIELD);
        map.put("UseBedrockModels", USE_BEDROCK_MODELS_FIELD);
        map.put("PerformFlowUiTask", PERFORM_FLOW_UI_TASK_FIELD);
        map.put("UseAgentWebSearch", USE_AGENT_WEB_SEARCH_FIELD);
        map.put("KnowledgeBase", KNOWLEDGE_BASE_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Space", SPACE_FIELD);
        map.put("ChatAgent", CHAT_AGENT_FIELD);
        map.put("CreateChatAgents", CREATE_CHAT_AGENTS_FIELD);
        map.put("Research", RESEARCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Capabilities, T> g) {
        return obj -> g.apply((Capabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Capabilities> {
        /**
         * <p>
         * The ability to export to CSV files from the UI.
         * </p>
         * 
         * @param exportToCsv
         *        The ability to export to CSV files from the UI.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToCsv(String exportToCsv);

        /**
         * <p>
         * The ability to export to CSV files from the UI.
         * </p>
         * 
         * @param exportToCsv
         *        The ability to export to CSV files from the UI.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToCsv(CapabilityState exportToCsv);

        /**
         * <p>
         * The ability to export to Excel files from the UI.
         * </p>
         * 
         * @param exportToExcel
         *        The ability to export to Excel files from the UI.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToExcel(String exportToExcel);

        /**
         * <p>
         * The ability to export to Excel files from the UI.
         * </p>
         * 
         * @param exportToExcel
         *        The ability to export to Excel files from the UI.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToExcel(CapabilityState exportToExcel);

        /**
         * <p>
         * The ability to export to PDF files from the UI.
         * </p>
         * 
         * @param exportToPdf
         *        The ability to export to PDF files from the UI.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToPdf(String exportToPdf);

        /**
         * <p>
         * The ability to export to PDF files from the UI.
         * </p>
         * 
         * @param exportToPdf
         *        The ability to export to PDF files from the UI.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToPdf(CapabilityState exportToPdf);

        /**
         * <p>
         * The ability to print reports.
         * </p>
         * 
         * @param printReports
         *        The ability to print reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder printReports(String printReports);

        /**
         * <p>
         * The ability to print reports.
         * </p>
         * 
         * @param printReports
         *        The ability to print reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder printReports(CapabilityState printReports);

        /**
         * <p>
         * The ability to export to Create and Update themes.
         * </p>
         * 
         * @param createAndUpdateThemes
         *        The ability to export to Create and Update themes.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateThemes(String createAndUpdateThemes);

        /**
         * <p>
         * The ability to export to Create and Update themes.
         * </p>
         * 
         * @param createAndUpdateThemes
         *        The ability to export to Create and Update themes.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateThemes(CapabilityState createAndUpdateThemes);

        /**
         * <p>
         * The ability to add or run anomaly detection.
         * </p>
         * 
         * @param addOrRunAnomalyDetectionForAnalyses
         *        The ability to add or run anomaly detection.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder addOrRunAnomalyDetectionForAnalyses(String addOrRunAnomalyDetectionForAnalyses);

        /**
         * <p>
         * The ability to add or run anomaly detection.
         * </p>
         * 
         * @param addOrRunAnomalyDetectionForAnalyses
         *        The ability to add or run anomaly detection.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder addOrRunAnomalyDetectionForAnalyses(CapabilityState addOrRunAnomalyDetectionForAnalyses);

        /**
         * <p>
         * The ability to share analyses.
         * </p>
         * 
         * @param shareAnalyses
         *        The ability to share analyses.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder shareAnalyses(String shareAnalyses);

        /**
         * <p>
         * The ability to share analyses.
         * </p>
         * 
         * @param shareAnalyses
         *        The ability to share analyses.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder shareAnalyses(CapabilityState shareAnalyses);

        /**
         * <p>
         * The ability to create and update datasets.
         * </p>
         * 
         * @param createAndUpdateDatasets
         *        The ability to create and update datasets.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateDatasets(String createAndUpdateDatasets);

        /**
         * <p>
         * The ability to create and update datasets.
         * </p>
         * 
         * @param createAndUpdateDatasets
         *        The ability to create and update datasets.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateDatasets(CapabilityState createAndUpdateDatasets);

        /**
         * <p>
         * The ability to share datasets.
         * </p>
         * 
         * @param shareDatasets
         *        The ability to share datasets.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder shareDatasets(String shareDatasets);

        /**
         * <p>
         * The ability to share datasets.
         * </p>
         * 
         * @param shareDatasets
         *        The ability to share datasets.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder shareDatasets(CapabilityState shareDatasets);

        /**
         * <p>
         * The ability to subscribe to email reports.
         * </p>
         * 
         * @param subscribeDashboardEmailReports
         *        The ability to subscribe to email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder subscribeDashboardEmailReports(String subscribeDashboardEmailReports);

        /**
         * <p>
         * The ability to subscribe to email reports.
         * </p>
         * 
         * @param subscribeDashboardEmailReports
         *        The ability to subscribe to email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder subscribeDashboardEmailReports(CapabilityState subscribeDashboardEmailReports);

        /**
         * <p>
         * The ability to create and update email reports.
         * </p>
         * 
         * @param createAndUpdateDashboardEmailReports
         *        The ability to create and update email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateDashboardEmailReports(String createAndUpdateDashboardEmailReports);

        /**
         * <p>
         * The ability to create and update email reports.
         * </p>
         * 
         * @param createAndUpdateDashboardEmailReports
         *        The ability to create and update email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateDashboardEmailReports(CapabilityState createAndUpdateDashboardEmailReports);

        /**
         * <p>
         * The ability to share dashboards.
         * </p>
         * 
         * @param shareDashboards
         *        The ability to share dashboards.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder shareDashboards(String shareDashboards);

        /**
         * <p>
         * The ability to share dashboards.
         * </p>
         * 
         * @param shareDashboards
         *        The ability to share dashboards.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder shareDashboards(CapabilityState shareDashboards);

        /**
         * <p>
         * The ability to create and update threshold alerts.
         * </p>
         * 
         * @param createAndUpdateThresholdAlerts
         *        The ability to create and update threshold alerts.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateThresholdAlerts(String createAndUpdateThresholdAlerts);

        /**
         * <p>
         * The ability to create and update threshold alerts.
         * </p>
         * 
         * @param createAndUpdateThresholdAlerts
         *        The ability to create and update threshold alerts.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateThresholdAlerts(CapabilityState createAndUpdateThresholdAlerts);

        /**
         * <p>
         * The ability to rename shared folders.
         * </p>
         * 
         * @param renameSharedFolders
         *        The ability to rename shared folders.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder renameSharedFolders(String renameSharedFolders);

        /**
         * <p>
         * The ability to rename shared folders.
         * </p>
         * 
         * @param renameSharedFolders
         *        The ability to rename shared folders.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder renameSharedFolders(CapabilityState renameSharedFolders);

        /**
         * <p>
         * The ability to create shared folders.
         * </p>
         * 
         * @param createSharedFolders
         *        The ability to create shared folders.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createSharedFolders(String createSharedFolders);

        /**
         * <p>
         * The ability to create shared folders.
         * </p>
         * 
         * @param createSharedFolders
         *        The ability to create shared folders.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createSharedFolders(CapabilityState createSharedFolders);

        /**
         * <p>
         * The ability to create and update data sources.
         * </p>
         * 
         * @param createAndUpdateDataSources
         *        The ability to create and update data sources.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateDataSources(String createAndUpdateDataSources);

        /**
         * <p>
         * The ability to create and update data sources.
         * </p>
         * 
         * @param createAndUpdateDataSources
         *        The ability to create and update data sources.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createAndUpdateDataSources(CapabilityState createAndUpdateDataSources);

        /**
         * <p>
         * The ability to share data sources.
         * </p>
         * 
         * @param shareDataSources
         *        The ability to share data sources.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder shareDataSources(String shareDataSources);

        /**
         * <p>
         * The ability to share data sources.
         * </p>
         * 
         * @param shareDataSources
         *        The ability to share data sources.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder shareDataSources(CapabilityState shareDataSources);

        /**
         * <p>
         * The ability to view account SPICE capacity.
         * </p>
         * 
         * @param viewAccountSPICECapacity
         *        The ability to view account SPICE capacity.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder viewAccountSPICECapacity(String viewAccountSPICECapacity);

        /**
         * <p>
         * The ability to view account SPICE capacity.
         * </p>
         * 
         * @param viewAccountSPICECapacity
         *        The ability to view account SPICE capacity.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder viewAccountSPICECapacity(CapabilityState viewAccountSPICECapacity);

        /**
         * <p>
         * The ability to create a SPICE dataset.
         * </p>
         * 
         * @param createSPICEDataset
         *        The ability to create a SPICE dataset.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createSPICEDataset(String createSPICEDataset);

        /**
         * <p>
         * The ability to create a SPICE dataset.
         * </p>
         * 
         * @param createSPICEDataset
         *        The ability to create a SPICE dataset.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createSPICEDataset(CapabilityState createSPICEDataset);

        /**
         * <p>
         * The ability to export to PDF files in scheduled email reports.
         * </p>
         * 
         * @param exportToPdfInScheduledReports
         *        The ability to export to PDF files in scheduled email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToPdfInScheduledReports(String exportToPdfInScheduledReports);

        /**
         * <p>
         * The ability to export to PDF files in scheduled email reports.
         * </p>
         * 
         * @param exportToPdfInScheduledReports
         *        The ability to export to PDF files in scheduled email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToPdfInScheduledReports(CapabilityState exportToPdfInScheduledReports);

        /**
         * <p>
         * The ability to export to CSV files in scheduled email reports.
         * </p>
         * 
         * @param exportToCsvInScheduledReports
         *        The ability to export to CSV files in scheduled email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToCsvInScheduledReports(String exportToCsvInScheduledReports);

        /**
         * <p>
         * The ability to export to CSV files in scheduled email reports.
         * </p>
         * 
         * @param exportToCsvInScheduledReports
         *        The ability to export to CSV files in scheduled email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToCsvInScheduledReports(CapabilityState exportToCsvInScheduledReports);

        /**
         * <p>
         * The ability to export to Excel files in scheduled email reports.
         * </p>
         * 
         * @param exportToExcelInScheduledReports
         *        The ability to export to Excel files in scheduled email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToExcelInScheduledReports(String exportToExcelInScheduledReports);

        /**
         * <p>
         * The ability to export to Excel files in scheduled email reports.
         * </p>
         * 
         * @param exportToExcelInScheduledReports
         *        The ability to export to Excel files in scheduled email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder exportToExcelInScheduledReports(CapabilityState exportToExcelInScheduledReports);

        /**
         * <p>
         * The ability to include content in scheduled email reports.
         * </p>
         * 
         * @param includeContentInScheduledReportsEmail
         *        The ability to include content in scheduled email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder includeContentInScheduledReportsEmail(String includeContentInScheduledReportsEmail);

        /**
         * <p>
         * The ability to include content in scheduled email reports.
         * </p>
         * 
         * @param includeContentInScheduledReportsEmail
         *        The ability to include content in scheduled email reports.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder includeContentInScheduledReportsEmail(CapabilityState includeContentInScheduledReportsEmail);

        /**
         * <p>
         * The ability to perform dashboard-related actions.
         * </p>
         * 
         * @param dashboard
         *        The ability to perform dashboard-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder dashboard(String dashboard);

        /**
         * <p>
         * The ability to perform dashboard-related actions.
         * </p>
         * 
         * @param dashboard
         *        The ability to perform dashboard-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder dashboard(CapabilityState dashboard);

        /**
         * <p>
         * The ability to perform analysis-related actions.
         * </p>
         * 
         * @param analysis
         *        The ability to perform analysis-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder analysis(String analysis);

        /**
         * <p>
         * The ability to perform analysis-related actions.
         * </p>
         * 
         * @param analysis
         *        The ability to perform analysis-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder analysis(CapabilityState analysis);

        /**
         * <p>
         * The ability to perform automate-related actions.
         * </p>
         * 
         * @param automate
         *        The ability to perform automate-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder automate(String automate);

        /**
         * <p>
         * The ability to perform automate-related actions.
         * </p>
         * 
         * @param automate
         *        The ability to perform automate-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder automate(CapabilityState automate);

        /**
         * <p>
         * The ability to perform flow-related actions.
         * </p>
         * 
         * @param flow
         *        The ability to perform flow-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder flow(String flow);

        /**
         * <p>
         * The ability to perform flow-related actions.
         * </p>
         * 
         * @param flow
         *        The ability to perform flow-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder flow(CapabilityState flow);

        /**
         * <p>
         * The ability to enable approvals for flow share.
         * </p>
         * 
         * @param publishWithoutApproval
         *        The ability to enable approvals for flow share.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder publishWithoutApproval(String publishWithoutApproval);

        /**
         * <p>
         * The ability to enable approvals for flow share.
         * </p>
         * 
         * @param publishWithoutApproval
         *        The ability to enable approvals for flow share.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder publishWithoutApproval(CapabilityState publishWithoutApproval);

        /**
         * <p>
         * The ability to use Bedrock models for general knowledge step in flows.
         * </p>
         * 
         * @param useBedrockModels
         *        The ability to use Bedrock models for general knowledge step in flows.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder useBedrockModels(String useBedrockModels);

        /**
         * <p>
         * The ability to use Bedrock models for general knowledge step in flows.
         * </p>
         * 
         * @param useBedrockModels
         *        The ability to use Bedrock models for general knowledge step in flows.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder useBedrockModels(CapabilityState useBedrockModels);

        /**
         * <p>
         * The ability to use UI Agent step to perform tasks on public websites.
         * </p>
         * 
         * @param performFlowUiTask
         *        The ability to use UI Agent step to perform tasks on public websites.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder performFlowUiTask(String performFlowUiTask);

        /**
         * <p>
         * The ability to use UI Agent step to perform tasks on public websites.
         * </p>
         * 
         * @param performFlowUiTask
         *        The ability to use UI Agent step to perform tasks on public websites.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder performFlowUiTask(CapabilityState performFlowUiTask);

        /**
         * <p>
         * The ability to use internet to enhance results in Chat Agents, Flows, and Quick Research. Web search queries
         * will be processed securely in an Amazon Web Services region <code>us-east-1</code>.
         * </p>
         * 
         * @param useAgentWebSearch
         *        The ability to use internet to enhance results in Chat Agents, Flows, and Quick Research. Web search
         *        queries will be processed securely in an Amazon Web Services region <code>us-east-1</code>.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder useAgentWebSearch(String useAgentWebSearch);

        /**
         * <p>
         * The ability to use internet to enhance results in Chat Agents, Flows, and Quick Research. Web search queries
         * will be processed securely in an Amazon Web Services region <code>us-east-1</code>.
         * </p>
         * 
         * @param useAgentWebSearch
         *        The ability to use internet to enhance results in Chat Agents, Flows, and Quick Research. Web search
         *        queries will be processed securely in an Amazon Web Services region <code>us-east-1</code>.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder useAgentWebSearch(CapabilityState useAgentWebSearch);

        /**
         * <p>
         * The ability to use knowledge bases to specify content from external applications.
         * </p>
         * 
         * @param knowledgeBase
         *        The ability to use knowledge bases to specify content from external applications.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder knowledgeBase(String knowledgeBase);

        /**
         * <p>
         * The ability to use knowledge bases to specify content from external applications.
         * </p>
         * 
         * @param knowledgeBase
         *        The ability to use knowledge bases to specify content from external applications.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder knowledgeBase(CapabilityState knowledgeBase);

        /**
         * <p>
         * The ability to perform actions in external services through Action connectors. Actions allow users to
         * interact with third-party systems.
         * </p>
         * 
         * @param action
         *        The ability to perform actions in external services through Action connectors. Actions allow users to
         *        interact with third-party systems.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder action(String action);

        /**
         * <p>
         * The ability to perform actions in external services through Action connectors. Actions allow users to
         * interact with third-party systems.
         * </p>
         * 
         * @param action
         *        The ability to perform actions in external services through Action connectors. Actions allow users to
         *        interact with third-party systems.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder action(CapabilityState action);

        /**
         * <p>
         * The ability to perform space-related actions.
         * </p>
         * 
         * @param space
         *        The ability to perform space-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder space(String space);

        /**
         * <p>
         * The ability to perform space-related actions.
         * </p>
         * 
         * @param space
         *        The ability to perform space-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder space(CapabilityState space);

        /**
         * <p>
         * The ability to perform chat-related actions.
         * </p>
         * 
         * @param chatAgent
         *        The ability to perform chat-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder chatAgent(String chatAgent);

        /**
         * <p>
         * The ability to perform chat-related actions.
         * </p>
         * 
         * @param chatAgent
         *        The ability to perform chat-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder chatAgent(CapabilityState chatAgent);

        /**
         * <p>
         * The ability to create chat agents.
         * </p>
         * 
         * @param createChatAgents
         *        The ability to create chat agents.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createChatAgents(String createChatAgents);

        /**
         * <p>
         * The ability to create chat agents.
         * </p>
         * 
         * @param createChatAgents
         *        The ability to create chat agents.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder createChatAgents(CapabilityState createChatAgents);

        /**
         * <p>
         * The ability to perform research-related actions.
         * </p>
         * 
         * @param research
         *        The ability to perform research-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder research(String research);

        /**
         * <p>
         * The ability to perform research-related actions.
         * </p>
         * 
         * @param research
         *        The ability to perform research-related actions.
         * @see CapabilityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityState
         */
        Builder research(CapabilityState research);
    }

    static final class BuilderImpl implements Builder {
        private String exportToCsv;

        private String exportToExcel;

        private String exportToPdf;

        private String printReports;

        private String createAndUpdateThemes;

        private String addOrRunAnomalyDetectionForAnalyses;

        private String shareAnalyses;

        private String createAndUpdateDatasets;

        private String shareDatasets;

        private String subscribeDashboardEmailReports;

        private String createAndUpdateDashboardEmailReports;

        private String shareDashboards;

        private String createAndUpdateThresholdAlerts;

        private String renameSharedFolders;

        private String createSharedFolders;

        private String createAndUpdateDataSources;

        private String shareDataSources;

        private String viewAccountSPICECapacity;

        private String createSPICEDataset;

        private String exportToPdfInScheduledReports;

        private String exportToCsvInScheduledReports;

        private String exportToExcelInScheduledReports;

        private String includeContentInScheduledReportsEmail;

        private String dashboard;

        private String analysis;

        private String automate;

        private String flow;

        private String publishWithoutApproval;

        private String useBedrockModels;

        private String performFlowUiTask;

        private String useAgentWebSearch;

        private String knowledgeBase;

        private String action;

        private String space;

        private String chatAgent;

        private String createChatAgents;

        private String research;

        private BuilderImpl() {
        }

        private BuilderImpl(Capabilities model) {
            exportToCsv(model.exportToCsv);
            exportToExcel(model.exportToExcel);
            exportToPdf(model.exportToPdf);
            printReports(model.printReports);
            createAndUpdateThemes(model.createAndUpdateThemes);
            addOrRunAnomalyDetectionForAnalyses(model.addOrRunAnomalyDetectionForAnalyses);
            shareAnalyses(model.shareAnalyses);
            createAndUpdateDatasets(model.createAndUpdateDatasets);
            shareDatasets(model.shareDatasets);
            subscribeDashboardEmailReports(model.subscribeDashboardEmailReports);
            createAndUpdateDashboardEmailReports(model.createAndUpdateDashboardEmailReports);
            shareDashboards(model.shareDashboards);
            createAndUpdateThresholdAlerts(model.createAndUpdateThresholdAlerts);
            renameSharedFolders(model.renameSharedFolders);
            createSharedFolders(model.createSharedFolders);
            createAndUpdateDataSources(model.createAndUpdateDataSources);
            shareDataSources(model.shareDataSources);
            viewAccountSPICECapacity(model.viewAccountSPICECapacity);
            createSPICEDataset(model.createSPICEDataset);
            exportToPdfInScheduledReports(model.exportToPdfInScheduledReports);
            exportToCsvInScheduledReports(model.exportToCsvInScheduledReports);
            exportToExcelInScheduledReports(model.exportToExcelInScheduledReports);
            includeContentInScheduledReportsEmail(model.includeContentInScheduledReportsEmail);
            dashboard(model.dashboard);
            analysis(model.analysis);
            automate(model.automate);
            flow(model.flow);
            publishWithoutApproval(model.publishWithoutApproval);
            useBedrockModels(model.useBedrockModels);
            performFlowUiTask(model.performFlowUiTask);
            useAgentWebSearch(model.useAgentWebSearch);
            knowledgeBase(model.knowledgeBase);
            action(model.action);
            space(model.space);
            chatAgent(model.chatAgent);
            createChatAgents(model.createChatAgents);
            research(model.research);
        }

        public final String getExportToCsv() {
            return exportToCsv;
        }

        public final void setExportToCsv(String exportToCsv) {
            this.exportToCsv = exportToCsv;
        }

        @Override
        public final Builder exportToCsv(String exportToCsv) {
            this.exportToCsv = exportToCsv;
            return this;
        }

        @Override
        public final Builder exportToCsv(CapabilityState exportToCsv) {
            this.exportToCsv(exportToCsv == null ? null : exportToCsv.toString());
            return this;
        }

        public final String getExportToExcel() {
            return exportToExcel;
        }

        public final void setExportToExcel(String exportToExcel) {
            this.exportToExcel = exportToExcel;
        }

        @Override
        public final Builder exportToExcel(String exportToExcel) {
            this.exportToExcel = exportToExcel;
            return this;
        }

        @Override
        public final Builder exportToExcel(CapabilityState exportToExcel) {
            this.exportToExcel(exportToExcel == null ? null : exportToExcel.toString());
            return this;
        }

        public final String getExportToPdf() {
            return exportToPdf;
        }

        public final void setExportToPdf(String exportToPdf) {
            this.exportToPdf = exportToPdf;
        }

        @Override
        public final Builder exportToPdf(String exportToPdf) {
            this.exportToPdf = exportToPdf;
            return this;
        }

        @Override
        public final Builder exportToPdf(CapabilityState exportToPdf) {
            this.exportToPdf(exportToPdf == null ? null : exportToPdf.toString());
            return this;
        }

        public final String getPrintReports() {
            return printReports;
        }

        public final void setPrintReports(String printReports) {
            this.printReports = printReports;
        }

        @Override
        public final Builder printReports(String printReports) {
            this.printReports = printReports;
            return this;
        }

        @Override
        public final Builder printReports(CapabilityState printReports) {
            this.printReports(printReports == null ? null : printReports.toString());
            return this;
        }

        public final String getCreateAndUpdateThemes() {
            return createAndUpdateThemes;
        }

        public final void setCreateAndUpdateThemes(String createAndUpdateThemes) {
            this.createAndUpdateThemes = createAndUpdateThemes;
        }

        @Override
        public final Builder createAndUpdateThemes(String createAndUpdateThemes) {
            this.createAndUpdateThemes = createAndUpdateThemes;
            return this;
        }

        @Override
        public final Builder createAndUpdateThemes(CapabilityState createAndUpdateThemes) {
            this.createAndUpdateThemes(createAndUpdateThemes == null ? null : createAndUpdateThemes.toString());
            return this;
        }

        public final String getAddOrRunAnomalyDetectionForAnalyses() {
            return addOrRunAnomalyDetectionForAnalyses;
        }

        public final void setAddOrRunAnomalyDetectionForAnalyses(String addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses = addOrRunAnomalyDetectionForAnalyses;
        }

        @Override
        public final Builder addOrRunAnomalyDetectionForAnalyses(String addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses = addOrRunAnomalyDetectionForAnalyses;
            return this;
        }

        @Override
        public final Builder addOrRunAnomalyDetectionForAnalyses(CapabilityState addOrRunAnomalyDetectionForAnalyses) {
            this.addOrRunAnomalyDetectionForAnalyses(addOrRunAnomalyDetectionForAnalyses == null ? null
                    : addOrRunAnomalyDetectionForAnalyses.toString());
            return this;
        }

        public final String getShareAnalyses() {
            return shareAnalyses;
        }

        public final void setShareAnalyses(String shareAnalyses) {
            this.shareAnalyses = shareAnalyses;
        }

        @Override
        public final Builder shareAnalyses(String shareAnalyses) {
            this.shareAnalyses = shareAnalyses;
            return this;
        }

        @Override
        public final Builder shareAnalyses(CapabilityState shareAnalyses) {
            this.shareAnalyses(shareAnalyses == null ? null : shareAnalyses.toString());
            return this;
        }

        public final String getCreateAndUpdateDatasets() {
            return createAndUpdateDatasets;
        }

        public final void setCreateAndUpdateDatasets(String createAndUpdateDatasets) {
            this.createAndUpdateDatasets = createAndUpdateDatasets;
        }

        @Override
        public final Builder createAndUpdateDatasets(String createAndUpdateDatasets) {
            this.createAndUpdateDatasets = createAndUpdateDatasets;
            return this;
        }

        @Override
        public final Builder createAndUpdateDatasets(CapabilityState createAndUpdateDatasets) {
            this.createAndUpdateDatasets(createAndUpdateDatasets == null ? null : createAndUpdateDatasets.toString());
            return this;
        }

        public final String getShareDatasets() {
            return shareDatasets;
        }

        public final void setShareDatasets(String shareDatasets) {
            this.shareDatasets = shareDatasets;
        }

        @Override
        public final Builder shareDatasets(String shareDatasets) {
            this.shareDatasets = shareDatasets;
            return this;
        }

        @Override
        public final Builder shareDatasets(CapabilityState shareDatasets) {
            this.shareDatasets(shareDatasets == null ? null : shareDatasets.toString());
            return this;
        }

        public final String getSubscribeDashboardEmailReports() {
            return subscribeDashboardEmailReports;
        }

        public final void setSubscribeDashboardEmailReports(String subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports = subscribeDashboardEmailReports;
        }

        @Override
        public final Builder subscribeDashboardEmailReports(String subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports = subscribeDashboardEmailReports;
            return this;
        }

        @Override
        public final Builder subscribeDashboardEmailReports(CapabilityState subscribeDashboardEmailReports) {
            this.subscribeDashboardEmailReports(subscribeDashboardEmailReports == null ? null : subscribeDashboardEmailReports
                    .toString());
            return this;
        }

        public final String getCreateAndUpdateDashboardEmailReports() {
            return createAndUpdateDashboardEmailReports;
        }

        public final void setCreateAndUpdateDashboardEmailReports(String createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports = createAndUpdateDashboardEmailReports;
        }

        @Override
        public final Builder createAndUpdateDashboardEmailReports(String createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports = createAndUpdateDashboardEmailReports;
            return this;
        }

        @Override
        public final Builder createAndUpdateDashboardEmailReports(CapabilityState createAndUpdateDashboardEmailReports) {
            this.createAndUpdateDashboardEmailReports(createAndUpdateDashboardEmailReports == null ? null
                    : createAndUpdateDashboardEmailReports.toString());
            return this;
        }

        public final String getShareDashboards() {
            return shareDashboards;
        }

        public final void setShareDashboards(String shareDashboards) {
            this.shareDashboards = shareDashboards;
        }

        @Override
        public final Builder shareDashboards(String shareDashboards) {
            this.shareDashboards = shareDashboards;
            return this;
        }

        @Override
        public final Builder shareDashboards(CapabilityState shareDashboards) {
            this.shareDashboards(shareDashboards == null ? null : shareDashboards.toString());
            return this;
        }

        public final String getCreateAndUpdateThresholdAlerts() {
            return createAndUpdateThresholdAlerts;
        }

        public final void setCreateAndUpdateThresholdAlerts(String createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts = createAndUpdateThresholdAlerts;
        }

        @Override
        public final Builder createAndUpdateThresholdAlerts(String createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts = createAndUpdateThresholdAlerts;
            return this;
        }

        @Override
        public final Builder createAndUpdateThresholdAlerts(CapabilityState createAndUpdateThresholdAlerts) {
            this.createAndUpdateThresholdAlerts(createAndUpdateThresholdAlerts == null ? null : createAndUpdateThresholdAlerts
                    .toString());
            return this;
        }

        public final String getRenameSharedFolders() {
            return renameSharedFolders;
        }

        public final void setRenameSharedFolders(String renameSharedFolders) {
            this.renameSharedFolders = renameSharedFolders;
        }

        @Override
        public final Builder renameSharedFolders(String renameSharedFolders) {
            this.renameSharedFolders = renameSharedFolders;
            return this;
        }

        @Override
        public final Builder renameSharedFolders(CapabilityState renameSharedFolders) {
            this.renameSharedFolders(renameSharedFolders == null ? null : renameSharedFolders.toString());
            return this;
        }

        public final String getCreateSharedFolders() {
            return createSharedFolders;
        }

        public final void setCreateSharedFolders(String createSharedFolders) {
            this.createSharedFolders = createSharedFolders;
        }

        @Override
        public final Builder createSharedFolders(String createSharedFolders) {
            this.createSharedFolders = createSharedFolders;
            return this;
        }

        @Override
        public final Builder createSharedFolders(CapabilityState createSharedFolders) {
            this.createSharedFolders(createSharedFolders == null ? null : createSharedFolders.toString());
            return this;
        }

        public final String getCreateAndUpdateDataSources() {
            return createAndUpdateDataSources;
        }

        public final void setCreateAndUpdateDataSources(String createAndUpdateDataSources) {
            this.createAndUpdateDataSources = createAndUpdateDataSources;
        }

        @Override
        public final Builder createAndUpdateDataSources(String createAndUpdateDataSources) {
            this.createAndUpdateDataSources = createAndUpdateDataSources;
            return this;
        }

        @Override
        public final Builder createAndUpdateDataSources(CapabilityState createAndUpdateDataSources) {
            this.createAndUpdateDataSources(createAndUpdateDataSources == null ? null : createAndUpdateDataSources.toString());
            return this;
        }

        public final String getShareDataSources() {
            return shareDataSources;
        }

        public final void setShareDataSources(String shareDataSources) {
            this.shareDataSources = shareDataSources;
        }

        @Override
        public final Builder shareDataSources(String shareDataSources) {
            this.shareDataSources = shareDataSources;
            return this;
        }

        @Override
        public final Builder shareDataSources(CapabilityState shareDataSources) {
            this.shareDataSources(shareDataSources == null ? null : shareDataSources.toString());
            return this;
        }

        public final String getViewAccountSPICECapacity() {
            return viewAccountSPICECapacity;
        }

        public final void setViewAccountSPICECapacity(String viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity = viewAccountSPICECapacity;
        }

        @Override
        public final Builder viewAccountSPICECapacity(String viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity = viewAccountSPICECapacity;
            return this;
        }

        @Override
        public final Builder viewAccountSPICECapacity(CapabilityState viewAccountSPICECapacity) {
            this.viewAccountSPICECapacity(viewAccountSPICECapacity == null ? null : viewAccountSPICECapacity.toString());
            return this;
        }

        public final String getCreateSPICEDataset() {
            return createSPICEDataset;
        }

        public final void setCreateSPICEDataset(String createSPICEDataset) {
            this.createSPICEDataset = createSPICEDataset;
        }

        @Override
        public final Builder createSPICEDataset(String createSPICEDataset) {
            this.createSPICEDataset = createSPICEDataset;
            return this;
        }

        @Override
        public final Builder createSPICEDataset(CapabilityState createSPICEDataset) {
            this.createSPICEDataset(createSPICEDataset == null ? null : createSPICEDataset.toString());
            return this;
        }

        public final String getExportToPdfInScheduledReports() {
            return exportToPdfInScheduledReports;
        }

        public final void setExportToPdfInScheduledReports(String exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports = exportToPdfInScheduledReports;
        }

        @Override
        public final Builder exportToPdfInScheduledReports(String exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports = exportToPdfInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToPdfInScheduledReports(CapabilityState exportToPdfInScheduledReports) {
            this.exportToPdfInScheduledReports(exportToPdfInScheduledReports == null ? null : exportToPdfInScheduledReports
                    .toString());
            return this;
        }

        public final String getExportToCsvInScheduledReports() {
            return exportToCsvInScheduledReports;
        }

        public final void setExportToCsvInScheduledReports(String exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports = exportToCsvInScheduledReports;
        }

        @Override
        public final Builder exportToCsvInScheduledReports(String exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports = exportToCsvInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToCsvInScheduledReports(CapabilityState exportToCsvInScheduledReports) {
            this.exportToCsvInScheduledReports(exportToCsvInScheduledReports == null ? null : exportToCsvInScheduledReports
                    .toString());
            return this;
        }

        public final String getExportToExcelInScheduledReports() {
            return exportToExcelInScheduledReports;
        }

        public final void setExportToExcelInScheduledReports(String exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports = exportToExcelInScheduledReports;
        }

        @Override
        public final Builder exportToExcelInScheduledReports(String exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports = exportToExcelInScheduledReports;
            return this;
        }

        @Override
        public final Builder exportToExcelInScheduledReports(CapabilityState exportToExcelInScheduledReports) {
            this.exportToExcelInScheduledReports(exportToExcelInScheduledReports == null ? null : exportToExcelInScheduledReports
                    .toString());
            return this;
        }

        public final String getIncludeContentInScheduledReportsEmail() {
            return includeContentInScheduledReportsEmail;
        }

        public final void setIncludeContentInScheduledReportsEmail(String includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail = includeContentInScheduledReportsEmail;
        }

        @Override
        public final Builder includeContentInScheduledReportsEmail(String includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail = includeContentInScheduledReportsEmail;
            return this;
        }

        @Override
        public final Builder includeContentInScheduledReportsEmail(CapabilityState includeContentInScheduledReportsEmail) {
            this.includeContentInScheduledReportsEmail(includeContentInScheduledReportsEmail == null ? null
                    : includeContentInScheduledReportsEmail.toString());
            return this;
        }

        public final String getDashboard() {
            return dashboard;
        }

        public final void setDashboard(String dashboard) {
            this.dashboard = dashboard;
        }

        @Override
        public final Builder dashboard(String dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        @Override
        public final Builder dashboard(CapabilityState dashboard) {
            this.dashboard(dashboard == null ? null : dashboard.toString());
            return this;
        }

        public final String getAnalysis() {
            return analysis;
        }

        public final void setAnalysis(String analysis) {
            this.analysis = analysis;
        }

        @Override
        public final Builder analysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        @Override
        public final Builder analysis(CapabilityState analysis) {
            this.analysis(analysis == null ? null : analysis.toString());
            return this;
        }

        public final String getAutomate() {
            return automate;
        }

        public final void setAutomate(String automate) {
            this.automate = automate;
        }

        @Override
        public final Builder automate(String automate) {
            this.automate = automate;
            return this;
        }

        @Override
        public final Builder automate(CapabilityState automate) {
            this.automate(automate == null ? null : automate.toString());
            return this;
        }

        public final String getFlow() {
            return flow;
        }

        public final void setFlow(String flow) {
            this.flow = flow;
        }

        @Override
        public final Builder flow(String flow) {
            this.flow = flow;
            return this;
        }

        @Override
        public final Builder flow(CapabilityState flow) {
            this.flow(flow == null ? null : flow.toString());
            return this;
        }

        public final String getPublishWithoutApproval() {
            return publishWithoutApproval;
        }

        public final void setPublishWithoutApproval(String publishWithoutApproval) {
            this.publishWithoutApproval = publishWithoutApproval;
        }

        @Override
        public final Builder publishWithoutApproval(String publishWithoutApproval) {
            this.publishWithoutApproval = publishWithoutApproval;
            return this;
        }

        @Override
        public final Builder publishWithoutApproval(CapabilityState publishWithoutApproval) {
            this.publishWithoutApproval(publishWithoutApproval == null ? null : publishWithoutApproval.toString());
            return this;
        }

        public final String getUseBedrockModels() {
            return useBedrockModels;
        }

        public final void setUseBedrockModels(String useBedrockModels) {
            this.useBedrockModels = useBedrockModels;
        }

        @Override
        public final Builder useBedrockModels(String useBedrockModels) {
            this.useBedrockModels = useBedrockModels;
            return this;
        }

        @Override
        public final Builder useBedrockModels(CapabilityState useBedrockModels) {
            this.useBedrockModels(useBedrockModels == null ? null : useBedrockModels.toString());
            return this;
        }

        public final String getPerformFlowUiTask() {
            return performFlowUiTask;
        }

        public final void setPerformFlowUiTask(String performFlowUiTask) {
            this.performFlowUiTask = performFlowUiTask;
        }

        @Override
        public final Builder performFlowUiTask(String performFlowUiTask) {
            this.performFlowUiTask = performFlowUiTask;
            return this;
        }

        @Override
        public final Builder performFlowUiTask(CapabilityState performFlowUiTask) {
            this.performFlowUiTask(performFlowUiTask == null ? null : performFlowUiTask.toString());
            return this;
        }

        public final String getUseAgentWebSearch() {
            return useAgentWebSearch;
        }

        public final void setUseAgentWebSearch(String useAgentWebSearch) {
            this.useAgentWebSearch = useAgentWebSearch;
        }

        @Override
        public final Builder useAgentWebSearch(String useAgentWebSearch) {
            this.useAgentWebSearch = useAgentWebSearch;
            return this;
        }

        @Override
        public final Builder useAgentWebSearch(CapabilityState useAgentWebSearch) {
            this.useAgentWebSearch(useAgentWebSearch == null ? null : useAgentWebSearch.toString());
            return this;
        }

        public final String getKnowledgeBase() {
            return knowledgeBase;
        }

        public final void setKnowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
        }

        @Override
        public final Builder knowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        @Override
        public final Builder knowledgeBase(CapabilityState knowledgeBase) {
            this.knowledgeBase(knowledgeBase == null ? null : knowledgeBase.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(CapabilityState action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getSpace() {
            return space;
        }

        public final void setSpace(String space) {
            this.space = space;
        }

        @Override
        public final Builder space(String space) {
            this.space = space;
            return this;
        }

        @Override
        public final Builder space(CapabilityState space) {
            this.space(space == null ? null : space.toString());
            return this;
        }

        public final String getChatAgent() {
            return chatAgent;
        }

        public final void setChatAgent(String chatAgent) {
            this.chatAgent = chatAgent;
        }

        @Override
        public final Builder chatAgent(String chatAgent) {
            this.chatAgent = chatAgent;
            return this;
        }

        @Override
        public final Builder chatAgent(CapabilityState chatAgent) {
            this.chatAgent(chatAgent == null ? null : chatAgent.toString());
            return this;
        }

        public final String getCreateChatAgents() {
            return createChatAgents;
        }

        public final void setCreateChatAgents(String createChatAgents) {
            this.createChatAgents = createChatAgents;
        }

        @Override
        public final Builder createChatAgents(String createChatAgents) {
            this.createChatAgents = createChatAgents;
            return this;
        }

        @Override
        public final Builder createChatAgents(CapabilityState createChatAgents) {
            this.createChatAgents(createChatAgents == null ? null : createChatAgents.toString());
            return this;
        }

        public final String getResearch() {
            return research;
        }

        public final void setResearch(String research) {
            this.research = research;
        }

        @Override
        public final Builder research(String research) {
            this.research = research;
            return this;
        }

        @Override
        public final Builder research(CapabilityState research) {
            this.research(research == null ? null : research.toString());
            return this;
        }

        @Override
        public Capabilities build() {
            return new Capabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
