/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for OAuth 2.0 client credentials grant authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientCredentialsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientCredentialsDetails.Builder, ClientCredentialsDetails> {
    private static final SdkField<ClientCredentialsGrantDetails> CLIENT_CREDENTIALS_GRANT_DETAILS_FIELD = SdkField
            .<ClientCredentialsGrantDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ClientCredentialsGrantDetails")
            .getter(getter(ClientCredentialsDetails::clientCredentialsGrantDetails))
            .setter(setter(Builder::clientCredentialsGrantDetails))
            .constructor(ClientCredentialsGrantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsGrantDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLIENT_CREDENTIALS_GRANT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ClientCredentialsGrantDetails clientCredentialsGrantDetails;

    private final Type type;

    private ClientCredentialsDetails(BuilderImpl builder) {
        this.clientCredentialsGrantDetails = builder.clientCredentialsGrantDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The OAuth2 client credentials grant configuration details for authentication.
     * </p>
     * 
     * @return The OAuth2 client credentials grant configuration details for authentication.
     */
    public final ClientCredentialsGrantDetails clientCredentialsGrantDetails() {
        return clientCredentialsGrantDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientCredentialsGrantDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientCredentialsDetails)) {
            return false;
        }
        ClientCredentialsDetails other = (ClientCredentialsDetails) obj;
        return Objects.equals(clientCredentialsGrantDetails(), other.clientCredentialsGrantDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientCredentialsDetails").add("ClientCredentialsGrantDetails", clientCredentialsGrantDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientCredentialsGrantDetails":
            return Optional.ofNullable(clazz.cast(clientCredentialsGrantDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #clientCredentialsGrantDetails()} initialized to the given value.
     *
     * <p>
     * The OAuth2 client credentials grant configuration details for authentication.
     * </p>
     * 
     * @param clientCredentialsGrantDetails
     *        The OAuth2 client credentials grant configuration details for authentication.
     */
    public static ClientCredentialsDetails fromClientCredentialsGrantDetails(
            ClientCredentialsGrantDetails clientCredentialsGrantDetails) {
        return builder().clientCredentialsGrantDetails(clientCredentialsGrantDetails).build();
    }

    /**
     * Create an instance of this class with {@link #clientCredentialsGrantDetails()} initialized to the given value.
     *
     * <p>
     * The OAuth2 client credentials grant configuration details for authentication.
     * </p>
     * 
     * @param clientCredentialsGrantDetails
     *        The OAuth2 client credentials grant configuration details for authentication.
     */
    public static ClientCredentialsDetails fromClientCredentialsGrantDetails(
            Consumer<ClientCredentialsGrantDetails.Builder> clientCredentialsGrantDetails) {
        ClientCredentialsGrantDetails.Builder builder = ClientCredentialsGrantDetails.builder();
        clientCredentialsGrantDetails.accept(builder);
        return fromClientCredentialsGrantDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientCredentialsGrantDetails", CLIENT_CREDENTIALS_GRANT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientCredentialsDetails, T> g) {
        return obj -> g.apply((ClientCredentialsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientCredentialsDetails> {
        /**
         * <p>
         * The OAuth2 client credentials grant configuration details for authentication.
         * </p>
         * 
         * @param clientCredentialsGrantDetails
         *        The OAuth2 client credentials grant configuration details for authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCredentialsGrantDetails(ClientCredentialsGrantDetails clientCredentialsGrantDetails);

        /**
         * <p>
         * The OAuth2 client credentials grant configuration details for authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientCredentialsGrantDetails.Builder}
         * avoiding the need to create one manually via {@link ClientCredentialsGrantDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientCredentialsGrantDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #clientCredentialsGrantDetails(ClientCredentialsGrantDetails)}.
         * 
         * @param clientCredentialsGrantDetails
         *        a consumer that will call methods on {@link ClientCredentialsGrantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientCredentialsGrantDetails(ClientCredentialsGrantDetails)
         */
        default Builder clientCredentialsGrantDetails(
                Consumer<ClientCredentialsGrantDetails.Builder> clientCredentialsGrantDetails) {
            return clientCredentialsGrantDetails(ClientCredentialsGrantDetails.builder()
                    .applyMutation(clientCredentialsGrantDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClientCredentialsGrantDetails clientCredentialsGrantDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ClientCredentialsDetails model) {
            clientCredentialsGrantDetails(model.clientCredentialsGrantDetails);
        }

        public final ClientCredentialsGrantDetails.Builder getClientCredentialsGrantDetails() {
            return clientCredentialsGrantDetails != null ? clientCredentialsGrantDetails.toBuilder() : null;
        }

        public final void setClientCredentialsGrantDetails(ClientCredentialsGrantDetails.BuilderImpl clientCredentialsGrantDetails) {
            Object oldValue = this.clientCredentialsGrantDetails;
            this.clientCredentialsGrantDetails = clientCredentialsGrantDetails != null ? clientCredentialsGrantDetails.build()
                    : null;
            handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_DETAILS, oldValue, this.clientCredentialsGrantDetails);
        }

        @Override
        public final Builder clientCredentialsGrantDetails(ClientCredentialsGrantDetails clientCredentialsGrantDetails) {
            Object oldValue = this.clientCredentialsGrantDetails;
            this.clientCredentialsGrantDetails = clientCredentialsGrantDetails;
            handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_DETAILS, oldValue, this.clientCredentialsGrantDetails);
            return this;
        }

        @Override
        public ClientCredentialsDetails build() {
            return new ClientCredentialsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ClientCredentialsDetails#type()
     */
    public enum Type {
        CLIENT_CREDENTIALS_GRANT_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
