/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contextual accent palette.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContextualAccentPalette implements SdkPojo, Serializable,
        ToCopyableBuilder<ContextualAccentPalette.Builder, ContextualAccentPalette> {
    private static final SdkField<Palette> CONNECTION_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Connection").getter(getter(ContextualAccentPalette::connection)).setter(setter(Builder::connection))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connection").build()).build();

    private static final SdkField<Palette> VISUALIZATION_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Visualization").getter(getter(ContextualAccentPalette::visualization))
            .setter(setter(Builder::visualization)).constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visualization").build()).build();

    private static final SdkField<Palette> INSIGHT_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Insight").getter(getter(ContextualAccentPalette::insight)).setter(setter(Builder::insight))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()).build();

    private static final SdkField<Palette> AUTOMATION_FIELD = SdkField.<Palette> builder(MarshallingType.SDK_POJO)
            .memberName("Automation").getter(getter(ContextualAccentPalette::automation)).setter(setter(Builder::automation))
            .constructor(Palette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FIELD,
            VISUALIZATION_FIELD, INSIGHT_FIELD, AUTOMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Palette connection;

    private final Palette visualization;

    private final Palette insight;

    private final Palette automation;

    private ContextualAccentPalette(BuilderImpl builder) {
        this.connection = builder.connection;
        this.visualization = builder.visualization;
        this.insight = builder.insight;
        this.automation = builder.automation;
    }

    /**
     * Returns the value of the Connection property for this object.
     * 
     * @return The value of the Connection property for this object.
     */
    public final Palette connection() {
        return connection;
    }

    /**
     * Returns the value of the Visualization property for this object.
     * 
     * @return The value of the Visualization property for this object.
     */
    public final Palette visualization() {
        return visualization;
    }

    /**
     * Returns the value of the Insight property for this object.
     * 
     * @return The value of the Insight property for this object.
     */
    public final Palette insight() {
        return insight;
    }

    /**
     * Returns the value of the Automation property for this object.
     * 
     * @return The value of the Automation property for this object.
     */
    public final Palette automation() {
        return automation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connection());
        hashCode = 31 * hashCode + Objects.hashCode(visualization());
        hashCode = 31 * hashCode + Objects.hashCode(insight());
        hashCode = 31 * hashCode + Objects.hashCode(automation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextualAccentPalette)) {
            return false;
        }
        ContextualAccentPalette other = (ContextualAccentPalette) obj;
        return Objects.equals(connection(), other.connection()) && Objects.equals(visualization(), other.visualization())
                && Objects.equals(insight(), other.insight()) && Objects.equals(automation(), other.automation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContextualAccentPalette").add("Connection", connection()).add("Visualization", visualization())
                .add("Insight", insight()).add("Automation", automation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connection":
            return Optional.ofNullable(clazz.cast(connection()));
        case "Visualization":
            return Optional.ofNullable(clazz.cast(visualization()));
        case "Insight":
            return Optional.ofNullable(clazz.cast(insight()));
        case "Automation":
            return Optional.ofNullable(clazz.cast(automation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Connection", CONNECTION_FIELD);
        map.put("Visualization", VISUALIZATION_FIELD);
        map.put("Insight", INSIGHT_FIELD);
        map.put("Automation", AUTOMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContextualAccentPalette, T> g) {
        return obj -> g.apply((ContextualAccentPalette) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContextualAccentPalette> {
        /**
         * Sets the value of the Connection property for this object.
         *
         * @param connection
         *        The new value for the Connection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connection(Palette connection);

        /**
         * Sets the value of the Connection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #connection(Palette)}.
         * 
         * @param connection
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connection(Palette)
         */
        default Builder connection(Consumer<Palette.Builder> connection) {
            return connection(Palette.builder().applyMutation(connection).build());
        }

        /**
         * Sets the value of the Visualization property for this object.
         *
         * @param visualization
         *        The new value for the Visualization property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualization(Palette visualization);

        /**
         * Sets the value of the Visualization property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #visualization(Palette)}.
         * 
         * @param visualization
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualization(Palette)
         */
        default Builder visualization(Consumer<Palette.Builder> visualization) {
            return visualization(Palette.builder().applyMutation(visualization).build());
        }

        /**
         * Sets the value of the Insight property for this object.
         *
         * @param insight
         *        The new value for the Insight property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insight(Palette insight);

        /**
         * Sets the value of the Insight property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #insight(Palette)}.
         * 
         * @param insight
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insight(Palette)
         */
        default Builder insight(Consumer<Palette.Builder> insight) {
            return insight(Palette.builder().applyMutation(insight).build());
        }

        /**
         * Sets the value of the Automation property for this object.
         *
         * @param automation
         *        The new value for the Automation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automation(Palette automation);

        /**
         * Sets the value of the Automation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Palette.Builder} avoiding the need to
         * create one manually via {@link Palette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Palette.Builder#build()} is called immediately and its result is
         * passed to {@link #automation(Palette)}.
         * 
         * @param automation
         *        a consumer that will call methods on {@link Palette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automation(Palette)
         */
        default Builder automation(Consumer<Palette.Builder> automation) {
            return automation(Palette.builder().applyMutation(automation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Palette connection;

        private Palette visualization;

        private Palette insight;

        private Palette automation;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextualAccentPalette model) {
            connection(model.connection);
            visualization(model.visualization);
            insight(model.insight);
            automation(model.automation);
        }

        public final Palette.Builder getConnection() {
            return connection != null ? connection.toBuilder() : null;
        }

        public final void setConnection(Palette.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        public final Builder connection(Palette connection) {
            this.connection = connection;
            return this;
        }

        public final Palette.Builder getVisualization() {
            return visualization != null ? visualization.toBuilder() : null;
        }

        public final void setVisualization(Palette.BuilderImpl visualization) {
            this.visualization = visualization != null ? visualization.build() : null;
        }

        @Override
        public final Builder visualization(Palette visualization) {
            this.visualization = visualization;
            return this;
        }

        public final Palette.Builder getInsight() {
            return insight != null ? insight.toBuilder() : null;
        }

        public final void setInsight(Palette.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        public final Builder insight(Palette insight) {
            this.insight = insight;
            return this;
        }

        public final Palette.Builder getAutomation() {
            return automation != null ? automation.toBuilder() : null;
        }

        public final void setAutomation(Palette.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        @Override
        public final Builder automation(Palette automation) {
            this.automation = automation;
            return this;
        }

        @Override
        public ContextualAccentPalette build() {
            return new ContextualAccentPalette(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
