/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTemplateRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateTemplateRequest.Builder, CreateTemplateRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateTemplateRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(CreateTemplateRequest::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(CreateTemplateRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TemplateSourceEntity> SOURCE_ENTITY_FIELD = SdkField
            .<TemplateSourceEntity> builder(MarshallingType.SDK_POJO).memberName("SourceEntity")
            .getter(getter(CreateTemplateRequest::sourceEntity)).setter(setter(Builder::sourceEntity))
            .constructor(TemplateSourceEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(CreateTemplateRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<TemplateVersionDefinition> DEFINITION_FIELD = SdkField
            .<TemplateVersionDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(CreateTemplateRequest::definition)).setter(setter(Builder::definition))
            .constructor(TemplateVersionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<ValidationStrategy> VALIDATION_STRATEGY_FIELD = SdkField
            .<ValidationStrategy> builder(MarshallingType.SDK_POJO).memberName("ValidationStrategy")
            .getter(getter(CreateTemplateRequest::validationStrategy)).setter(setter(Builder::validationStrategy))
            .constructor(ValidationStrategy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            TEMPLATE_ID_FIELD, NAME_FIELD, PERMISSIONS_FIELD, SOURCE_ENTITY_FIELD, TAGS_FIELD, VERSION_DESCRIPTION_FIELD,
            DEFINITION_FIELD, VALIDATION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String templateId;

    private final String name;

    private final List<ResourcePermission> permissions;

    private final TemplateSourceEntity sourceEntity;

    private final List<Tag> tags;

    private final String versionDescription;

    private final TemplateVersionDefinition definition;

    private final ValidationStrategy validationStrategy;

    private CreateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.permissions = builder.permissions;
        this.sourceEntity = builder.sourceEntity;
        this.tags = builder.tags;
        this.versionDescription = builder.versionDescription;
        this.definition = builder.definition;
        this.validationStrategy = builder.validationStrategy;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services
     * account that contains your Amazon Quick Sight account.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web
     *         Services account that contains your Amazon Quick Sight account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each
     * Amazon Web Services account.
     * </p>
     * 
     * @return An ID for the template that you want to create. This template is unique per Amazon Web Services Region;
     *         in each Amazon Web Services account.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * A display name for the template.
     * </p>
     * 
     * @return A display name for the template.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource permissions to be set on the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return A list of resource permissions to be set on the template.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you specify
     * the type of object you're using as source: <code>SourceTemplate</code> for a template or
     * <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
     * <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify the
     * ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services account and
     * any Quick Sight-supported Amazon Web Services Region.
     * </p>
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or <code>SourceAnalysis</code>
     * to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must
     * match its placeholder.
     * </p>
     * <p>
     * Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to be
     * valid.
     * </p>
     * 
     * @return The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you
     *         specify the type of object you're using as source: <code>SourceTemplate</code> for a template or
     *         <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
     *         <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>,
     *         specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web
     *         Services account and any Quick Sight-supported Amazon Web Services Region. </p>
     *         <p>
     *         Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
     *         <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original.
     *         The schema in each dataset must match its placeholder.
     *         </p>
     *         <p>
     *         Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request
     *         to be valid.
     */
    public final TemplateSourceEntity sourceEntity() {
        return sourceEntity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A description of the current template version being created. This API operation creates the first version of the
     * template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the
     * template maintains a description of the version in the <code>VersionDescription</code> field.
     * </p>
     * 
     * @return A description of the current template version being created. This API operation creates the first version
     *         of the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version
     *         of the template maintains a description of the version in the <code>VersionDescription</code> field.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The definition of a template.
     * </p>
     * <p>
     * A definition is the data model of all features in a Dashboard, Template, or Analysis.
     * </p>
     * <p>
     * Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to be
     * valid.
     * </p>
     * 
     * @return The definition of a template.</p>
     *         <p>
     *         A definition is the data model of all features in a Dashboard, Template, or Analysis.
     *         </p>
     *         <p>
     *         Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request
     *         to be valid.
     */
    public final TemplateVersionDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * TThe option to relax the validation needed to create a template with definition objects. This skips the
     * validation step for specific errors.
     * </p>
     * 
     * @return TThe option to relax the validation needed to create a template with definition objects. This skips the
     *         validation step for specific errors.
     */
    public final ValidationStrategy validationStrategy() {
        return validationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(validationStrategy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateRequest)) {
            return false;
        }
        CreateTemplateRequest other = (CreateTemplateRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(name(), other.name()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions()) && Objects.equals(sourceEntity(), other.sourceEntity())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(definition(), other.definition())
                && Objects.equals(validationStrategy(), other.validationStrategy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTemplateRequest").add("AwsAccountId", awsAccountId()).add("TemplateId", templateId())
                .add("Name", name()).add("Permissions", hasPermissions() ? permissions() : null)
                .add("SourceEntity", sourceEntity()).add("Tags", hasTags() ? tags() : null)
                .add("VersionDescription", versionDescription()).add("Definition", definition())
                .add("ValidationStrategy", validationStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "SourceEntity":
            return Optional.ofNullable(clazz.cast(sourceEntity()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "ValidationStrategy":
            return Optional.ofNullable(clazz.cast(validationStrategy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("TemplateId", TEMPLATE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("SourceEntity", SOURCE_ENTITY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("ValidationStrategy", VALIDATION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateRequest, T> g) {
        return obj -> g.apply((CreateTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTemplateRequest> {
        /**
         * <p>
         * The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services
         * account that contains your Amazon Quick Sight account.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web
         *        Services account that contains your Amazon Quick Sight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in
         * each Amazon Web Services account.
         * </p>
         * 
         * @param templateId
         *        An ID for the template that you want to create. This template is unique per Amazon Web Services
         *        Region; in each Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * A display name for the template.
         * </p>
         * 
         * @param name
         *        A display name for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions to be set on the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions to be set on the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A list of resource permissions to be set on the template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder#build()} is called
         * immediately and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(java.util.Collection<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you
         * specify the type of object you're using as source: <code>SourceTemplate</code> for a template or
         * <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
         * <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify
         * the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services
         * account and any Quick Sight-supported Amazon Web Services Region.
         * </p>
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
         * <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The
         * schema in each dataset must match its placeholder.
         * </p>
         * <p>
         * Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to
         * be valid.
         * </p>
         * 
         * @param sourceEntity
         *        The entity that you are using as a source when you create the template. In <code>SourceEntity</code>,
         *        you specify the type of object you're using as source: <code>SourceTemplate</code> for a template or
         *        <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
         *        <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>,
         *        specify the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web
         *        Services account and any Quick Sight-supported Amazon Web Services Region. </p>
         *        <p>
         *        Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
         *        <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the
         *        original. The schema in each dataset must match its placeholder.
         *        </p>
         *        <p>
         *        Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the
         *        request to be valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntity(TemplateSourceEntity sourceEntity);

        /**
         * <p>
         * The entity that you are using as a source when you create the template. In <code>SourceEntity</code>, you
         * specify the type of object you're using as source: <code>SourceTemplate</code> for a template or
         * <code>SourceAnalysis</code> for an analysis. Both of these require an Amazon Resource Name (ARN). For
         * <code>SourceTemplate</code>, specify the ARN of the source template. For <code>SourceAnalysis</code>, specify
         * the ARN of the source analysis. The <code>SourceTemplate</code> ARN can contain any Amazon Web Services
         * account and any Quick Sight-supported Amazon Web Services Region.
         * </p>
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> or
         * <code>SourceAnalysis</code> to list the replacement datasets for the placeholders listed in the original. The
         * schema in each dataset must match its placeholder.
         * </p>
         * <p>
         * Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to
         * be valid.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateSourceEntity.Builder} avoiding
         * the need to create one manually via {@link TemplateSourceEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateSourceEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceEntity(TemplateSourceEntity)}.
         * 
         * @param sourceEntity
         *        a consumer that will call methods on {@link TemplateSourceEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEntity(TemplateSourceEntity)
         */
        default Builder sourceEntity(Consumer<TemplateSourceEntity.Builder> sourceEntity) {
            return sourceEntity(TemplateSourceEntity.builder().applyMutation(sourceEntity).build());
        }

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.quicksight.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A description of the current template version being created. This API operation creates the first version of
         * the template. Every time <code>UpdateTemplate</code> is called, a new version is created. Each version of the
         * template maintains a description of the version in the <code>VersionDescription</code> field.
         * </p>
         * 
         * @param versionDescription
         *        A description of the current template version being created. This API operation creates the first
         *        version of the template. Every time <code>UpdateTemplate</code> is called, a new version is created.
         *        Each version of the template maintains a description of the version in the
         *        <code>VersionDescription</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The definition of a template.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * <p>
         * Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to
         * be valid.
         * </p>
         * 
         * @param definition
         *        The definition of a template.</p>
         *        <p>
         *        A definition is the data model of all features in a Dashboard, Template, or Analysis.
         *        </p>
         *        <p>
         *        Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the
         *        request to be valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(TemplateVersionDefinition definition);

        /**
         * <p>
         * The definition of a template.
         * </p>
         * <p>
         * A definition is the data model of all features in a Dashboard, Template, or Analysis.
         * </p>
         * <p>
         * Either a <code>SourceEntity</code> or a <code>Definition</code> must be provided in order for the request to
         * be valid.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateVersionDefinition.Builder}
         * avoiding the need to create one manually via {@link TemplateVersionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TemplateVersionDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(TemplateVersionDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link TemplateVersionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(TemplateVersionDefinition)
         */
        default Builder definition(Consumer<TemplateVersionDefinition.Builder> definition) {
            return definition(TemplateVersionDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * TThe option to relax the validation needed to create a template with definition objects. This skips the
         * validation step for specific errors.
         * </p>
         * 
         * @param validationStrategy
         *        TThe option to relax the validation needed to create a template with definition objects. This skips
         *        the validation step for specific errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStrategy(ValidationStrategy validationStrategy);

        /**
         * <p>
         * TThe option to relax the validation needed to create a template with definition objects. This skips the
         * validation step for specific errors.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValidationStrategy.Builder} avoiding the
         * need to create one manually via {@link ValidationStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationStrategy.Builder#build()} is called immediately and its
         * result is passed to {@link #validationStrategy(ValidationStrategy)}.
         * 
         * @param validationStrategy
         *        a consumer that will call methods on {@link ValidationStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationStrategy(ValidationStrategy)
         */
        default Builder validationStrategy(Consumer<ValidationStrategy.Builder> validationStrategy) {
            return validationStrategy(ValidationStrategy.builder().applyMutation(validationStrategy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String templateId;

        private String name;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private TemplateSourceEntity sourceEntity;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String versionDescription;

        private TemplateVersionDefinition definition;

        private ValidationStrategy validationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            templateId(model.templateId);
            name(model.name);
            permissions(model.permissions);
            sourceEntity(model.sourceEntity);
            tags(model.tags);
            versionDescription(model.versionDescription);
            definition(model.definition);
            validationStrategy(model.validationStrategy);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TemplateSourceEntity.Builder getSourceEntity() {
            return sourceEntity != null ? sourceEntity.toBuilder() : null;
        }

        public final void setSourceEntity(TemplateSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        @Override
        public final Builder sourceEntity(TemplateSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final TemplateVersionDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateVersionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateVersionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final ValidationStrategy.Builder getValidationStrategy() {
            return validationStrategy != null ? validationStrategy.toBuilder() : null;
        }

        public final void setValidationStrategy(ValidationStrategy.BuilderImpl validationStrategy) {
            this.validationStrategy = validationStrategy != null ? validationStrategy.build() : null;
        }

        @Override
        public final Builder validationStrategy(ValidationStrategy validationStrategy) {
            this.validationStrategy = validationStrategy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTemplateRequest build() {
            return new CreateTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
