/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dashboard publish options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardPublishOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardPublishOptions.Builder, DashboardPublishOptions> {
    private static final SdkField<AdHocFilteringOption> AD_HOC_FILTERING_OPTION_FIELD = SdkField
            .<AdHocFilteringOption> builder(MarshallingType.SDK_POJO).memberName("AdHocFilteringOption")
            .getter(getter(DashboardPublishOptions::adHocFilteringOption)).setter(setter(Builder::adHocFilteringOption))
            .constructor(AdHocFilteringOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdHocFilteringOption").build())
            .build();

    private static final SdkField<ExportToCSVOption> EXPORT_TO_CSV_OPTION_FIELD = SdkField
            .<ExportToCSVOption> builder(MarshallingType.SDK_POJO).memberName("ExportToCSVOption")
            .getter(getter(DashboardPublishOptions::exportToCSVOption)).setter(setter(Builder::exportToCSVOption))
            .constructor(ExportToCSVOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCSVOption").build()).build();

    private static final SdkField<SheetControlsOption> SHEET_CONTROLS_OPTION_FIELD = SdkField
            .<SheetControlsOption> builder(MarshallingType.SDK_POJO).memberName("SheetControlsOption")
            .getter(getter(DashboardPublishOptions::sheetControlsOption)).setter(setter(Builder::sheetControlsOption))
            .constructor(SheetControlsOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetControlsOption").build())
            .build();

    private static final SdkField<DashboardVisualPublishOptions> VISUAL_PUBLISH_OPTIONS_FIELD = SdkField
            .<DashboardVisualPublishOptions> builder(MarshallingType.SDK_POJO).memberName("VisualPublishOptions")
            .getter(getter(DashboardPublishOptions::visualPublishOptions)).setter(setter(Builder::visualPublishOptions))
            .constructor(DashboardVisualPublishOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPublishOptions").build())
            .build();

    private static final SdkField<SheetLayoutElementMaximizationOption> SHEET_LAYOUT_ELEMENT_MAXIMIZATION_OPTION_FIELD = SdkField
            .<SheetLayoutElementMaximizationOption> builder(MarshallingType.SDK_POJO)
            .memberName("SheetLayoutElementMaximizationOption")
            .getter(getter(DashboardPublishOptions::sheetLayoutElementMaximizationOption))
            .setter(setter(Builder::sheetLayoutElementMaximizationOption))
            .constructor(SheetLayoutElementMaximizationOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SheetLayoutElementMaximizationOption").build()).build();

    private static final SdkField<VisualMenuOption> VISUAL_MENU_OPTION_FIELD = SdkField
            .<VisualMenuOption> builder(MarshallingType.SDK_POJO).memberName("VisualMenuOption")
            .getter(getter(DashboardPublishOptions::visualMenuOption)).setter(setter(Builder::visualMenuOption))
            .constructor(VisualMenuOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualMenuOption").build()).build();

    private static final SdkField<VisualAxisSortOption> VISUAL_AXIS_SORT_OPTION_FIELD = SdkField
            .<VisualAxisSortOption> builder(MarshallingType.SDK_POJO).memberName("VisualAxisSortOption")
            .getter(getter(DashboardPublishOptions::visualAxisSortOption)).setter(setter(Builder::visualAxisSortOption))
            .constructor(VisualAxisSortOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualAxisSortOption").build())
            .build();

    private static final SdkField<ExportWithHiddenFieldsOption> EXPORT_WITH_HIDDEN_FIELDS_OPTION_FIELD = SdkField
            .<ExportWithHiddenFieldsOption> builder(MarshallingType.SDK_POJO)
            .memberName("ExportWithHiddenFieldsOption")
            .getter(getter(DashboardPublishOptions::exportWithHiddenFieldsOption))
            .setter(setter(Builder::exportWithHiddenFieldsOption))
            .constructor(ExportWithHiddenFieldsOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportWithHiddenFieldsOption")
                    .build()).build();

    private static final SdkField<DataPointDrillUpDownOption> DATA_POINT_DRILL_UP_DOWN_OPTION_FIELD = SdkField
            .<DataPointDrillUpDownOption> builder(MarshallingType.SDK_POJO)
            .memberName("DataPointDrillUpDownOption")
            .getter(getter(DashboardPublishOptions::dataPointDrillUpDownOption))
            .setter(setter(Builder::dataPointDrillUpDownOption))
            .constructor(DataPointDrillUpDownOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPointDrillUpDownOption").build())
            .build();

    private static final SdkField<DataPointMenuLabelOption> DATA_POINT_MENU_LABEL_OPTION_FIELD = SdkField
            .<DataPointMenuLabelOption> builder(MarshallingType.SDK_POJO).memberName("DataPointMenuLabelOption")
            .getter(getter(DashboardPublishOptions::dataPointMenuLabelOption)).setter(setter(Builder::dataPointMenuLabelOption))
            .constructor(DataPointMenuLabelOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPointMenuLabelOption").build())
            .build();

    private static final SdkField<DataPointTooltipOption> DATA_POINT_TOOLTIP_OPTION_FIELD = SdkField
            .<DataPointTooltipOption> builder(MarshallingType.SDK_POJO).memberName("DataPointTooltipOption")
            .getter(getter(DashboardPublishOptions::dataPointTooltipOption)).setter(setter(Builder::dataPointTooltipOption))
            .constructor(DataPointTooltipOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPointTooltipOption").build())
            .build();

    private static final SdkField<DataQAEnabledOption> DATA_QA_ENABLED_OPTION_FIELD = SdkField
            .<DataQAEnabledOption> builder(MarshallingType.SDK_POJO).memberName("DataQAEnabledOption")
            .getter(getter(DashboardPublishOptions::dataQAEnabledOption)).setter(setter(Builder::dataQAEnabledOption))
            .constructor(DataQAEnabledOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQAEnabledOption").build())
            .build();

    private static final SdkField<QuickSuiteActionsOption> QUICK_SUITE_ACTIONS_OPTION_FIELD = SdkField
            .<QuickSuiteActionsOption> builder(MarshallingType.SDK_POJO).memberName("QuickSuiteActionsOption")
            .getter(getter(DashboardPublishOptions::quickSuiteActionsOption)).setter(setter(Builder::quickSuiteActionsOption))
            .constructor(QuickSuiteActionsOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickSuiteActionsOption").build())
            .build();

    private static final SdkField<ExecutiveSummaryOption> EXECUTIVE_SUMMARY_OPTION_FIELD = SdkField
            .<ExecutiveSummaryOption> builder(MarshallingType.SDK_POJO).memberName("ExecutiveSummaryOption")
            .getter(getter(DashboardPublishOptions::executiveSummaryOption)).setter(setter(Builder::executiveSummaryOption))
            .constructor(ExecutiveSummaryOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutiveSummaryOption").build())
            .build();

    private static final SdkField<DataStoriesSharingOption> DATA_STORIES_SHARING_OPTION_FIELD = SdkField
            .<DataStoriesSharingOption> builder(MarshallingType.SDK_POJO).memberName("DataStoriesSharingOption")
            .getter(getter(DashboardPublishOptions::dataStoriesSharingOption)).setter(setter(Builder::dataStoriesSharingOption))
            .constructor(DataStoriesSharingOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStoriesSharingOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_HOC_FILTERING_OPTION_FIELD,
            EXPORT_TO_CSV_OPTION_FIELD, SHEET_CONTROLS_OPTION_FIELD, VISUAL_PUBLISH_OPTIONS_FIELD,
            SHEET_LAYOUT_ELEMENT_MAXIMIZATION_OPTION_FIELD, VISUAL_MENU_OPTION_FIELD, VISUAL_AXIS_SORT_OPTION_FIELD,
            EXPORT_WITH_HIDDEN_FIELDS_OPTION_FIELD, DATA_POINT_DRILL_UP_DOWN_OPTION_FIELD, DATA_POINT_MENU_LABEL_OPTION_FIELD,
            DATA_POINT_TOOLTIP_OPTION_FIELD, DATA_QA_ENABLED_OPTION_FIELD, QUICK_SUITE_ACTIONS_OPTION_FIELD,
            EXECUTIVE_SUMMARY_OPTION_FIELD, DATA_STORIES_SHARING_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AdHocFilteringOption adHocFilteringOption;

    private final ExportToCSVOption exportToCSVOption;

    private final SheetControlsOption sheetControlsOption;

    private final DashboardVisualPublishOptions visualPublishOptions;

    private final SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption;

    private final VisualMenuOption visualMenuOption;

    private final VisualAxisSortOption visualAxisSortOption;

    private final ExportWithHiddenFieldsOption exportWithHiddenFieldsOption;

    private final DataPointDrillUpDownOption dataPointDrillUpDownOption;

    private final DataPointMenuLabelOption dataPointMenuLabelOption;

    private final DataPointTooltipOption dataPointTooltipOption;

    private final DataQAEnabledOption dataQAEnabledOption;

    private final QuickSuiteActionsOption quickSuiteActionsOption;

    private final ExecutiveSummaryOption executiveSummaryOption;

    private final DataStoriesSharingOption dataStoriesSharingOption;

    private DashboardPublishOptions(BuilderImpl builder) {
        this.adHocFilteringOption = builder.adHocFilteringOption;
        this.exportToCSVOption = builder.exportToCSVOption;
        this.sheetControlsOption = builder.sheetControlsOption;
        this.visualPublishOptions = builder.visualPublishOptions;
        this.sheetLayoutElementMaximizationOption = builder.sheetLayoutElementMaximizationOption;
        this.visualMenuOption = builder.visualMenuOption;
        this.visualAxisSortOption = builder.visualAxisSortOption;
        this.exportWithHiddenFieldsOption = builder.exportWithHiddenFieldsOption;
        this.dataPointDrillUpDownOption = builder.dataPointDrillUpDownOption;
        this.dataPointMenuLabelOption = builder.dataPointMenuLabelOption;
        this.dataPointTooltipOption = builder.dataPointTooltipOption;
        this.dataQAEnabledOption = builder.dataQAEnabledOption;
        this.quickSuiteActionsOption = builder.quickSuiteActionsOption;
        this.executiveSummaryOption = builder.executiveSummaryOption;
        this.dataStoriesSharingOption = builder.dataStoriesSharingOption;
    }

    /**
     * <p>
     * Ad hoc (one-time) filtering option.
     * </p>
     * 
     * @return Ad hoc (one-time) filtering option.
     */
    public final AdHocFilteringOption adHocFilteringOption() {
        return adHocFilteringOption;
    }

    /**
     * <p>
     * Export to .csv option.
     * </p>
     * 
     * @return Export to .csv option.
     */
    public final ExportToCSVOption exportToCSVOption() {
        return exportToCSVOption;
    }

    /**
     * <p>
     * Sheet controls option.
     * </p>
     * 
     * @return Sheet controls option.
     */
    public final SheetControlsOption sheetControlsOption() {
        return sheetControlsOption;
    }

    /**
     * <p>
     * The visual publish options of a visual in a dashboard.
     * </p>
     * 
     * @return The visual publish options of a visual in a dashboard.
     * @deprecated VisualPublishOptions property will reach its end of standard support in a future release. To perform
     *             this action, use ExportWithHiddenFields.
     */
    @Deprecated
    public final DashboardVisualPublishOptions visualPublishOptions() {
        return visualPublishOptions;
    }

    /**
     * <p>
     * The sheet layout maximization options of a dashbaord.
     * </p>
     * 
     * @return The sheet layout maximization options of a dashbaord.
     */
    public final SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption() {
        return sheetLayoutElementMaximizationOption;
    }

    /**
     * <p>
     * The menu options of a visual in a dashboard.
     * </p>
     * 
     * @return The menu options of a visual in a dashboard.
     */
    public final VisualMenuOption visualMenuOption() {
        return visualMenuOption;
    }

    /**
     * <p>
     * The axis sort options of a dashboard.
     * </p>
     * 
     * @return The axis sort options of a dashboard.
     */
    public final VisualAxisSortOption visualAxisSortOption() {
        return visualAxisSortOption;
    }

    /**
     * <p>
     * Determines if hidden fields are exported with a dashboard.
     * </p>
     * 
     * @return Determines if hidden fields are exported with a dashboard.
     */
    public final ExportWithHiddenFieldsOption exportWithHiddenFieldsOption() {
        return exportWithHiddenFieldsOption;
    }

    /**
     * <p>
     * The drill-down options of data points in a dashboard.
     * </p>
     * 
     * @return The drill-down options of data points in a dashboard.
     */
    public final DataPointDrillUpDownOption dataPointDrillUpDownOption() {
        return dataPointDrillUpDownOption;
    }

    /**
     * <p>
     * The data point menu label options of a dashboard.
     * </p>
     * 
     * @return The data point menu label options of a dashboard.
     */
    public final DataPointMenuLabelOption dataPointMenuLabelOption() {
        return dataPointMenuLabelOption;
    }

    /**
     * <p>
     * The data point tool tip options of a dashboard.
     * </p>
     * 
     * @return The data point tool tip options of a dashboard.
     */
    public final DataPointTooltipOption dataPointTooltipOption() {
        return dataPointTooltipOption;
    }

    /**
     * <p>
     * Adds Q&amp;A capabilities to an Quick Sight dashboard. If no topic is linked, Dashboard Q&amp;A uses the data
     * values that are rendered on the dashboard. End users can use Dashboard Q&amp;A to ask for different slices of the
     * data that they see on the dashboard. If a topic is linked, Topic Q&amp;A is used.
     * </p>
     * 
     * @return Adds Q&amp;A capabilities to an Quick Sight dashboard. If no topic is linked, Dashboard Q&amp;A uses the
     *         data values that are rendered on the dashboard. End users can use Dashboard Q&amp;A to ask for different
     *         slices of the data that they see on the dashboard. If a topic is linked, Topic Q&amp;A is used.
     */
    public final DataQAEnabledOption dataQAEnabledOption() {
        return dataQAEnabledOption;
    }

    /**
     * <p>
     * Determines if Actions in Amazon Quick Suite are enabled in a dashboard.
     * </p>
     * 
     * @return Determines if Actions in Amazon Quick Suite are enabled in a dashboard.
     */
    public final QuickSuiteActionsOption quickSuiteActionsOption() {
        return quickSuiteActionsOption;
    }

    /**
     * <p>
     * Executive summary option.
     * </p>
     * 
     * @return Executive summary option.
     */
    public final ExecutiveSummaryOption executiveSummaryOption() {
        return executiveSummaryOption;
    }

    /**
     * <p>
     * Data stories sharing option.
     * </p>
     * 
     * @return Data stories sharing option.
     */
    public final DataStoriesSharingOption dataStoriesSharingOption() {
        return dataStoriesSharingOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adHocFilteringOption());
        hashCode = 31 * hashCode + Objects.hashCode(exportToCSVOption());
        hashCode = 31 * hashCode + Objects.hashCode(sheetControlsOption());
        hashCode = 31 * hashCode + Objects.hashCode(visualPublishOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sheetLayoutElementMaximizationOption());
        hashCode = 31 * hashCode + Objects.hashCode(visualMenuOption());
        hashCode = 31 * hashCode + Objects.hashCode(visualAxisSortOption());
        hashCode = 31 * hashCode + Objects.hashCode(exportWithHiddenFieldsOption());
        hashCode = 31 * hashCode + Objects.hashCode(dataPointDrillUpDownOption());
        hashCode = 31 * hashCode + Objects.hashCode(dataPointMenuLabelOption());
        hashCode = 31 * hashCode + Objects.hashCode(dataPointTooltipOption());
        hashCode = 31 * hashCode + Objects.hashCode(dataQAEnabledOption());
        hashCode = 31 * hashCode + Objects.hashCode(quickSuiteActionsOption());
        hashCode = 31 * hashCode + Objects.hashCode(executiveSummaryOption());
        hashCode = 31 * hashCode + Objects.hashCode(dataStoriesSharingOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardPublishOptions)) {
            return false;
        }
        DashboardPublishOptions other = (DashboardPublishOptions) obj;
        return Objects.equals(adHocFilteringOption(), other.adHocFilteringOption())
                && Objects.equals(exportToCSVOption(), other.exportToCSVOption())
                && Objects.equals(sheetControlsOption(), other.sheetControlsOption())
                && Objects.equals(visualPublishOptions(), other.visualPublishOptions())
                && Objects.equals(sheetLayoutElementMaximizationOption(), other.sheetLayoutElementMaximizationOption())
                && Objects.equals(visualMenuOption(), other.visualMenuOption())
                && Objects.equals(visualAxisSortOption(), other.visualAxisSortOption())
                && Objects.equals(exportWithHiddenFieldsOption(), other.exportWithHiddenFieldsOption())
                && Objects.equals(dataPointDrillUpDownOption(), other.dataPointDrillUpDownOption())
                && Objects.equals(dataPointMenuLabelOption(), other.dataPointMenuLabelOption())
                && Objects.equals(dataPointTooltipOption(), other.dataPointTooltipOption())
                && Objects.equals(dataQAEnabledOption(), other.dataQAEnabledOption())
                && Objects.equals(quickSuiteActionsOption(), other.quickSuiteActionsOption())
                && Objects.equals(executiveSummaryOption(), other.executiveSummaryOption())
                && Objects.equals(dataStoriesSharingOption(), other.dataStoriesSharingOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashboardPublishOptions").add("AdHocFilteringOption", adHocFilteringOption())
                .add("ExportToCSVOption", exportToCSVOption()).add("SheetControlsOption", sheetControlsOption())
                .add("VisualPublishOptions", visualPublishOptions())
                .add("SheetLayoutElementMaximizationOption", sheetLayoutElementMaximizationOption())
                .add("VisualMenuOption", visualMenuOption()).add("VisualAxisSortOption", visualAxisSortOption())
                .add("ExportWithHiddenFieldsOption", exportWithHiddenFieldsOption())
                .add("DataPointDrillUpDownOption", dataPointDrillUpDownOption())
                .add("DataPointMenuLabelOption", dataPointMenuLabelOption())
                .add("DataPointTooltipOption", dataPointTooltipOption()).add("DataQAEnabledOption", dataQAEnabledOption())
                .add("QuickSuiteActionsOption", quickSuiteActionsOption())
                .add("ExecutiveSummaryOption", executiveSummaryOption())
                .add("DataStoriesSharingOption", dataStoriesSharingOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdHocFilteringOption":
            return Optional.ofNullable(clazz.cast(adHocFilteringOption()));
        case "ExportToCSVOption":
            return Optional.ofNullable(clazz.cast(exportToCSVOption()));
        case "SheetControlsOption":
            return Optional.ofNullable(clazz.cast(sheetControlsOption()));
        case "VisualPublishOptions":
            return Optional.ofNullable(clazz.cast(visualPublishOptions()));
        case "SheetLayoutElementMaximizationOption":
            return Optional.ofNullable(clazz.cast(sheetLayoutElementMaximizationOption()));
        case "VisualMenuOption":
            return Optional.ofNullable(clazz.cast(visualMenuOption()));
        case "VisualAxisSortOption":
            return Optional.ofNullable(clazz.cast(visualAxisSortOption()));
        case "ExportWithHiddenFieldsOption":
            return Optional.ofNullable(clazz.cast(exportWithHiddenFieldsOption()));
        case "DataPointDrillUpDownOption":
            return Optional.ofNullable(clazz.cast(dataPointDrillUpDownOption()));
        case "DataPointMenuLabelOption":
            return Optional.ofNullable(clazz.cast(dataPointMenuLabelOption()));
        case "DataPointTooltipOption":
            return Optional.ofNullable(clazz.cast(dataPointTooltipOption()));
        case "DataQAEnabledOption":
            return Optional.ofNullable(clazz.cast(dataQAEnabledOption()));
        case "QuickSuiteActionsOption":
            return Optional.ofNullable(clazz.cast(quickSuiteActionsOption()));
        case "ExecutiveSummaryOption":
            return Optional.ofNullable(clazz.cast(executiveSummaryOption()));
        case "DataStoriesSharingOption":
            return Optional.ofNullable(clazz.cast(dataStoriesSharingOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdHocFilteringOption", AD_HOC_FILTERING_OPTION_FIELD);
        map.put("ExportToCSVOption", EXPORT_TO_CSV_OPTION_FIELD);
        map.put("SheetControlsOption", SHEET_CONTROLS_OPTION_FIELD);
        map.put("VisualPublishOptions", VISUAL_PUBLISH_OPTIONS_FIELD);
        map.put("SheetLayoutElementMaximizationOption", SHEET_LAYOUT_ELEMENT_MAXIMIZATION_OPTION_FIELD);
        map.put("VisualMenuOption", VISUAL_MENU_OPTION_FIELD);
        map.put("VisualAxisSortOption", VISUAL_AXIS_SORT_OPTION_FIELD);
        map.put("ExportWithHiddenFieldsOption", EXPORT_WITH_HIDDEN_FIELDS_OPTION_FIELD);
        map.put("DataPointDrillUpDownOption", DATA_POINT_DRILL_UP_DOWN_OPTION_FIELD);
        map.put("DataPointMenuLabelOption", DATA_POINT_MENU_LABEL_OPTION_FIELD);
        map.put("DataPointTooltipOption", DATA_POINT_TOOLTIP_OPTION_FIELD);
        map.put("DataQAEnabledOption", DATA_QA_ENABLED_OPTION_FIELD);
        map.put("QuickSuiteActionsOption", QUICK_SUITE_ACTIONS_OPTION_FIELD);
        map.put("ExecutiveSummaryOption", EXECUTIVE_SUMMARY_OPTION_FIELD);
        map.put("DataStoriesSharingOption", DATA_STORIES_SHARING_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DashboardPublishOptions, T> g) {
        return obj -> g.apply((DashboardPublishOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardPublishOptions> {
        /**
         * <p>
         * Ad hoc (one-time) filtering option.
         * </p>
         * 
         * @param adHocFilteringOption
         *        Ad hoc (one-time) filtering option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adHocFilteringOption(AdHocFilteringOption adHocFilteringOption);

        /**
         * <p>
         * Ad hoc (one-time) filtering option.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdHocFilteringOption.Builder} avoiding
         * the need to create one manually via {@link AdHocFilteringOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdHocFilteringOption.Builder#build()} is called immediately and
         * its result is passed to {@link #adHocFilteringOption(AdHocFilteringOption)}.
         * 
         * @param adHocFilteringOption
         *        a consumer that will call methods on {@link AdHocFilteringOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adHocFilteringOption(AdHocFilteringOption)
         */
        default Builder adHocFilteringOption(Consumer<AdHocFilteringOption.Builder> adHocFilteringOption) {
            return adHocFilteringOption(AdHocFilteringOption.builder().applyMutation(adHocFilteringOption).build());
        }

        /**
         * <p>
         * Export to .csv option.
         * </p>
         * 
         * @param exportToCSVOption
         *        Export to .csv option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportToCSVOption(ExportToCSVOption exportToCSVOption);

        /**
         * <p>
         * Export to .csv option.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportToCSVOption.Builder} avoiding the
         * need to create one manually via {@link ExportToCSVOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportToCSVOption.Builder#build()} is called immediately and its
         * result is passed to {@link #exportToCSVOption(ExportToCSVOption)}.
         * 
         * @param exportToCSVOption
         *        a consumer that will call methods on {@link ExportToCSVOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportToCSVOption(ExportToCSVOption)
         */
        default Builder exportToCSVOption(Consumer<ExportToCSVOption.Builder> exportToCSVOption) {
            return exportToCSVOption(ExportToCSVOption.builder().applyMutation(exportToCSVOption).build());
        }

        /**
         * <p>
         * Sheet controls option.
         * </p>
         * 
         * @param sheetControlsOption
         *        Sheet controls option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetControlsOption(SheetControlsOption sheetControlsOption);

        /**
         * <p>
         * Sheet controls option.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetControlsOption.Builder} avoiding the
         * need to create one manually via {@link SheetControlsOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetControlsOption.Builder#build()} is called immediately and
         * its result is passed to {@link #sheetControlsOption(SheetControlsOption)}.
         * 
         * @param sheetControlsOption
         *        a consumer that will call methods on {@link SheetControlsOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheetControlsOption(SheetControlsOption)
         */
        default Builder sheetControlsOption(Consumer<SheetControlsOption.Builder> sheetControlsOption) {
            return sheetControlsOption(SheetControlsOption.builder().applyMutation(sheetControlsOption).build());
        }

        /**
         * <p>
         * The visual publish options of a visual in a dashboard.
         * </p>
         * 
         * @param visualPublishOptions
         *        The visual publish options of a visual in a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated VisualPublishOptions property will reach its end of standard support in a future release. To
         *             perform this action, use ExportWithHiddenFields.
         */
        @Deprecated
        Builder visualPublishOptions(DashboardVisualPublishOptions visualPublishOptions);

        /**
         * <p>
         * The visual publish options of a visual in a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashboardVisualPublishOptions.Builder}
         * avoiding the need to create one manually via {@link DashboardVisualPublishOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashboardVisualPublishOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #visualPublishOptions(DashboardVisualPublishOptions)}.
         * 
         * @param visualPublishOptions
         *        a consumer that will call methods on {@link DashboardVisualPublishOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPublishOptions(DashboardVisualPublishOptions)
         * @deprecated VisualPublishOptions property will reach its end of standard support in a future release. To
         *             perform this action, use ExportWithHiddenFields.
         */
        @Deprecated
        default Builder visualPublishOptions(Consumer<DashboardVisualPublishOptions.Builder> visualPublishOptions) {
            return visualPublishOptions(DashboardVisualPublishOptions.builder().applyMutation(visualPublishOptions).build());
        }

        /**
         * <p>
         * The sheet layout maximization options of a dashbaord.
         * </p>
         * 
         * @param sheetLayoutElementMaximizationOption
         *        The sheet layout maximization options of a dashbaord.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetLayoutElementMaximizationOption(SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption);

        /**
         * <p>
         * The sheet layout maximization options of a dashbaord.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SheetLayoutElementMaximizationOption.Builder} avoiding the need to create one manually via
         * {@link SheetLayoutElementMaximizationOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetLayoutElementMaximizationOption.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sheetLayoutElementMaximizationOption(SheetLayoutElementMaximizationOption)}.
         * 
         * @param sheetLayoutElementMaximizationOption
         *        a consumer that will call methods on {@link SheetLayoutElementMaximizationOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheetLayoutElementMaximizationOption(SheetLayoutElementMaximizationOption)
         */
        default Builder sheetLayoutElementMaximizationOption(
                Consumer<SheetLayoutElementMaximizationOption.Builder> sheetLayoutElementMaximizationOption) {
            return sheetLayoutElementMaximizationOption(SheetLayoutElementMaximizationOption.builder()
                    .applyMutation(sheetLayoutElementMaximizationOption).build());
        }

        /**
         * <p>
         * The menu options of a visual in a dashboard.
         * </p>
         * 
         * @param visualMenuOption
         *        The menu options of a visual in a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualMenuOption(VisualMenuOption visualMenuOption);

        /**
         * <p>
         * The menu options of a visual in a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualMenuOption.Builder} avoiding the
         * need to create one manually via {@link VisualMenuOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualMenuOption.Builder#build()} is called immediately and its
         * result is passed to {@link #visualMenuOption(VisualMenuOption)}.
         * 
         * @param visualMenuOption
         *        a consumer that will call methods on {@link VisualMenuOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualMenuOption(VisualMenuOption)
         */
        default Builder visualMenuOption(Consumer<VisualMenuOption.Builder> visualMenuOption) {
            return visualMenuOption(VisualMenuOption.builder().applyMutation(visualMenuOption).build());
        }

        /**
         * <p>
         * The axis sort options of a dashboard.
         * </p>
         * 
         * @param visualAxisSortOption
         *        The axis sort options of a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualAxisSortOption(VisualAxisSortOption visualAxisSortOption);

        /**
         * <p>
         * The axis sort options of a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualAxisSortOption.Builder} avoiding
         * the need to create one manually via {@link VisualAxisSortOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualAxisSortOption.Builder#build()} is called immediately and
         * its result is passed to {@link #visualAxisSortOption(VisualAxisSortOption)}.
         * 
         * @param visualAxisSortOption
         *        a consumer that will call methods on {@link VisualAxisSortOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualAxisSortOption(VisualAxisSortOption)
         */
        default Builder visualAxisSortOption(Consumer<VisualAxisSortOption.Builder> visualAxisSortOption) {
            return visualAxisSortOption(VisualAxisSortOption.builder().applyMutation(visualAxisSortOption).build());
        }

        /**
         * <p>
         * Determines if hidden fields are exported with a dashboard.
         * </p>
         * 
         * @param exportWithHiddenFieldsOption
         *        Determines if hidden fields are exported with a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportWithHiddenFieldsOption(ExportWithHiddenFieldsOption exportWithHiddenFieldsOption);

        /**
         * <p>
         * Determines if hidden fields are exported with a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportWithHiddenFieldsOption.Builder}
         * avoiding the need to create one manually via {@link ExportWithHiddenFieldsOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportWithHiddenFieldsOption.Builder#build()} is called
         * immediately and its result is passed to {@link #exportWithHiddenFieldsOption(ExportWithHiddenFieldsOption)}.
         * 
         * @param exportWithHiddenFieldsOption
         *        a consumer that will call methods on {@link ExportWithHiddenFieldsOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportWithHiddenFieldsOption(ExportWithHiddenFieldsOption)
         */
        default Builder exportWithHiddenFieldsOption(Consumer<ExportWithHiddenFieldsOption.Builder> exportWithHiddenFieldsOption) {
            return exportWithHiddenFieldsOption(ExportWithHiddenFieldsOption.builder()
                    .applyMutation(exportWithHiddenFieldsOption).build());
        }

        /**
         * <p>
         * The drill-down options of data points in a dashboard.
         * </p>
         * 
         * @param dataPointDrillUpDownOption
         *        The drill-down options of data points in a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPointDrillUpDownOption(DataPointDrillUpDownOption dataPointDrillUpDownOption);

        /**
         * <p>
         * The drill-down options of data points in a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPointDrillUpDownOption.Builder}
         * avoiding the need to create one manually via {@link DataPointDrillUpDownOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPointDrillUpDownOption.Builder#build()} is called immediately
         * and its result is passed to {@link #dataPointDrillUpDownOption(DataPointDrillUpDownOption)}.
         * 
         * @param dataPointDrillUpDownOption
         *        a consumer that will call methods on {@link DataPointDrillUpDownOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPointDrillUpDownOption(DataPointDrillUpDownOption)
         */
        default Builder dataPointDrillUpDownOption(Consumer<DataPointDrillUpDownOption.Builder> dataPointDrillUpDownOption) {
            return dataPointDrillUpDownOption(DataPointDrillUpDownOption.builder().applyMutation(dataPointDrillUpDownOption)
                    .build());
        }

        /**
         * <p>
         * The data point menu label options of a dashboard.
         * </p>
         * 
         * @param dataPointMenuLabelOption
         *        The data point menu label options of a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPointMenuLabelOption(DataPointMenuLabelOption dataPointMenuLabelOption);

        /**
         * <p>
         * The data point menu label options of a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPointMenuLabelOption.Builder}
         * avoiding the need to create one manually via {@link DataPointMenuLabelOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPointMenuLabelOption.Builder#build()} is called immediately
         * and its result is passed to {@link #dataPointMenuLabelOption(DataPointMenuLabelOption)}.
         * 
         * @param dataPointMenuLabelOption
         *        a consumer that will call methods on {@link DataPointMenuLabelOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPointMenuLabelOption(DataPointMenuLabelOption)
         */
        default Builder dataPointMenuLabelOption(Consumer<DataPointMenuLabelOption.Builder> dataPointMenuLabelOption) {
            return dataPointMenuLabelOption(DataPointMenuLabelOption.builder().applyMutation(dataPointMenuLabelOption).build());
        }

        /**
         * <p>
         * The data point tool tip options of a dashboard.
         * </p>
         * 
         * @param dataPointTooltipOption
         *        The data point tool tip options of a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPointTooltipOption(DataPointTooltipOption dataPointTooltipOption);

        /**
         * <p>
         * The data point tool tip options of a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPointTooltipOption.Builder} avoiding
         * the need to create one manually via {@link DataPointTooltipOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPointTooltipOption.Builder#build()} is called immediately and
         * its result is passed to {@link #dataPointTooltipOption(DataPointTooltipOption)}.
         * 
         * @param dataPointTooltipOption
         *        a consumer that will call methods on {@link DataPointTooltipOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPointTooltipOption(DataPointTooltipOption)
         */
        default Builder dataPointTooltipOption(Consumer<DataPointTooltipOption.Builder> dataPointTooltipOption) {
            return dataPointTooltipOption(DataPointTooltipOption.builder().applyMutation(dataPointTooltipOption).build());
        }

        /**
         * <p>
         * Adds Q&amp;A capabilities to an Quick Sight dashboard. If no topic is linked, Dashboard Q&amp;A uses the data
         * values that are rendered on the dashboard. End users can use Dashboard Q&amp;A to ask for different slices of
         * the data that they see on the dashboard. If a topic is linked, Topic Q&amp;A is used.
         * </p>
         * 
         * @param dataQAEnabledOption
         *        Adds Q&amp;A capabilities to an Quick Sight dashboard. If no topic is linked, Dashboard Q&amp;A uses
         *        the data values that are rendered on the dashboard. End users can use Dashboard Q&amp;A to ask for
         *        different slices of the data that they see on the dashboard. If a topic is linked, Topic Q&amp;A is
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQAEnabledOption(DataQAEnabledOption dataQAEnabledOption);

        /**
         * <p>
         * Adds Q&amp;A capabilities to an Quick Sight dashboard. If no topic is linked, Dashboard Q&amp;A uses the data
         * values that are rendered on the dashboard. End users can use Dashboard Q&amp;A to ask for different slices of
         * the data that they see on the dashboard. If a topic is linked, Topic Q&amp;A is used.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQAEnabledOption.Builder} avoiding the
         * need to create one manually via {@link DataQAEnabledOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQAEnabledOption.Builder#build()} is called immediately and
         * its result is passed to {@link #dataQAEnabledOption(DataQAEnabledOption)}.
         * 
         * @param dataQAEnabledOption
         *        a consumer that will call methods on {@link DataQAEnabledOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQAEnabledOption(DataQAEnabledOption)
         */
        default Builder dataQAEnabledOption(Consumer<DataQAEnabledOption.Builder> dataQAEnabledOption) {
            return dataQAEnabledOption(DataQAEnabledOption.builder().applyMutation(dataQAEnabledOption).build());
        }

        /**
         * <p>
         * Determines if Actions in Amazon Quick Suite are enabled in a dashboard.
         * </p>
         * 
         * @param quickSuiteActionsOption
         *        Determines if Actions in Amazon Quick Suite are enabled in a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickSuiteActionsOption(QuickSuiteActionsOption quickSuiteActionsOption);

        /**
         * <p>
         * Determines if Actions in Amazon Quick Suite are enabled in a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickSuiteActionsOption.Builder} avoiding
         * the need to create one manually via {@link QuickSuiteActionsOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickSuiteActionsOption.Builder#build()} is called immediately
         * and its result is passed to {@link #quickSuiteActionsOption(QuickSuiteActionsOption)}.
         * 
         * @param quickSuiteActionsOption
         *        a consumer that will call methods on {@link QuickSuiteActionsOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickSuiteActionsOption(QuickSuiteActionsOption)
         */
        default Builder quickSuiteActionsOption(Consumer<QuickSuiteActionsOption.Builder> quickSuiteActionsOption) {
            return quickSuiteActionsOption(QuickSuiteActionsOption.builder().applyMutation(quickSuiteActionsOption).build());
        }

        /**
         * <p>
         * Executive summary option.
         * </p>
         * 
         * @param executiveSummaryOption
         *        Executive summary option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executiveSummaryOption(ExecutiveSummaryOption executiveSummaryOption);

        /**
         * <p>
         * Executive summary option.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutiveSummaryOption.Builder} avoiding
         * the need to create one manually via {@link ExecutiveSummaryOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutiveSummaryOption.Builder#build()} is called immediately and
         * its result is passed to {@link #executiveSummaryOption(ExecutiveSummaryOption)}.
         * 
         * @param executiveSummaryOption
         *        a consumer that will call methods on {@link ExecutiveSummaryOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executiveSummaryOption(ExecutiveSummaryOption)
         */
        default Builder executiveSummaryOption(Consumer<ExecutiveSummaryOption.Builder> executiveSummaryOption) {
            return executiveSummaryOption(ExecutiveSummaryOption.builder().applyMutation(executiveSummaryOption).build());
        }

        /**
         * <p>
         * Data stories sharing option.
         * </p>
         * 
         * @param dataStoriesSharingOption
         *        Data stories sharing option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStoriesSharingOption(DataStoriesSharingOption dataStoriesSharingOption);

        /**
         * <p>
         * Data stories sharing option.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataStoriesSharingOption.Builder}
         * avoiding the need to create one manually via {@link DataStoriesSharingOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataStoriesSharingOption.Builder#build()} is called immediately
         * and its result is passed to {@link #dataStoriesSharingOption(DataStoriesSharingOption)}.
         * 
         * @param dataStoriesSharingOption
         *        a consumer that will call methods on {@link DataStoriesSharingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataStoriesSharingOption(DataStoriesSharingOption)
         */
        default Builder dataStoriesSharingOption(Consumer<DataStoriesSharingOption.Builder> dataStoriesSharingOption) {
            return dataStoriesSharingOption(DataStoriesSharingOption.builder().applyMutation(dataStoriesSharingOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AdHocFilteringOption adHocFilteringOption;

        private ExportToCSVOption exportToCSVOption;

        private SheetControlsOption sheetControlsOption;

        private DashboardVisualPublishOptions visualPublishOptions;

        private SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption;

        private VisualMenuOption visualMenuOption;

        private VisualAxisSortOption visualAxisSortOption;

        private ExportWithHiddenFieldsOption exportWithHiddenFieldsOption;

        private DataPointDrillUpDownOption dataPointDrillUpDownOption;

        private DataPointMenuLabelOption dataPointMenuLabelOption;

        private DataPointTooltipOption dataPointTooltipOption;

        private DataQAEnabledOption dataQAEnabledOption;

        private QuickSuiteActionsOption quickSuiteActionsOption;

        private ExecutiveSummaryOption executiveSummaryOption;

        private DataStoriesSharingOption dataStoriesSharingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardPublishOptions model) {
            adHocFilteringOption(model.adHocFilteringOption);
            exportToCSVOption(model.exportToCSVOption);
            sheetControlsOption(model.sheetControlsOption);
            visualPublishOptions(model.visualPublishOptions);
            sheetLayoutElementMaximizationOption(model.sheetLayoutElementMaximizationOption);
            visualMenuOption(model.visualMenuOption);
            visualAxisSortOption(model.visualAxisSortOption);
            exportWithHiddenFieldsOption(model.exportWithHiddenFieldsOption);
            dataPointDrillUpDownOption(model.dataPointDrillUpDownOption);
            dataPointMenuLabelOption(model.dataPointMenuLabelOption);
            dataPointTooltipOption(model.dataPointTooltipOption);
            dataQAEnabledOption(model.dataQAEnabledOption);
            quickSuiteActionsOption(model.quickSuiteActionsOption);
            executiveSummaryOption(model.executiveSummaryOption);
            dataStoriesSharingOption(model.dataStoriesSharingOption);
        }

        public final AdHocFilteringOption.Builder getAdHocFilteringOption() {
            return adHocFilteringOption != null ? adHocFilteringOption.toBuilder() : null;
        }

        public final void setAdHocFilteringOption(AdHocFilteringOption.BuilderImpl adHocFilteringOption) {
            this.adHocFilteringOption = adHocFilteringOption != null ? adHocFilteringOption.build() : null;
        }

        @Override
        public final Builder adHocFilteringOption(AdHocFilteringOption adHocFilteringOption) {
            this.adHocFilteringOption = adHocFilteringOption;
            return this;
        }

        public final ExportToCSVOption.Builder getExportToCSVOption() {
            return exportToCSVOption != null ? exportToCSVOption.toBuilder() : null;
        }

        public final void setExportToCSVOption(ExportToCSVOption.BuilderImpl exportToCSVOption) {
            this.exportToCSVOption = exportToCSVOption != null ? exportToCSVOption.build() : null;
        }

        @Override
        public final Builder exportToCSVOption(ExportToCSVOption exportToCSVOption) {
            this.exportToCSVOption = exportToCSVOption;
            return this;
        }

        public final SheetControlsOption.Builder getSheetControlsOption() {
            return sheetControlsOption != null ? sheetControlsOption.toBuilder() : null;
        }

        public final void setSheetControlsOption(SheetControlsOption.BuilderImpl sheetControlsOption) {
            this.sheetControlsOption = sheetControlsOption != null ? sheetControlsOption.build() : null;
        }

        @Override
        public final Builder sheetControlsOption(SheetControlsOption sheetControlsOption) {
            this.sheetControlsOption = sheetControlsOption;
            return this;
        }

        @Deprecated
        public final DashboardVisualPublishOptions.Builder getVisualPublishOptions() {
            return visualPublishOptions != null ? visualPublishOptions.toBuilder() : null;
        }

        @Deprecated
        public final void setVisualPublishOptions(DashboardVisualPublishOptions.BuilderImpl visualPublishOptions) {
            this.visualPublishOptions = visualPublishOptions != null ? visualPublishOptions.build() : null;
        }

        @Override
        @Deprecated
        public final Builder visualPublishOptions(DashboardVisualPublishOptions visualPublishOptions) {
            this.visualPublishOptions = visualPublishOptions;
            return this;
        }

        public final SheetLayoutElementMaximizationOption.Builder getSheetLayoutElementMaximizationOption() {
            return sheetLayoutElementMaximizationOption != null ? sheetLayoutElementMaximizationOption.toBuilder() : null;
        }

        public final void setSheetLayoutElementMaximizationOption(
                SheetLayoutElementMaximizationOption.BuilderImpl sheetLayoutElementMaximizationOption) {
            this.sheetLayoutElementMaximizationOption = sheetLayoutElementMaximizationOption != null ? sheetLayoutElementMaximizationOption
                    .build() : null;
        }

        @Override
        public final Builder sheetLayoutElementMaximizationOption(
                SheetLayoutElementMaximizationOption sheetLayoutElementMaximizationOption) {
            this.sheetLayoutElementMaximizationOption = sheetLayoutElementMaximizationOption;
            return this;
        }

        public final VisualMenuOption.Builder getVisualMenuOption() {
            return visualMenuOption != null ? visualMenuOption.toBuilder() : null;
        }

        public final void setVisualMenuOption(VisualMenuOption.BuilderImpl visualMenuOption) {
            this.visualMenuOption = visualMenuOption != null ? visualMenuOption.build() : null;
        }

        @Override
        public final Builder visualMenuOption(VisualMenuOption visualMenuOption) {
            this.visualMenuOption = visualMenuOption;
            return this;
        }

        public final VisualAxisSortOption.Builder getVisualAxisSortOption() {
            return visualAxisSortOption != null ? visualAxisSortOption.toBuilder() : null;
        }

        public final void setVisualAxisSortOption(VisualAxisSortOption.BuilderImpl visualAxisSortOption) {
            this.visualAxisSortOption = visualAxisSortOption != null ? visualAxisSortOption.build() : null;
        }

        @Override
        public final Builder visualAxisSortOption(VisualAxisSortOption visualAxisSortOption) {
            this.visualAxisSortOption = visualAxisSortOption;
            return this;
        }

        public final ExportWithHiddenFieldsOption.Builder getExportWithHiddenFieldsOption() {
            return exportWithHiddenFieldsOption != null ? exportWithHiddenFieldsOption.toBuilder() : null;
        }

        public final void setExportWithHiddenFieldsOption(ExportWithHiddenFieldsOption.BuilderImpl exportWithHiddenFieldsOption) {
            this.exportWithHiddenFieldsOption = exportWithHiddenFieldsOption != null ? exportWithHiddenFieldsOption.build()
                    : null;
        }

        @Override
        public final Builder exportWithHiddenFieldsOption(ExportWithHiddenFieldsOption exportWithHiddenFieldsOption) {
            this.exportWithHiddenFieldsOption = exportWithHiddenFieldsOption;
            return this;
        }

        public final DataPointDrillUpDownOption.Builder getDataPointDrillUpDownOption() {
            return dataPointDrillUpDownOption != null ? dataPointDrillUpDownOption.toBuilder() : null;
        }

        public final void setDataPointDrillUpDownOption(DataPointDrillUpDownOption.BuilderImpl dataPointDrillUpDownOption) {
            this.dataPointDrillUpDownOption = dataPointDrillUpDownOption != null ? dataPointDrillUpDownOption.build() : null;
        }

        @Override
        public final Builder dataPointDrillUpDownOption(DataPointDrillUpDownOption dataPointDrillUpDownOption) {
            this.dataPointDrillUpDownOption = dataPointDrillUpDownOption;
            return this;
        }

        public final DataPointMenuLabelOption.Builder getDataPointMenuLabelOption() {
            return dataPointMenuLabelOption != null ? dataPointMenuLabelOption.toBuilder() : null;
        }

        public final void setDataPointMenuLabelOption(DataPointMenuLabelOption.BuilderImpl dataPointMenuLabelOption) {
            this.dataPointMenuLabelOption = dataPointMenuLabelOption != null ? dataPointMenuLabelOption.build() : null;
        }

        @Override
        public final Builder dataPointMenuLabelOption(DataPointMenuLabelOption dataPointMenuLabelOption) {
            this.dataPointMenuLabelOption = dataPointMenuLabelOption;
            return this;
        }

        public final DataPointTooltipOption.Builder getDataPointTooltipOption() {
            return dataPointTooltipOption != null ? dataPointTooltipOption.toBuilder() : null;
        }

        public final void setDataPointTooltipOption(DataPointTooltipOption.BuilderImpl dataPointTooltipOption) {
            this.dataPointTooltipOption = dataPointTooltipOption != null ? dataPointTooltipOption.build() : null;
        }

        @Override
        public final Builder dataPointTooltipOption(DataPointTooltipOption dataPointTooltipOption) {
            this.dataPointTooltipOption = dataPointTooltipOption;
            return this;
        }

        public final DataQAEnabledOption.Builder getDataQAEnabledOption() {
            return dataQAEnabledOption != null ? dataQAEnabledOption.toBuilder() : null;
        }

        public final void setDataQAEnabledOption(DataQAEnabledOption.BuilderImpl dataQAEnabledOption) {
            this.dataQAEnabledOption = dataQAEnabledOption != null ? dataQAEnabledOption.build() : null;
        }

        @Override
        public final Builder dataQAEnabledOption(DataQAEnabledOption dataQAEnabledOption) {
            this.dataQAEnabledOption = dataQAEnabledOption;
            return this;
        }

        public final QuickSuiteActionsOption.Builder getQuickSuiteActionsOption() {
            return quickSuiteActionsOption != null ? quickSuiteActionsOption.toBuilder() : null;
        }

        public final void setQuickSuiteActionsOption(QuickSuiteActionsOption.BuilderImpl quickSuiteActionsOption) {
            this.quickSuiteActionsOption = quickSuiteActionsOption != null ? quickSuiteActionsOption.build() : null;
        }

        @Override
        public final Builder quickSuiteActionsOption(QuickSuiteActionsOption quickSuiteActionsOption) {
            this.quickSuiteActionsOption = quickSuiteActionsOption;
            return this;
        }

        public final ExecutiveSummaryOption.Builder getExecutiveSummaryOption() {
            return executiveSummaryOption != null ? executiveSummaryOption.toBuilder() : null;
        }

        public final void setExecutiveSummaryOption(ExecutiveSummaryOption.BuilderImpl executiveSummaryOption) {
            this.executiveSummaryOption = executiveSummaryOption != null ? executiveSummaryOption.build() : null;
        }

        @Override
        public final Builder executiveSummaryOption(ExecutiveSummaryOption executiveSummaryOption) {
            this.executiveSummaryOption = executiveSummaryOption;
            return this;
        }

        public final DataStoriesSharingOption.Builder getDataStoriesSharingOption() {
            return dataStoriesSharingOption != null ? dataStoriesSharingOption.toBuilder() : null;
        }

        public final void setDataStoriesSharingOption(DataStoriesSharingOption.BuilderImpl dataStoriesSharingOption) {
            this.dataStoriesSharingOption = dataStoriesSharingOption != null ? dataStoriesSharingOption.build() : null;
        }

        @Override
        public final Builder dataStoriesSharingOption(DataStoriesSharingOption dataStoriesSharingOption) {
            this.dataStoriesSharingOption = dataStoriesSharingOption;
            return this;
        }

        @Override
        public DashboardPublishOptions build() {
            return new DashboardPublishOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
