/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for data bars.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataBarsOptions implements SdkPojo, Serializable, ToCopyableBuilder<DataBarsOptions.Builder, DataBarsOptions> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(DataBarsOptions::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<String> POSITIVE_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PositiveColor").getter(getter(DataBarsOptions::positiveColor)).setter(setter(Builder::positiveColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositiveColor").build()).build();

    private static final SdkField<String> NEGATIVE_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NegativeColor").getter(getter(DataBarsOptions::negativeColor)).setter(setter(Builder::negativeColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NegativeColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD,
            POSITIVE_COLOR_FIELD, NEGATIVE_COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final String positiveColor;

    private final String negativeColor;

    private DataBarsOptions(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.positiveColor = builder.positiveColor;
        this.negativeColor = builder.negativeColor;
    }

    /**
     * <p>
     * The field ID for the data bars options.
     * </p>
     * 
     * @return The field ID for the data bars options.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The color of the positive data bar.
     * </p>
     * 
     * @return The color of the positive data bar.
     */
    public final String positiveColor() {
        return positiveColor;
    }

    /**
     * <p>
     * The color of the negative data bar.
     * </p>
     * 
     * @return The color of the negative data bar.
     */
    public final String negativeColor() {
        return negativeColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(positiveColor());
        hashCode = 31 * hashCode + Objects.hashCode(negativeColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataBarsOptions)) {
            return false;
        }
        DataBarsOptions other = (DataBarsOptions) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(positiveColor(), other.positiveColor())
                && Objects.equals(negativeColor(), other.negativeColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataBarsOptions").add("FieldId", fieldId()).add("PositiveColor", positiveColor())
                .add("NegativeColor", negativeColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "PositiveColor":
            return Optional.ofNullable(clazz.cast(positiveColor()));
        case "NegativeColor":
            return Optional.ofNullable(clazz.cast(negativeColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("PositiveColor", POSITIVE_COLOR_FIELD);
        map.put("NegativeColor", NEGATIVE_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataBarsOptions, T> g) {
        return obj -> g.apply((DataBarsOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataBarsOptions> {
        /**
         * <p>
         * The field ID for the data bars options.
         * </p>
         * 
         * @param fieldId
         *        The field ID for the data bars options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The color of the positive data bar.
         * </p>
         * 
         * @param positiveColor
         *        The color of the positive data bar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder positiveColor(String positiveColor);

        /**
         * <p>
         * The color of the negative data bar.
         * </p>
         * 
         * @param negativeColor
         *        The color of the negative data bar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negativeColor(String negativeColor);
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private String positiveColor;

        private String negativeColor;

        private BuilderImpl() {
        }

        private BuilderImpl(DataBarsOptions model) {
            fieldId(model.fieldId);
            positiveColor(model.positiveColor);
            negativeColor(model.negativeColor);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getPositiveColor() {
            return positiveColor;
        }

        public final void setPositiveColor(String positiveColor) {
            this.positiveColor = positiveColor;
        }

        @Override
        public final Builder positiveColor(String positiveColor) {
            this.positiveColor = positiveColor;
            return this;
        }

        public final String getNegativeColor() {
            return negativeColor;
        }

        public final void setNegativeColor(String negativeColor) {
            this.negativeColor = negativeColor;
        }

        @Override
        public final Builder negativeColor(String negativeColor) {
            this.negativeColor = negativeColor;
            return this;
        }

        @Override
        public DataBarsOptions build() {
            return new DataBarsOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
