/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data point tooltip options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPointTooltipOption implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPointTooltipOption.Builder, DataPointTooltipOption> {
    private static final SdkField<String> AVAILABILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityStatus").getter(getter(DataPointTooltipOption::availabilityStatusAsString))
            .setter(setter(Builder::availabilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String availabilityStatus;

    private DataPointTooltipOption(BuilderImpl builder) {
        this.availabilityStatus = builder.availabilityStatus;
    }

    /**
     * <p>
     * The status of the data point tool tip options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityStatus} will return {@link DashboardBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #availabilityStatusAsString}.
     * </p>
     * 
     * @return The status of the data point tool tip options.
     * @see DashboardBehavior
     */
    public final DashboardBehavior availabilityStatus() {
        return DashboardBehavior.fromValue(availabilityStatus);
    }

    /**
     * <p>
     * The status of the data point tool tip options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityStatus} will return {@link DashboardBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #availabilityStatusAsString}.
     * </p>
     * 
     * @return The status of the data point tool tip options.
     * @see DashboardBehavior
     */
    public final String availabilityStatusAsString() {
        return availabilityStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPointTooltipOption)) {
            return false;
        }
        DataPointTooltipOption other = (DataPointTooltipOption) obj;
        return Objects.equals(availabilityStatusAsString(), other.availabilityStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPointTooltipOption").add("AvailabilityStatus", availabilityStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityStatus":
            return Optional.ofNullable(clazz.cast(availabilityStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityStatus", AVAILABILITY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPointTooltipOption, T> g) {
        return obj -> g.apply((DataPointTooltipOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPointTooltipOption> {
        /**
         * <p>
         * The status of the data point tool tip options.
         * </p>
         * 
         * @param availabilityStatus
         *        The status of the data point tool tip options.
         * @see DashboardBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardBehavior
         */
        Builder availabilityStatus(String availabilityStatus);

        /**
         * <p>
         * The status of the data point tool tip options.
         * </p>
         * 
         * @param availabilityStatus
         *        The status of the data point tool tip options.
         * @see DashboardBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardBehavior
         */
        Builder availabilityStatus(DashboardBehavior availabilityStatus);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPointTooltipOption model) {
            availabilityStatus(model.availabilityStatus);
        }

        public final String getAvailabilityStatus() {
            return availabilityStatus;
        }

        public final void setAvailabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
        }

        @Override
        public final Builder availabilityStatus(String availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
            return this;
        }

        @Override
        public final Builder availabilityStatus(DashboardBehavior availabilityStatus) {
            this.availabilityStatus(availabilityStatus == null ? null : availabilityStatus.toString());
            return this;
        }

        @Override
        public DataPointTooltipOption build() {
            return new DataPointTooltipOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
