/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the type of aggregation function to apply to data during data preparation, supporting simple and list
 * aggregations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPrepAggregationFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPrepAggregationFunction.Builder, DataPrepAggregationFunction> {
    private static final SdkField<DataPrepSimpleAggregationFunction> SIMPLE_AGGREGATION_FIELD = SdkField
            .<DataPrepSimpleAggregationFunction> builder(MarshallingType.SDK_POJO).memberName("SimpleAggregation")
            .getter(getter(DataPrepAggregationFunction::simpleAggregation)).setter(setter(Builder::simpleAggregation))
            .constructor(DataPrepSimpleAggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleAggregation").build()).build();

    private static final SdkField<DataPrepListAggregationFunction> LIST_AGGREGATION_FIELD = SdkField
            .<DataPrepListAggregationFunction> builder(MarshallingType.SDK_POJO).memberName("ListAggregation")
            .getter(getter(DataPrepAggregationFunction::listAggregation)).setter(setter(Builder::listAggregation))
            .constructor(DataPrepListAggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListAggregation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMPLE_AGGREGATION_FIELD,
            LIST_AGGREGATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataPrepSimpleAggregationFunction simpleAggregation;

    private final DataPrepListAggregationFunction listAggregation;

    private DataPrepAggregationFunction(BuilderImpl builder) {
        this.simpleAggregation = builder.simpleAggregation;
        this.listAggregation = builder.listAggregation;
    }

    /**
     * <p>
     * A simple aggregation function such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
     * <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
     * <code>STANDARD_DEVIATION</code>.
     * </p>
     * 
     * @return A simple aggregation function such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
     *         <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
     *         <code>STANDARD_DEVIATION</code>.
     */
    public final DataPrepSimpleAggregationFunction simpleAggregation() {
        return simpleAggregation;
    }

    /**
     * <p>
     * A list aggregation function that concatenates values from multiple rows into a single delimited string.
     * </p>
     * 
     * @return A list aggregation function that concatenates values from multiple rows into a single delimited string.
     */
    public final DataPrepListAggregationFunction listAggregation() {
        return listAggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simpleAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(listAggregation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPrepAggregationFunction)) {
            return false;
        }
        DataPrepAggregationFunction other = (DataPrepAggregationFunction) obj;
        return Objects.equals(simpleAggregation(), other.simpleAggregation())
                && Objects.equals(listAggregation(), other.listAggregation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPrepAggregationFunction").add("SimpleAggregation", simpleAggregation())
                .add("ListAggregation", listAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SimpleAggregation":
            return Optional.ofNullable(clazz.cast(simpleAggregation()));
        case "ListAggregation":
            return Optional.ofNullable(clazz.cast(listAggregation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SimpleAggregation", SIMPLE_AGGREGATION_FIELD);
        map.put("ListAggregation", LIST_AGGREGATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPrepAggregationFunction, T> g) {
        return obj -> g.apply((DataPrepAggregationFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPrepAggregationFunction> {
        /**
         * <p>
         * A simple aggregation function such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
         * <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
         * <code>STANDARD_DEVIATION</code>.
         * </p>
         * 
         * @param simpleAggregation
         *        A simple aggregation function such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
         *        <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
         *        <code>STANDARD_DEVIATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleAggregation(DataPrepSimpleAggregationFunction simpleAggregation);

        /**
         * <p>
         * A simple aggregation function such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
         * <code>MIN</code>, <code>MAX</code>, <code>MEDIAN</code>, <code>VARIANCE</code>, or
         * <code>STANDARD_DEVIATION</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataPrepSimpleAggregationFunction.Builder} avoiding the need to create one manually via
         * {@link DataPrepSimpleAggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrepSimpleAggregationFunction.Builder#build()} is called
         * immediately and its result is passed to {@link #simpleAggregation(DataPrepSimpleAggregationFunction)}.
         * 
         * @param simpleAggregation
         *        a consumer that will call methods on {@link DataPrepSimpleAggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleAggregation(DataPrepSimpleAggregationFunction)
         */
        default Builder simpleAggregation(Consumer<DataPrepSimpleAggregationFunction.Builder> simpleAggregation) {
            return simpleAggregation(DataPrepSimpleAggregationFunction.builder().applyMutation(simpleAggregation).build());
        }

        /**
         * <p>
         * A list aggregation function that concatenates values from multiple rows into a single delimited string.
         * </p>
         * 
         * @param listAggregation
         *        A list aggregation function that concatenates values from multiple rows into a single delimited
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAggregation(DataPrepListAggregationFunction listAggregation);

        /**
         * <p>
         * A list aggregation function that concatenates values from multiple rows into a single delimited string.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrepListAggregationFunction.Builder}
         * avoiding the need to create one manually via {@link DataPrepListAggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrepListAggregationFunction.Builder#build()} is called
         * immediately and its result is passed to {@link #listAggregation(DataPrepListAggregationFunction)}.
         * 
         * @param listAggregation
         *        a consumer that will call methods on {@link DataPrepListAggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listAggregation(DataPrepListAggregationFunction)
         */
        default Builder listAggregation(Consumer<DataPrepListAggregationFunction.Builder> listAggregation) {
            return listAggregation(DataPrepListAggregationFunction.builder().applyMutation(listAggregation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataPrepSimpleAggregationFunction simpleAggregation;

        private DataPrepListAggregationFunction listAggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPrepAggregationFunction model) {
            simpleAggregation(model.simpleAggregation);
            listAggregation(model.listAggregation);
        }

        public final DataPrepSimpleAggregationFunction.Builder getSimpleAggregation() {
            return simpleAggregation != null ? simpleAggregation.toBuilder() : null;
        }

        public final void setSimpleAggregation(DataPrepSimpleAggregationFunction.BuilderImpl simpleAggregation) {
            this.simpleAggregation = simpleAggregation != null ? simpleAggregation.build() : null;
        }

        @Override
        public final Builder simpleAggregation(DataPrepSimpleAggregationFunction simpleAggregation) {
            this.simpleAggregation = simpleAggregation;
            return this;
        }

        public final DataPrepListAggregationFunction.Builder getListAggregation() {
            return listAggregation != null ? listAggregation.toBuilder() : null;
        }

        public final void setListAggregation(DataPrepListAggregationFunction.BuilderImpl listAggregation) {
            this.listAggregation = listAggregation != null ? listAggregation.build() : null;
        }

        @Override
        public final Builder listAggregation(DataPrepListAggregationFunction listAggregation) {
            this.listAggregation = listAggregation;
            return this;
        }

        @Override
        public DataPrepAggregationFunction build() {
            return new DataPrepAggregationFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
