/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for data preparation operations, defining the complete pipeline from source tables through
 * transformations to destination tables.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataPrepConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataPrepConfiguration.Builder, DataPrepConfiguration> {
    private static final SdkField<Map<String, SourceTable>> SOURCE_TABLE_MAP_FIELD = SdkField
            .<Map<String, SourceTable>> builder(MarshallingType.MAP)
            .memberName("SourceTableMap")
            .getter(getter(DataPrepConfiguration::sourceTableMap))
            .setter(setter(Builder::sourceTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SourceTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TransformStep>> TRANSFORM_STEP_MAP_FIELD = SdkField
            .<Map<String, TransformStep>> builder(MarshallingType.MAP)
            .memberName("TransformStepMap")
            .getter(getter(DataPrepConfiguration::transformStepMap))
            .setter(setter(Builder::transformStepMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformStepMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TransformStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransformStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, DestinationTable>> DESTINATION_TABLE_MAP_FIELD = SdkField
            .<Map<String, DestinationTable>> builder(MarshallingType.MAP)
            .memberName("DestinationTableMap")
            .getter(getter(DataPrepConfiguration::destinationTableMap))
            .setter(setter(Builder::destinationTableMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DestinationTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(DestinationTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TABLE_MAP_FIELD,
            TRANSFORM_STEP_MAP_FIELD, DESTINATION_TABLE_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, SourceTable> sourceTableMap;

    private final Map<String, TransformStep> transformStepMap;

    private final Map<String, DestinationTable> destinationTableMap;

    private DataPrepConfiguration(BuilderImpl builder) {
        this.sourceTableMap = builder.sourceTableMap;
        this.transformStepMap = builder.transformStepMap;
        this.destinationTableMap = builder.destinationTableMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceTableMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceTableMap() {
        return sourceTableMap != null && !(sourceTableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of source tables that provide information about underlying sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceTableMap} method.
     * </p>
     * 
     * @return A map of source tables that provide information about underlying sources.
     */
    public final Map<String, SourceTable> sourceTableMap() {
        return sourceTableMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransformStepMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransformStepMap() {
        return transformStepMap != null && !(transformStepMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of transformation steps that process the data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransformStepMap} method.
     * </p>
     * 
     * @return A map of transformation steps that process the data.
     */
    public final Map<String, TransformStep> transformStepMap() {
        return transformStepMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationTableMap property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationTableMap() {
        return destinationTableMap != null && !(destinationTableMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of destination tables that receive the final prepared data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationTableMap} method.
     * </p>
     * 
     * @return A map of destination tables that receive the final prepared data.
     */
    public final Map<String, DestinationTable> destinationTableMap() {
        return destinationTableMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceTableMap() ? sourceTableMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTransformStepMap() ? transformStepMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationTableMap() ? destinationTableMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPrepConfiguration)) {
            return false;
        }
        DataPrepConfiguration other = (DataPrepConfiguration) obj;
        return hasSourceTableMap() == other.hasSourceTableMap() && Objects.equals(sourceTableMap(), other.sourceTableMap())
                && hasTransformStepMap() == other.hasTransformStepMap()
                && Objects.equals(transformStepMap(), other.transformStepMap())
                && hasDestinationTableMap() == other.hasDestinationTableMap()
                && Objects.equals(destinationTableMap(), other.destinationTableMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataPrepConfiguration").add("SourceTableMap", hasSourceTableMap() ? sourceTableMap() : null)
                .add("TransformStepMap", hasTransformStepMap() ? transformStepMap() : null)
                .add("DestinationTableMap", hasDestinationTableMap() ? destinationTableMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceTableMap":
            return Optional.ofNullable(clazz.cast(sourceTableMap()));
        case "TransformStepMap":
            return Optional.ofNullable(clazz.cast(transformStepMap()));
        case "DestinationTableMap":
            return Optional.ofNullable(clazz.cast(destinationTableMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceTableMap", SOURCE_TABLE_MAP_FIELD);
        map.put("TransformStepMap", TRANSFORM_STEP_MAP_FIELD);
        map.put("DestinationTableMap", DESTINATION_TABLE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataPrepConfiguration, T> g) {
        return obj -> g.apply((DataPrepConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataPrepConfiguration> {
        /**
         * <p>
         * A map of source tables that provide information about underlying sources.
         * </p>
         * 
         * @param sourceTableMap
         *        A map of source tables that provide information about underlying sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableMap(Map<String, SourceTable> sourceTableMap);

        /**
         * <p>
         * A map of transformation steps that process the data.
         * </p>
         * 
         * @param transformStepMap
         *        A map of transformation steps that process the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformStepMap(Map<String, TransformStep> transformStepMap);

        /**
         * <p>
         * A map of destination tables that receive the final prepared data.
         * </p>
         * 
         * @param destinationTableMap
         *        A map of destination tables that receive the final prepared data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTableMap(Map<String, DestinationTable> destinationTableMap);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, SourceTable> sourceTableMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TransformStep> transformStepMap = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, DestinationTable> destinationTableMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataPrepConfiguration model) {
            sourceTableMap(model.sourceTableMap);
            transformStepMap(model.transformStepMap);
            destinationTableMap(model.destinationTableMap);
        }

        public final Map<String, SourceTable.Builder> getSourceTableMap() {
            Map<String, SourceTable.Builder> result = SourceTableMapCopier.copyToBuilder(this.sourceTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSourceTableMap(Map<String, SourceTable.BuilderImpl> sourceTableMap) {
            this.sourceTableMap = SourceTableMapCopier.copyFromBuilder(sourceTableMap);
        }

        @Override
        public final Builder sourceTableMap(Map<String, SourceTable> sourceTableMap) {
            this.sourceTableMap = SourceTableMapCopier.copy(sourceTableMap);
            return this;
        }

        public final Map<String, TransformStep.Builder> getTransformStepMap() {
            Map<String, TransformStep.Builder> result = TransformStepMapCopier.copyToBuilder(this.transformStepMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTransformStepMap(Map<String, TransformStep.BuilderImpl> transformStepMap) {
            this.transformStepMap = TransformStepMapCopier.copyFromBuilder(transformStepMap);
        }

        @Override
        public final Builder transformStepMap(Map<String, TransformStep> transformStepMap) {
            this.transformStepMap = TransformStepMapCopier.copy(transformStepMap);
            return this;
        }

        public final Map<String, DestinationTable.Builder> getDestinationTableMap() {
            Map<String, DestinationTable.Builder> result = DestinationTableMapCopier.copyToBuilder(this.destinationTableMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setDestinationTableMap(Map<String, DestinationTable.BuilderImpl> destinationTableMap) {
            this.destinationTableMap = DestinationTableMapCopier.copyFromBuilder(destinationTableMap);
        }

        @Override
        public final Builder destinationTableMap(Map<String, DestinationTable> destinationTableMap) {
            this.destinationTableMap = DestinationTableMapCopier.copy(destinationTableMap);
            return this;
        }

        @Override
        public DataPrepConfiguration build() {
            return new DataPrepConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
