/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DataSetColumnIdMappingListCopier {
    static List<DataSetColumnIdMapping> copy(Collection<? extends DataSetColumnIdMapping> dataSetColumnIdMappingListParam) {
        List<DataSetColumnIdMapping> list;
        if (dataSetColumnIdMappingListParam == null || dataSetColumnIdMappingListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataSetColumnIdMapping> modifiableList = new ArrayList<>(dataSetColumnIdMappingListParam.size());
            dataSetColumnIdMappingListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataSetColumnIdMapping> copyFromBuilder(
            Collection<? extends DataSetColumnIdMapping.Builder> dataSetColumnIdMappingListParam) {
        List<DataSetColumnIdMapping> list;
        if (dataSetColumnIdMappingListParam == null || dataSetColumnIdMappingListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataSetColumnIdMapping> modifiableList = new ArrayList<>(dataSetColumnIdMappingListParam.size());
            dataSetColumnIdMappingListParam.forEach(entry -> {
                DataSetColumnIdMapping member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataSetColumnIdMapping.Builder> copyToBuilder(
            Collection<? extends DataSetColumnIdMapping> dataSetColumnIdMappingListParam) {
        List<DataSetColumnIdMapping.Builder> list;
        if (dataSetColumnIdMappingListParam == null || dataSetColumnIdMappingListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataSetColumnIdMapping.Builder> modifiableList = new ArrayList<>(dataSetColumnIdMappingListParam.size());
            dataSetColumnIdMappingListParam.forEach(entry -> {
                DataSetColumnIdMapping.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
