/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter condition that compares date values using operators like <code>BEFORE</code>, <code>AFTER</code>, or their
 * inclusive variants.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetDateComparisonFilterCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetDateComparisonFilterCondition.Builder, DataSetDateComparisonFilterCondition> {
    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(DataSetDateComparisonFilterCondition::operatorAsString))
            .setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<DataSetDateFilterValue> VALUE_FIELD = SdkField
            .<DataSetDateFilterValue> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(DataSetDateComparisonFilterCondition::value)).setter(setter(Builder::value))
            .constructor(DataSetDateFilterValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATOR_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String operator;

    private final DataSetDateFilterValue value;

    private DataSetDateComparisonFilterCondition(BuilderImpl builder) {
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The comparison operator to use, such as <code>BEFORE</code>, <code>BEFORE_OR_EQUALS_TO</code>, <code>AFTER</code>
     * , or <code>AFTER_OR_EQUALS_TO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link DataSetDateComparisonFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The comparison operator to use, such as <code>BEFORE</code>, <code>BEFORE_OR_EQUALS_TO</code>,
     *         <code>AFTER</code>, or <code>AFTER_OR_EQUALS_TO</code>.
     * @see DataSetDateComparisonFilterOperator
     */
    public final DataSetDateComparisonFilterOperator operator() {
        return DataSetDateComparisonFilterOperator.fromValue(operator);
    }

    /**
     * <p>
     * The comparison operator to use, such as <code>BEFORE</code>, <code>BEFORE_OR_EQUALS_TO</code>, <code>AFTER</code>
     * , or <code>AFTER_OR_EQUALS_TO</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link DataSetDateComparisonFilterOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The comparison operator to use, such as <code>BEFORE</code>, <code>BEFORE_OR_EQUALS_TO</code>,
     *         <code>AFTER</code>, or <code>AFTER_OR_EQUALS_TO</code>.
     * @see DataSetDateComparisonFilterOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The date value to compare against.
     * </p>
     * 
     * @return The date value to compare against.
     */
    public final DataSetDateFilterValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetDateComparisonFilterCondition)) {
            return false;
        }
        DataSetDateComparisonFilterCondition other = (DataSetDateComparisonFilterCondition) obj;
        return Objects.equals(operatorAsString(), other.operatorAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetDateComparisonFilterCondition").add("Operator", operatorAsString()).add("Value", value())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operator", OPERATOR_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetDateComparisonFilterCondition, T> g) {
        return obj -> g.apply((DataSetDateComparisonFilterCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetDateComparisonFilterCondition> {
        /**
         * <p>
         * The comparison operator to use, such as <code>BEFORE</code>, <code>BEFORE_OR_EQUALS_TO</code>,
         * <code>AFTER</code>, or <code>AFTER_OR_EQUALS_TO</code>.
         * </p>
         * 
         * @param operator
         *        The comparison operator to use, such as <code>BEFORE</code>, <code>BEFORE_OR_EQUALS_TO</code>,
         *        <code>AFTER</code>, or <code>AFTER_OR_EQUALS_TO</code>.
         * @see DataSetDateComparisonFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetDateComparisonFilterOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The comparison operator to use, such as <code>BEFORE</code>, <code>BEFORE_OR_EQUALS_TO</code>,
         * <code>AFTER</code>, or <code>AFTER_OR_EQUALS_TO</code>.
         * </p>
         * 
         * @param operator
         *        The comparison operator to use, such as <code>BEFORE</code>, <code>BEFORE_OR_EQUALS_TO</code>,
         *        <code>AFTER</code>, or <code>AFTER_OR_EQUALS_TO</code>.
         * @see DataSetDateComparisonFilterOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetDateComparisonFilterOperator
         */
        Builder operator(DataSetDateComparisonFilterOperator operator);

        /**
         * <p>
         * The date value to compare against.
         * </p>
         * 
         * @param value
         *        The date value to compare against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(DataSetDateFilterValue value);

        /**
         * <p>
         * The date value to compare against.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetDateFilterValue.Builder} avoiding
         * the need to create one manually via {@link DataSetDateFilterValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetDateFilterValue.Builder#build()} is called immediately and
         * its result is passed to {@link #value(DataSetDateFilterValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link DataSetDateFilterValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(DataSetDateFilterValue)
         */
        default Builder value(Consumer<DataSetDateFilterValue.Builder> value) {
            return value(DataSetDateFilterValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String operator;

        private DataSetDateFilterValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetDateComparisonFilterCondition model) {
            operator(model.operator);
            value(model.value);
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(DataSetDateComparisonFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final DataSetDateFilterValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(DataSetDateFilterValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataSetDateFilterValue value) {
            this.value = value;
            return this;
        }

        @Override
        public DataSetDateComparisonFilterCondition build() {
            return new DataSetDateComparisonFilterCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
