/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The option that determines the decimal places configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecimalPlacesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DecimalPlacesConfiguration.Builder, DecimalPlacesConfiguration> {
    private static final SdkField<Long> DECIMAL_PLACES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DecimalPlaces").getter(getter(DecimalPlacesConfiguration::decimalPlaces))
            .setter(setter(Builder::decimalPlaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalPlaces").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECIMAL_PLACES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long decimalPlaces;

    private DecimalPlacesConfiguration(BuilderImpl builder) {
        this.decimalPlaces = builder.decimalPlaces;
    }

    /**
     * <p>
     * The values of the decimal places.
     * </p>
     * 
     * @return The values of the decimal places.
     */
    public final Long decimalPlaces() {
        return decimalPlaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decimalPlaces());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalPlacesConfiguration)) {
            return false;
        }
        DecimalPlacesConfiguration other = (DecimalPlacesConfiguration) obj;
        return Objects.equals(decimalPlaces(), other.decimalPlaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DecimalPlacesConfiguration").add("DecimalPlaces", decimalPlaces()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DecimalPlaces":
            return Optional.ofNullable(clazz.cast(decimalPlaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DecimalPlaces", DECIMAL_PLACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecimalPlacesConfiguration, T> g) {
        return obj -> g.apply((DecimalPlacesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DecimalPlacesConfiguration> {
        /**
         * <p>
         * The values of the decimal places.
         * </p>
         * 
         * @param decimalPlaces
         *        The values of the decimal places.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalPlaces(Long decimalPlaces);
    }

    static final class BuilderImpl implements Builder {
        private Long decimalPlaces;

        private BuilderImpl() {
        }

        private BuilderImpl(DecimalPlacesConfiguration model) {
            decimalPlaces(model.decimalPlaces);
        }

        public final Long getDecimalPlaces() {
            return decimalPlaces;
        }

        public final void setDecimalPlaces(Long decimalPlaces) {
            this.decimalPlaces = decimalPlaces;
        }

        @Override
        public final Builder decimalPlaces(Long decimalPlaces) {
            this.decimalPlaces = decimalPlaces;
            return this;
        }

        @Override
        public DecimalPlacesConfiguration build() {
            return new DecimalPlacesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
